/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.util.Constants;

public class StudentAvailabilityConflicts
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private TimeOverlapsCounter iTOC = null;

    public StudentAvailabilityConflicts(StudentSectioningModel model) {
        super(model);
        this.iTOC = model.getTimeOverlaps();
        if (this.iTOC == null) {
            this.iTOC = new TimeOverlapsCounter(null, model.getProperties());
        }
    }

    public boolean shareHoursIgnoreBreakTime(TimeLocation t1, TimeLocation t2) {
        int s1 = t1.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e1 = (t1.getStartSlot() + t1.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t1.getBreakTime();
        int s2 = t2.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e2 = (t2.getStartSlot() + t2.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t2.getBreakTime();
        return e1 > s2 && e2 > s1;
    }

    public boolean inConflict(SctAssignment a1, SctAssignment a2, boolean ignoreBreakTimeConflicts) {
        if (a1.getTime() == null || a2.getTime() == null) {
            return false;
        }
        if (ignoreBreakTimeConflicts) {
            TimeLocation t2;
            TimeLocation t1 = a1.getTime();
            return t1.shareDays(t2 = a2.getTime()) && this.shareHoursIgnoreBreakTime(t1, t2) && t1.shareWeeks(t2);
        }
        return a1.getTime().hasIntersection(a2.getTime());
    }

    public int nrSharedHoursIgnoreBreakTime(TimeLocation t1, TimeLocation t2) {
        int start;
        int s1 = t1.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e1 = (t1.getStartSlot() + t1.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t1.getBreakTime();
        int s2 = t2.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e2 = (t2.getStartSlot() + t2.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t2.getBreakTime();
        int end = Math.min(e1, e2);
        return end < (start = Math.max(s1, s2)) ? 0 : end - start;
    }

    public int share(SctAssignment a1, SctAssignment a2, boolean ignoreBreakTimeConflicts) {
        if (!this.inConflict(a1, a2, ignoreBreakTimeConflicts)) {
            return 0;
        }
        if (ignoreBreakTimeConflicts) {
            return a1.getTime().nrSharedDays(a2.getTime()) * this.nrSharedHoursIgnoreBreakTime(a1.getTime(), a2.getTime());
        }
        return 5 * a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        boolean includeAllowedOverlaps = properties.getPropertyBoolean("includeAllowedOverlaps", true);
        boolean ignoreBreakTimeConflicts = properties.getPropertyBoolean("ignoreBreakTimeConflicts", false);
        CSVFile csv = new CSVFile();
        if (includeAllowedOverlaps) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportAllowedOverlap()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.reportSubpartOverlap()), new CSVFile.CSVField((Object)MSG.reportTimeOverride()), new CSVFile.CSVField((Object)MSG.reportConflictingAssignment()), new CSVFile.CSVField((Object)MSG.reportConflictingMeetingTime()), new CSVFile.CSVField((Object)MSG.reportTeachingOverlap()), new CSVFile.CSVField((Object)MSG.reportOverlapMinutes())});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.reportConflictingAssignment()), new CSVFile.CSVField((Object)MSG.reportConflictingMeetingTime()), new CSVFile.CSVField((Object)MSG.reportOverlapMinutes())});
        }
        TreeSet<Student> students = new TreeSet<Student>(new Comparator<Student>(){

            @Override
            public int compare(Student s1, Student s2) {
                return s1.getExternalId().compareTo(s2.getExternalId());
            }
        });
        students.addAll(this.getModel().getStudents());
        for (Student student : students) {
            if (student.getUnavailabilities().isEmpty()) continue;
            for (Request r : student.getRequests()) {
                Enrollment e = (Enrollment)assignment.getValue((Variable)r);
                if (e == null || r instanceof FreeTimeRequest || !this.matches(r, e)) continue;
                for (Section s : e.getSections()) {
                    for (Unavailability u : student.getUnavailabilities()) {
                        if (!u.isTeachingAssignment() || !this.inConflict((SctAssignment)s, (SctAssignment)u, ignoreBreakTimeConflicts) || !includeAllowedOverlaps && (e.isAllowOverlap() || u.isAllowOverlap() || !s.isOverlapping((SctAssignment)u))) continue;
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                        if (dbStudent != null) {
                            line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)""));
                        }
                        line.add(new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())));
                        line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                        line.add(new CSVFile.CSVField((Object)this.group(student)));
                        line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                        if (includeAllowedOverlaps) {
                            line.add(new CSVFile.CSVField(e.isAllowOverlap() || u.isAllowOverlap() || !s.isOverlapping((SctAssignment)u)));
                        }
                        line.add(new CSVFile.CSVField((Object)e.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(s.getSubpart().getName() + " " + s.getName(e.getCourse().getId()))));
                        line.add(new CSVFile.CSVField(s.getTime() == null ? "" : s.getTime().getDayHeader() + " " + s.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + s.getTime().getEndTimeHeader(this.isUseAmPm())));
                        if (includeAllowedOverlaps) {
                            line.add(new CSVFile.CSVField(s.getSubpart().isAllowOverlap()));
                            line.add(new CSVFile.CSVField(e.getReservation() != null && e.getReservation().isAllowOverlap()));
                        }
                        if (u.getSection().getSubpart() == null) {
                            line.add(new CSVFile.CSVField((Object)u.getSection().getName()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)(u.getSection().getSubpart().getConfig().getOffering().getName() + " " + u.getSection().getSubpart().getName() + " " + u.getSection().getName())));
                        }
                        line.add(new CSVFile.CSVField(u.getTime() == null ? "" : u.getTime().getDayHeader() + " " + u.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + u.getTime().getEndTimeHeader(this.isUseAmPm())));
                        if (includeAllowedOverlaps) {
                            line.add(new CSVFile.CSVField(u.isAllowOverlap()));
                        }
                        line.add(new CSVFile.CSVField((Object)sDF1.format(this.share((SctAssignment)s, (SctAssignment)u, ignoreBreakTimeConflicts))));
                        csv.addLine(line);
                    }
                }
            }
        }
        return csv;
    }
}

