/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationChangeGradeModes
implements OnlineSectioningAction<SpecialRegistrationInterface.ChangeGradeModesResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.ChangeGradeModesRequest iRequest;

    public SpecialRegistrationChangeGradeModes withRequest(SpecialRegistrationInterface.ChangeGradeModesRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.ChangeGradeModesRequest getRequest() {
        return this.iRequest;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.ChangeGradeModesResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            SpecialRegistrationInterface.ChangeGradeModesResponse response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
            for (XRequest request : student.getRequests()) {
                if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
                XEnrollment enrl = ((XCourseRequest)request).getEnrollment();
                XOffering offering = server.getOffering(enrl.getOfferingId());
                for (XSection section : offering.getSections(enrl)) {
                    SpecialRegistrationInterface.SpecialRegistrationGradeModeChange mode;
                    OnlineSectioningLog.Section.Builder sct = OnlineSectioningHelper.toProto(section, enrl);
                    String ext = section.getExternalId(enrl.getCourseId());
                    SpecialRegistrationInterface.SpecialRegistrationGradeModeChange specialRegistrationGradeModeChange = mode = ext == null ? null : this.getRequest().getChange(ext);
                    if (mode != null) {
                        sct.getClazzBuilder().addParameterBuilder().setKey("selectedGradeMode").setValue(mode.getSelectedGradeMode());
                    }
                    enrollment.addSection(sct);
                }
            }
            action.addEnrollment(enrollment);
            SpecialRegistrationInterface.ChangeGradeModesResponse changeGradeModesResponse = response = CustomSpecialRegistrationHolder.getProvider().changeGradeModes(server, helper, student, this.getRequest());
            return changeGradeModesResponse;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "change-grade-modes";
    }
}

