/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class MidtermPeriodPreferenceModel {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected TreeSet<Integer> iDates = new TreeSet();
    protected TreeSet<Integer> iStarts = new TreeSet();
    protected Hashtable<Integer, Hashtable<Integer, String>> iPreferences = new Hashtable();
    protected Hashtable<Integer, Integer> iLength = new Hashtable();
    private TreeSet iPeriods = null;
    private Date iFirstDate = null;
    private Date iLastDate = null;
    protected boolean iLocation = false;
    private ExamPeriod iPeriod = null;
    private Date iExamBeginDate = null;
    private Session iSession = null;
    private ExamType iExamType = null;
    private String iName = "mp";

    public MidtermPeriodPreferenceModel(Session session, ExamType type) {
        this(session, type, (ExamPeriod)null);
    }

    public MidtermPeriodPreferenceModel(Session session, ExamType type, ExamAssignment assignment) {
        this(session, type, assignment == null ? null : assignment.getPeriod());
    }

    public MidtermPeriodPreferenceModel(Session session, ExamType type, ExamPeriod assignment) {
        this.iPeriod = assignment;
        this.iSession = session;
        this.iExamType = type;
        this.iExamBeginDate = session.getExamBeginDate();
        this.iPeriods = ExamPeriod.findAll(session.getUniqueId(), type);
        for (ExamPeriod period : this.iPeriods) {
            this.iStarts.add(period.getStartSlot());
            this.iLength.put(period.getStartSlot(), period.getLength());
            this.iDates.add(period.getDateOffset());
            Hashtable<Integer, String> pref = this.iPreferences.get(period.getDateOffset());
            if (pref == null) {
                pref = new Hashtable();
                this.iPreferences.put(period.getDateOffset(), pref);
            }
            pref.put(period.getStartSlot(), PreferenceLevel.sProhibited);
            if (this.iFirstDate == null) {
                this.iFirstDate = period.getStartDate();
                this.iLastDate = period.getStartDate();
                continue;
            }
            if (period.getStartDate().compareTo(this.iFirstDate) < 0) {
                this.iFirstDate = period.getStartDate();
            }
            if (period.getStartDate().compareTo(this.iLastDate) <= 0) continue;
            this.iLastDate = period.getStartDate();
        }
    }

    public void setName(String name) {
        this.iName = name;
    }

    public void load(PreferenceGroup pg) {
        for (ExamPeriodPref pref : pg.getPreferences(ExamPeriodPref.class)) {
            if (!this.iExamType.equals(pref.getExamPeriod().getExamType())) continue;
            this.iPreferences.get(pref.getExamPeriod().getDateOffset()).put(pref.getExamPeriod().getStartSlot(), pref.getPrefLevel().getPrefProlog());
        }
        this.invertIfNeeded();
    }

    private void invertIfNeeded() {
        Hashtable<Integer, String> pref;
        boolean hasReq = false;
        block0: for (Integer date : this.iDates) {
            pref = this.iPreferences.get(date);
            for (Integer time : this.iStarts) {
                if (!PreferenceLevel.sRequired.equals(pref.get(time))) continue;
                hasReq = true;
                break block0;
            }
        }
        if (hasReq) {
            for (Integer date : this.iDates) {
                pref = this.iPreferences.get(date);
                for (Integer time : this.iStarts) {
                    if (pref.get(time) == null) continue;
                    pref.put(time, PreferenceLevel.sRequired.equals(pref.get(time)) ? PreferenceLevel.sNeutral : PreferenceLevel.sProhibited);
                }
            }
        }
    }

    public void save(Set preferences, PreferenceGroup pg) {
        for (ExamPeriod period : this.iPeriods) {
            String pref = this.iPreferences.get(period.getDateOffset()).get(period.getStartSlot());
            if (pref == null || PreferenceLevel.sProhibited.equals(pref)) continue;
            ExamPeriodPref p = new ExamPeriodPref();
            p.setOwner(pg);
            p.setExamPeriod(period);
            p.setPrefLevel(PreferenceLevel.getPreferenceLevel(pref));
            preferences.add(p);
        }
    }

    public void load(Location location) {
        this.iLocation = true;
        for (ExamPeriod period : this.iPeriods) {
            this.iPreferences.get(period.getDateOffset()).put(period.getStartSlot(), location.getExamPreference(period).getPrefProlog());
        }
        this.invertIfNeeded();
    }

    public void save(Location location) {
        location.clearExamPreferences(this.iExamType);
        for (ExamPeriod period : this.iPeriods) {
            String pref = this.iPreferences.get(period.getDateOffset()).get(period.getStartSlot());
            if (pref == null || PreferenceLevel.sNeutral.equals(pref)) continue;
            location.addExamPreference(period, PreferenceLevel.getPreferenceLevel(pref));
        }
    }

    public int getExamOffset() {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.iExamBeginDate);
        return cal.get(6);
    }

    public Integer getDateOffset(int day, int month) {
        return 1 + DateUtils.getDayOfYear(day, month, this.getYear()) - this.getExamOffset();
    }

    public Date getDate(Integer dateOffset) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.iExamBeginDate);
        cal.add(6, dateOffset);
        return cal.getTime();
    }

    public int getStartMonth() {
        Calendar begin = Calendar.getInstance(Locale.US);
        begin.setTime(this.iExamBeginDate);
        Calendar first = Calendar.getInstance(Locale.US);
        first.setTime(this.iFirstDate);
        int month = first.get(2);
        if (first.get(1) != begin.get(1)) {
            month -= 12 * (begin.get(1) - first.get(1));
        }
        return month;
    }

    public int getEndMonth() {
        Calendar begin = Calendar.getInstance(Locale.US);
        begin.setTime(this.iExamBeginDate);
        Calendar last = Calendar.getInstance(Locale.US);
        last.setTime(this.iLastDate);
        int month = last.get(2);
        if (last.get(1) != begin.get(1)) {
            month += 12 * (last.get(1) - begin.get(1));
        }
        return month;
    }

    public int getYear() {
        Calendar begin = Calendar.getInstance(Locale.US);
        begin.setTime(this.iExamBeginDate);
        return begin.get(1);
    }

    public String getBorder(int day, int month, int start) {
        if (this.iPeriod != null && this.iPeriod.getDateOffset().equals(this.getDateOffset(day, month)) && this.iPeriod.getStartSlot().equals(start)) {
            return "'purple 2px solid'";
        }
        int m = month;
        int sessStartYr = this.iSession.getSessionStartYear();
        if (sessStartYr < this.getYear()) {
            m += 12 * (this.getYear() - sessStartYr);
        } else if (sessStartYr > this.getYear()) {
            m -= 12 * (sessStartYr - this.getYear());
        }
        return this.iSession.getBorder(day, m);
    }

    public String getColor(Integer pref) {
        if (pref == null) {
            return PreferenceLevel.prolog2bgColor(PreferenceLevel.sNeutral);
        }
        if (this.iLocation) {
            switch (pref) {
                case 1: {
                    return PreferenceLevel.prolog2bgColor(PreferenceLevel.sDiscouraged);
                }
                case 2: {
                    return PreferenceLevel.prolog2bgColor(PreferenceLevel.sStronglyDiscouraged);
                }
                case 3: {
                    return PreferenceLevel.prolog2bgColor(PreferenceLevel.sProhibited);
                }
            }
            return PreferenceLevel.prolog2bgColor(PreferenceLevel.sNeutral);
        }
        switch (pref) {
            case 1: {
                return PreferenceLevel.prolog2bgColor(PreferenceLevel.sPreferred);
            }
            case 2: {
                return PreferenceLevel.prolog2bgColor(PreferenceLevel.sStronglyPreferred);
            }
            case 3: {
                return PreferenceLevel.prolog2bgColor(PreferenceLevel.sRequired);
            }
        }
        return PreferenceLevel.prolog2bgColor(PreferenceLevel.sNeutral);
    }

    public String print(boolean editable) throws Exception {
        return this.print(editable, 0);
    }

    private String getBorderArray(Integer start) {
        StringBuffer border = new StringBuffer("[");
        for (int m = this.getStartMonth(); m <= this.getEndMonth(); ++m) {
            if (m != this.getStartMonth()) {
                border.append(",");
            }
            border.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, this.getYear());
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    border.append(",");
                }
                border.append(this.getBorder(d, m, start));
            }
            border.append("]");
        }
        border.append("]");
        return border.toString();
    }

    private String getPattern(Integer start) {
        StringBuffer pattern = new StringBuffer("[");
        for (int m = this.getStartMonth(); m <= this.getEndMonth(); ++m) {
            if (m != this.getStartMonth()) {
                pattern.append(",");
            }
            pattern.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, this.getYear());
            for (int d = 1; d <= daysOfMonth; ++d) {
                Integer date;
                if (d > 1) {
                    pattern.append(",");
                }
                if (this.iDates.contains(date = this.getDateOffset(d, m))) {
                    String pref = this.iPreferences.get(date).get(start);
                    if (pref == null) {
                        pattern.append("'@'");
                        continue;
                    }
                    pattern.append("'" + pref + "'");
                    continue;
                }
                pattern.append("'@'");
            }
            pattern.append("]");
        }
        pattern.append("]");
        return pattern.toString();
    }

    private boolean isAllProhibited(Integer start) {
        for (Integer date : this.iDates) {
            String pref = this.iPreferences.get(date).get(start);
            if (pref == null || PreferenceLevel.sProhibited.equals(pref)) continue;
            return false;
        }
        return true;
    }

    public String print(boolean editable, int length) throws Exception {
        int i;
        TreeSet<Integer> starts = new TreeSet<Integer>();
        for (Integer n : this.iStarts) {
            if (length > Constants.SLOT_LENGTH_MIN * this.iLength.get(n) || !editable && !this.iLocation && this.isAllProhibited(n)) continue;
            starts.add(n);
        }
        if (starts.isEmpty()) {
            boolean tooLong = true;
            for (Integer start : this.iStarts) {
                if (length > Constants.SLOT_LENGTH_MIN * this.iLength.get(start)) continue;
                tooLong = false;
                break;
            }
            if (tooLong) {
                return "<font color='red'>Examination is too long, no period is availabile.</font>";
            }
            return "<font color='red'>No period is availabile.</font>";
        }
        StringBuffer legendCode = new StringBuffer("[");
        StringBuffer stringBuffer = new StringBuffer("[");
        StringBuffer legendColor = new StringBuffer("[");
        for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
            if (p.getPrefProlog().equalsIgnoreCase(PreferenceLevel.sRequired)) continue;
            legendCode.append("'" + p.getPrefProlog() + "',");
            stringBuffer.append("'" + p.getPrefName() + "',");
            legendColor.append("'" + PreferenceLevel.prolog2bgColor(p.getPrefProlog()) + "',");
        }
        legendCode.append("'@']");
        stringBuffer.append("'No Period']");
        legendColor.append("'rgb(150,150,150)']");
        StringBuffer sb = new StringBuffer();
        sb.append("<script language='JavaScript' type='text/javascript' src='scripts/datepatt.js'></script>\n");
        sb.append("<script language='JavaScript'>\n");
        sb.append("var CAL_WEEKDAYS = [");
        for (i = 0; i < 7; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"" + CONSTANTS.days()[(i + 6) % 7] + "\"");
        }
        sb.append("];\n");
        sb.append("var CAL_MONTHS = [");
        for (i = 0; i < 12; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"" + Month.of(1 + i).getDisplayName(TextStyle.FULL_STANDALONE, Localization.getJavaLocale()) + "\"");
        }
        sb.append("];\n");
        int legendIdx = starts.size() == 1 ? 0 : (starts.size() == 2 ? 1 : starts.size() / 2);
        int idx = 0;
        for (Integer n : starts) {
            String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * n + Constants.FIRST_SLOT_TIME_MIN);
            String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (n + this.iLength.get(n)) + Constants.FIRST_SLOT_TIME_MIN);
            sb.append("calGenerate(" + this.getYear() + ",\n\t" + this.getStartMonth() + ",\n\t" + this.getEndMonth() + ",\n\t" + this.getPattern(n) + ",\n\t" + String.valueOf(legendCode) + "," + String.valueOf(stringBuffer) + "," + String.valueOf(legendColor) + ",'0',\n\t" + this.getBorderArray(n) + "," + editable + "," + (editable && legendIdx == idx) + ",\n\t'" + this.iName + n + "','(" + startTime + " - " + endTime + ")',6," + (n == starts.first()) + "," + (n == starts.last()) + ");\n");
            ++idx;
        }
        sb.append("</script>\n");
        return sb.toString();
    }

    public void load(HttpServletRequest request) {
        int year = this.getYear();
        for (int m = this.getStartMonth(); m <= this.getEndMonth(); ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            int yr = DateUtils.calculateActualYear(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (!this.iDates.contains(this.getDateOffset(d, m))) continue;
                for (int start : this.iStarts) {
                    String pref = request.getParameter(this.iName + start + "_val_" + yr + "_" + (12 + m) % 12 + "_" + d);
                    if (pref == null || "@".equals(pref)) continue;
                    this.iPreferences.get(this.getDateOffset(d, m)).put(start, pref);
                }
            }
        }
    }

    public String toString() {
        return this.toString(false);
    }

    private String getLabel(int fDate, int lDate, Hashtable<Integer, String> prefs, boolean html, boolean color) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        String dates = df.format(this.getDate(fDate)) + (String)(fDate == lDate ? "" : " - " + df.format(this.getDate(lDate)));
        String lastPref = null;
        int fStart = -1;
        int lStart = -1;
        Object ret = "";
        for (int start : this.iStarts) {
            String pref = prefs.get(start);
            if (pref == null) continue;
            if (lastPref == null) {
                lastPref = pref;
                fStart = start;
            } else if (!pref.equals(lastPref)) {
                if (!(this.iLocation && PreferenceLevel.sNeutral.equals(lastPref) || !this.iLocation && PreferenceLevel.sProhibited.equals(lastPref))) {
                    String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * fStart + Constants.FIRST_SLOT_TIME_MIN);
                    String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (lStart + this.iLength.get(lStart)) + Constants.FIRST_SLOT_TIME_MIN);
                    if (((String)ret).length() > 0) {
                        ret = (String)ret + ", ";
                    }
                    if (html) {
                        ret = (String)ret + "<span style='color:" + PreferenceLevel.prolog2color(lastPref) + "; white-space:nowrap;' title='" + PreferenceLevel.prolog2string(lastPref) + " " + dates + " " + startTime + " - " + endTime + "'>" + dates + " " + (this.iStarts.size() == 2 ? (fStart == this.iStarts.first() ? "Early" : "Late") : startTime) + (String)(fStart == lStart ? "" : " - " + endTime) + "</span>";
                    } else {
                        if (color) {
                            ret = (String)ret + "@@COLOR " + PreferenceLevel.prolog2color(lastPref) + " ";
                        }
                        ret = (String)ret + PreferenceLevel.prolog2abbv(lastPref) + " " + dates + " " + (this.iStarts.size() == 2 ? (fStart == this.iStarts.first() ? "Early" : "Late") : startTime) + (String)(fStart == lStart ? "" : " - " + endTime);
                    }
                }
                lastPref = pref;
                fStart = start;
            }
            lStart = start;
        }
        if (!(lastPref == null || this.iLocation && PreferenceLevel.sNeutral.equals(lastPref) || !this.iLocation && PreferenceLevel.sProhibited.equals(lastPref))) {
            String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * fStart + Constants.FIRST_SLOT_TIME_MIN);
            String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (lStart + this.iLength.get(lStart)) + Constants.FIRST_SLOT_TIME_MIN);
            if (fStart == this.iStarts.first()) {
                if (html) {
                    ret = (String)ret + "<span style='color:" + PreferenceLevel.prolog2color(lastPref) + "; white-space:nowrap;' title='" + PreferenceLevel.prolog2string(lastPref) + " " + dates + " " + startTime + " - " + endTime + "'>" + dates + "</span>";
                } else {
                    if (color) {
                        ret = (String)ret + "@@COLOR " + PreferenceLevel.prolog2color(lastPref) + " ";
                    }
                    ret = (String)ret + PreferenceLevel.prolog2abbv(lastPref) + " " + dates;
                }
            } else {
                if (((String)ret).length() > 0) {
                    ret = (String)ret + ", ";
                }
                if (html) {
                    ret = (String)ret + "<span style='color:" + PreferenceLevel.prolog2color(lastPref) + "; white-space:nowrap;' title='" + PreferenceLevel.prolog2string(lastPref) + " " + dates + " " + startTime + " - " + endTime + "'>" + dates + " " + (this.iStarts.size() == 2 ? (fStart == this.iStarts.first() ? "Early" : "Late") : startTime) + (String)(fStart == lStart ? "" : " - " + endTime) + "</span>";
                } else {
                    if (color) {
                        ret = (String)ret + "@@COLOR " + PreferenceLevel.prolog2color(lastPref) + " ";
                    }
                    ret = (String)ret + PreferenceLevel.prolog2abbv(lastPref) + " " + dates + " " + (this.iStarts.size() == 2 ? (fStart == this.iStarts.first() ? "Early" : "Late") : startTime) + (String)(fStart == lStart ? "" : " - " + endTime);
                }
            }
        }
        return ret;
    }

    public String toString(boolean html) {
        return this.toString(html, false);
    }

    public String toString(boolean html, boolean color) {
        String label;
        if (this.iStarts.isEmpty()) {
            return "";
        }
        Object ret = "";
        Hashtable<Integer, String> fPref = null;
        int fDate = -1;
        int lDate = -1;
        for (Integer date : this.iDates) {
            Hashtable<Integer, String> pref = this.iPreferences.get(date);
            if (fPref == null) {
                fPref = pref;
                fDate = date;
            } else if (!fPref.equals(pref)) {
                String label2 = this.getLabel(fDate, lDate, fPref, html, color);
                if (label2.length() > 0) {
                    if (((String)ret).length() > 0) {
                        ret = (String)ret + ", ";
                    }
                    ret = (String)ret + label2;
                }
                fPref = pref;
                fDate = date;
            }
            lDate = date;
        }
        if (fPref != null && (label = this.getLabel(fDate, lDate, fPref, html, color)).length() > 0) {
            if (((String)ret).length() > 0) {
                ret = (String)ret + ", ";
            }
            ret = (String)ret + label;
        }
        return ret;
    }

    private void addToCell(TableInterface.CellInterface ret, int fDate, int lDate, Hashtable<Integer, String> prefs) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        String dates = df.format(this.getDate(fDate)) + (String)(fDate == lDate ? "" : " - " + df.format(this.getDate(lDate)));
        String lastPref = null;
        int fStart = -1;
        int lStart = -1;
        for (int start : this.iStarts) {
            String pref = prefs.get(start);
            if (pref == null) continue;
            if (lastPref == null) {
                lastPref = pref;
                fStart = start;
            } else if (!pref.equals(lastPref)) {
                if (!(this.iLocation && PreferenceLevel.sNeutral.equals(lastPref) || !this.iLocation && PreferenceLevel.sProhibited.equals(lastPref))) {
                    String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * fStart + Constants.FIRST_SLOT_TIME_MIN);
                    String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (lStart + this.iLength.get(lStart)) + Constants.FIRST_SLOT_TIME_MIN);
                    if (ret.hasItems()) {
                        ret.add(", ");
                    }
                    ret.add(dates + " " + (this.iStarts.size() == 2 ? (fStart == this.iStarts.first() ? MSG.eveningExamsEarly() : MSG.eveningExamsLate()) : startTime) + (String)(fStart == lStart ? "" : " - " + endTime)).setColor(PreferenceLevel.prolog2color(lastPref)).setTitle(PreferenceLevel.prolog2string(lastPref) + " " + dates + " " + startTime + " - " + endTime).setNoWrap(true);
                }
                lastPref = pref;
                fStart = start;
            }
            lStart = start;
        }
        if (!(lastPref == null || this.iLocation && PreferenceLevel.sNeutral.equals(lastPref) || !this.iLocation && PreferenceLevel.sProhibited.equals(lastPref))) {
            String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * fStart + Constants.FIRST_SLOT_TIME_MIN);
            String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (lStart + this.iLength.get(lStart)) + Constants.FIRST_SLOT_TIME_MIN);
            if (ret.hasItems()) {
                ret.add(", ");
            }
            if (fStart == this.iStarts.first()) {
                ret.add(dates).setColor(PreferenceLevel.prolog2color(lastPref)).setTitle(PreferenceLevel.prolog2string(lastPref) + " " + dates + " " + startTime + " - " + endTime).setNoWrap(true);
            } else {
                ret.add(dates + " " + (this.iStarts.size() == 2 ? (fStart == this.iStarts.first() ? MSG.eveningExamsEarly() : MSG.eveningExamsLate()) : startTime) + (String)(fStart == lStart ? "" : " - " + endTime)).setColor(PreferenceLevel.prolog2color(lastPref)).setTitle(PreferenceLevel.prolog2string(lastPref) + " " + dates + " " + startTime + " - " + endTime).setNoWrap(true);
            }
        }
    }

    public TableInterface.CellInterface toCellInterface() {
        TableInterface.CellInterface ret = new TableInterface.CellInterface();
        if (this.iStarts.isEmpty()) {
            return ret;
        }
        Hashtable<Integer, String> fPref = null;
        int fDate = -1;
        int lDate = -1;
        for (Integer date : this.iDates) {
            Hashtable<Integer, String> pref = this.iPreferences.get(date);
            if (fPref == null) {
                fPref = pref;
                fDate = date;
            } else if (!fPref.equals(pref)) {
                this.addToCell(ret, fDate, lDate, fPref);
                fPref = pref;
                fDate = date;
            }
            lDate = date;
        }
        if (fPref != null) {
            this.addToCell(ret, fDate, lDate, fPref);
        }
        return ret;
    }
}

