/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.util.Date;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamGridForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.timegrid.PdfExamGridTable;

@Action(value="examGrid", results={@Result(name={"showGrid"}, type="tiles", location="examGrid.tiles")})
@TilesDefinition(name="examGrid.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Timetable"), @TilesPutAttribute(name="body", value="/exam/examGrid.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamGridAction
extends UniTimeAction<ExamGridForm> {
    private static final long serialVersionUID = 7694694407236929358L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String resource;

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String execute() throws Exception {
        TreeSet<ExamType> types;
        this.sessionContext.checkPermission(Right.ExaminationTimetable);
        ExamSolverProxy solver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new ExamGridForm();
            ((ExamGridForm)this.form).reset();
            if (solver != null) {
                ((ExamGridForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        if (((ExamGridForm)this.form).getOp() != null) {
            this.op = ((ExamGridForm)this.form).getOp();
        }
        if (this.op == null && this.resource != null) {
            this.op = MSG.buttonChange();
        }
        if (MSG.buttonChange().equals(this.op) || MSG.actionExportPdf().equals(this.op)) {
            ((ExamGridForm)this.form).save(this.sessionContext);
        }
        ((ExamGridForm)this.form).load(this.sessionContext);
        if (((ExamGridForm)this.form).getExamType() == null && !(types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())).isEmpty()) {
            ((ExamGridForm)this.form).setExamType(types.first().getUniqueId());
        }
        if ("Cbs".equals(this.op)) {
            if (this.request.getParameter("resource") != null) {
                ((ExamGridForm)this.form).setResource(Integer.parseInt(this.request.getParameter("resource")));
            }
            if (this.request.getParameter("filter") != null) {
                ((ExamGridForm)this.form).setFilter(this.request.getParameter("filter"));
            }
        }
        if (RoomAvailability.getInstance() != null && ((ExamGridForm)this.form).getExamType() != null) {
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            Date[] bounds = ExamPeriod.getBounds(session, ((ExamGridForm)this.form).getExamType());
            String exclude = ((ExamType)ExamTypeDAO.getInstance().get(((ExamGridForm)this.form).getExamType())).getReference();
            if (bounds != null) {
                RoomAvailability.getInstance().activate(session.getUniqueId(), bounds[0], bounds[1], exclude, false);
                RoomAvailability.setAvailabilityWarning(this.request, session, ((ExamGridForm)this.form).getExamType(), true, false);
            }
        }
        PdfExamGridTable table = new PdfExamGridTable((ExamGridForm)this.form, this.sessionContext, this.getExaminationSolverService().getSolver());
        this.request.setAttribute("table", (Object)table);
        if (MSG.actionExportPdf().equals(this.op)) {
            OutputStream out = ExportUtils.getPdfOutputStream(this.response, "timetable");
            table.export(out);
            out.flush();
            out.close();
            return null;
        }
        ((ExamGridForm)this.form).setOp(MSG.buttonChange());
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return "showGrid";
    }

    public void printTable() {
        PdfExamGridTable table = (PdfExamGridTable)this.request.getAttribute("table");
        table.printToHtml(this.getPageContext().getOut());
    }

    public void printLegend() {
        PdfExamGridTable table = (PdfExamGridTable)this.request.getAttribute("table");
        table.printLegend(this.getPageContext().getOut());
    }
}

