/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.ClassSearchAction;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ClassAssignmentsReportForm;
import org.unitime.timetable.form.ClassListFormInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.CsvClassAssignmentExport;
import org.unitime.timetable.webutil.WebClassAssignmentReportListTableBuilder;
import org.unitime.timetable.webutil.pdf.PdfClassAssignmentReportListTableBuilder;

@Action(value="classAssignmentsReportSearch", results={@Result(name={"showClassAssignmentsReportSearch"}, type="tiles", location="classAssignmentsReportSearch.tiles")})
@TilesDefinition(name="classAssignmentsReportSearch.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Class Assignments"), @TilesPutAttribute(name="body", value="/user/classAssignmentsReportSearch.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment"), @TilesPutAttribute(name="checkRole", value="false")})
public class ClassAssignmentsReportSearchAction
extends UniTimeAction<ClassAssignmentsReportForm> {
    private static final long serialVersionUID = -2339315783902007234L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String doit;
    private String[] subjectAreaIds;
    private String loadFilter;
    private boolean showTable = false;

    public String getDoit() {
        return this.doit;
    }

    public void setDoit(String doit) {
        this.doit = doit;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public String getLoadFilter() {
        return this.loadFilter;
    }

    public void setLoadFilter(String loadFilter) {
        this.loadFilter = loadFilter;
    }

    public boolean isShowTable() {
        return this.showTable;
    }

    public void setShowTable(boolean showTable) {
        this.showTable = showTable;
    }

    public String execute() throws Exception {
        if (ApplicationProperty.LegacyClassAssignments.isFalse()) {
            Object url = "classAssignments";
            boolean first = true;
            Enumeration e = this.getRequest().getParameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                url = (String)url + (first ? "?" : "&") + param + "=" + URLEncoder.encode(this.getRequest().getParameter(param), "utf-8");
                first = false;
            }
            this.response.sendRedirect((String)url);
            return null;
        }
        if (this.form == null) {
            this.form = new ClassAssignmentsReportForm();
        }
        if (this.getSubjectAreaIds() != null) {
            ((ClassAssignmentsReportForm)this.form).setSubjectAreaIds(this.getSubjectAreaIds());
        }
        LookupTables.setupItypes(this.request, true);
        if (MSG.actionSearchClassAssignments().equals(this.doit) || "Search".equals(this.doit)) {
            return this.searchClasses();
        }
        if (MSG.actionExportPdf().equals(this.doit)) {
            return this.exportPdf();
        }
        if (MSG.actionExportCsv().equals(this.doit)) {
            return this.exportCsv();
        }
        BackTracker.markForBack(this.request, null, null, false, true);
        this.sessionContext.checkPermission(Right.ClassAssignments);
        this.request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        ClassAssignmentsReportSearchAction.setupGeneralFormFilters(this.sessionContext.getUser(), (ClassAssignmentsReportForm)this.form);
        if (this.request.getParameter("sortBy") != null) {
            ((ClassAssignmentsReportForm)this.form).setSortBy(this.request.getParameter("sortBy"));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedRoom(this.request.getParameter("filterAssignedRoom"));
            ((ClassAssignmentsReportForm)this.form).setFilterManager(this.request.getParameter("filterManager"));
            ((ClassAssignmentsReportForm)this.form).setFilterIType(this.request.getParameter("filterIType"));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeMon(this.request.getParameter("filterAssignedTimeMon") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeMon")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeTue(this.request.getParameter("filterAssignedTimeTue") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeTue")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeWed(this.request.getParameter("filterAssignedTimeWed") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeWed")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeThu(this.request.getParameter("filterAssignedTimeThu") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeThu")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeFri(this.request.getParameter("filterAssignedTimeFri") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeFri")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeSat(this.request.getParameter("filterAssignedTimeSat") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeSat")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeSun(this.request.getParameter("filterAssignedTimeSun") == null ? false : Boolean.getBoolean(this.request.getParameter("filterAssignedTimeSun")));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeHour(this.request.getParameter("filterAssignedTimeHour"));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeMin(this.request.getParameter("filterAssignedTimeMin"));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeAmPm(this.request.getParameter("filterAssignedTimeAmPm"));
            ((ClassAssignmentsReportForm)this.form).setFilterAssignedTimeLength(this.request.getParameter("filterAssignedTimeLength"));
            ((ClassAssignmentsReportForm)this.form).setSortByKeepSubparts(Boolean.getBoolean(this.request.getParameter("sortByKeepSubparts")));
        }
        ((ClassAssignmentsReportForm)this.form).setSubjectAreas(SubjectArea.getAllSubjectAreas(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        Object sas = this.sessionContext.getAttribute(SessionAttribute.ClassAssignmentsSubjectAreas);
        if (sas == null) {
            sas = this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
        }
        if (Constants.ALL_OPTION_VALUE.equals(sas)) {
            sas = null;
        }
        if (sas != null && sas.toString().trim().length() > 0) {
            String subjectAreaIds = sas.toString();
            try {
                Debug.debug("Subject Areas: " + subjectAreaIds);
                ((ClassAssignmentsReportForm)this.form).setSubjectAreaIds(subjectAreaIds.split(","));
                Integer maxSubjectsToSearch = ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue();
                if (maxSubjectsToSearch != null && maxSubjectsToSearch >= 0 && ((ClassAssignmentsReportForm)this.form).getSubjectAreaIds().length > maxSubjectsToSearch) {
                    this.setShowTable(false);
                    return "showClassAssignmentsReportSearch";
                }
                ((ClassAssignmentsReportForm)this.form).validate(this);
                if (this.hasFieldErrors()) {
                    this.setShowTable(false);
                    return "showClassAssignmentsReportSearch";
                }
                ((ClassAssignmentsReportForm)this.form).setClasses(ClassSearchAction.getClasses((ClassListFormInterface)((Object)this.form), this.getClassAssignmentService().getAssignment()));
                Collection<Class_> classes = ((ClassAssignmentsReportForm)this.form).getClasses();
                if (classes.isEmpty()) {
                    this.addFieldError("searchResult", MSG.errorNoRecords());
                    this.setShowTable(false);
                    return "showClassAssignmentsReportSearch";
                }
                StringBuffer ids = new StringBuffer();
                StringBuffer names = new StringBuffer();
                for (int i = 0; i < ((ClassAssignmentsReportForm)this.form).getSubjectAreaIds().length; ++i) {
                    if (i > 0) {
                        names.append(",");
                    }
                    ids.append("&subjectAreaIds=" + ((ClassAssignmentsReportForm)this.form).getSubjectAreaIds()[i]);
                    names.append(((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((ClassAssignmentsReportForm)this.form).getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
                }
                BackTracker.markForBack(this.request, "classAssignmentsReportSearch.action?doit=Search&loadFilter=1" + String.valueOf(ids), "Class Assignments (" + String.valueOf(names) + ")", true, true);
                this.setShowTable(true);
                return "showClassAssignmentsReportSearch";
            }
            catch (NumberFormatException nfe) {
                Debug.error("Subject Area Ids session attribute is corrupted. Resetting ... ");
                this.sessionContext.removeAttribute(SessionAttribute.ClassAssignmentsSubjectAreas);
            }
        }
        this.setShowTable(false);
        return "showClassAssignmentsReportSearch";
    }

    private void initializeFilters() {
        if ("1".equals(this.getLoadFilter())) {
            ClassAssignmentsReportSearchAction.setupGeneralFormFilters(this.sessionContext.getUser(), (ClassAssignmentsReportForm)this.form);
        } else {
            this.sessionContext.getUser().setProperty("ClassAssignments.sortByKeepSubparts", ((ClassAssignmentsReportForm)this.form).getSortByKeepSubparts() ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassAssignments.sortBy", ((ClassAssignmentsReportForm)this.form).getSortBy());
            this.sessionContext.getUser().setProperty("ClassAssignments.filterAssignedRoom", ((ClassAssignmentsReportForm)this.form).getFilterAssignedRoom());
            this.sessionContext.getUser().setProperty("ClassAssignments.filterManager", ((ClassAssignmentsReportForm)this.form).getFilterManager());
            this.sessionContext.getUser().setProperty("ClassAssignments.filterIType", ((ClassAssignmentsReportForm)this.form).getFilterIType());
            this.sessionContext.getUser().setProperty("ClassAssignments.filterDayCode", String.valueOf(((ClassAssignmentsReportForm)this.form).getFilterDayCode()));
            this.sessionContext.getUser().setProperty("ClassAssignments.filterStartSlot", String.valueOf(((ClassAssignmentsReportForm)this.form).getFilterStartSlot()));
            this.sessionContext.getUser().setProperty("ClassAssignments.filterLength", String.valueOf(((ClassAssignmentsReportForm)this.form).getFilterLength()));
            this.sessionContext.getUser().setProperty("ClassAssignments.showCrossListedClasses", ((ClassAssignmentsReportForm)this.form).getShowCrossListedClasses() ? "1" : "0");
        }
    }

    public static void setupGeneralFormFilters(UserContext user, ClassAssignmentsReportForm form) {
        form.setSortBy(user.getProperty("ClassAssignments.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        form.setFilterAssignedRoom(user.getProperty("ClassAssignments.filterAssignedRoom", ""));
        form.setFilterManager(user.getProperty("ClassAssignments.filterManager", ""));
        form.setFilterIType(user.getProperty("ClassAssignments.filterIType", ""));
        form.setFilterDayCode(Integer.valueOf(user.getProperty("ClassAssignments.filterDayCode", "-1")));
        form.setFilterStartSlot(Integer.valueOf(user.getProperty("ClassAssignments.filterStartSlot", "-1")));
        form.setFilterLength(Integer.valueOf(user.getProperty("ClassAssignments.filterLength", "-1")));
        form.setSortByKeepSubparts("1".equals(user.getProperty("ClassAssignments.sortByKeepSubparts", "1")));
        form.setShowCrossListedClasses("1".equals(user.getProperty("ClassAssignments.showCrossListedClasses", "0")));
    }

    public String searchClasses() throws Exception {
        return this.performAction("search");
    }

    public String exportPdf() throws Exception {
        return this.performAction("exportPdf");
    }

    public String exportCsv() throws Exception {
        return this.performAction("exportCsv");
    }

    public String performAction(String action) throws Exception {
        this.sessionContext.checkPermission(Right.ClassAssignments);
        if (!(action.equals("search") || action.equals("exportPdf") || action.equals("exportCsv"))) {
            throw new Exception("Unrecognized Action");
        }
        this.request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        this.initializeFilters();
        ((ClassAssignmentsReportForm)this.form).setSubjectAreas(SubjectArea.getAllSubjectAreas(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        ((ClassAssignmentsReportForm)this.form).validate(this);
        if (this.hasFieldErrors()) {
            this.setShowTable(false);
            return "showClassAssignmentsReportSearch";
        }
        ((ClassAssignmentsReportForm)this.form).setClasses(ClassSearchAction.getClasses((ClassListFormInterface)((Object)this.form), this.getClassAssignmentService().getAssignment()));
        Collection<Class_> classes = ((ClassAssignmentsReportForm)this.form).getClasses();
        if (classes.isEmpty()) {
            this.addFieldError("searchResult", MSG.errorNoRecords());
            this.setShowTable(false);
            return "showClassAssignmentsReportSearch";
        }
        StringBuffer subjIds = new StringBuffer();
        StringBuffer ids = new StringBuffer();
        StringBuffer names = new StringBuffer();
        for (int i = 0; i < ((ClassAssignmentsReportForm)this.form).getSubjectAreaIds().length; ++i) {
            if (i > 0) {
                names.append(",");
                subjIds.append(",");
            }
            ids.append("&subjectAreaIds=" + ((ClassAssignmentsReportForm)this.form).getSubjectAreaIds()[i]);
            subjIds.append(((ClassAssignmentsReportForm)this.form).getSubjectAreaIds()[i]);
            names.append(((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((ClassAssignmentsReportForm)this.form).getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
        }
        this.sessionContext.setAttribute(SessionAttribute.ClassAssignmentsSubjectAreas, (Object)subjIds);
        if ("search".equals(action)) {
            BackTracker.markForBack(this.request, "classAssignmentsReportSearch.action?doit=Search&loadFilter=1" + String.valueOf(ids), MSG.backClassAssignments(names.toString()), true, true);
            this.setShowTable(true);
        } else {
            if ("exportPdf".equals(action)) {
                OutputStream out = ExportUtils.getPdfOutputStream(this.response, "classassign");
                new PdfClassAssignmentReportListTableBuilder().pdfTableForClasses(out, this.getClassAssignmentService().getAssignment(), (ExamAssignmentProxy)this.getExaminationSolverService().getSolver(), (ClassAssignmentsReportForm)this.form, this.sessionContext);
                out.flush();
                out.close();
                return null;
            }
            if ("exportCsv".equals(action)) {
                ExportUtils.exportCSV(CsvClassAssignmentExport.exportCsv(this.sessionContext.getUser(), ((ClassAssignmentsReportForm)this.form).getClasses(), this.getClassAssignmentService().getAssignment()), this.response, "classassign");
                return null;
            }
        }
        return "showClassAssignmentsReportSearch";
    }

    public List<IdValue> getManagers() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        ret.add(new IdValue(-2L, MSG.dropDeptDepartment()));
        for (Department d : (TreeSet)this.request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)) {
            ret.add(new IdValue(d.getUniqueId(), d.getManagingDeptLabel()));
        }
        return ret;
    }

    public int getFilterManagerSize() {
        int size = 1 + ((TreeSet)this.request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)).size();
        return Math.min(size, 3);
    }

    public String printTable() throws Exception {
        new WebClassAssignmentReportListTableBuilder().htmlTableForClasses(this.sessionContext, this.getClassAssignmentService().getAssignment(), (ExamAssignmentProxy)this.getExaminationSolverService().getSolver(), (ClassAssignmentsReportForm)this.form, this.getPageContext().getOut(), this.request.getParameter("backType"), this.request.getParameter("backId"));
        return "";
    }
}

