/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.AccessStatistics;
import org.unitime.timetable.model.dao.AccessStatisticsDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.IdValue;

@Action(value="accessStats", results={@Result(name={"show"}, type="tiles", location="stats.tiles")})
@TilesDefinition(name="accessStats.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Access Statistics"), @TilesPutAttribute(name="body", value="/admin/accessStats.jsp")})
public class AccessStatsAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = 1827478747175650862L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GWT_MSG = Localization.create(GwtMessages.class);
    private Page iPage;
    private Type iType;
    private Interval iInterval;
    private DateFormat sDF = new SimpleDateFormat("yyyyMMdd-HHmm");
    private Date iFrom;
    private Date iTo;
    private String iFromDate;
    private String iToDate;
    private Integer iFromSlot;
    private Integer iToSlot;

    public String getPage() {
        return this.iPage == null ? null : this.iPage.getId();
    }

    public void setPage(String page) {
        this.iPage = page == null || page.isEmpty() ? null : Page.valueOf(page);
    }

    public String getType() {
        return this.iType == null ? null : this.iType.getId();
    }

    public void setType(String type) {
        this.iType = type == null || type.isEmpty() ? null : Type.valueOf(type);
    }

    public String getInterval() {
        if (this.iFrom != null) {
            return Interval.CUSTOM.getId();
        }
        return this.iInterval == null ? null : this.iInterval.getId();
    }

    public void setInterval(String interval) {
        this.iInterval = interval == null || interval.isEmpty() ? null : Interval.valueOf(interval);
    }

    public String getFrom() {
        return this.iFrom == null ? null : this.sDF.format(this.iFrom);
    }

    public void setFrom(String date) {
        if (date == null || date.isEmpty()) {
            this.iFrom = null;
        } else {
            try {
                this.iFrom = this.sDF.parse(date);
            }
            catch (ParseException e) {
                this.iFrom = null;
            }
        }
    }

    public void setFromDate(String date) {
        this.iFromDate = date;
    }

    public String getFromDate() {
        if (this.iFrom != null) {
            return Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).format(this.iFrom);
        }
        return this.iFromDate;
    }

    public void setFromSlot(Integer slot) {
        this.iFromSlot = slot;
    }

    public Integer getFromSlot() {
        if (this.iFrom != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.iFrom);
            return c.get(11) * 12 + c.get(12) / 5;
        }
        return this.iFromSlot;
    }

    public String getTo() {
        return this.iTo == null ? null : this.sDF.format(this.iTo);
    }

    public void setTo(String date) {
        if (date == null || date.isEmpty()) {
            this.iTo = null;
        } else {
            try {
                this.iTo = this.sDF.parse(date);
            }
            catch (ParseException e) {
                this.iTo = null;
            }
        }
    }

    public void setToDate(String date) {
        this.iToDate = date;
    }

    public String getToDate() {
        if (this.iTo != null) {
            return Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).format(this.iTo);
        }
        return this.iToDate;
    }

    public void setToSlot(Integer slot) {
        this.iToSlot = slot;
    }

    public Integer getToSlot() {
        if (this.iTo != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.iTo);
            return c.get(11) * 12 + c.get(12) / 5;
        }
        return this.iToSlot;
    }

    public Date getFromDateTime() {
        if (this.iFrom != null) {
            return this.iFrom;
        }
        if (this.iFromDate == null || this.iFromDate.isEmpty()) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).parse(this.iFromDate));
        }
        catch (ParseException e) {
            return null;
        }
        if (this.iFromSlot != null) {
            c.set(11, this.iFromSlot / 12);
            c.set(12, 5 * (this.iFromSlot % 12));
        }
        return c.getTime();
    }

    public Date getToDateTime() {
        if (this.iTo != null) {
            return this.iTo;
        }
        if (this.iToDate == null || this.iToDate.isEmpty()) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).parse(this.iToDate));
        }
        catch (ParseException e) {
            return null;
        }
        if (this.iToSlot != null) {
            c.set(11, this.iToSlot / 12);
            c.set(12, 5 * (this.iToSlot % 12));
        } else {
            c.add(6, 1);
        }
        return c.getTime();
    }

    public String execute() {
        this.sessionContext.checkPermission(Right.AccessStatistics);
        return "show";
    }

    public List<String> getHosts() {
        if (this.iPage == null || this.iType == null) {
            return null;
        }
        if (this.iFrom != null) {
            return AccessStatisticsDAO.getInstance().getSession().createQuery("select host from AccessStatistics where access > 0 and page = :page and timeStamp > :since group by host order by host", String.class).setParameter("page", (Object)this.iPage.name()).setParameter("since", (Object)this.iFrom).setCacheable(true).list();
        }
        if (this.iInterval == Interval.CUSTOM) {
            Date since = this.getFromDateTime();
            if (since == null) {
                return null;
            }
            return AccessStatisticsDAO.getInstance().getSession().createQuery("select host from AccessStatistics where access > 0 and page = :page and timeStamp > :since group by host order by host", String.class).setParameter("page", (Object)this.iPage.name()).setParameter("since", (Object)since).setCacheable(true).list();
        }
        if (this.iInterval != null) {
            return AccessStatisticsDAO.getInstance().getSession().createQuery("select host from AccessStatistics where access > 0 and page = :page and timeStamp > :since group by host order by host", String.class).setParameter("page", (Object)this.iPage.name()).setParameter("since", (Object)this.iInterval.getSince()).setCacheable(true).list();
        }
        return null;
    }

    public Type[] getTypes() {
        return Type.values();
    }

    public Page[] getPages() {
        return Page.values();
    }

    public Interval[] getIntervals() {
        return Interval.values();
    }

    public List<AccessStatistics> getData(String host) {
        if (this.iFrom != null) {
            if (this.iTo == null) {
                return AccessStatisticsDAO.getInstance().getSession().createQuery("from AccessStatistics where access > 0 and host = :host and page = :page and timeStamp >= :from order by timeStamp", AccessStatistics.class).setParameter("host", (Object)host).setParameter("page", (Object)this.iPage.name()).setParameter("from", (Object)this.iFrom).list();
            }
            return AccessStatisticsDAO.getInstance().getSession().createQuery("from AccessStatistics where access > 0 and host = :host and page = :page and timeStamp >= :from and timeStamp <= :to order by timeStamp", AccessStatistics.class).setParameter("host", (Object)host).setParameter("page", (Object)this.iPage.name()).setParameter("from", (Object)this.iFrom).setParameter("to", (Object)this.iTo).list();
        }
        if (this.iInterval == Interval.CUSTOM) {
            Date from = this.getFromDateTime();
            Date to = this.getToDateTime();
            if (from != null) {
                if (to == null) {
                    return AccessStatisticsDAO.getInstance().getSession().createQuery("from AccessStatistics where access > 0 and host = :host and page = :page and timeStamp >= :from order by timeStamp", AccessStatistics.class).setParameter("host", (Object)host).setParameter("page", (Object)this.iPage.name()).setParameter("from", (Object)from).list();
                }
                return AccessStatisticsDAO.getInstance().getSession().createQuery("from AccessStatistics where access > 0 and host = :host and page = :page and timeStamp >= :from and timeStamp <= :to order by timeStamp", AccessStatistics.class).setParameter("host", (Object)host).setParameter("page", (Object)this.iPage.name()).setParameter("from", (Object)from).setParameter("to", (Object)to).list();
            }
            return null;
        }
        if (this.iInterval != null) {
            return AccessStatisticsDAO.getInstance().getSession().createQuery("from AccessStatistics where access > 0 and host = :host and page = :page and timeStamp >= :since order by timeStamp", AccessStatistics.class).setParameter("host", (Object)host).setParameter("page", (Object)this.iPage.name()).setParameter("since", (Object)this.iInterval.getSince()).list();
        }
        return null;
    }

    public String getChartData(String host) {
        if (this.iPage == null || this.iType == null) {
            return null;
        }
        List<AccessStatistics> data = this.getData(host);
        if (data == null || data.isEmpty()) {
            return null;
        }
        int mod = 1;
        if (data.size() > 1000) {
            mod = data.size() / 1000;
        }
        switch (this.iType) {
            case ACTIVE: {
                return AccessStatsAction.getVisualisationDataActive(data, mod);
            }
            case BASIC: {
                return AccessStatsAction.getVisualisationDataBasic(data, mod);
            }
            case TIME: {
                return AccessStatsAction.getVisualisationDataTimes(data, mod);
            }
        }
        return null;
    }

    public String getChartLabel(String host) {
        if (this.iPage == null || this.iType == null) {
            return null;
        }
        if (this.iFrom != null) {
            Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT);
            if (this.iTo == null) {
                return this.iPage.getLabel() + " " + this.iType.getLabel() + " (" + dateFormat.format(this.iFrom) + " @ " + host + ")";
            }
            return this.iPage.getLabel() + " " + this.iType.getLabel() + " (" + dateFormat.format(this.iFrom) + " - " + dateFormat.format(this.iTo) + " @ " + host + ")";
        }
        if (this.iInterval != null) {
            return this.iPage.getLabel() + " " + this.iType.getLabel() + " (" + this.iInterval.getLabel() + " @ " + host + ")";
        }
        return null;
    }

    public static String getVisualisationDataBasic(List<AccessStatistics> data, int mod) {
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT);
        Formats.Format<Number> numberFormat = Formats.getNumberFormat("0.##");
        double opened = 0.0;
        double access = 0.0;
        double active = 0.0;
        double waiting = 0.0;
        double gotIn = 0.0;
        double left = 0.0;
        double gaveUp = 0.0;
        int cnt = 0;
        long increment = 1000 * (60 * mod + 30);
        long first = -1L;
        long last = -1L;
        ArrayList<DataLine> lines = new ArrayList<DataLine>();
        for (AccessStatistics stat : data) {
            if (cnt == mod || cnt > 0 && first + increment < stat.getTimeStamp().getTime()) {
                lines.add(new DataLine(dateFormat.format(new Date(first)), opened / (double)cnt, access / (double)cnt, active / (double)cnt, waiting / (double)cnt, gotIn / (double)cnt, left / (double)cnt, gaveUp / (double)cnt));
                cnt = 0;
                opened = 0.0;
                access = 0.0;
                active = 0.0;
                waiting = 0.0;
                gotIn = 0.0;
                left = 0.0;
                gaveUp = 0.0;
            }
            if (cnt == 0) {
                first = stat.getTimeStamp().getTime();
            }
            last = stat.getTimeStamp().getTime();
            ++cnt;
            opened += (double)stat.getOpened().intValue();
            access += (double)stat.getAccess().intValue();
            active += (double)stat.getActive().intValue();
            waiting += (double)stat.getWaiting().intValue();
            if (stat.getGotIn() != null) {
                gotIn += (double)stat.getGotIn().intValue();
            }
            if (stat.getLeft() != null) {
                left += (double)stat.getLeft().intValue();
            }
            if (stat.getGaveUp() == null) continue;
            gaveUp += (double)stat.getGaveUp().intValue();
        }
        if (cnt > 0) {
            lines.add(new DataLine(dateFormat.format(new Date(last)), opened / (double)cnt, access / (double)cnt, active / (double)cnt, waiting / (double)cnt, gotIn / (double)cnt, left / (double)cnt, gaveUp / (double)cnt));
        }
        String ret = "[\n['" + MSG.chartBasicDate() + "', '" + MSG.chartBasicOpened() + "', '" + MSG.chartBasicAccess() + "', '" + MSG.chartBasicActive() + "', '" + MSG.chartBasicWaiting() + "', '" + MSG.chartBasicGotIn() + "', '" + MSG.chartBasicLeft() + "', '" + MSG.chartBasicGaveUp() + "']";
        for (DataLine line : lines) {
            ret = ret + ",\n" + line.toString(numberFormat);
        }
        ret = ret + "\n]";
        return ret;
    }

    public static String getVisualisationDataActive(List<AccessStatistics> data, int mod) {
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT);
        Formats.Format<Number> numberFormat = Formats.getNumberFormat("0.##");
        double active1 = 0.0;
        double active2 = 0.0;
        double active5 = 0.0;
        double active10 = 0.0;
        double active15 = 0.0;
        int cnt = 0;
        long increment = 1000 * (60 * cnt + 30);
        long first = -1L;
        long last = -1L;
        ArrayList<DataLine> lines = new ArrayList<DataLine>();
        for (AccessStatistics stat : data) {
            if (cnt == mod || cnt > 0 && first + increment < stat.getTimeStamp().getTime()) {
                lines.add(new DataLine(dateFormat.format(new Date(first)), active1 / (double)cnt, active2 / (double)cnt, active5 / (double)cnt, active10 / (double)cnt, active15 / (double)cnt));
                cnt = 0;
                active1 = 0.0;
                active2 = 0.0;
                active5 = 0.0;
                active10 = 0.0;
                active15 = 0.0;
            }
            if (cnt == 0) {
                first = stat.getTimeStamp().getTime();
            }
            last = stat.getTimeStamp().getTime();
            ++cnt;
            active1 += (double)stat.getActive1m().intValue();
            active2 += (double)stat.getActive2m().intValue();
            active5 += (double)stat.getActive5m().intValue();
            active10 += (double)stat.getActive10m().intValue();
            active15 += (double)stat.getActive15m().intValue();
        }
        if (cnt > 0) {
            lines.add(new DataLine(dateFormat.format(new Date(last)), active1 / (double)cnt, active2 / (double)cnt, active5 / (double)cnt, active10 / (double)cnt, active15 / (double)cnt));
        }
        if (lines.isEmpty()) {
            return null;
        }
        String ret = "[\n['" + MSG.chartBasicDate() + "', '" + MSG.chartActive1m() + "', '" + MSG.chartActive2m() + "', '" + MSG.chartActive5m() + "', '" + MSG.chartActive10m() + "', '" + MSG.chartActive15m() + "']";
        for (DataLine line : lines) {
            ret = ret + ",\n" + line.toString(numberFormat);
        }
        ret = ret + "\n]";
        return ret;
    }

    public static String getVisualisationDataTimes(List<AccessStatistics> data, int mod) {
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT);
        Formats.Format<Number> numberFormat = Formats.getNumberFormat("0.##");
        double avgWait = 0.0;
        int wait = 0;
        double avgAcces = 0.0;
        int access = 0;
        double avgWaitGotIn = 0.0;
        int gotIn = 0;
        double avgAccesLeft = 0.0;
        int left = 0;
        int cnt = 0;
        long increment = 1000 * (60 * cnt + 30);
        long first = -1L;
        long last = -1L;
        ArrayList<DataLine> lines = new ArrayList<DataLine>();
        for (AccessStatistics stat : data) {
            if (cnt == mod || cnt > 0 && first + increment < stat.getTimeStamp().getTime()) {
                lines.add(new DataLine(dateFormat.format(new Date(last)), (access > 0 ? avgAcces / (double)access : 0.0) / 60.0, (wait > 0 ? avgWait / (double)wait : 0.0) / 60.0, (left > 0 ? avgAccesLeft / (double)left : 0.0) / 60.0, (gotIn > 0 ? avgWaitGotIn / (double)gotIn : 0.0) / 60.0));
                cnt = 0;
                avgWait = 0.0;
                wait = 0;
                avgAcces = 0.0;
                access = 0;
                avgWaitGotIn = 0.0;
                gotIn = 0;
                avgAccesLeft = 0.0;
                left = 0;
            }
            if (cnt == 0) {
                first = stat.getTimeStamp().getTime();
            }
            last = stat.getTimeStamp().getTime();
            ++cnt;
            if (stat.getAvgWaitTime() != null && stat.getWaiting() > 0) {
                avgWait += (double)(stat.getAvgWaitTime() * (long)stat.getWaiting().intValue());
                wait += stat.getWaiting().intValue();
            }
            if (stat.getAvgAccessTime() != null && stat.getAccess() > 0) {
                avgAcces += (double)(stat.getAvgAccessTime() * (long)stat.getAccess().intValue());
                access += stat.getAccess().intValue();
            }
            if (stat.getAvgAccessTimeWhenLeft() != null && stat.getLeft() > 0) {
                avgAccesLeft += (double)(stat.getAvgAccessTimeWhenLeft() * (long)stat.getLeft().intValue());
                left += stat.getLeft().intValue();
            }
            if (stat.getAvgWaitTimeWhenGotIn() == null || stat.getGotIn() <= 0) continue;
            avgWaitGotIn += (double)(stat.getAvgWaitTimeWhenGotIn() * (long)stat.getGotIn().intValue());
            gotIn += stat.getGotIn().intValue();
        }
        if (cnt > 0) {
            lines.add(new DataLine(dateFormat.format(new Date(last)), (access > 0 ? avgAcces / (double)access : 0.0) / 60.0, (wait > 0 ? avgWait / (double)wait : 0.0) / 60.0, (left > 0 ? avgAccesLeft / (double)left : 0.0) / 60.0, (gotIn > 0 ? avgWaitGotIn / (double)gotIn : 0.0) / 60.0));
        }
        if (lines.isEmpty()) {
            return null;
        }
        String ret = "[\n['" + MSG.chartBasicDate() + "', '" + MSG.chartTimesAccess() + "', '" + MSG.chartTimesWait() + "', '" + MSG.chartTimesAccessLeft() + "', '" + MSG.chartTimesWaitGotIn() + "']";
        for (DataLine line : lines) {
            ret = ret + ",\n" + line.toString(numberFormat);
        }
        ret = ret + "\n]";
        return ret;
    }

    public List<IdValue> getTimes() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (int slot = 0; slot <= 288; slot += 3) {
            ret.add(new IdValue(Long.valueOf(slot), Constants.slot2str(slot)));
        }
        return ret;
    }

    public static enum Page {
        sectioning,
        requests;


        public String getId() {
            return this.name();
        }

        public String getLabel() {
            switch (this) {
                case requests: {
                    return GWT_MSG.pageStudentCourseRequests();
                }
                case sectioning: {
                    return GWT_MSG.pageStudentSchedulingAssistant();
                }
            }
            return this.name();
        }
    }

    public static enum Type {
        BASIC,
        ACTIVE,
        TIME;


        public String getId() {
            return this.name();
        }

        public String getLabel() {
            switch (this) {
                case BASIC: {
                    return MSG.chartModeBasic();
                }
                case ACTIVE: {
                    return MSG.chartModeActive();
                }
                case TIME: {
                    return MSG.chartModeTimes();
                }
            }
            return this.name();
        }
    }

    public static enum Interval {
        LAST_HOUR,
        LAST_3HOURS,
        LAST_DAY,
        LAST_WEEK,
        LAST_MONTH,
        CUSTOM;


        public String getId() {
            return this.name();
        }

        public String getLabel() {
            switch (this) {
                case LAST_DAY: {
                    return MSG.chartIntervalLastDay();
                }
                case LAST_3HOURS: {
                    return MSG.chartIntervalLast3Hours();
                }
                case LAST_HOUR: {
                    return MSG.chartIntervalLastHour();
                }
                case LAST_WEEK: {
                    return MSG.chartIntervalLastWeek();
                }
                case LAST_MONTH: {
                    return MSG.chartIntervalLastMonth();
                }
                case CUSTOM: {
                    return MSG.chartIntervalCustom();
                }
            }
            return this.name();
        }

        public Date getSince() {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            switch (this) {
                case LAST_3HOURS: {
                    c.add(11, -3);
                    break;
                }
                case LAST_DAY: {
                    c.add(6, -1);
                    break;
                }
                case LAST_HOUR: {
                    c.add(11, -1);
                    break;
                }
                case LAST_MONTH: {
                    c.add(2, -1);
                    break;
                }
                case LAST_WEEK: {
                    c.add(6, -7);
                }
            }
            return c.getTime();
        }
    }

    private static class DataLine {
        String iName;
        double[] iData;

        private DataLine(String name, double ... data) {
            this.iName = name;
            this.iData = data;
        }

        public String toString(Formats.Format<Number> format) {
            String ret = "['" + this.iName + "'";
            for (double d : this.iData) {
                ret = ret + "," + format.format(d);
            }
            ret = ret + "]";
            return ret;
        }
    }
}

