/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gwt.i18n.client.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.gwt.resources.Constants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.Messages;
import org.unitime.timetable.util.Constants;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PageNameGenerator {
    private Map<String, String> iPageNames = new HashMap<String, String>();
    private File iSource;

    public void setSource(File source) {
        this.iSource = source;
    }

    protected boolean addValue(String name) {
        String key = this.name2property(name);
        if (this.iPageNames.containsKey(key)) {
            return false;
        }
        this.iPageNames.put(key, name);
        return true;
    }

    protected boolean addKey(String key) {
        if (this.iPageNames.containsKey(key)) {
            return false;
        }
        this.iPageNames.put(key, this.property2name(key));
        return true;
    }

    protected boolean addPair(String key, String name) {
        if (this.iPageNames.containsKey(key)) {
            return false;
        }
        this.iPageNames.put(key, name);
        return true;
    }

    public void checkPageNamecClass() {
        for (Method method : PageNames.class.getMethods()) {
            Messages.DefaultMessage dm = method.getAnnotation(Messages.DefaultMessage.class);
            if (dm == null || !this.addValue(dm.value())) continue;
            System.out.println("[names] " + dm.value());
        }
    }

    public void checkMenuXML() throws DocumentException, IOException {
        SAXReader sax = new SAXReader();
        Document document = null;
        InputStream is = PageNameGenerator.class.getClassLoader().getResourceAsStream("menu.xml");
        if (is != null) {
            sax.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId.equals("-//UniTime//UniTime Menu DTD/EN")) {
                        return new InputSource(PageNameGenerator.class.getClassLoader().getResourceAsStream("menu.dtd"));
                    }
                    return null;
                }
            });
            document = sax.read(is);
        } else if (this.iSource != null) {
            File file = new File(this.iSource, "menu.xml");
            sax.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId.equals("-//UniTime//UniTime Menu DTD/EN")) {
                        try {
                            return new InputSource(new FileInputStream(new File(PageNameGenerator.this.iSource, "menu.dtd")));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
            System.out.println(" [menu] Using " + String.valueOf(new File(this.iSource, "menu.xml")));
            document = sax.read(file);
        }
        if (document != null) {
            this.parseMenu(document.getRootElement());
        }
    }

    protected void parseMenu(Element element) {
        String name;
        Iterator i = element.elementIterator("item");
        while (i.hasNext()) {
            Element item = (Element)i.next();
            name = item.attributeValue("name");
            if (name == null || name.isEmpty() || !this.addValue(name)) continue;
            System.out.println(" [menu] " + name);
        }
        i = element.elementIterator("menu");
        while (i.hasNext()) {
            Element menu = (Element)i.next();
            name = menu.attributeValue("name");
            if (name != null && !name.isEmpty() && this.addValue(name)) {
                System.out.println(" [menu] " + name);
            }
            this.parseMenu(menu);
        }
    }

    public void checkProperties() throws IOException {
        Properties properties = new Properties();
        InputStream is = PageNameGenerator.class.getClassLoader().getResourceAsStream("org/unitime/localization/messages/PageNames.properties");
        if (is == null && this.iSource != null) {
            is = new FileInputStream(new File(this.iSource, "org" + File.separator + "unitime" + File.separator + "localization" + File.separator + "messages" + File.separator + "PageNames.properties"));
        }
        if (is == null) {
            return;
        }
        try {
            properties.load(is);
        }
        finally {
            is.close();
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String name;
            String key = (String)e.getKey();
            if (!this.addPair(key, name = (String)e.getValue())) continue;
            System.out.println("   [default] " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLocale(String locale) throws IOException {
        Properties properties = new Properties();
        InputStream is = PageNameGenerator.class.getClassLoader().getResourceAsStream("org/unitime/localization/messages/PageNames_" + locale + ".properties");
        if (is == null && this.iSource != null) {
            is = new FileInputStream(new File(this.iSource, "org" + File.separator + "unitime" + File.separator + "localization" + File.separator + "messages" + File.separator + "PageNames_" + locale + ".properties"));
        }
        if (is == null) {
            return;
        }
        try {
            properties.load(is);
        }
        finally {
            is.close();
        }
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (!this.addKey(key)) continue;
            System.out.println("   [" + locale + "] " + this.property2name(key));
        }
    }

    public void checkGwtMessages() {
        for (Method method : GwtMessages.class.getMethods()) {
            Messages.DefaultMessage dm;
            boolean doNotTranslate;
            if (!method.getName().startsWith("page")) continue;
            boolean bl = doNotTranslate = method.getAnnotation(Messages.DoNotTranslate.class) != null || method.getAnnotation(Constants.DoNotTranslate.class) != null;
            if (!doNotTranslate || (dm = method.getAnnotation(Messages.DefaultMessage.class)) == null || dm.value().contains("{0}") || !this.addValue(dm.value())) continue;
            System.out.println("  [gwt] " + dm.value());
        }
    }

    public void checkOnlineHelp() throws IOException, DocumentException {
        URL url = new URL("https://sites.google.com/feeds/content/unitime.org/help45?kind=webpage");
        while (url != null) {
            Element feed = this.readHelpContentFeed(url).getRootElement();
            url = null;
            Iterator i = feed.elementIterator("entry");
            while (i.hasNext()) {
                Element entry = (Element)i.next();
                String name = entry.element("pageName").getTextTrim();
                String title = entry.element("title").getTextTrim();
                if (!this.name2old(title).equals(name) || !this.addValue(title)) continue;
                System.out.println(" [help] " + title);
            }
            i = feed.elementIterator("link");
            while (i.hasNext()) {
                Element link = (Element)i.next();
                if (!"next".equals(link.attributeValue("rel"))) continue;
                System.out.println(" [next] " + link.attributeValue("href"));
                url = new URL(link.attributeValue("href"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document readHelpContentFeed(URL url) throws IOException, DocumentException {
        try (InputStream in = url.openStream();){
            Document document = new SAXReader().read(in);
            return document;
        }
    }

    public String name2old(String name) {
        return name.trim().replace(' ', '_').replace("(", "").replace(")", "").replace(':', '_');
    }

    public String name2property(String name) {
        return name.trim().replace(' ', '-').replace("(", "").replace(")", "").replace(':', '-').toLowerCase();
    }

    public String property2name(String property) {
        if (this.iPageNames.containsKey(property)) {
            return this.iPageNames.get(property);
        }
        return Constants.toInitialCase(property.trim()).replace('-', ' ');
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : this.iPageNames.entrySet()) {
            properties.put(e.getKey(), e.getValue());
        }
        return properties;
    }

    public Map<String, String> getPageNames() {
        return this.iPageNames;
    }

    public Collection<String> execute() throws Exception {
        this.checkPageNamecClass();
        this.checkMenuXML();
        this.checkGwtMessages();
        this.checkOnlineHelp();
        this.checkProperties();
        this.checkLocale("cs");
        return new TreeSet<String>(this.iPageNames.keySet());
    }

    public static void main(String[] args) {
        try {
            PageNameGenerator task = new PageNameGenerator();
            task.execute();
            task.getProperties().store(System.out, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

