/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.TableBuilder;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class InstructorsTableBuilder
extends TableBuilder {
    private String iInstructorSortOrder;
    private Formats.Format<Date> iDF;

    public InstructorsTableBuilder(SessionContext context, String backType, String backId) {
        super(context, backType, backId);
        this.iInstructorSortOrder = UserProperty.SortNames.get(context.getUser());
        this.iDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    }

    public boolean matches(DepartmentalInstructor instructor, TableInterface.FilterInterface filter) {
        String positions = filter.getParameterValue("positions");
        if (positions != null && !positions.isEmpty()) {
            boolean positionsMatch = false;
            for (String posId : positions.split(",")) {
                if (posId.equals("-1") && instructor.getPositionType() == null) {
                    positionsMatch = true;
                    break;
                }
                if (instructor.getPositionType() == null || !instructor.getPositionType().getUniqueId().toString().equals(posId)) continue;
                positionsMatch = true;
                break;
            }
            if (!positionsMatch) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public TableInterface generateTableForDepartment(Department department, TableInterface.FilterInterface filter, SessionContext context) {
        List<DepartmentalInstructor> instructors = DepartmentalInstructor.findInstructorsForDepartment(department.getUniqueId());
        TableInterface table = new TableInterface();
        table.setName(MSG.sectionDepartmentalInstructors(department.getName()));
        table.setId("Instructors");
        TableInterface.LineInterface header = table.addHeader();
        boolean hasCoursePrefs = false;
        boolean hasTeachPref = false;
        boolean hasMaxLoad = false;
        boolean hasUnavailableDates = false;
        Map<String, InstructorSurvey> instructorSurveys = InstructorSurvey.getInstructorSurveysForDepartment(department.getUniqueId());
        boolean hasInstructorSurvey = instructorSurveys != null && !instructorSurveys.isEmpty();
        TreeSet<InstructorAttributeType> attributeTypes = new TreeSet<InstructorAttributeType>(new Comparator<InstructorAttributeType>(){

            @Override
            public int compare(InstructorAttributeType o1, InstructorAttributeType o2) {
                return o1.getReference().compareTo(o2.getReference());
            }
        });
        for (DepartmentalInstructor di : instructors) {
            if (!this.matches(di, filter)) continue;
            if (!di.getPreferences(InstructorCoursePref.class).isEmpty()) {
                hasCoursePrefs = true;
            }
            if (di.getMaxLoad() != null && di.getMaxLoad().floatValue() > 0.0f) {
                hasMaxLoad = true;
            }
            if (di.hasUnavailabilities()) {
                hasUnavailableDates = true;
            }
            if (di.getTeachingPreference() != null && !PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) {
                hasTeachPref = true;
            }
            for (InstructorAttribute at : di.getAttributes()) {
                if (at.getType() == null) continue;
                attributeTypes.add(at.getType());
            }
        }
        header.addCell(MSG.columnExternalId()).setSortable(true);
        header.addCell(MSG.columnInstructorName()).setSortable(true);
        header.addCell(MSG.columnInstructorPosition()).setSortable(true);
        header.addCell(MSG.columnInstructorNote()).setSortable(true);
        header.addCell(MSG.columnPreferences() + "\n" + MSG.columnTimePref());
        header.addCell("\n" + MSG.columnRoomPref());
        header.addCell("\n" + MSG.columnDistributionPref());
        if (hasCoursePrefs) {
            header.addCell("\n" + MSG.columnCoursePref());
        }
        if (hasTeachPref) {
            header.addCell(MSG.columnTeachingPreference()).setSortable(true);
        }
        if (hasUnavailableDates) {
            header.addCell(MSG.columnUnavailableDates());
        }
        if (hasMaxLoad) {
            header.addCell(MSG.columnMaxTeachingLoad()).setSortable(true);
        }
        for (InstructorAttributeType at : attributeTypes) {
            header.addCell(at.getReference()).setSortable(true);
        }
        header.addCell(MSG.columnInstructorClassAssignments());
        header.addCell(MSG.columnInstructorExamAssignments());
        header.addCell(MSG.columnInstructorIgnoreTooFar()).setSortable(true);
        if (hasInstructorSurvey) {
            header.addCell(MSG.columnInstrSurvey()).setSortable(true);
        }
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n").replace("<BR>", "\n"));
            cell.addStyle("white-space: pre");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DepartmentalInstructor di : instructors) {
            if (!this.matches(di, filter)) continue;
            TableInterface.LineInterface line = table.addLine();
            line.setId(di.getUniqueId());
            line.setClassName("instructor-line");
            ids.add(di.getUniqueId());
            if (context.hasPermission(di, Right.InstructorDetail)) {
                line.setURL("instructor?id=" + di.getUniqueId());
            }
            if (di.getExternalUniqueId() != null && !di.getExternalUniqueId().trim().isEmpty()) {
                line.addCell(di.getExternalUniqueId()).addAnchor("A" + di.getUniqueId());
            } else {
                line.addCell().setComparable((Comparable<?>)((Object)"")).addAnchor("A" + di.getUniqueId()).setAria(MSG.altNotAvailableExternalId()).addImage().setSource("images/error.png").setAlt(MSG.altNotAvailableExternalId()).setTitle(MSG.titleInstructorExternalIdNotSupplied());
            }
            if (di.getUniqueId().toString().equals(this.getBackId())) {
                line.getCells().get(0).addAnchor("back");
            }
            line.addCell(di.getName(this.getInstructorNameFormat())).setComparable((Comparable<?>)((Object)(CommonValues.SortAsDisplayed.eq(this.iInstructorSortOrder) ? di.getName(this.getInstructorNameFormat()).toLowerCase() : di.nameLastNameFirst().toLowerCase())));
            if (di.getPositionType() != null) {
                line.addCell(di.getPositionType().getLabel()).setComparable(di.getPositionType().getSortOrder());
            } else {
                line.addCell(MSG.instructorPositionNotSpecified()).addStyle("font-style: italic;").setComparable(Integer.valueOf(Integer.MAX_VALUE));
            }
            line.addCell(di.getNote()).addStyle("white-space: pre-wrap; max-width: 300px; ");
            TableInterface.CellInterface timePref = line.addCell().addStyle("white-space: pre-wrap;");
            for (TimePref timePref2 : di.getTimePreferences()) {
                final RequiredTimeTable requiredTimeTable = timePref2.getRequiredTimeTable();
                if (this.getGridAsText()) {
                    timePref.add(requiredTimeTable.getModel().toString().replace(", ", "\n")).setMouseOver("$wnd.showGwtInstructorAvailabilityHint($wnd.lastMouseOverElement, '" + di.getUniqueId() + "');").setMouseOut("$wnd.hideGwtInstructorAvailabilityHint();");
                    continue;
                }
                timePref.add(null).setImage(new TableInterface.ImageInterface().setSource("pattern?v=" + (this.getTimeVertival() ? 1 : 0) + "&s=" + requiredTimeTable.getModel().getDefaultSelection() + "&p=" + requiredTimeTable.getModel().getPreferences()).setAlt(requiredTimeTable.getModel().toString()).setGenerator(new TableInterface.ImageGenerator(){

                    @Override
                    public Object generate() {
                        return requiredTimeTable.createBufferedImage(InstructorsTableBuilder.this.getTimeVertival());
                    }
                })).setMouseOver("$wnd.showGwtInstructorAvailabilityHint($wnd.lastMouseOverElement, '" + di.getUniqueId() + "');").setMouseOut("$wnd.hideGwtInstructorAvailabilityHint();").addStyle("display: inline-block;").setAria(requiredTimeTable.getModel().toString());
            }
            TableInterface.CellInterface roomPref = line.addCell();
            for (Preference preference : di.effectivePreferences(RoomPref.class)) {
                roomPref.addItem(this.preferenceCell(preference));
            }
            for (Preference preference : di.effectivePreferences(BuildingPref.class)) {
                roomPref.addItem(this.preferenceCell(preference));
            }
            for (Preference preference : di.effectivePreferences(RoomFeaturePref.class)) {
                roomPref.addItem(this.preferenceCell(preference));
            }
            for (Preference preference : di.effectivePreferences(RoomGroupPref.class)) {
                roomPref.addItem(this.preferenceCell(preference));
            }
            TableInterface.CellInterface cellInterface = line.addCell();
            for (Object p3 : di.effectivePreferences(DistributionPref.class)) {
                cellInterface.addItem(this.preferenceCell((Preference)p3));
            }
            if (hasCoursePrefs) {
                Object p3;
                TableInterface.CellInterface cellInterface2 = new TableInterface.CellInterface();
                p3 = di.effectivePreferences(InstructorCoursePref.class).iterator();
                while (p3.hasNext()) {
                    Preference preference = (Preference)p3.next();
                    cellInterface2.addItem(this.preferenceCell(preference));
                }
                line.addCell(cellInterface2);
            }
            if (hasTeachPref) {
                void var21_43;
                PreferenceLevel preferenceLevel = di.getTeachingPreference();
                if (preferenceLevel == null) {
                    PreferenceLevel preferenceLevel2 = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited);
                }
                line.addCell(var21_43.getPrefName()).setColor(PreferenceLevel.prolog2color(var21_43.getPrefProlog())).setComparable(var21_43.getPrefId());
            }
            if (hasUnavailableDates) {
                line.addCell(di.hasUnavailabilities() ? di.getUnavailableDaysText("\n") : "").addStyle("white-space: pre-wrap;");
            }
            if (hasMaxLoad) {
                if (di.getMaxLoad() == null) {
                    line.addCell("").setComparable(Float.valueOf(0.0f));
                } else {
                    line.addCell(Formats.getNumberFormat("0.##").format(di.getMaxLoad())).setComparable(di.getMaxLoad());
                }
            }
            for (InstructorAttributeType at : attributeTypes) {
                TableInterface.CellInterface cellInterface3 = line.addCell();
                for (InstructorAttribute a : di.getAttributes(at)) {
                    cellInterface3.add(a.getCode()).setTitle(a.getName()).setInline(false);
                }
            }
            TreeSet<ClassInstructor> treeSet = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
            treeSet.addAll(di.getClasses());
            TableInterface.CellInterface cls = line.addCell();
            for (ClassInstructor ci : treeSet) {
                Class_ c = ci.getClassInstructing();
                String className = c.getClassLabel();
                Object title = className;
                if (c.isCancelled().booleanValue()) {
                    title = MSG.classNoteCancelled(c.getClassLabel());
                }
                title = (String)title + " (" + ci.getPercentShare() + "%" + (String)(ci.isLead() != false ? ", " + MSG.titleCheckConflicts() : "") + ")";
                if (!c.isDisplayInstructor().booleanValue()) {
                    title = (String)title + " - " + MSG.titleDoNotDisplayInstructor();
                }
                TableInterface.CellInterface cl = cls.add(className);
                cl.setTitle((String)title);
                if (c.isCancelled().booleanValue()) {
                    cl.addStyle("text-decoration: line-through;");
                    cl.setColor("gray");
                }
                if (ci.isLead().booleanValue()) {
                    cl.addStyle("font-weight:bold;");
                }
                if (!c.isDisplayInstructor().booleanValue()) {
                    cl.addStyle("font-style:italic;");
                }
                cl.setNoWrap(true).setInline(false);
            }
            TreeSet<Exam> treeSet2 = new TreeSet<Exam>(di.getExams());
            TableInterface.CellInterface exs = line.addCell();
            for (Exam exam : treeSet2) {
                if (!context.hasPermission(exam, Right.ExaminationView)) continue;
                TableInterface.CellInterface ex = exs.add(exam.getLabel());
                ex.setTitle(exam.getLabel() + " " + exam.getExamType().getLabel());
                if (exam.getExamType().getType() == 0) {
                    ex.addStyle("font-weight:bold;");
                }
                ex.setNoWrap(true).setInline(false);
            }
            if (di.isIgnoreToFar() != null && di.isIgnoreToFar().booleanValue()) {
                line.addCell().setComparable(Boolean.valueOf(true)).addImage().setSource("images/accept.png").setAlt(MSG.titleIgnoreTooFarDistances()).setTitle(MSG.titleIgnoreTooFarDistances());
            } else {
                line.addCell().setComparable(Boolean.valueOf(false));
            }
            if (!hasInstructorSurvey) continue;
            if (di.getExternalUniqueId() == null || di.getExternalUniqueId().isEmpty()) {
                line.addCell().setComparable(Long.valueOf(Long.MAX_VALUE));
                continue;
            }
            InstructorSurvey is = instructorSurveys.get(di.getExternalUniqueId());
            if (is != null && is.getCourseRequirements().isEmpty() && is.getPreferences().isEmpty() && (is.getNote() == null || is.getNote().isEmpty())) {
                is = null;
            }
            if (is != null) {
                if (is.getSubmitted() != null) {
                    line.addCell(this.iDF.format(is.getSubmitted())).setComparable(Long.valueOf(is.getSubmitted().getTime()));
                    continue;
                }
                line.addCell(MSG.instrSurveyNotSubmitted()).setComparable(Long.valueOf(0L)).addStyle("font-style: italic;").setColor("#dcb414");
                continue;
            }
            line.addCell(MSG.instrSurveyNotFilled()).setComparable(Long.valueOf(-1L)).addStyle("font-style: italic;").setColor("#c81e14");
        }
        table.setNavigationLevel(Navigation.sInstructionalOfferingLevel);
        Navigation.set(context, Navigation.sInstructionalOfferingLevel, ids);
        return table;
    }
}

