/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class CurriculumPermissions {

    @PermissionForRight(value=Right.CurriculumProjectionRulesEdit)
    public static class CurriculumProjectionRulesEdit
    extends CurriculumAdmin {
    }

    @PermissionForRight(value=Right.CurriculumProjectionRulesDetail)
    public static class CurriculumProjectionRulesDetail
    extends CurriculumView {
    }

    @PermissionForRight(value=Right.CurriculumAdmin)
    public static class CurriculumAdmin
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) && this.permissionSession.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.CurriculumMerge)
    public static class CurriculumMerge
    extends CurriculumEdit {
    }

    @PermissionForRight(value=Right.CurriculumDelete)
    public static class CurriculumDelete
    extends CurriculumEdit {
    }

    @PermissionForRight(value=Right.CurriculumDetail)
    public static class CurriculumDetail
    implements Permission<Curriculum> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Curriculum source) {
            return source != null && this.permissionSession.check(user, source.getDepartment().getSession());
        }

        @Override
        public Class<Curriculum> type() {
            return Curriculum.class;
        }
    }

    @PermissionForRight(value=Right.CurriculumEdit)
    public static class CurriculumEdit
    implements Permission<Curriculum> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Curriculum source) {
            Department department = source == null ? null : source.getDepartment();
            return department != null && this.permissionDepartment.check(user, department, DepartmentStatusType.Status.OwnerEdit, DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<Curriculum> type() {
            return Curriculum.class;
        }
    }

    @PermissionForRight(value=Right.CurriculumAdd)
    public static class CurriculumAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return source != null && this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerEdit, DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.CurriculumView)
    public static class CurriculumView
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source, DepartmentStatusType.Status.OwnerView, DepartmentStatusType.Status.ManagerView);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }
}

