/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;

public class PerturbationsReport
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    protected double iSameChoiceWeight = 0.9;
    protected double iSameTimeWeight = 0.7;
    protected double iSameConfigWeight = 0.5;

    public PerturbationsReport(StudentSectioningModel model) {
        super(model);
        this.iSameChoiceWeight = model.getProperties().getPropertyDouble("StudentWeights.SameChoice", this.iSameChoiceWeight);
        this.iSameTimeWeight = model.getProperties().getPropertyDouble("StudentWeights.SameTime", this.iSameTimeWeight);
        this.iSameConfigWeight = model.getProperties().getPropertyDouble("StudentWeights.SameConfig", this.iSameConfigWeight);
    }

    protected double getDifference(Section section, Enrollment other) {
        if (section == null) {
            return 0.0;
        }
        if (section.getSubpart().getConfig().equals((Object)other.getConfig())) {
            for (Section initial : other.getSections()) {
                if (!section.getSubpart().equals((Object)initial.getSubpart())) continue;
                if (section.equals((Object)initial)) {
                    return 1.0;
                }
                if (section.sameChoice(initial)) {
                    return this.iSameChoiceWeight;
                }
                if (!section.sameTime(initial)) continue;
                return this.iSameTimeWeight;
            }
        } else {
            for (Section initial : other.getSections()) {
                if (section.sameChoice(initial)) {
                    return this.iSameChoiceWeight;
                }
                if (!section.sameInstructionalType(initial) || !section.sameTime(initial)) continue;
                return this.iSameTimeWeight;
            }
        }
        return 0.0;
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportOriginalClass()), new CSVFile.CSVField((Object)MSG.reportOriginalTime()), new CSVFile.CSVField((Object)MSG.reportOriginalDate()), new CSVFile.CSVField((Object)MSG.reportOriginalRoom()), new CSVFile.CSVField((Object)MSG.reportAssignedClass()), new CSVFile.CSVField((Object)MSG.reportAssignedTime()), new CSVFile.CSVField((Object)MSG.reportAssignedDate()), new CSVFile.CSVField((Object)MSG.reportAssignedRoom()), new CSVFile.CSVField((Object)MSG.reportPenalization())});
        TreeSet<Student> students = new TreeSet<Student>(new Comparator<Student>(){

            @Override
            public int compare(Student s1, Student s2) {
                return s1.getExternalId().compareTo(s2.getExternalId());
            }
        });
        students.addAll(this.getModel().getStudents());
        for (Student student : students) {
            if (student.isDummy()) continue;
            for (Request r : student.getRequests()) {
                Section sct;
                Enrollment e = (Enrollment)assignment.getValue((Variable)r);
                Enrollment i = (Enrollment)r.getInitialAssignment();
                if (i == null || r instanceof FreeTimeRequest || i.equals((Object)e) || !this.matches(r, i)) continue;
                org.unitime.timetable.model.Student s = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (e == null) {
                    for (Section sct2 : i.getSections()) {
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(student.getId()));
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        line.add(new CSVFile.CSVField((Object)(s == null ? null : s.getEmail())));
                        line.add(new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())));
                        line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                        line.add(new CSVFile.CSVField((Object)this.group(student)));
                        line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                        line.add(new CSVFile.CSVField((Object)i.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(sct2.getSubpart().getName() + " " + sct2.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField(sct2.getTime() == null ? "" : sct2.getTime().getDayHeader() + " " + sct2.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + sct2.getTime().getEndTimeHeader(this.isUseAmPm())));
                        line.add(new CSVFile.CSVField((Object)(sct2.getTime() == null ? "" : sct2.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(sct2.getNrRooms() == 0 ? "" : sct2.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)MSG.reportNotAssigned()));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)sDF.format(1.0 - this.getDifference(null, i))));
                        csv.addLine(line);
                    }
                    continue;
                }
                if (i.getConfig().equals((Object)e.getConfig())) {
                    for (Section org : i.getSections()) {
                        sct = null;
                        for (Section x : e.getSections()) {
                            if (!org.getSubpart().equals((Object)x.getSubpart())) continue;
                            sct = x;
                            break;
                        }
                        if (sct == null || org.equals((Object)sct)) continue;
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(student.getId()));
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        line.add(new CSVFile.CSVField((Object)(s == null ? null : s.getEmail())));
                        line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                        line.add(new CSVFile.CSVField((Object)this.group(student)));
                        line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                        line.add(new CSVFile.CSVField((Object)i.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(org.getSubpart().getName() + " " + org.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField(org.getTime() == null ? "" : org.getTime().getDayHeader() + " " + org.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + org.getTime().getEndTimeHeader(this.isUseAmPm())));
                        line.add(new CSVFile.CSVField((Object)(org.getTime() == null ? "" : org.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(org.getNrRooms() == 0 ? "" : org.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)(sct.getSubpart().getName() + " " + sct.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField(sct.getTime() == null ? "" : sct.getTime().getDayHeader() + " " + sct.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + sct.getTime().getEndTimeHeader(this.isUseAmPm())));
                        line.add(new CSVFile.CSVField((Object)(sct.getTime() == null ? "" : sct.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(sct.getNrRooms() == 0 ? "" : sct.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)sDF.format(1.0 - this.getDifference(sct, i))));
                        csv.addLine(line);
                    }
                    continue;
                }
                Iterator orgIt = i.getSections().iterator();
                Iterator sctIt = e.getSections().iterator();
                while (orgIt.hasNext() || sctIt.hasNext()) {
                    sct = sctIt.hasNext() ? (Section)sctIt.next() : null;
                    Section org = orgIt.hasNext() ? (Section)orgIt.next() : null;
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField(student.getId()));
                    line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                    line.add(new CSVFile.CSVField((Object)student.getName()));
                    line.add(new CSVFile.CSVField((Object)(s == null ? null : s.getEmail())));
                    line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                    line.add(new CSVFile.CSVField((Object)this.group(student)));
                    line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                    line.add(new CSVFile.CSVField((Object)i.getCourse().getName()));
                    if (org != null) {
                        line.add(new CSVFile.CSVField((Object)(org.getSubpart().getName() + " " + org.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField(org.getTime() == null ? "" : org.getTime().getDayHeader() + " " + org.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + org.getTime().getEndTimeHeader(this.isUseAmPm())));
                        line.add(new CSVFile.CSVField((Object)(org.getTime() == null ? "" : org.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(org.getNrRooms() == 0 ? "" : org.getPlacement().getRoomName(", "))));
                    } else {
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                    }
                    if (sct != null) {
                        line.add(new CSVFile.CSVField((Object)(sct.getSubpart().getName() + " " + sct.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField(sct.getTime() == null ? "" : sct.getTime().getDayHeader() + " " + sct.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + sct.getTime().getEndTimeHeader(this.isUseAmPm())));
                        line.add(new CSVFile.CSVField((Object)(sct.getTime() == null ? "" : sct.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(sct.getNrRooms() == 0 ? "" : sct.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)sDF.format(1.0 - this.getDifference(sct, i))));
                    } else {
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                    }
                    csv.addLine(line);
                }
            }
        }
        return csv;
    }
}

