/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.model.CourseCreditUnitConfig;

public class XCredit
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iId;
    private String iAbbreviation;
    private String iText;
    private float iMin = 0.0f;
    private float iMax = 0.0f;
    private static Pattern sCreditPattern = Pattern.compile("(^| )(\\d+\\.?\\d*)([,-]?(\\d+\\.?\\d*))?($| )");

    public XCredit() {
    }

    public XCredit(CourseCreditUnitConfig credit) {
        this.iId = credit.getUniqueId();
        this.iAbbreviation = credit.creditAbbv();
        this.iText = credit.creditText();
        this.iMin = credit.getMinCredit();
        this.iMax = credit.getMaxCredit();
    }

    public XCredit(String credit) {
        int split = credit.indexOf(124);
        if (split >= 0) {
            this.iAbbreviation = credit.substring(0, split);
            this.iText = credit.substring(split + 1);
        } else {
            this.iAbbreviation = credit;
            this.iText = credit;
        }
        Matcher m = sCreditPattern.matcher(this.iAbbreviation);
        if (m.find()) {
            this.iMin = Float.parseFloat(m.group(2));
            this.iMax = m.group(4) != null ? Float.parseFloat(m.group(4)) : this.iMin;
        }
    }

    public XCredit(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public Long getId() {
        return this.iId;
    }

    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public String getText() {
        return this.iText;
    }

    public Float getMinCredit() {
        return Float.valueOf(this.iMin);
    }

    public Float getMaxCredit() {
        return Float.valueOf(this.iMax);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XCredit)) {
            return false;
        }
        return this.getAbbreviation().equals(((XCredit)o).getAbbreviation());
    }

    public String toString() {
        return this.getAbbreviation() + "|" + this.getText();
    }

    public int hashCode() {
        return this.getAbbreviation().hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iId = in.readLong();
        if (this.iId < 0L) {
            this.iId = null;
        }
        this.iAbbreviation = (String)in.readObject();
        this.iText = (String)in.readObject();
        this.iMin = in.readFloat();
        this.iMax = in.readFloat();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iId == null ? -1L : this.iId);
        out.writeObject(this.iAbbreviation);
        out.writeObject(this.iText);
        out.writeFloat(this.iMin);
        out.writeFloat(this.iMax);
    }

    public static void main(String[] args) {
        String[] test;
        for (String s : test = new String[]{"AH", "2", "1.5", "1.4 EQV", "1.4,2.5 EQV", "M/X 2-3 MS", "XX 2,3.5 PhD", "VR 1,2", "2-4.333 SH"}) {
            XCredit c = new XCredit(s);
            System.out.println(c.getAbbreviation() + ": " + c.getMinCredit() + " .. " + c.getMaxCredit());
        }
    }
}

