/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.joda.time.ReadableInstant;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationHelper {
    public static boolean hasLastNote(SpecialRegistrationInterface.Change change) {
        if (change.notes == null || change.notes.isEmpty()) {
            return false;
        }
        for (SpecialRegistrationInterface.ChangeNote n : change.notes) {
            if (n.notes == null || n.notes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static String getLastNote(SpecialRegistrationInterface.Change change) {
        if (change.notes == null || change.notes.isEmpty()) {
            return null;
        }
        SpecialRegistrationInterface.ChangeNote note = null;
        for (SpecialRegistrationInterface.ChangeNote n : change.notes) {
            if (n.notes == null || n.notes.isEmpty() || note != null && !note.dateCreated.isBefore((ReadableInstant)n.dateCreated)) continue;
            note = n;
        }
        return note == null ? null : note.notes;
    }

    public static String note(SpecialRegistrationInterface.SpecialRegistration reg, boolean credit) {
        Object note = null;
        if (reg.changes != null) {
            for (SpecialRegistrationInterface.Change ch : reg.changes) {
                if (credit && ch.subject == null && ch.courseNbr == null && SpecialRegistrationHelper.hasLastNote(ch)) {
                    note = (String)(note == null ? "" : note + "\n") + SpecialRegistrationHelper.getLastNote(ch);
                }
                if (credit || ch.subject == null || ch.courseNbr == null || !SpecialRegistrationHelper.hasLastNote(ch) || ch.status == SpecialRegistrationInterface.ChangeStatus.approved) continue;
                String n = SpecialRegistrationHelper.getLastNote(ch);
                if (note == null) {
                    note = n;
                    continue;
                }
                if (((String)note).contains(n)) continue;
                note = (String)note + "\n" + n;
            }
        }
        return note;
    }

    public static String requestorNotes(SpecialRegistrationInterface.SpecialRegistration r, String subject, String courseNbr) {
        if (r.changes != null && subject != null && courseNbr != null) {
            for (SpecialRegistrationInterface.Change ch : r.changes) {
                if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr) || ch.requestorNotes == null || ch.requestorNotes.isEmpty()) continue;
                return ch.requestorNotes;
            }
        }
        return r.requestorNotes;
    }

    public static String requestorNotes(SpecialRegistrationInterface.SpecialRegistration r, String course) {
        if (r.changes != null && course != null) {
            for (SpecialRegistrationInterface.Change ch : r.changes) {
                if (!course.equals(ch.subject + " " + ch.courseNbr)) continue;
                return ch.requestorNotes;
            }
        }
        return r.requestorNotes;
    }

    public static String maxCreditRequestorNotes(SpecialRegistrationInterface.SpecialRegistration r) {
        if (r.maxCreditRequestorNotes != null) {
            return r.maxCreditRequestorNotes;
        }
        return r.requestorNotes;
    }

    public static SpecialRegistrationInterface.RestrictionsCheckRequest createValidationRequest(SpecialRegistrationInterface.CheckRestrictionsRequest req, SpecialRegistrationInterface.ValidationMode mode, boolean includeRegistration) {
        SpecialRegistrationInterface.RestrictionsCheckRequest ret = new SpecialRegistrationInterface.RestrictionsCheckRequest();
        ret.sisId = req.studentId;
        ret.term = req.term;
        ret.campus = req.campus;
        ret.mode = mode;
        ret.includeReg = includeRegistration ? SpecialRegistrationInterface.IncludeReg.Y : SpecialRegistrationInterface.IncludeReg.N;
        ret.actions = new HashMap<SpecialRegistrationInterface.ValidationOperation, List<SpecialRegistrationInterface.Crn>>();
        ret.actions.put(SpecialRegistrationInterface.ValidationOperation.ADD, new ArrayList());
        if (includeRegistration) {
            ret.actions.put(SpecialRegistrationInterface.ValidationOperation.DROP, new ArrayList());
        }
        return ret;
    }

    public static void addOperation(SpecialRegistrationInterface.RestrictionsCheckRequest request, SpecialRegistrationInterface.ValidationOperation op, String crn) {
        List<SpecialRegistrationInterface.Crn> crns;
        if (request.actions == null) {
            request.actions = new HashMap<SpecialRegistrationInterface.ValidationOperation, List<SpecialRegistrationInterface.Crn>>();
        }
        if ((crns = request.actions.get((Object)op)) == null) {
            crns = new ArrayList<SpecialRegistrationInterface.Crn>();
            request.actions.put(op, crns);
        } else {
            for (SpecialRegistrationInterface.Crn c : crns) {
                if (!crn.equals(c.crn)) continue;
                return;
            }
        }
        SpecialRegistrationInterface.Crn c = new SpecialRegistrationInterface.Crn();
        c.crn = crn;
        crns.add(c);
    }

    public static void addCrn(SpecialRegistrationInterface.RestrictionsCheckRequest request, String crn) {
        SpecialRegistrationHelper.addOperation(request, SpecialRegistrationInterface.ValidationOperation.ADD, crn);
    }

    public static void dropCrn(SpecialRegistrationInterface.RestrictionsCheckRequest request, String crn) {
        SpecialRegistrationHelper.addOperation(request, SpecialRegistrationInterface.ValidationOperation.DROP, crn);
    }

    public static boolean isEmpty(SpecialRegistrationInterface.RestrictionsCheckRequest request) {
        if (request.actions == null || request.actions.isEmpty()) {
            return true;
        }
        List<SpecialRegistrationInterface.Crn> adds = request.actions.get((Object)SpecialRegistrationInterface.ValidationOperation.ADD);
        if (adds != null && !adds.isEmpty()) {
            return false;
        }
        List<SpecialRegistrationInterface.Crn> drops = request.actions.get((Object)SpecialRegistrationInterface.ValidationOperation.DROP);
        return drops == null || drops.isEmpty();
    }

    public static void addCrn(SpecialRegistrationInterface.CheckRestrictionsRequest req, String crn) {
        if (req.changes == null) {
            req.changes = SpecialRegistrationHelper.createValidationRequest(req, SpecialRegistrationInterface.ValidationMode.REG, false);
        }
        SpecialRegistrationHelper.addCrn(req.changes, crn);
    }

    public static void addAltCrn(SpecialRegistrationInterface.CheckRestrictionsRequest req, String crn) {
        if (req.alternatives == null) {
            req.alternatives = SpecialRegistrationHelper.createValidationRequest(req, SpecialRegistrationInterface.ValidationMode.ALT, false);
        }
        SpecialRegistrationHelper.addCrn(req.alternatives, crn);
    }

    public static void addWaitListCrn(SpecialRegistrationInterface.CheckRestrictionsRequest req, String crn) {
        if (req.changes == null) {
            req.changes = SpecialRegistrationHelper.createValidationRequest(req, SpecialRegistrationInterface.ValidationMode.WAITL, true);
        }
        SpecialRegistrationHelper.addCrn(req.changes, crn);
    }

    public static void dropWaitListCrn(SpecialRegistrationInterface.CheckRestrictionsRequest req, String crn) {
        if (req.changes == null) {
            req.changes = SpecialRegistrationHelper.createValidationRequest(req, SpecialRegistrationInterface.ValidationMode.WAITL, true);
        }
        SpecialRegistrationHelper.dropCrn(req.changes, crn);
    }

    public static boolean isEmpty(SpecialRegistrationInterface.CheckRestrictionsRequest req) {
        return !(req.changes != null && !SpecialRegistrationHelper.isEmpty(req.changes) || req.alternatives != null && !SpecialRegistrationHelper.isEmpty(req.alternatives));
    }

    public static String pgrmcode(String programCode) {
        if (programCode == null || programCode.isEmpty()) {
            return null;
        }
        if (programCode.endsWith("-OL")) {
            return "OL";
        }
        if (programCode.endsWith("-HY")) {
            return "HY";
        }
        return "RT";
    }

    public static String getProgramCode(XStudent student) {
        Iterator<XAreaClassificationMajor> iterator = student.getMajors().iterator();
        if (iterator.hasNext()) {
            XAreaClassificationMajor acm = iterator.next();
            return SpecialRegistrationHelper.pgrmcode(acm.getProgram());
        }
        return null;
    }

    public static String getProgramCode(Student student) {
        StudentAreaClassificationMajor primary = student.getPrimaryAreaClasfMajor();
        if (primary == null || primary.getProgram() == null) {
            return null;
        }
        return SpecialRegistrationHelper.pgrmcode(primary.getProgram().getReference());
    }

    public static String getCampusCode(XStudent student) {
        Iterator<XAreaClassificationMajor> iterator = student.getMajors().iterator();
        if (iterator.hasNext()) {
            XAreaClassificationMajor acm = iterator.next();
            return acm.getCampus();
        }
        return null;
    }

    public static String getCampusCode(Student student) {
        StudentAreaClassificationMajor primary = student.getPrimaryAreaClasfMajor();
        if (primary == null || primary.getProgram() == null) {
            return null;
        }
        return primary.getCampus().getReference();
    }
}

