/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinFormula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.JointEnrollment;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolutionInfo;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.StudentEnrollment;

@MappedSuperclass
public abstract class BaseSolution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iCreated;
    private Boolean iValid;
    private Boolean iCommited;
    private Date iCommitDate;
    private String iNote;
    private String iCreator;
    private String iSolverMode;
    private String iSolverConfiguration;
    private SolverGroup iOwner;
    private SolutionInfo iGlobalInfo;
    private Set<SolverParameter> iParameters;
    private Set<SolutionInfo> iSolutionInfo;
    private Set<StudentEnrollment> iStudentEnrollments;
    private Set<Assignment> iAssignments;
    private Set<JointEnrollment> iJointEnrollments;

    public BaseSolution() {
    }

    public BaseSolution(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solution_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="created", nullable=false)
    public Date getCreated() {
        return this.iCreated;
    }

    public void setCreated(Date created) {
        this.iCreated = created;
    }

    @Column(name="valid", nullable=false)
    public Boolean isValid() {
        return this.iValid;
    }

    @Transient
    public Boolean getValid() {
        return this.iValid;
    }

    public void setValid(Boolean valid) {
        this.iValid = valid;
    }

    @Column(name="commited", nullable=false)
    public Boolean isCommited() {
        return this.iCommited;
    }

    @Transient
    public Boolean getCommited() {
        return this.iCommited;
    }

    public void setCommited(Boolean commited) {
        this.iCommited = commited;
    }

    @Column(name="commit_date", nullable=true)
    public Date getCommitDate() {
        return this.iCommitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.iCommitDate = commitDate;
    }

    @Column(name="note", nullable=true, length=1000)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="creator", nullable=true, length=250)
    public String getCreator() {
        return this.iCreator;
    }

    public void setCreator(String creator) {
        this.iCreator = creator;
    }

    @Formula(value="(select p.value from %SCHEMA%.solver_parameter p, %SCHEMA%.solver_parameter_def d where p.solution_id = uniqueid and d.uniqueid = p.solver_param_def_id and d.name='Basic.Mode')")
    public String getSolverMode() {
        return this.iSolverMode;
    }

    public void setSolverMode(String solverMode) {
        this.iSolverMode = solverMode;
    }

    @Formula(value="(select s.description from %SCHEMA%.solver_parameter p, %SCHEMA%.solver_parameter_def d, %SCHEMA%.solver_predef_setting s where p.solution_id = uniqueId and d.uniqueid = p.solver_param_def_id and d.name='General.SettingsId' and concat(s.uniqueid,'') = p.value)")
    public String getSolverConfiguration() {
        return this.iSolverConfiguration;
    }

    public void setSolverConfiguration(String solverConfiguration) {
        this.iSolverConfiguration = solverConfiguration;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="owner_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public SolverGroup getOwner() {
        return this.iOwner;
    }

    public void setOwner(SolverGroup owner) {
        this.iOwner = owner;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value=" ( select si.uniqueid from %SCHEMA%.solver_info si, %SCHEMA%.solver_info_def d where si.type=1 and si.solver_info_def_id=d.uniqueid and d.name='GlobalInfo' and si.solution_id=uniqueid ) ")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public SolutionInfo getGlobalInfo() {
        return this.iGlobalInfo;
    }

    public void setGlobalInfo(SolutionInfo globalInfo) {
        this.iGlobalInfo = globalInfo;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="solution_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SolverParameter> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<SolverParameter> parameters) {
        this.iParameters = parameters;
    }

    public void addToParameters(SolverParameter solverParameter) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<SolverParameter>();
        }
        this.iParameters.add(solverParameter);
    }

    @Deprecated
    public void addToparameters(SolverParameter solverParameter) {
        this.addToParameters(solverParameter);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="solution", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SolutionInfo> getSolutionInfo() {
        return this.iSolutionInfo;
    }

    public void setSolutionInfo(Set<SolutionInfo> solutionInfo) {
        this.iSolutionInfo = solutionInfo;
    }

    public void addToSolutionInfo(SolutionInfo solutionInfo) {
        if (this.iSolutionInfo == null) {
            this.iSolutionInfo = new HashSet<SolutionInfo>();
        }
        this.iSolutionInfo.add(solutionInfo);
    }

    @Deprecated
    public void addTosolutionInfo(SolutionInfo solutionInfo) {
        this.addToSolutionInfo(solutionInfo);
    }

    @OneToMany(mappedBy="solution", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentEnrollment> getStudentEnrollments() {
        return this.iStudentEnrollments;
    }

    public void setStudentEnrollments(Set<StudentEnrollment> studentEnrollments) {
        this.iStudentEnrollments = studentEnrollments;
    }

    public void addToStudentEnrollments(StudentEnrollment studentEnrollment) {
        if (this.iStudentEnrollments == null) {
            this.iStudentEnrollments = new HashSet<StudentEnrollment>();
        }
        this.iStudentEnrollments.add(studentEnrollment);
    }

    @Deprecated
    public void addTostudentEnrollments(StudentEnrollment studentEnrollment) {
        this.addToStudentEnrollments(studentEnrollment);
    }

    @OneToMany(mappedBy="solution", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToAssignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    @Deprecated
    public void addToassignments(Assignment assignment) {
        this.addToAssignments(assignment);
    }

    @OneToMany(mappedBy="solution", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<JointEnrollment> getJointEnrollments() {
        return this.iJointEnrollments;
    }

    public void setJointEnrollments(Set<JointEnrollment> jointEnrollments) {
        this.iJointEnrollments = jointEnrollments;
    }

    public void addToJointEnrollments(JointEnrollment jointEnrollment) {
        if (this.iJointEnrollments == null) {
            this.iJointEnrollments = new HashSet<JointEnrollment>();
        }
        this.iJointEnrollments.add(jointEnrollment);
    }

    @Deprecated
    public void addTojointEnrollments(JointEnrollment jointEnrollment) {
        this.addToJointEnrollments(jointEnrollment);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Solution)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Solution)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Solution)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Solution[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Solution[\n\tCommitDate: " + String.valueOf(this.getCommitDate()) + "\n\tCommited: " + this.getCommited() + "\n\tCreated: " + String.valueOf(this.getCreated()) + "\n\tCreator: " + this.getCreator() + "\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tValid: " + this.getValid() + "]";
    }
}

