/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.PitInstrOfferingConfig;
import org.unitime.timetable.model.PitInstructionalOffering;
import org.unitime.timetable.model.PitSchedulingSubpart;

@MappedSuperclass
public abstract class BasePitInstrOfferingConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Boolean iUnlimitedEnrollment;
    private String iName;
    private Long iUniqueIdRolledForwardFrom;
    private InstrOfferingConfig iInstrOfferingConfig;
    private PitInstructionalOffering iPitInstructionalOffering;
    private ClassDurationType iClassDurationType;
    private InstructionalMethod iInstructionalMethod;
    private Set<PitSchedulingSubpart> iSchedulingSubparts;

    public BasePitInstrOfferingConfig() {
    }

    public BasePitInstrOfferingConfig(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="unlimited_enrollment", nullable=false)
    public Boolean isUnlimitedEnrollment() {
        return this.iUnlimitedEnrollment;
    }

    @Transient
    public Boolean getUnlimitedEnrollment() {
        return this.iUnlimitedEnrollment;
    }

    public void setUnlimitedEnrollment(Boolean unlimitedEnrollment) {
        this.iUnlimitedEnrollment = unlimitedEnrollment;
    }

    @Column(name="name", nullable=true, length=10)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="instr_offering_config_id", nullable=true)
    public InstrOfferingConfig getInstrOfferingConfig() {
        return this.iInstrOfferingConfig;
    }

    public void setInstrOfferingConfig(InstrOfferingConfig instrOfferingConfig) {
        this.iInstrOfferingConfig = instrOfferingConfig;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_instr_offr_id", nullable=false)
    public PitInstructionalOffering getPitInstructionalOffering() {
        return this.iPitInstructionalOffering;
    }

    public void setPitInstructionalOffering(PitInstructionalOffering pitInstructionalOffering) {
        this.iPitInstructionalOffering = pitInstructionalOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="duration_type_id", nullable=true)
    public ClassDurationType getClassDurationType() {
        return this.iClassDurationType;
    }

    public void setClassDurationType(ClassDurationType classDurationType) {
        this.iClassDurationType = classDurationType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="instr_method_id", nullable=true)
    public InstructionalMethod getInstructionalMethod() {
        return this.iInstructionalMethod;
    }

    public void setInstructionalMethod(InstructionalMethod instructionalMethod) {
        this.iInstructionalMethod = instructionalMethod;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitInstrOfferingConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitSchedulingSubpart> getSchedulingSubparts() {
        return this.iSchedulingSubparts;
    }

    public void setSchedulingSubparts(Set<PitSchedulingSubpart> schedulingSubparts) {
        this.iSchedulingSubparts = schedulingSubparts;
    }

    public void addToSchedulingSubparts(PitSchedulingSubpart pitSchedulingSubpart) {
        if (this.iSchedulingSubparts == null) {
            this.iSchedulingSubparts = new HashSet<PitSchedulingSubpart>();
        }
        this.iSchedulingSubparts.add(pitSchedulingSubpart);
    }

    @Deprecated
    public void addToschedulingSubparts(PitSchedulingSubpart pitSchedulingSubpart) {
        this.addToSchedulingSubparts(pitSchedulingSubpart);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitInstrOfferingConfig)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitInstrOfferingConfig)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitInstrOfferingConfig)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitInstrOfferingConfig[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "PitInstrOfferingConfig[\n\tClassDurationType: " + String.valueOf(this.getClassDurationType()) + "\n\tInstrOfferingConfig: " + String.valueOf(this.getInstrOfferingConfig()) + "\n\tInstructionalMethod: " + String.valueOf(this.getInstructionalMethod()) + "\n\tName: " + this.getName() + "\n\tPitInstructionalOffering: " + String.valueOf(this.getPitInstructionalOffering()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "\n\tUnlimitedEnrollment: " + this.getUnlimitedEnrollment() + "]";
    }
}

