/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;

@MappedSuperclass
public abstract class BaseCurriculumCourse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Float iPercShare;
    private Integer iOrd;
    private Float iSnapshotPercShare;
    private Date iSnapshotPercShareDate;
    private CurriculumClassification iClassification;
    private CourseOffering iCourse;
    private Set<CurriculumCourseGroup> iGroups;

    public BaseCurriculumCourse() {
    }

    public BaseCurriculumCourse(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="pr_share", nullable=false)
    public Float getPercShare() {
        return this.iPercShare;
    }

    public void setPercShare(Float percShare) {
        this.iPercShare = percShare;
    }

    @Column(name="ord", nullable=false)
    public Integer getOrd() {
        return this.iOrd;
    }

    public void setOrd(Integer ord) {
        this.iOrd = ord;
    }

    @Column(name="snapshot_pr_share", nullable=true)
    public Float getSnapshotPercShare() {
        return this.iSnapshotPercShare;
    }

    public void setSnapshotPercShare(Float snapshotPercShare) {
        this.iSnapshotPercShare = snapshotPercShare;
    }

    @Column(name="snapshot_pr_shr_date", nullable=true)
    public Date getSnapshotPercShareDate() {
        return this.iSnapshotPercShareDate;
    }

    public void setSnapshotPercShareDate(Date snapshotPercShareDate) {
        this.iSnapshotPercShareDate = snapshotPercShareDate;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="cur_clasf_id", nullable=false)
    public CurriculumClassification getClassification() {
        return this.iClassification;
    }

    public void setClassification(CurriculumClassification classification) {
        this.iClassification = classification;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_id", nullable=false)
    public CourseOffering getCourse() {
        return this.iCourse;
    }

    public void setCourse(CourseOffering course) {
        this.iCourse = course;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="curriculum_course_group", joinColumns={@JoinColumn(name="cur_course_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CurriculumCourseGroup> getGroups() {
        return this.iGroups;
    }

    public void setGroups(Set<CurriculumCourseGroup> groups) {
        this.iGroups = groups;
    }

    public void addToGroups(CurriculumCourseGroup curriculumCourseGroup) {
        if (this.iGroups == null) {
            this.iGroups = new HashSet<CurriculumCourseGroup>();
        }
        this.iGroups.add(curriculumCourseGroup);
    }

    @Deprecated
    public void addTogroups(CurriculumCourseGroup curriculumCourseGroup) {
        this.addToGroups(curriculumCourseGroup);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumCourse)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CurriculumCourse)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CurriculumCourse)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CurriculumCourse[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CurriculumCourse[\n\tClassification: " + String.valueOf(this.getClassification()) + "\n\tCourse: " + String.valueOf(this.getCourse()) + "\n\tOrd: " + this.getOrd() + "\n\tPercShare: " + this.getPercShare() + "\n\tSnapshotPercShare: " + this.getSnapshotPercShare() + "\n\tSnapshotPercShareDate: " + String.valueOf(this.getSnapshotPercShareDate()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

