/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.base.BaseStudentAccomodation;
import org.unitime.timetable.model.dao.StudentAccomodationDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="student_accomodation")
public class StudentAccomodation
extends BaseStudentAccomodation {
    private static final long serialVersionUID = 1L;

    public StudentAccomodation() {
    }

    public StudentAccomodation(Long uniqueId) {
        super(uniqueId);
    }

    public static StudentAccomodation findByAbbv(Long sessionId, String abbv) {
        return (StudentAccomodation)StudentAccomodationDAO.getInstance().getSession().createQuery("select a from StudentAccomodation a where a.session.uniqueId=:sessionId and a.abbreviation=:abbv", StudentAccomodation.class).setParameter("sessionId", (Object)sessionId).setParameter("abbv", (Object)abbv).setCacheable(true).uniqueResult();
    }

    public static List<AccommodationCounter> getAccommodations(InstructionalOffering offering) {
        ArrayList<AccommodationCounter> ret = new ArrayList<AccommodationCounter>();
        for (Object[] line : StudentAccomodationDAO.getInstance().getSession().createQuery("select a, count(distinct e.student) from StudentClassEnrollment e inner join e.student.accomodations a where e.courseOffering.instructionalOffering.uniqueId = :offeringId group by a order by count(a) desc, a.name", Object[].class).setParameter("offeringId", (Object)offering.getUniqueId()).setCacheable(true).list()) {
            ret.add(new AccommodationCounter((StudentAccomodation)line[0], ((Number)line[1]).intValue()));
        }
        return ret;
    }

    public static List<AccommodationCounter> getAccommodations(Class_ clazz) {
        ArrayList<AccommodationCounter> ret = new ArrayList<AccommodationCounter>();
        for (Object[] line : StudentAccomodationDAO.getInstance().getSession().createQuery("select a, count(distinct e.student) from StudentClassEnrollment e inner join e.student.accomodations a where e.clazz.uniqueId = :classId group by a order by count(a) desc, a.name", Object[].class).setParameter("classId", (Object)clazz.getUniqueId()).setCacheable(true).list()) {
            ret.add(new AccommodationCounter((StudentAccomodation)line[0], ((Number)line[1]).intValue()));
        }
        return ret;
    }

    public static List<AccommodationCounter> getAccommodations(Exam exam) {
        Hashtable<StudentAccomodation, Integer> counter = new Hashtable<StudentAccomodation, Integer>();
        for (ExamOwner owner : exam.getOwners()) {
            String query = null;
            switch (owner.getOwnerType()) {
                case 3: {
                    query = "e.clazz.uniqueId = :examOwnerId";
                    break;
                }
                case 2: {
                    query = "e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId";
                    break;
                }
                case 1: {
                    query = "e.courseOffering.uniqueId = :examOwnerId";
                    break;
                }
                case 0: {
                    query = "e.courseOffering.instructionalOffering.uniqueId = :examOwnerId";
                }
            }
            if (query == null) continue;
            for (Object[] line : StudentAccomodationDAO.getInstance().getSession().createQuery("select a, count(distinct e.student) from StudentClassEnrollment e inner join e.student.accomodations a where " + query + " group by a order by count(a) desc, a.name", Object[].class).setParameter("examOwnerId", (Object)owner.getOwnerId()).setCacheable(true).list()) {
                StudentAccomodation a = (StudentAccomodation)line[0];
                int count = ((Number)line[1]).intValue();
                Integer prev = (Integer)counter.get(a);
                counter.put(a, count + (prev == null ? 0 : prev));
            }
        }
        ArrayList<AccommodationCounter> ret = new ArrayList<AccommodationCounter>();
        for (Map.Entry entry : counter.entrySet()) {
            ret.add(new AccommodationCounter((StudentAccomodation)entry.getKey(), (Integer)entry.getValue()));
        }
        Collections.sort(ret);
        return ret;
    }

    public static String toHtml(List<AccommodationCounter> table) {
        if (table == null || table.isEmpty()) {
            return null;
        }
        StringBuffer ret = new StringBuffer("<table>");
        for (AccommodationCounter ac : table) {
            ret.append(ac.toHtmlRow());
        }
        ret.append("</table>");
        return ret.toString();
    }

    public static class AccommodationCounter
    implements Comparable<AccommodationCounter> {
        StudentAccomodation iAccommodation;
        private int iCount;

        public AccommodationCounter(StudentAccomodation accommodation, int count) {
            this.iAccommodation = accommodation;
            this.iCount = count;
        }

        @Transient
        public int getCount() {
            return this.iCount;
        }

        @Transient
        public StudentAccomodation getAccommodation() {
            return this.iAccommodation;
        }

        public void increment(int count) {
            this.iCount += count;
        }

        public String toHtmlRow() {
            return "<tr><td>" + this.getAccommodation().getName() + ":</td><td>" + this.getCount() + "</td></tr>";
        }

        @Override
        public int compareTo(AccommodationCounter ac) {
            if (this.getCount() > ac.getCount()) {
                return -1;
            }
            if (this.getCount() < ac.getCount()) {
                return 1;
            }
            int cmp = this.getAccommodation().getName().compareTo(ac.getAccommodation().getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getAccommodation().getUniqueId().compareTo(ac.getAccommodation().getUniqueId());
        }
    }
}

