/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseRoomGroupPref;

@Entity
@Table(name="room_group_pref")
public class RoomGroupPref
extends BaseRoomGroupPref {
    private static final long serialVersionUID = 1L;

    public RoomGroupPref() {
    }

    public RoomGroupPref(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String preferenceText() {
        Object ret = this.getRoomGroup().getName();
        if (this.getRoomIndex() != null) {
            ret = (String)ret + " (" + MSG.itemOnlyRoom(1 + this.getRoomIndex()) + ")";
        }
        return ret;
    }

    @Override
    public String preferenceAbbv() {
        Object ret = this.getRoomGroup().getAbbv();
        if (this.getRoomIndex() != null) {
            ret = (String)ret + " (" + MSG.itemOnlyRoom(1 + this.getRoomIndex()) + ")";
        }
        return ret;
    }

    @Override
    public int compareTo(Object o) {
        try {
            RoomGroupPref p = (RoomGroupPref)o;
            int cmp = Integer.compare(this.getRoomIndex() == null ? -1 : this.getRoomIndex(), p.getRoomIndex() == null ? -1 : p.getRoomIndex());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getRoomGroup().getAbbv().compareTo(p.getRoomGroup().getAbbv());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    @Override
    public Object clone() {
        RoomGroupPref pref = new RoomGroupPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setRoomGroup(this.getRoomGroup());
        pref.setRoomIndex(this.getRoomIndex());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof RoomGroupPref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getRoomGroup(), (Object)((RoomGroupPref)other).getRoomGroup()) && ToolBox.equals((Object)this.getRoomIndex(), (Object)((RoomGroupPref)other).getRoomIndex());
    }

    @Override
    public boolean isSame(Preference other, PreferenceGroup level) {
        if (other == null || !(other instanceof RoomGroupPref)) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getRoomGroup(), (Object)((RoomGroupPref)other).getRoomGroup())) {
            return false;
        }
        if (!(level == null || !(level instanceof Class_) || ((Class_)level).getNbrRooms() != 1 || this.getRoomIndex() != null && this.getRoomIndex() != 0 || ((RoomGroupPref)other).getRoomIndex() != null && ((RoomGroupPref)other).getRoomIndex() != 0)) {
            return true;
        }
        return ToolBox.equals((Object)this.getRoomIndex(), (Object)((RoomGroupPref)other).getRoomIndex());
    }

    @Override
    public String preferenceTitle() {
        return MSG.prefTitleRoomGroup(this.getPrefLevel().getPrefName(), this.getRoomGroup().getNameWithTitle());
    }

    @Override
    @Transient
    public Preference.Type getType() {
        return Preference.Type.ROOM_GROUP;
    }

    @Override
    public String preferenceDescription() {
        return this.getRoomGroup().getDescription();
    }

    @Override
    public boolean appliesTo(PreferenceGroup group) {
        if (!super.appliesTo(group)) {
            return false;
        }
        if (this.getRoomIndex() != null && group instanceof Class_) {
            return this.getRoomIndex() < ((Class_)group).getNbrRooms();
        }
        if (this.getRoomIndex() != null && group instanceof SchedulingSubpart) {
            return this.getRoomIndex() < ((SchedulingSubpart)group).getMaxRooms();
        }
        return true;
    }
}

