/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.FlushMode;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseExactTimeMins;
import org.unitime.timetable.model.dao.ExactTimeMinsDAO;
import org.unitime.timetable.util.Constants;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="exact_time_mins")
public class ExactTimeMins
extends BaseExactTimeMins
implements Comparable {
    private static final long serialVersionUID = 1L;

    public ExactTimeMins() {
    }

    public ExactTimeMins(Long uniqueId) {
        super(uniqueId);
    }

    public static ExactTimeMins findByMinPerMtg(int minPerMtg) {
        return (ExactTimeMins)ExactTimeMinsDAO.getInstance().getSession().createQuery("select m from ExactTimeMins m where m.minsPerMtgMin<=:minPerMtg and :minPerMtg<=m.minsPerMtgMax", ExactTimeMins.class).setParameter("minPerMtg", (Object)minPerMtg).setCacheable(true).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
    }

    public static int getNrSlotsPerMtg(int minPerMtg) {
        ExactTimeMins ex = ExactTimeMins.findByMinPerMtg(minPerMtg);
        if (ex == null) {
            int slotsPerMtg = (int)Math.round(1.2 * (double)minPerMtg / (double)Constants.SLOT_LENGTH_MIN);
            if ((double)minPerMtg < 30.0) {
                slotsPerMtg = Math.min(6, slotsPerMtg);
            }
            return slotsPerMtg;
        }
        return ex.getNrSlots();
    }

    public static int getBreakTime(int minPerMtg) {
        ExactTimeMins ex = ExactTimeMins.findByMinPerMtg(minPerMtg);
        if (ex == null) {
            int slotsPerMtg = (int)Math.round(1.2 * (double)minPerMtg / (double)Constants.SLOT_LENGTH_MIN);
            if ((double)minPerMtg < 30.0) {
                slotsPerMtg = Math.min(6, slotsPerMtg);
            }
            int breakTime = 0;
            if (slotsPerMtg % 12 == 0) {
                breakTime = 10;
            } else if (slotsPerMtg > 6) {
                breakTime = 15;
            }
            return breakTime;
        }
        return ex.getBreakTime();
    }

    public static int getNrSlotsPerMtg(int dayCode, int minPerWeek) {
        int nrDays = 0;
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
            ++nrDays;
        }
        if (nrDays == 0) {
            nrDays = 1;
        }
        int minPerMtg = (int)Math.round((double)minPerWeek / (double)nrDays);
        return ExactTimeMins.getNrSlotsPerMtg(minPerMtg);
    }

    public static int getBreakTime(int dayCode, int minPerWeek) {
        int nrDays = 0;
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
            ++nrDays;
        }
        if (nrDays == 0) {
            nrDays = 1;
        }
        int minPerMtg = (int)Math.round((double)minPerWeek / (double)nrDays);
        return ExactTimeMins.getBreakTime(minPerMtg);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ExactTimeMins)) {
            return -1;
        }
        ExactTimeMins ex = (ExactTimeMins)o;
        int cmp = this.getMinsPerMtgMin().compareTo(ex.getMinsPerMtgMin());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getMinsPerMtgMax().compareTo(ex.getMinsPerMtgMax());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(ex.getUniqueId() == null ? -1L : ex.getUniqueId());
    }
}

