/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class DistributionsEditPage
extends Composite {
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private PrefGroupEditInterface.DistributionEditResponse iData;
    private UniTimeTable<PrefGroupEditInterface.DistributionObjectInterface> iClasses;
    private ListBox iDistrubutionType;
    private ListBox iStructure;
    private ListBox iPreference;
    private HTML iDistributionDesc;
    private HTML iStructureDesc;

    public DistributionsEditPage() {
        Long id = null;
        if (Window.Location.getParameter((String)"id") != null) {
            id = Long.valueOf(Window.Location.getParameter((String)"id"));
        } else if (Window.Location.getParameter((String)"distPrefId") != null) {
            id = Long.valueOf(Window.Location.getParameter((String)"distPrefId"));
        } else if (Window.Location.getParameter((String)"dp") != null) {
            id = Long.valueOf(Window.Location.getParameter((String)"dp"));
        }
        this.iPanel = new SimpleForm();
        this.iHeader = new UniTimeHeaderPanel(id == null ? COURSE.sectionTitleAddDistributionPreference() : COURSE.sectionTitleEditDistributionPreference());
        this.iHeader.addButton("save", COURSE.actionSaveNewDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                String error = DistributionsEditPage.this.validate();
                if (error == null) {
                    DistributionsEditPage.this.iHeader.clearMessage();
                    DistributionsEditPage.this.update();
                } else {
                    DistributionsEditPage.this.iHeader.setErrorMessage(error);
                }
            }
        });
        this.iHeader.getButton("save").setAccessKey(COURSE.accessSaveNewDistributionPreference().charAt(0));
        this.iHeader.getButton("save").setTitle(COURSE.titleSaveNewDistributionPreference(COURSE.accessSaveNewDistributionPreference()));
        this.iHeader.setEnabled("save", false);
        this.iHeader.addButton("update", COURSE.actionUpdateDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                String error = DistributionsEditPage.this.validate();
                if (error == null) {
                    DistributionsEditPage.this.iHeader.clearMessage();
                    DistributionsEditPage.this.update();
                } else {
                    DistributionsEditPage.this.iHeader.setErrorMessage(error);
                }
            }
        });
        this.iHeader.setEnabled("update", false);
        this.iHeader.getButton("save").setAccessKey(COURSE.accessUpdateDistributionPreference().charAt(0));
        this.iHeader.getButton("save").setTitle(COURSE.titleUpdateDistributionPreference(COURSE.accessUpdateDistributionPreference()));
        this.iHeader.addButton("delete", COURSE.actionDeleteDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                if (DistributionsEditPage.this.iData.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(COURSE.confirmDeleteDistributionPreference(), new Command(){

                        public void execute() {
                            DistributionsEditPage.this.delete();
                        }
                    });
                } else {
                    DistributionsEditPage.this.delete();
                }
            }
        });
        this.iHeader.setEnabled("delete", false);
        this.iHeader.getButton("delete").setAccessKey(COURSE.accessDeleteDistributionPreference().charAt(0));
        this.iHeader.getButton("delete").setTitle(COURSE.titleDeleteDistributionPreference(COURSE.accessDeleteDistributionPreference()));
        this.iHeader.addButton("back", COURSE.actionBackDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                if (DistributionsEditPage.this.iData.getBackUrl() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + DistributionsEditPage.this.iData.getBackUrl());
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "distributions" + (String)(DistributionsEditPage.this.iData.getPreferenceId() == null ? "" : "?backId=" + DistributionsEditPage.this.iData.getPreferenceId() + "&backType=DistributionPref"));
                }
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackDistributionPreference().charAt(0));
        this.iHeader.getButton("back").setTitle(COURSE.titleBackDistributionPreference(COURSE.accessBackDistributionPreference()));
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iFooter = this.iHeader.clonePanel();
        this.iFooter.setHeaderTitle("");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-DistributionsEditPage");
        this.initWidget((Widget)this.iRootPanel);
        PrefGroupEditInterface.DistributionEditRequest request = new PrefGroupEditInterface.DistributionEditRequest();
        request.setPreferenceId(id);
        if (Window.Location.getParameter((String)"classId") != null) {
            request.setClassId(Long.valueOf(Window.Location.getParameter((String)"classId")));
        }
        if (Window.Location.getParameter((String)"subpartId") != null) {
            request.setSubpartId(Long.valueOf(Window.Location.getParameter((String)"subpartId")));
        }
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<PrefGroupEditInterface.DistributionEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                DistributionsEditPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(PrefGroupEditInterface.DistributionEditResponse response) {
                LoadingWidget.hideLoading();
                DistributionsEditPage.this.iData = response;
                DistributionsEditPage.this.populate();
            }
        });
    }

    protected String validate() {
        if (this.iData.getDistTypeId() == null) {
            return COURSE.errorSelectDistributionType();
        }
        if (this.iData.getStructureId() == null) {
            return COURSE.errorSelectDistributionStructure();
        }
        if (this.iData.getPrefLevelId() == null) {
            return COURSE.errorSelectDistributionPreferenceLevel();
        }
        int count = 0;
        int classes = 0;
        HashSet<String> selections = new HashSet<String>();
        for (int row = 0; row < this.iClasses.getRowCount(); ++row) {
            PrefGroupEditInterface.DistributionObjectInterface doi = this.iClasses.getData(row);
            if (doi.isValid()) {
                if (!selections.add(doi.getId())) {
                    return COURSE.errorInvalidClassSelectionDP();
                }
                ++count;
                if (doi.getClassId() <= 0L) continue;
                ++classes;
                continue;
            }
            if (row + 1 >= this.iClasses.getRowCount()) continue;
            return COURSE.errorInvalidClassSelectionDP();
        }
        if (count <= 0) {
            return COURSE.errorInvalidClassSelectionDPSubpart();
        }
        if (count == 1 && classes > 0) {
            return COURSE.errorInvalidClassSelectionDPMinTwoClasses();
        }
        return null;
    }

    protected void update() {
        PrefGroupEditInterface.DistributionEditRequest request = new PrefGroupEditInterface.DistributionEditRequest();
        request.setPreferenceId(this.iData.getPreferenceId());
        if (this.iData.hasDistributionObjects()) {
            this.iData.getDistributionObjects().clear();
        }
        for (PrefGroupEditInterface.DistributionObjectInterface doi : this.iClasses.getData()) {
            if (!doi.isValid()) continue;
            this.iData.addDistributionObject(doi);
        }
        request.setData(this.iData);
        request.setOperation(PrefGroupEditInterface.DistributionEditRequest.Operation.SAVE);
        LoadingWidget.showLoading(MESSAGES.waitSavingRecord());
        RPC.execute(request, new AsyncCallback<PrefGroupEditInterface.DistributionEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                DistributionsEditPage.this.iHeader.setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(PrefGroupEditInterface.DistributionEditResponse response) {
                LoadingWidget.hideLoading();
                if (DistributionsEditPage.this.iData.getBackUrl() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + DistributionsEditPage.this.iData.getBackUrl() + (DistributionsEditPage.this.iData.getBackUrl().contains("?") ? "&" : "?") + "backId=" + response.getPreferenceId() + "&backType=DistributionPref");
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "distributions?backId=" + response.getPreferenceId() + "&backType=DistributionPref");
                }
            }
        });
    }

    protected void delete() {
        PrefGroupEditInterface.DistributionEditRequest request = new PrefGroupEditInterface.DistributionEditRequest();
        request.setPreferenceId(this.iData.getPreferenceId());
        this.iData.setDistributionObjects(this.iClasses.getData());
        request.setOperation(PrefGroupEditInterface.DistributionEditRequest.Operation.DELETE);
        LoadingWidget.showLoading(MESSAGES.waitDeletingRecord());
        RPC.execute(request, new AsyncCallback<PrefGroupEditInterface.DistributionEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                DistributionsEditPage.this.iHeader.setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(PrefGroupEditInterface.DistributionEditResponse response) {
                LoadingWidget.hideLoading();
                if (DistributionsEditPage.this.iData.getBackUrl() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + DistributionsEditPage.this.iData.getBackUrl());
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "distributions");
                }
            }
        });
    }

    protected void populate() {
        this.iDistrubutionType = new ListBox();
        this.iDistrubutionType.addItem(COURSE.itemSelect(), "");
        this.iDistrubutionType.getElement().getStyle().setProperty("min-width", "300px");
        this.iDistributionDesc = new HTML();
        this.iDistributionDesc.addStyleName("unitime-Description");
        for (PrefGroupEditInterface.IdLabel idLabel : this.iData.getDistTypes()) {
            this.iDistrubutionType.addItem(idLabel.getLabel(), idLabel.getId().toString());
            if (!idLabel.getId().equals(this.iData.getDistTypeId())) continue;
            this.iDistrubutionType.setSelectedIndex(this.iDistrubutionType.getItemCount() - 1);
            this.iDistributionDesc.setHTML(idLabel.getDescription() == null ? "" : idLabel.getDescription());
        }
        this.iDistrubutionType.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                PrefGroupEditInterface.IdLabel dt;
                Long id = DistributionsEditPage.this.iDistrubutionType.getSelectedValue().isEmpty() ? null : Long.valueOf(DistributionsEditPage.this.iDistrubutionType.getSelectedValue());
                DistributionsEditPage.this.iData.setDistTypeId(id);
                PrefGroupEditInterface.IdLabel idLabel = dt = id == null ? null : DistributionsEditPage.this.iData.getDistType(id);
                if (dt != null) {
                    DistributionsEditPage.this.iDistributionDesc.setHTML(dt.getDescription() == null ? "" : dt.getDescription());
                } else {
                    DistributionsEditPage.this.iDistributionDesc.setHTML("");
                }
                DistributionsEditPage.this.iPreference.clear();
                DistributionsEditPage.this.iPreference.addItem(COURSE.itemSelect(), "");
                for (PrefGroupEditInterface.IdLabel st : DistributionsEditPage.this.iData.getPrefLevels()) {
                    if (!dt.getAllowedPrefs().contains(st.getDescription())) continue;
                    DistributionsEditPage.this.iPreference.addItem(st.getLabel(), st.getId().toString());
                    if (!st.getId().equals(DistributionsEditPage.this.iData.getPrefLevelId())) continue;
                    DistributionsEditPage.this.iPreference.setSelectedIndex(DistributionsEditPage.this.iPreference.getItemCount() - 1);
                }
                DistributionsEditPage.this.iData.setPrefLevelId(DistributionsEditPage.this.iPreference.getSelectedValue().isEmpty() ? null : Long.valueOf(DistributionsEditPage.this.iPreference.getSelectedValue()));
            }
        });
        P dtp = new P(new String[0]);
        dtp.add((Widget)this.iDistrubutionType);
        dtp.add((Widget)this.iDistributionDesc);
        this.iPanel.addRow(COURSE.propertyDistributionType(), (Widget)dtp);
        this.iStructure = new ListBox();
        this.iStructure.getElement().getStyle().setProperty("min-width", "300px");
        this.iStructure.addItem(COURSE.itemSelect(), "");
        this.iStructureDesc = new HTML();
        this.iStructureDesc.addStyleName("unitime-Description");
        for (PrefGroupEditInterface.IdLabel st : this.iData.getStructures()) {
            this.iStructure.addItem(st.getLabel(), st.getId().toString());
            if (!st.getId().equals(this.iData.getStructureId())) continue;
            this.iStructure.setSelectedIndex(this.iStructure.getItemCount() - 1);
            this.iStructureDesc.setHTML(st.getDescription() == null ? "" : st.getDescription());
        }
        this.iStructure.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                PrefGroupEditInterface.IdLabel st;
                Long id = DistributionsEditPage.this.iStructure.getSelectedValue().isEmpty() ? null : Long.valueOf(DistributionsEditPage.this.iStructure.getSelectedValue());
                DistributionsEditPage.this.iData.setStructureId(id);
                PrefGroupEditInterface.IdLabel idLabel = st = id == null ? null : DistributionsEditPage.this.iData.getStructure(id);
                if (st != null) {
                    DistributionsEditPage.this.iStructureDesc.setHTML(st.getDescription() == null ? "" : st.getDescription());
                } else {
                    DistributionsEditPage.this.iStructureDesc.setHTML("");
                }
            }
        });
        P p = new P(new String[0]);
        p.add((Widget)this.iStructure);
        p.add((Widget)this.iStructureDesc);
        this.iPanel.addRow(COURSE.propertyDistributionStructure(), (Widget)p);
        this.iPreference = new ListBox();
        this.iPreference.getElement().getStyle().setProperty("min-width", "300px");
        this.iPreference.addItem(COURSE.itemSelect(), "");
        PrefGroupEditInterface.IdLabel dt = this.iData.getDistTypeId() == null ? null : this.iData.getDistType(this.iData.getDistTypeId());
        for (PrefGroupEditInterface.IdLabel idLabel : this.iData.getPrefLevels()) {
            if (dt != null && !dt.getAllowedPrefs().contains(idLabel.getDescription())) continue;
            this.iPreference.addItem(idLabel.getLabel(), idLabel.getId().toString());
            if (!idLabel.getId().equals(this.iData.getPrefLevelId())) continue;
            this.iPreference.setSelectedIndex(this.iPreference.getItemCount() - 1);
        }
        this.iPreference.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                DistributionsEditPage.this.iData.setPrefLevelId(DistributionsEditPage.this.iPreference.getSelectedValue().isEmpty() ? null : Long.valueOf(DistributionsEditPage.this.iPreference.getSelectedValue()));
            }
        });
        this.iPanel.addRow(COURSE.propertyDistributionPreference(), (Widget)this.iPreference);
        this.iClasses = new UniTimeTable();
        UniTimeHeaderPanel header = new UniTimeHeaderPanel(COURSE.sectionTitleClassesInDistribution());
        this.iPanel.addHeaderRow((Widget)header);
        header.addButton("add", COURSE.actionAddClassToDistribution(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                PrefGroupEditInterface.DistributionObjectInterface doi = new PrefGroupEditInterface.DistributionObjectInterface();
                DistributionsEditPage.this.iClasses.addRow(doi, DistributionsEditPage.this.toClassRow(doi));
                DistributionsEditPage.this.updateButtons();
            }
        });
        this.iPanel.addRow((Widget)this.iClasses);
        if (this.iData.hasDistributionObjects()) {
            for (PrefGroupEditInterface.DistributionObjectInterface doi : this.iData.getDistributionObjects()) {
                this.iClasses.addRow(doi, this.toClassRow(doi));
            }
        }
        if (this.iClasses.getRowCount() == 0) {
            PrefGroupEditInterface.DistributionObjectInterface distributionObjectInterface = new PrefGroupEditInterface.DistributionObjectInterface();
            if (Window.Location.getParameter((String)"subjectId") != null) {
                distributionObjectInterface.setSubjectId(Long.valueOf(Window.Location.getParameter((String)"subjectId")));
            }
            this.iClasses.addRow(distributionObjectInterface, this.toClassRow(distributionObjectInterface));
        }
        this.updateButtons();
        this.iPanel.addBottomRow((Widget)this.iFooter);
        this.iHeader.setEnabled("save", this.iData.getPreferenceId() == null);
        this.iHeader.setEnabled("update", this.iData.getPreferenceId() != null);
        this.iHeader.setEnabled("delete", this.iData.getPreferenceId() != null && this.iData.isCanDelete());
        this.iHeader.setEnabled("back", true);
    }

    protected void updateButtons() {
        for (int i = 0; i < this.iClasses.getRowCount(); ++i) {
            ImageButton up = (ImageButton)this.iClasses.getWidget(i, 4);
            ImageButton down = (ImageButton)this.iClasses.getWidget(i, 5);
            ImageButton delete = (ImageButton)this.iClasses.getWidget(i, 6);
            up.setVisible(i > 0);
            down.setVisible(i + 1 < this.iClasses.getRowCount());
            delete.setVisible(this.iClasses.getRowCount() > 1);
        }
    }

    protected List<Widget> toClassRow(final PrefGroupEditInterface.DistributionObjectInterface doi) {
        final ArrayList<Widget> row = new ArrayList<Widget>();
        final ListBox subject = new ListBox();
        subject.addItem("-", "");
        subject.setWidth("90px");
        row.add((Widget)subject);
        final ListBox course = new ListBox();
        course.addItem("-", "");
        course.setWidth("470px");
        row.add((Widget)course);
        final ListBox subpart = new ListBox();
        subpart.addItem("-", "");
        subpart.setWidth("150px");
        row.add((Widget)subpart);
        final ListBox clazz = new ListBox();
        clazz.addItem("-", "");
        clazz.setWidth("150px");
        row.add((Widget)clazz);
        for (PrefGroupEditInterface.IdLabel s : this.iData.getSubjects()) {
            subject.addItem(s.getLabel(), s.getId().toString());
            if (!s.getId().equals(doi.getSubjectId())) continue;
            subject.setSelectedIndex(subject.getItemCount() - 1);
        }
        if (doi.getSubjectId() != null && subject.getSelectedIndex() <= 0) {
            subject.addItem(doi.getSubject(), doi.getSubjectId().toString());
            subject.setSelectedIndex(subject.getItemCount() - 1);
            subject.setEnabled(false);
            course.setEnabled(false);
            subject.setEnabled(false);
            clazz.setEnabled(false);
        }
        subject.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setSubjectId(subject.getSelectedIndex() <= 0 ? null : Long.valueOf(subject.getSelectedValue()));
                DistributionsEditPage.this.subjectChanged(row, doi);
            }
        });
        course.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setCourseId(course.getSelectedIndex() <= 0 ? null : Long.valueOf(course.getSelectedValue()));
                DistributionsEditPage.this.courseChanged(row, doi);
            }
        });
        subpart.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setSubpartId(subpart.getSelectedIndex() <= 0 ? null : Long.valueOf(subpart.getSelectedValue()));
                DistributionsEditPage.this.subpartChanged(row, doi);
            }
        });
        clazz.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setClassId(clazz.getSelectedIndex() <= 0 ? null : Long.valueOf(clazz.getSelectedValue()));
                if (doi.getClassId() != null && DistributionsEditPage.this.iClasses.getRowForWidget((Widget)clazz) == DistributionsEditPage.this.iClasses.getRowCount() - 1) {
                    PrefGroupEditInterface.DistributionObjectInterface doi2 = new PrefGroupEditInterface.DistributionObjectInterface();
                    DistributionsEditPage.this.iClasses.addRow(doi2, DistributionsEditPage.this.toClassRow(doi2));
                    DistributionsEditPage.this.updateButtons();
                }
            }
        });
        if (subject.getSelectedIndex() <= 0 && subject.getItemCount() == 2) {
            subject.setSelectedIndex(1);
            doi.setSubjectId(subject.getSelectedIndex() <= 0 ? null : Long.valueOf(subject.getSelectedValue()));
        }
        if (subject.getSelectedIndex() > 0) {
            this.subjectChanged(row, doi);
        }
        final ImageButton up = new ImageButton(RESOURCES.orderUp());
        up.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = DistributionsEditPage.this.iClasses.getRowForWidget((Widget)up);
                if (row > 0) {
                    DistributionsEditPage.this.iClasses.swapRows(row - 1, row);
                }
                DistributionsEditPage.this.updateButtons();
            }
        });
        row.add((Widget)up);
        final ImageButton down = new ImageButton(RESOURCES.orderDown());
        down.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = DistributionsEditPage.this.iClasses.getRowForWidget((Widget)down);
                if (row + 1 < DistributionsEditPage.this.iClasses.getRowCount()) {
                    DistributionsEditPage.this.iClasses.swapRows(row, row + 1);
                }
                DistributionsEditPage.this.updateButtons();
            }
        });
        row.add((Widget)down);
        final ImageButton delete = new ImageButton(RESOURCES.delete());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = DistributionsEditPage.this.iClasses.getRowForWidget((Widget)delete);
                DistributionsEditPage.this.iClasses.removeRow(row);
                DistributionsEditPage.this.updateButtons();
            }
        });
        row.add((Widget)delete);
        return row;
    }

    protected void subjectChanged(final List<Widget> row, final PrefGroupEditInterface.DistributionObjectInterface doi) {
        final ListBox course = (ListBox)row.get(1);
        ListBox subpart = (ListBox)row.get(2);
        ListBox clazz = (ListBox)row.get(3);
        course.clear();
        course.addItem("-", "");
        subpart.clear();
        subpart.addItem("-", "");
        clazz.clear();
        clazz.addItem("-", "");
        if (doi.getSubjectId() != null) {
            PrefGroupEditInterface.DistributionsLookupCourses req = new PrefGroupEditInterface.DistributionsLookupCourses();
            req.setSubjectId(doi.getSubjectId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    course.clear();
                    course.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        course.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getCourseId())) continue;
                        course.setSelectedIndex(course.getItemCount() - 1);
                        DistributionsEditPage.this.courseChanged(row, doi);
                    }
                    if (course.getSelectedIndex() <= 0 && course.getItemCount() == 2) {
                        course.setSelectedIndex(1);
                        doi.setCourseId(course.getSelectedIndex() <= 0 ? null : Long.valueOf(course.getSelectedValue()));
                        DistributionsEditPage.this.courseChanged(row, doi);
                    }
                }
            });
        }
    }

    protected void courseChanged(final List<Widget> row, final PrefGroupEditInterface.DistributionObjectInterface doi) {
        final ListBox subpart = (ListBox)row.get(2);
        ListBox clazz = (ListBox)row.get(3);
        subpart.clear();
        subpart.addItem("-", "");
        clazz.clear();
        clazz.addItem("-", "");
        if (doi.getCourseId() != null) {
            PrefGroupEditInterface.DistributionsLookupSubparts req = new PrefGroupEditInterface.DistributionsLookupSubparts();
            req.setCourseId(doi.getCourseId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    subpart.clear();
                    subpart.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        subpart.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getSubpartId())) continue;
                        subpart.setSelectedIndex(subpart.getItemCount() - 1);
                        DistributionsEditPage.this.subpartChanged(row, doi);
                    }
                    if (subpart.getSelectedIndex() <= 0 && subpart.getItemCount() == 2) {
                        subpart.setSelectedIndex(1);
                        doi.setSubpartId(subpart.getSelectedIndex() <= 0 ? null : Long.valueOf(subpart.getSelectedValue()));
                        DistributionsEditPage.this.subpartChanged(row, doi);
                    }
                }
            });
        }
    }

    protected void subpartChanged(List<Widget> row, final PrefGroupEditInterface.DistributionObjectInterface doi) {
        final ListBox clazz = (ListBox)row.get(3);
        clazz.clear();
        clazz.addItem("-", "");
        if (doi.getSubpartId() != null) {
            PrefGroupEditInterface.DistributionsLookupClasses req = new PrefGroupEditInterface.DistributionsLookupClasses();
            req.setSubpartId(doi.getSubpartId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    clazz.clear();
                    clazz.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        clazz.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getClassId())) continue;
                        clazz.setSelectedIndex(clazz.getItemCount() - 1);
                    }
                    if (clazz.getSelectedIndex() <= 0) {
                        clazz.setSelectedIndex(1);
                        doi.setClassId(clazz.getSelectedIndex() <= 0 ? null : Long.valueOf(clazz.getSelectedValue()));
                        if (doi.getClassId() != null && DistributionsEditPage.this.iClasses.getRowForWidget((Widget)clazz) == DistributionsEditPage.this.iClasses.getRowCount() - 1) {
                            PrefGroupEditInterface.DistributionObjectInterface doi2 = new PrefGroupEditInterface.DistributionObjectInterface();
                            DistributionsEditPage.this.iClasses.addRow(doi2, DistributionsEditPage.this.toClassRow(doi2));
                            DistributionsEditPage.this.updateButtons();
                        }
                    }
                }
            });
        }
    }
}

