/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.protocols.TransferQueueBundler;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

@Experimental
public class AlternatingBundler
extends TransferQueueBundler {
    protected Address target_dest;
    protected final List<Message> target_list = new ArrayList<Message>();
    protected final AverageMinMax avg_batch_size = new AverageMinMax();

    @ManagedAttribute(description="Average batch size")
    public String getAverageBatchSize() {
        return this.avg_batch_size.toString();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg_batch_size.clear();
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = (Message)this.queue.take();
                if (msg == null) continue;
                int size = msg.size();
                if (this.count + (long)size >= (long)this.max_size) {
                    this.num_sends_because_full_queue.increment();
                    this.avg_fill_count.add(this.count);
                    this._sendBundledMessages();
                }
                while (true) {
                    Address dest;
                    if (!Util.match(dest = msg.getDest(), this.target_dest) || this.count + (long)size >= (long)this.max_size) {
                        this._sendBundledMessages();
                    }
                    this.addMessage(msg, size);
                    msg = (Message)this.queue.poll();
                    if (msg == null) break;
                    size = msg.size();
                }
                this._sendBundledMessages();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void _sendBundledMessages() {
        try {
            if (this.target_list.isEmpty()) {
                return;
            }
            this.output.position(0);
            if (this.target_list.size() == 1) {
                this.sendSingle(this.target_list.get(0).dest(), this.target_list.get(0), this.output);
            } else {
                this.avg_batch_size.add(this.target_list.size());
                this.sendMultiple(this.target_dest, this.target_list.get(0).getSrc(), this.target_list, this.output);
            }
        }
        finally {
            this.target_list.clear();
            this.count = 0L;
        }
    }

    @Override
    protected void addMessage(Message msg, int size) {
        this.target_dest = msg.getDest();
        this.target_list.add(msg);
        this.count += (long)size;
    }
}

