/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.StudentPinsProvider;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class ReleaseStudentPin
implements OnlineSectioningAction<Map<Long, String>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iStudentIds = null;
    private boolean iRelease = true;

    public ReleaseStudentPin forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public ReleaseStudentPin setRelease(boolean release) {
        this.iRelease = release;
        return this;
    }

    public boolean isRelease() {
        return this.iRelease;
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Long, String> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<Long, String> pins = new HashMap<Long, String>();
        StudentPinsProvider provider = (StudentPinsProvider)Customization.StudentPinsProvider.getProvider();
        Iterator<Long> iterator = this.getStudentIds().iterator();
        while (iterator.hasNext()) {
            Long studentId = iterator.next();
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            XStudent student = server.getStudent(studentId);
            helper.beginTransaction();
            Student dbStudent = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
            if (student != null && dbStudent != null) {
                OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession(), true);
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
                if (this.isRelease()) {
                    action.addOptionBuilder().setKey("Mode").setValue("RELEASE");
                    if ((dbStudent.getPin() == null || dbStudent.getPin().isEmpty()) && provider != null) {
                        try {
                            String pin = provider.retriveStudentPin(server, helper, student);
                            dbStudent.setPin(pin);
                            student.setPin(pin);
                        }
                        catch (SectioningException e) {
                            if (action.getApiException() == null) {
                                action.setApiException("Failed to retrieve PIN: " + e.getMessage());
                            }
                            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                            lock.release();
                            continue;
                        }
                    }
                    if (dbStudent.getPin() != null && !dbStudent.getPin().isEmpty()) {
                        dbStudent.setPinReleased(true);
                        student.setPinReleased(true);
                        pins.put(dbStudent.getUniqueId(), dbStudent.getPin());
                        helper.getHibSession().merge((Object)dbStudent);
                        server.update(student, false);
                        action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
                    } else {
                        action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
                    }
                } else {
                    action.addOptionBuilder().setKey("Mode").setValue("SUPPRESS");
                    dbStudent.setPinReleased(false);
                    student.setPinReleased(false);
                    pins.put(dbStudent.getUniqueId(), dbStudent.getPin() == null ? "" : dbStudent.getPin());
                    helper.getHibSession().merge((Object)dbStudent);
                    server.update(student, false);
                    action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                }
            }
            helper.commitTransaction();
        }
        return pins;
        {
            catch (Exception e) {
                helper.rollbackTransaction();
                if (!(e instanceof SectioningException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (SectioningException)e;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    @Override
    public String name() {
        return "pin-release";
    }
}

