/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.online.expectations.AvoidUnbalancedWhenNoExpectations;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.online.selection.StudentSchedulingAssistantWeights;
import org.hibernate.CacheMode;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSchedulingRuleDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.CacheElement;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningActionFactory;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCredit;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRules;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.server.CourseCache;
import org.unitime.timetable.onlinesectioning.server.SimpleActionFactory;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.updates.CheckAllOfferingsAction;
import org.unitime.timetable.onlinesectioning.updates.PersistExpectedSpacesAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.MemoryCounter;

public abstract class AbstractServer
implements OnlineSectioningServer {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Log iLog = LogFactory.getLog(AbstractServer.class);
    private DistanceMetric iDistanceMetric = null;
    private DistanceMetric iUnavailabilityDistanceMetric = null;
    private DataProperties iConfig = null;
    protected XSchedulingRules iRules = null;
    private OnlineSectioningActionFactory iActionFactory = null;
    protected List<AsyncExecutor> iExecutors = new ArrayList<AsyncExecutor>();
    private Queue<Runnable> iExecutorQueue = new LinkedList<Runnable>();
    private HashSet<CacheElement<Long>> iOfferingsToPersistExpectedSpaces = new HashSet();
    private static ThreadLocal<LinkedList<OnlineSectioningHelper>> sHelper = new ThreadLocal();
    protected Map<String, Object> iProperties = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractServer(OnlineSectioningServerContext context) throws SectioningException {
        this.iConfig = new ServerConfig();
        this.iDistanceMetric = new DistanceMetric(this.iConfig);
        TravelTime.populateTravelTimes(this.iDistanceMetric, context.getAcademicSessionId());
        int unavailabilityMaxTravelTime = this.iConfig.getPropertyInteger("Distances.UnavailabilityMaxTravelTimeInMinutes", Integer.valueOf(this.iDistanceMetric.getMaxTravelDistanceInMinutes()));
        if (unavailabilityMaxTravelTime != this.iDistanceMetric.getMaxTravelDistanceInMinutes()) {
            this.iUnavailabilityDistanceMetric = new DistanceMetric(this.iDistanceMetric);
            this.iUnavailabilityDistanceMetric.setMaxTravelDistanceInMinutes(unavailabilityMaxTravelTime);
            this.iUnavailabilityDistanceMetric.setComputeDistanceConflictsBetweenNonBTBClasses(true);
        }
        try {
            this.iActionFactory = (OnlineSectioningActionFactory)Class.forName(ApplicationProperty.CustomizationOnlineSectioningActionFactory.value()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogFactory.getLog(OnlineSectioningServer.class).warn((Object)"Failed to initialize online sectioning action factory, using the default one.", (Throwable)e);
            this.iActionFactory = new SimpleActionFactory();
        }
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
            Session session = (Session)SessionDAO.getInstance().get(context.getAcademicSessionId(), hibSession);
            if (session == null) {
                throw new SectioningException(MSG.exceptionSessionDoesNotExist(context.getAcademicSessionId() == null ? "null" : context.getAcademicSessionId().toString()));
            }
            Date firstDay = DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear());
            this.iConfig.setProperty("DatePattern.DayOfWeekOffset", Integer.toString(Constants.getDayOfWeek(firstDay)));
            AcademicSessionInfo academicSession = new AcademicSessionInfo(session);
            this.iLog = LogFactory.getLog((String)(OnlineSectioningServer.class.getName() + ".server[" + academicSession.toCompactString() + "]"));
            this.iProperties.put("AcademicSession", academicSession);
            int asncPoolSize = ApplicationProperty.OnlineSchedulingServerAsyncPoolSize.intValue();
            for (int i = 0; i < asncPoolSize; ++i) {
                new AsyncExecutor(academicSession, 1 + i).start();
            }
        }
        this.iLog.info((Object)("Config: " + ToolBox.dict2string((Map)this.iConfig, (int)2)));
        this.load(context);
    }

    protected AbstractServer(AcademicSessionInfo session, boolean allowAsyncCalls) {
        this.iConfig = new ServerConfig();
        this.iDistanceMetric = new DistanceMetric(this.iConfig);
        TravelTime.populateTravelTimes(this.iDistanceMetric, session.getUniqueId());
        int unavailabilityMaxTravelTime = this.iConfig.getPropertyInteger("Distances.UnavailabilityMaxTravelTimeInMinutes", Integer.valueOf(this.iDistanceMetric.getMaxTravelDistanceInMinutes()));
        if (unavailabilityMaxTravelTime != this.iDistanceMetric.getMaxTravelDistanceInMinutes()) {
            this.iUnavailabilityDistanceMetric = new DistanceMetric(this.iDistanceMetric);
            this.iUnavailabilityDistanceMetric.setMaxTravelDistanceInMinutes(unavailabilityMaxTravelTime);
            this.iUnavailabilityDistanceMetric.setComputeDistanceConflictsBetweenNonBTBClasses(true);
        }
        try {
            this.iActionFactory = (OnlineSectioningActionFactory)Class.forName(ApplicationProperty.CustomizationOnlineSectioningActionFactory.value()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogFactory.getLog(OnlineSectioningServer.class).warn((Object)"Failed to initialize online sectioning action factory, using the default one.", (Throwable)e);
            this.iActionFactory = new SimpleActionFactory();
        }
        this.iLog = LogFactory.getLog((String)(OnlineSectioningServer.class.getName() + ".server[" + session.toCompactString() + "]"));
        this.iProperties.put("AcademicSession", session);
        if (allowAsyncCalls) {
            int asncPoolSize = ApplicationProperty.OnlineSchedulingServerAsyncPoolSize.intValue();
            for (int i = 0; i < asncPoolSize; ++i) {
                new AsyncExecutor(session, 1 + i).start();
            }
        }
    }

    protected void load(OnlineSectioningServerContext context) throws SectioningException {
        this.loadOnMaster(context);
    }

    protected void loadOnMaster(OnlineSectioningServerContext context) throws SectioningException {
        block10: {
            try {
                this.setProperty("ReloadIsNeeded", Boolean.FALSE);
                final OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
                if (context.isWaitTillStarted()) {
                    try {
                        this.execute(this.createAction(ReloadAllData.class), user);
                    }
                    catch (Throwable exception) {
                        this.iLog.error((Object)("Failed to load server: " + exception.getMessage()), exception);
                        throw exception;
                    }
                    if (this.getAcademicSession().isSectioningEnabled()) {
                        try {
                            this.execute(this.createAction(CheckAllOfferingsAction.class), user);
                        }
                        catch (Throwable exception) {
                            this.iLog.error((Object)("Failed to check all offerings: " + exception.getMessage()), exception);
                            throw exception;
                        }
                    }
                    this.setReady(true);
                    this.getMemUsage();
                    break block10;
                }
                if (Boolean.TRUE.equals(this.getProperty("ReloadingAllData", Boolean.FALSE))) {
                    this.iLog.info((Object)"Already reloading all data.");
                    return;
                }
                this.setProperty("ReloadingAllData", Boolean.TRUE);
                this.execute(this.createAction(ReloadAllData.class), user, new OnlineSectioningServer.ServerCallback<Boolean>(){

                    @Override
                    public void onSuccess(Boolean result) {
                        if (AbstractServer.this.getAcademicSession().isSectioningEnabled()) {
                            AbstractServer.this.execute(AbstractServer.this.createAction(CheckAllOfferingsAction.class), user, new OnlineSectioningServer.ServerCallback<Boolean>(){

                                @Override
                                public void onSuccess(Boolean result) {
                                    AbstractServer.this.setProperty("ReloadingAllData", Boolean.FALSE);
                                    AbstractServer.this.setReady(true);
                                    AbstractServer.this.getMemUsage();
                                }

                                @Override
                                public void onFailure(Throwable exception) {
                                    AbstractServer.this.setProperty("ReloadingAllData", Boolean.FALSE);
                                    AbstractServer.this.iLog.error((Object)("Failed to check all offerings: " + exception.getMessage()), exception);
                                }
                            });
                        } else {
                            AbstractServer.this.setProperty("ReloadingAllData", Boolean.FALSE);
                            AbstractServer.this.setReady(true);
                            AbstractServer.this.getMemUsage();
                        }
                    }

                    @Override
                    public void onFailure(Throwable exception) {
                        AbstractServer.this.setProperty("ReloadingAllData", Boolean.FALSE);
                        AbstractServer.this.iLog.error((Object)("Failed to load server: " + exception.getMessage()), exception);
                    }
                });
            }
            catch (Throwable t) {
                if (t instanceof SectioningException) {
                    throw (SectioningException)t;
                }
                throw new SectioningException(MSG.exceptionUnknown(t.getMessage()), t);
            }
        }
    }

    @Override
    public long getMemUsage() {
        Runtime rt = Runtime.getRuntime();
        MemoryCounter mc = new MemoryCounter();
        DecimalFormat df = new DecimalFormat("#,##0.00");
        long total = 0L;
        HashMap<CallSite, CallSite> info = new HashMap<CallSite, CallSite>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType().isPrimitive()) continue;
                fields[i].setAccessible(true);
                try {
                    Object obj = fields[i].get(this);
                    if (obj == null) continue;
                    long est = this.estimate(mc, obj);
                    if (est > 1024L) {
                        info.put((CallSite)((Object)(clazz.getSimpleName() + "." + fields[i].getName())), (CallSite)((Object)(df.format((double)est / 1024.0) + " kB" + (String)(obj instanceof Map ? " (" + ((Map)obj).size() + " records)" : (obj instanceof Collection ? "(" + ((Collection)obj).size() + " records)" : "")))));
                    }
                    total += est;
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
        this.iLog.info((Object)("Total Allocated " + df.format((double)total / 1024.0) + " kB (of " + df.format((double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0) + " MB), details: " + ToolBox.dict2string(info, (int)2)));
        return total;
    }

    private long estimate(MemoryCounter mc, Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.size() <= 1000) {
                return mc.estimate(obj);
            }
            long total = 0L;
            int limit = map.size() / 5;
            Iterator it = map.entrySet().iterator();
            for (int i = 0; i < limit; ++i) {
                Map.Entry e = it.next();
                total += mc.estimate(e.getKey()) + mc.estimate(e.getValue());
            }
            return (long)map.size() * total / (long)limit;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (col.size() <= 1000) {
                return mc.estimate(obj);
            }
            long total = 0L;
            int limit = col.size() / 5;
            Iterator it = col.iterator();
            for (int i = 0; i < limit; ++i) {
                Object val = it.next();
                total += mc.estimate(val);
            }
            return (long)col.size() * total / (long)limit;
        }
        return mc.estimate(obj);
    }

    protected void setReady(boolean ready) {
        this.setProperty("ReadyToServe", Boolean.TRUE);
    }

    @Override
    public boolean isReady() {
        return Boolean.TRUE.equals(this.getProperty("ReadyToServe", Boolean.FALSE));
    }

    @Override
    public void reload() {
        this.setProperty("ReadyToServe", Boolean.FALSE);
        this.setProperty("ReloadIsNeeded", Boolean.TRUE);
        this.iLog.info((Object)"Reloading server...");
        List<Long> offeringIds = this.getOfferingsToPersistExpectedSpaces(0L);
        if (!offeringIds.isEmpty()) {
            this.iLog.info((Object)("There are " + offeringIds.size() + " offerings that need expected spaces persisted."));
            this.execute(this.createAction(PersistExpectedSpacesAction.class).forOfferings(offeringIds), this.getSystemUser());
        }
        final Long sessionId = this.getAcademicSession().getUniqueId();
        this.loadOnMaster(new OnlineSectioningServerContext(){

            @Override
            public Long getAcademicSessionId() {
                return sessionId;
            }

            @Override
            public boolean isWaitTillStarted() {
                return false;
            }
        });
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.iDistanceMetric;
    }

    @Override
    public DistanceMetric getUnavailabilityDistanceMetric() {
        return this.iUnavailabilityDistanceMetric == null ? this.iDistanceMetric : this.iUnavailabilityDistanceMetric;
    }

    @Override
    public OverExpectedCriterion getOverExpectedCriterion() {
        try {
            Class<?> overExpectedCriterionClass = Class.forName(this.getConfig().getProperty("OverExpectedCriterion.Class", AvoidUnbalancedWhenNoExpectations.class.getName()));
            return (OverExpectedCriterion)overExpectedCriterionClass.getConstructor(DataProperties.class).newInstance(this.getConfig());
        }
        catch (Exception e) {
            this.iLog.error((Object)("Unable to create custom over-expected criterion (" + e.getMessage() + "), using default."), (Throwable)e);
            return new AvoidUnbalancedWhenNoExpectations(this.getConfig());
        }
    }

    @Override
    public AcademicSessionInfo getAcademicSession() {
        return this.getProperty("AcademicSession", null);
    }

    @Override
    public String getCourseDetails(Long courseId, CourseDetailsProvider provider) {
        XCourse course = this.getCourse(courseId);
        return course == null ? null : course.getDetails(this.getAcademicSession(), provider);
    }

    protected OnlineSectioningHelper getCurrentHelper() {
        LinkedList<OnlineSectioningHelper> h = sHelper.get();
        if (h == null || h.isEmpty()) {
            return new OnlineSectioningHelper();
        }
        return h.peek();
    }

    protected void setCurrentHelper(OnlineSectioningHelper helper) {
        LinkedList<OnlineSectioningHelper> h = sHelper.get();
        if (h == null) {
            h = new LinkedList();
            sHelper.set(h);
        }
        h.push(helper);
    }

    protected void releaseCurrentHelper() {
        LinkedList<OnlineSectioningHelper> h = sHelper.get();
        h.poll();
        if (h.isEmpty()) {
            sHelper.remove();
        }
    }

    protected OnlineSectioningLog.Entity getSystemUser() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
    }

    @Override
    public <X extends OnlineSectioningAction> X createAction(Class<X> clazz) {
        return this.iActionFactory.createAction(clazz);
    }

    @Override
    public <E> E execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user) throws SectioningException {
        Long oldSessionId = ApplicationProperties.getSessionId();
        ApplicationProperties.setSessionId(this.getAcademicSession().getUniqueId());
        long c0 = OnlineSectioningHelper.getCpuTime();
        String cacheMode = this.getConfig().getProperty(action.name() + ".CacheMode", this.getConfig().getProperty("CacheMode"));
        OnlineSectioningHelper h = new OnlineSectioningHelper(user, cacheMode != null ? CacheMode.valueOf((String)cacheMode) : (action instanceof HasCacheMode ? ((HasCacheMode)((Object)action)).getCacheMode() : CacheMode.IGNORE));
        try {
            this.setCurrentHelper(h);
            h.addMessageHandler(new OnlineSectioningHelper.DefaultMessageLogger(LogFactory.getLog((String)(action.getClass().getName() + "." + action.name() + "[" + this.getAcademicSession().toCompactString() + "]"))));
            h.addAction(action, this.getAcademicSession());
            E ret = action.execute(this, h);
            if (h.getAction() != null && !h.getAction().hasResult()) {
                if (ret == null) {
                    h.getAction().setResult(OnlineSectioningLog.Action.ResultType.NULL);
                } else if (ret instanceof Boolean) {
                    h.getAction().setResult((Boolean)ret != false ? OnlineSectioningLog.Action.ResultType.TRUE : OnlineSectioningLog.Action.ResultType.FALSE);
                } else {
                    h.getAction().setResult(OnlineSectioningLog.Action.ResultType.SUCCESS);
                }
            }
            E e = ret;
            return e;
        }
        catch (Exception e) {
            if (e instanceof SectioningException || e instanceof PageAccessException) {
                if (e.getCause() == null) {
                    h.info("Execution failed: " + e.getMessage());
                } else {
                    h.warn("Execution failed: " + e.getMessage(), e.getCause());
                }
            } else {
                h.error("Execution failed: " + e.getMessage(), e);
            }
            if (h.getAction() != null) {
                h.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                if (e.getCause() != null && e instanceof SectioningException) {
                    h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
                } else {
                    h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
                }
            }
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            if (e instanceof PageAccessException) {
                throw (PageAccessException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        finally {
            if (h.getAction() != null) {
                h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                if ((!h.getAction().hasStudent() || !h.getAction().getStudent().hasExternalId()) && user != null && user.hasExternalId() && user.hasType() && user.getType() == OnlineSectioningLog.Entity.EntityType.STUDENT) {
                    if (h.getAction().hasStudent()) {
                        h.getAction().getStudentBuilder().setExternalId(user.getExternalId());
                    } else {
                        h.getAction().setStudent(OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getExternalId()));
                    }
                }
            }
            if (this.iLog.isDebugEnabled()) {
                this.iLog.debug((Object)("Executed: " + String.valueOf(h.getLog()) + " (" + h.getLog().toByteArray().length + " bytes)"));
            }
            OnlineSectioningLogger.getInstance().record(h.getLog());
            this.releaseCurrentHelper();
            ApplicationProperties.setSessionId(oldSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> void execute(final OnlineSectioningAction<E> action, final OnlineSectioningLog.Entity user, final OnlineSectioningServer.ServerCallback<E> callback) throws SectioningException {
        if (this.iExecutors == null || this.iExecutors.isEmpty()) {
            try {
                callback.onSuccess(this.execute(action, user));
            }
            catch (Throwable t) {
                callback.onFailure(t);
            }
            return;
        }
        final String locale = Localization.getLocale();
        Queue<Runnable> queue = this.iExecutorQueue;
        synchronized (queue) {
            this.iExecutorQueue.offer(new Runnable(){

                @Override
                public void run() {
                    Localization.setLocale(locale);
                    try {
                        callback.onSuccess(AbstractServer.this.execute(action, user));
                    }
                    catch (Throwable t) {
                        callback.onFailure(t);
                    }
                }

                public String toString() {
                    return action.name();
                }
            });
            this.iExecutorQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        List<Long> offeringIds = this.getOfferingsToPersistExpectedSpaces(0L);
        if (!offeringIds.isEmpty()) {
            this.iLog.info((Object)("There are " + offeringIds.size() + " offerings that need expected spaces persisted."));
            this.execute(this.createAction(PersistExpectedSpacesAction.class).forOfferings(offeringIds), this.getSystemUser());
        }
        if (this.iExecutors != null) {
            for (AsyncExecutor ex : this.iExecutors) {
                ex.iStop = true;
            }
            Queue<Runnable> queue = this.iExecutorQueue;
            synchronized (queue) {
                this.iExecutorQueue.notifyAll();
            }
        }
    }

    @Override
    public DataProperties getConfig() {
        return this.iConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistExpectedSpaces(Long offeringId) {
        HashSet<CacheElement<Long>> hashSet = this.iOfferingsToPersistExpectedSpaces;
        synchronized (hashSet) {
            this.iOfferingsToPersistExpectedSpaces.add(new CacheElement<Long>(offeringId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getOfferingsToPersistExpectedSpaces(long minimalAge) {
        ArrayList<Long> offeringIds = new ArrayList<Long>();
        long current = JProf.currentTimeMillis();
        HashSet<CacheElement<Long>> hashSet = this.iOfferingsToPersistExpectedSpaces;
        synchronized (hashSet) {
            Iterator<CacheElement<Long>> i = this.iOfferingsToPersistExpectedSpaces.iterator();
            while (i.hasNext()) {
                CacheElement<Long> c = i.next();
                if (current - c.created() < minimalAge) continue;
                offeringIds.add(c.element());
                i.remove();
            }
        }
        return offeringIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needPersistExpectedSpaces(Long offeringId) {
        HashSet<CacheElement<Long>> hashSet = this.iOfferingsToPersistExpectedSpaces;
        synchronized (hashSet) {
            return this.iOfferingsToPersistExpectedSpaces.remove(new CacheElement<Long>(offeringId));
        }
    }

    @Override
    public boolean checkDeadline(Long courseId, XTime sectionTime, OnlineSectioningServer.Deadline type) {
        if (!ApplicationProperty.OnlineSchedulingCheckDeadlines.isTrue()) {
            return true;
        }
        XCourse info = this.getCourse(courseId);
        int deadline = 0;
        switch (type) {
            case NEW: {
                if (info != null && info.getLastWeekToEnroll() != null) {
                    deadline = info.getLastWeekToEnroll();
                    break;
                }
                deadline = this.getAcademicSession().getLastWeekToEnroll();
                break;
            }
            case CHANGE: {
                if (info != null && info.getLastWeekToChange() != null) {
                    deadline = info.getLastWeekToChange();
                    break;
                }
                deadline = this.getAcademicSession().getLastWeekToChange();
                break;
            }
            case DROP: {
                deadline = info != null && info.getLastWeekToDrop() != null ? info.getLastWeekToDrop().intValue() : this.getAcademicSession().getLastWeekToDrop();
            }
        }
        long start = this.getAcademicSession().getSessionBeginDate().getTime();
        long now = new Date().getTime();
        int week = 0;
        week = now >= start ? (int)((now - start) / 604800000L) + 1 : -((int)((start - now) / 604800000L));
        if (sectionTime == null) {
            return week <= deadline;
        }
        int offset = 0;
        long time = this.getAcademicSession().getDatePatternFirstDate().getTime() + (long)sectionTime.getWeeks().nextSetBit(0) * 86400000L + 43200000L;
        offset = time >= start ? (int)((time - start) / 604800000L) : -((int)((start - time) / 604800000L)) - 1;
        return week <= deadline + offset;
    }

    @Override
    public OnlineSectioningServer.CourseDeadlines getCourseDeadlines(Long courseId) {
        boolean enabled = ApplicationProperty.OnlineSchedulingCheckDeadlines.isTrue();
        XCourse info = this.getCourse(courseId);
        int newDeadline = 0;
        int changeDeadline = 0;
        int dropDeadline = 0;
        newDeadline = info != null && info.getLastWeekToEnroll() != null ? info.getLastWeekToEnroll().intValue() : this.getAcademicSession().getLastWeekToEnroll();
        changeDeadline = info != null && info.getLastWeekToChange() != null ? info.getLastWeekToChange().intValue() : this.getAcademicSession().getLastWeekToChange();
        dropDeadline = info != null && info.getLastWeekToDrop() != null ? info.getLastWeekToDrop().intValue() : this.getAcademicSession().getLastWeekToDrop();
        long start = this.getAcademicSession().getSessionBeginDate().getTime();
        long now = new Date().getTime();
        int week = 0;
        week = now >= start ? (int)((now - start) / 604800000L) + 1 : -((int)((start - now) / 604800000L));
        return new CourseDeadlinesImpl(enabled, newDeadline, changeDeadline, dropDeadline, week, start, this.getAcademicSession().getDatePatternFirstDate().getTime());
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public String getUser() {
        return this.getAcademicSession().getUniqueId().toString();
    }

    @Override
    public XEnrollments getEnrollments(Long offeringId) {
        return new XEnrollments(offeringId, this.getRequests(offeringId));
    }

    @Override
    public <E> E getProperty(String name, E defaultValue) {
        Object ret = this.iProperties.get(name);
        return (E)(ret == null ? defaultValue : ret);
    }

    @Override
    public <E> void setProperty(String name, E value) {
        if (value == null) {
            this.iProperties.remove(name);
        } else {
            this.iProperties.put(name, value);
        }
    }

    @Override
    public XCourseId getCourse(Long courseId, String courseName) {
        if (courseId != null) {
            return this.getCourse(courseId);
        }
        if (courseName != null) {
            return this.getCourse(courseName);
        }
        return null;
    }

    @Override
    public void setSchedulingRules(XSchedulingRules rules) {
        this.iRules = rules;
    }

    @Override
    public XSchedulingRule getSchedulingRule(XStudent student, StudentSchedulingRule.Mode mode, boolean isAdvisor, boolean isAdmin) {
        if (this.iRules != null) {
            return this.iRules.getRule(student, mode, this, isAdvisor, isAdmin);
        }
        StudentSchedulingRule rule = StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, this.getAcademicSession().getDefaultSectioningStatus(), this, false), this.getAcademicSession(), isAdvisor, isAdmin, mode, StudentSchedulingRuleDAO.getInstance().getSession());
        return rule == null ? null : new XSchedulingRule(rule);
    }

    @Override
    public Collection<XClassEnrollment> getStudentSchedule(String studentExternalId) {
        XStudent student = this.getStudentForExternalId(studentExternalId);
        if (student == null) {
            return null;
        }
        ArrayList<XClassEnrollment> ret = new ArrayList<XClassEnrollment>();
        for (XRequest request : student.getRequests()) {
            XCourseRequest cr;
            XEnrollment e;
            if (!(request instanceof XCourseRequest) || (e = (cr = (XCourseRequest)request).getEnrollment()) == null) continue;
            XOffering offering = this.getOffering(e.getOfferingId());
            XEnrollments enrl = this.getEnrollments(e.getOfferingId());
            for (XSection section : offering.getSections(e)) {
                XClassEnrollment ce = new XClassEnrollment(e, section);
                if (section.getParentId() != null) {
                    ce.setParentSectionName(offering.getSection(section.getParentId()).getName(e.getCourseId()));
                }
                if (enrl != null) {
                    ce.setEnrollment(enrl.countEnrollmentsForSection(section.getSectionId()));
                }
                XSubpart subpart = offering.getSubpart(section.getSubpartId());
                ce.setCredit(subpart.getCredit(e.getCourseId()));
                Float creditOverride = section.getCreditOverride(e.getCourseId());
                if (creditOverride != null) {
                    ce.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                ret.add(ce);
            }
        }
        return ret;
    }

    @Override
    public XSchedulingRule getSchedulingRule(Long studentId, StudentSchedulingRule.Mode mode, boolean isAdvisor, boolean isAdmin) {
        XStudent student = this.getStudent(studentId);
        if (student == null) {
            return null;
        }
        return this.getSchedulingRule(student, mode, isAdvisor, isAdmin);
    }

    @Override
    public float[] getCredits(String studentExternalId) {
        return this.getCredits(this.getStudentForExternalId(studentExternalId));
    }

    public static XCourse getParentRequest(CourseCache server, XStudent student, XCourse childCourse) {
        if (childCourse == null || childCourse.getParentCourseId() == null) {
            return null;
        }
        for (XRequest cr : student.getRequests()) {
            if (!(cr instanceof XCourseRequest)) continue;
            for (XCourseId parent : ((XCourseRequest)cr).getCourseIds()) {
                if (!parent.getCourseId().equals(childCourse.getParentCourseId())) continue;
                return server.getCourse(parent.getCourseId());
            }
        }
        return null;
    }

    public FindStudentInfoAction.MinMaxCredit getMinMaxCredit(CourseCache server, XStudent student, XCourse course, Float ec) {
        if (course == null) {
            return null;
        }
        XCredit c = course.getCreditInfo();
        if (c == null && ec == null) {
            return null;
        }
        XCourse pc = AbstractServer.getParentRequest(server, student, course);
        if (pc != null && pc.getCreditInfo() != null) {
            return new FindStudentInfoAction.MinMaxCredit(0.0f, 0.0f);
        }
        float tMin = 0.0f;
        float tMax = 0.0f;
        for (XRequest request : student.getRequests()) {
            Float max;
            Float min;
            block9: {
                XCourseRequest cr;
                block8: {
                    if (!(request instanceof XCourseRequest)) continue;
                    min = null;
                    max = null;
                    cr = (XCourseRequest)request;
                    XEnrollment e = cr.getEnrollment();
                    if (e == null) break block8;
                    XCourse child = server.getCourse(e.getCourseId());
                    if (child == null || !course.getCourseId().equals(child.getParentCourseId())) break block9;
                    float cred = e.getCredit(this);
                    if (min == null || min.floatValue() > cred) {
                        min = Float.valueOf(cred);
                    }
                    if (max != null && !(max.floatValue() < cred)) break block9;
                    max = Float.valueOf(cred);
                    break block9;
                }
                for (XCourseId cid : cr.getCourseIds()) {
                    XCredit cc;
                    XCourse child = server.getCourse(cid.getCourseId());
                    if (child == null || !course.getCourseId().equals(child.getParentCourseId()) || (cc = child.getCreditInfo()) == null) continue;
                    if (min == null || min.floatValue() > cc.getMinCredit().floatValue()) {
                        min = cc.getMinCredit();
                    }
                    if (max != null && !(max.floatValue() < cc.getMaxCredit().floatValue())) continue;
                    max = cc.getMinCredit();
                }
            }
            if (min == null) continue;
            tMin += min.floatValue();
            tMax += max.floatValue();
        }
        if (ec != null) {
            return new FindStudentInfoAction.MinMaxCredit(ec.floatValue() + tMin, ec.floatValue() + tMax);
        }
        return new FindStudentInfoAction.MinMaxCredit(c.getMinCredit().floatValue() + tMin, c.getMinCredit().floatValue() + tMax);
    }

    @Override
    public float[] getCredits(XStudent student) {
        if (student == null) {
            return null;
        }
        Set<Long> advisorWaitListedCourseIds = student.getAdvisorWaitListedCourseIds(this);
        CourseCache cache = new CourseCache(this);
        ArrayList<Float> mins = new ArrayList<Float>();
        ArrayList<Float> maxs = new ArrayList<Float>();
        int nrCourses = 0;
        float tMin = 0.0f;
        float tMax = 0.0f;
        float tEnrl = 0.0f;
        for (XRequest request : student.getRequests()) {
            if (!(request instanceof XCourseRequest)) continue;
            XCourseRequest cr = (XCourseRequest)request;
            XEnrollment e = cr.getEnrollment();
            if (e != null) {
                float cred = e.getCredit(this);
                FindStudentInfoAction.MinMaxCredit rc = this.getMinMaxCredit(cache, student, cache.getCourse(e.getCourseId()), Float.valueOf(cred));
                if (rc != null) {
                    tMin += rc.getMinCredit();
                    tMax += rc.getMaxCredit();
                } else {
                    tMin += cred;
                    tMax += cred;
                }
                tEnrl += cred;
                if (!cr.isAlternative()) continue;
                --nrCourses;
                continue;
            }
            Float min = null;
            Float max = null;
            for (XCourseId courseId : cr.getCourseIds()) {
                XCourse course = this.getCourse(courseId.getCourseId());
                FindStudentInfoAction.MinMaxCredit rc = this.getMinMaxCredit(cache, student, course, null);
                if (rc == null) continue;
                if (min == null || min.floatValue() > rc.getMinCredit()) {
                    min = Float.valueOf(rc.getMinCredit());
                }
                if (max != null && !(max.floatValue() < rc.getMaxCredit())) continue;
                max = Float.valueOf(rc.getMaxCredit());
            }
            if (cr.isAlternative()) {
                if (min == null) continue;
                mins.add(min);
                maxs.add(max);
                continue;
            }
            if (min == null) continue;
            if (cr.isWaitListOrNoSub(OnlineSectioningInterface.WaitListMode.NoSubs, advisorWaitListedCourseIds)) {
                tMin += min.floatValue();
                tMax += max.floatValue();
                continue;
            }
            mins.add(min);
            maxs.add(max);
            ++nrCourses;
        }
        Collections.sort(mins);
        Collections.sort(maxs);
        for (int i = 0; i < nrCourses; ++i) {
            tMin += ((Float)mins.get(i)).floatValue();
            tMax += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
        }
        return new float[]{tMin, tMax, tEnrl};
    }

    private static class ServerConfig
    extends DataProperties {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerConfig() {
            this.setProperty("Neighbour.BranchAndBoundTimeout", "1000");
            this.setProperty("Suggestions.Timeout", "1000");
            this.setProperty("Extensions.Classes", DistanceConflict.class.getName() + ";" + TimeOverlapsCounter.class.getName());
            this.setProperty("StudentWeights.Class", StudentSchedulingAssistantWeights.class.getName());
            this.setProperty("StudentWeights.PriorityWeighting", "true");
            this.setProperty("StudentWeights.LeftoverSpread", "true");
            this.setProperty("StudentWeights.BalancingFactor", "0.0");
            this.setProperty("StudentWeights.MultiCriteria", "true");
            this.setProperty("Reservation.CanAssignOverTheLimit", "true");
            this.setProperty("General.SaveDefaultProperties", "false");
            this.setProperty("General.StartUpDate", String.valueOf(new Date().getTime()));
            this.setProperty("check-assignment.ExcludeLockedOfferings", "false");
            this.setProperty("check-offering.ExcludeLockedOfferings", "false");
            this.setProperty("approve-enrollments.ExcludeLockedOfferings", "false");
            this.setProperty("reject-enrollments.ExcludeLockedOfferings", "false");
            this.setProperty("status-change.LockOfferings", "false");
            this.setProperty("student-email.LockOfferings", "false");
            this.setProperty("eligibility.LockOfferings", "false");
            try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
                for (SolverParameterDef def : hibSession.createQuery("from SolverParameterDef x where x.group.type = :type and x.default is not null", SolverParameterDef.class).setParameter("type", (Object)SolverParameterGroup.SolverType.STUDENT.ordinal()).list()) {
                    this.setProperty(def.getName(), def.getDefault());
                }
                SolverPredefinedSetting settings = (SolverPredefinedSetting)hibSession.createQuery("from SolverPredefinedSetting x where x.name = :reference", SolverPredefinedSetting.class).setParameter("reference", (Object)"StudentSct.Online").setMaxResults(1).uniqueResult();
                if (settings != null) {
                    for (SolverParameter param : settings.getParameters()) {
                        if (!param.getDefinition().isVisible().booleanValue() || param.getDefinition().getGroup().getSolverType() != SolverParameterGroup.SolverType.STUDENT) continue;
                        this.setProperty(param.getDefinition().getName(), param.getValue());
                    }
                    this.setProperty("General.SettingsId", settings.getUniqueId().toString());
                }
                if (this.getProperty("Distances.Ellipsoid") == null || "DEFAULT".equals(this.getProperty("Distances.Ellipsoid"))) {
                    this.setProperty("Distances.Ellipsoid", ApplicationProperty.DistanceEllipsoid.value());
                }
                if ("Priority".equals(this.getProperty("StudentWeights.Mode"))) {
                    this.setProperty("StudentWeights.PriorityWeighting", "true");
                } else if ("Equal".equals(this.getProperty("StudentWeights.Mode"))) {
                    this.setProperty("StudentWeights.PriorityWeighting", "false");
                }
            }
        }

        public String getProperty(String key) {
            String value = ApplicationProperty.OnlineSchedulingParameter.value(key);
            return value == null ? super.getProperty(key) : value;
        }

        public String getProperty(String key, String defaultValue) {
            String value = ApplicationProperty.OnlineSchedulingParameter.value(key);
            return value == null ? super.getProperty(key, defaultValue) : value;
        }
    }

    public class AsyncExecutor
    extends Thread {
        private boolean iStop = false;
        private int iId;

        public AsyncExecutor(AcademicSessionInfo session, int id) {
            this.iId = id;
            this.setName("AsyncExecutor[" + String.valueOf(session) + "-" + id + "]");
            this.setDaemon(true);
            AbstractServer.this.iExecutors.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ApplicationProperties.setSessionId(AbstractServer.this.getAcademicSession().getUniqueId());
                while (!this.iStop) {
                    Runnable job;
                    Queue<Runnable> queue = AbstractServer.this.iExecutorQueue;
                    synchronized (queue) {
                        job = AbstractServer.this.iExecutorQueue.poll();
                        if (job == null) {
                            try {
                                AbstractServer.this.iLog.debug((Object)("Executor " + this.iId + " is waiting for a new job..."));
                                AbstractServer.this.iExecutorQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    job.run();
                    if (!HibernateUtil.closeCurrentThreadSessions()) continue;
                    AbstractServer.this.iLog.debug((Object)("Job " + String.valueOf(job) + " did not close current-thread hibernate session."));
                }
                AbstractServer.this.iLog.info((Object)("Executor " + this.iId + " stopped."));
            }
            finally {
                ApplicationProperties.setSessionId(null);
                Localization.removeLocale();
                Formats.removeFormats();
                AbstractServer.this.iExecutors.remove(this);
            }
        }
    }

    public static class CourseDeadlinesImpl
    implements OnlineSectioningServer.CourseDeadlines {
        private static final long serialVersionUID = 1L;
        private boolean iEnabled;
        private int iNewDeadline = 0;
        private int iChangeDeadline = 0;
        private int iDropDeadline = 0;
        private int iWeek = 0;
        private long iStart;
        private long iFirstDate;

        public CourseDeadlinesImpl(boolean enabled, int newDeadline, int changeDeadline, int dropDeadline, int week, long start, long firstDate) {
            this.iEnabled = enabled;
            this.iNewDeadline = newDeadline;
            this.iChangeDeadline = changeDeadline;
            this.iDropDeadline = dropDeadline;
            this.iWeek = week;
            this.iStart = start;
            this.iFirstDate = firstDate;
        }

        @Override
        public boolean isEnabled() {
            return this.iEnabled;
        }

        protected int getDeadline(OnlineSectioningServer.Deadline type) {
            switch (type) {
                case NEW: {
                    return this.iNewDeadline;
                }
                case CHANGE: {
                    return this.iChangeDeadline;
                }
                case DROP: {
                    return this.iDropDeadline;
                }
            }
            return this.iNewDeadline;
        }

        @Override
        public boolean checkDeadline(XTime sectionTime, OnlineSectioningServer.Deadline type) {
            int deadline = this.getDeadline(type);
            if (sectionTime == null) {
                return this.iWeek <= deadline;
            }
            int offset = 0;
            long time = this.iFirstDate + (long)sectionTime.getWeeks().nextSetBit(0) * 86400000L + 43200000L;
            offset = time >= this.iStart ? (int)((time - this.iStart) / 604800000L) : -((int)((this.iStart - time) / 604800000L)) - 1;
            return this.iWeek <= deadline + offset;
        }
    }
}

