/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.dao.ExactTimeMinsDAO;
import org.unitime.timetable.util.Constants;

public class XExactTimeConversion {
    private int[] iBreakTimes;
    private int[] iLength;

    public XExactTimeConversion(Session hibSession) {
        List list = ExactTimeMinsDAO.getInstance().findAll(hibSession);
        int max = 0;
        for (ExactTimeMins e : list) {
            if (e.getMinsPerMtgMax() <= max) continue;
            max = e.getMinsPerMtgMax();
        }
        this.iBreakTimes = new int[1 + max];
        this.iLength = new int[1 + max];
        for (int i = 0; i <= max; ++i) {
            this.iLength[i] = -1;
            this.iBreakTimes[i] = -1;
        }
        for (ExactTimeMins e : list) {
            for (int i = e.getMinsPerMtgMin().intValue(); i <= e.getMinsPerMtgMax(); ++i) {
                this.iBreakTimes[i] = e.getBreakTime();
                this.iLength[i] = e.getNrSlots();
            }
        }
    }

    public static int getDefaultLength(int minutesPerMeeting) {
        int len = (int)Math.round(1.2 * (double)minutesPerMeeting / 5.0);
        if (minutesPerMeeting < 30) {
            len = Math.min(6, len);
        }
        return len;
    }

    public static int getDefaultBreakTime(int minutesPerMeeting) {
        int len = XExactTimeConversion.getDefaultLength(minutesPerMeeting);
        if (len <= 6) {
            return 0;
        }
        if (len % 12 == 0) {
            return 10;
        }
        return 15;
    }

    public int getLength(int minutesPerMeeting) {
        int len;
        if (minutesPerMeeting < this.iLength.length && (len = this.iLength[minutesPerMeeting]) >= 0) {
            return len;
        }
        return XExactTimeConversion.getDefaultLength(minutesPerMeeting);
    }

    public int getBreakTime(int minutesPerMeeting) {
        int breakTime;
        if (minutesPerMeeting < this.iBreakTimes.length && (breakTime = this.iBreakTimes[minutesPerMeeting]) >= 0) {
            return breakTime;
        }
        return XExactTimeConversion.getDefaultBreakTime(minutesPerMeeting);
    }

    private static int toMinutesPerMeeting(int days, int minPerWeek) {
        int nrDays = 0;
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            if ((days & Constants.DAY_CODES[i]) == 0) continue;
            ++nrDays;
        }
        return minPerWeek / (nrDays == 0 ? 1 : nrDays);
    }

    public int getLength(int days, int minPerWeek) {
        return this.getLength(XExactTimeConversion.toMinutesPerMeeting(days, minPerWeek));
    }

    public int getBreakTime(int days, int minPerWeek) {
        return this.getBreakTime(XExactTimeConversion.toMinutesPerMeeting(days, minPerWeek));
    }

    public static int getDefaultLength(int days, int minPerWeek) {
        return XExactTimeConversion.getDefaultLength(XExactTimeConversion.toMinutesPerMeeting(days, minPerWeek));
    }

    public static int getDefaultBreakTime(int days, int minPerWeek) {
        return XExactTimeConversion.getDefaultBreakTime(XExactTimeConversion.toMinutesPerMeeting(days, minPerWeek));
    }
}

