/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.UserData;
import org.unitime.timetable.model.base.UserDataId;

@MappedSuperclass
@IdClass(value=UserDataId.class)
public abstract class BaseUserData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalUniqueId;
    private String iName;
    private String iValue;

    @Id
    @Column(name="external_uid", length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Id
    @Column(name="name", length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="value", nullable=false, length=4000)
    public String getValue() {
        return this.iValue;
    }

    public void setValue(String value) {
        this.iValue = value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof UserData)) {
            return false;
        }
        UserData userData = (UserData)o;
        if (this.getExternalUniqueId() == null || userData.getExternalUniqueId() == null || !this.getExternalUniqueId().equals(userData.getExternalUniqueId())) {
            return false;
        }
        return this.getName() != null && userData.getName() != null && this.getName().equals(userData.getName());
    }

    public int hashCode() {
        if (this.getExternalUniqueId() == null || this.getName() == null) {
            return super.hashCode();
        }
        return this.getExternalUniqueId().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return "UserData[" + this.getExternalUniqueId() + ", " + this.getName() + "]";
    }

    public String toDebugString() {
        return "UserData[\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tName: " + this.getName() + "\n\tValue: " + this.getValue() + "]";
    }
}

