/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupType;

@MappedSuperclass
public abstract class BaseStudentGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iGroupAbbreviation;
    private String iGroupName;
    private String iExternalUniqueId;
    private Integer iExpectedSize;
    private Session iSession;
    private StudentGroupType iType;
    private Set<Student> iStudents;

    public BaseStudentGroup() {
    }

    public BaseStudentGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="student_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="group_abbreviation", nullable=false, length=30)
    public String getGroupAbbreviation() {
        return this.iGroupAbbreviation;
    }

    public void setGroupAbbreviation(String groupAbbreviation) {
        this.iGroupAbbreviation = groupAbbreviation;
    }

    @Column(name="group_name", nullable=false, length=90)
    public String getGroupName() {
        return this.iGroupName;
    }

    public void setGroupName(String groupName) {
        this.iGroupName = groupName;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="expected_size", nullable=true)
    public Integer getExpectedSize() {
        return this.iExpectedSize;
    }

    public void setExpectedSize(Integer expectedSize) {
        this.iExpectedSize = expectedSize;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="type_id", nullable=true)
    public StudentGroupType getType() {
        return this.iType;
    }

    public void setType(StudentGroupType type) {
        this.iType = type;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="student_to_group", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="student_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addToStudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    @Deprecated
    public void addTostudents(Student student) {
        this.addToStudents(student);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentGroup[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentGroup[\n\tExpectedSize: " + this.getExpectedSize() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tGroupAbbreviation: " + this.getGroupAbbreviation() + "\n\tGroupName: " + this.getGroupName() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tType: " + String.valueOf(this.getType()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

