/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.ReferenceList;

public class SessionEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 3258410646873060656L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    Session session = new Session();
    ReferenceList statusOptions;
    String academicInitiative;
    String academicYear;
    String academicTerm;
    String sessionStart;
    String sessionEnd;
    String classesEnd;
    String examStart;
    String eventStart;
    String eventEnd;
    Long defaultDatePatternId;
    String defaultDatePatternLabel;
    Integer wkEnroll = 1;
    Integer wkChange = 1;
    Integer wkDrop = 4;
    Long sectStatus;
    boolean includeTestSession;
    Long durationType;
    Long instructionalMethod;
    String notificationsBegin;
    String notificationsEnd;

    public SessionEditForm() {
        this.reset();
    }

    @Override
    public void reset() {
        this.academicInitiative = null;
        this.academicYear = null;
        this.academicTerm = null;
        this.sessionStart = null;
        this.sessionEnd = null;
        this.classesEnd = null;
        this.examStart = null;
        this.eventStart = null;
        this.eventEnd = null;
        this.defaultDatePatternId = null;
        this.defaultDatePatternLabel = null;
        this.wkEnroll = 1;
        this.wkChange = 1;
        this.wkDrop = 4;
        this.sectStatus = null;
        this.includeTestSession = false;
        this.durationType = null;
        this.instructionalMethod = null;
        this.notificationsBegin = null;
        this.notificationsEnd = null;
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.academicInitiative == null || this.academicInitiative.trim().length() == 0) {
            action.addFieldError("form.academicInitiative", MSG.errorRequiredField(MSG.columnAcademicInitiative()));
        }
        if (this.academicTerm == null || this.academicTerm.trim().length() == 0) {
            action.addFieldError("form.academicTerm", MSG.errorRequiredField(MSG.columnAcademicTerm()));
        }
        if (this.academicYear == null || this.academicYear.trim().length() == 0) {
            action.addFieldError("form.academicYear", MSG.errorRequiredField(MSG.columnAcademicYear()));
        } else {
            try {
                Integer.parseInt(this.academicYear);
            }
            catch (Exception e) {
                action.addFieldError("form.academicYear", MSG.errorNotNumber(MSG.columnAcademicYear()));
            }
        }
        this.validateDates(action);
        if (this.getStatus() == null || this.getStatus().trim().length() == 0) {
            action.addFieldError("form.status", MSG.errorRequiredField(MSG.columnSessionStatus()));
        }
        if (!action.hasFieldErrors()) {
            Session sessn = Session.getSessionUsingInitiativeYearTerm(this.academicInitiative, this.academicYear, this.academicTerm);
            if (this.session.getSessionId() == null && sessn != null) {
                action.addFieldError("form.sessionId", MSG.errorAcademicSessionAlreadyExists());
            }
            if (this.session.getSessionId() != null && sessn != null && !this.session.getSessionId().equals(sessn.getSessionId())) {
                action.addFieldError("form.sessionId", MSG.errorAcademicSessionSameAlreadyExists());
            }
        }
    }

    public boolean validateDates(UniTimeAction action) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        Date dStart = null;
        try {
            dStart = df.parse(this.sessionStart);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dStart == null) {
            action.addFieldError("form.sessionStart", MSG.errorNotValidDate(MSG.columnSessionStartDate()));
            return false;
        }
        Date dEnd = null;
        try {
            dEnd = df.parse(this.sessionEnd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dEnd == null) {
            action.addFieldError("form.sessionEnd", MSG.errorNotValidDate(MSG.columnSessionEndDate()));
            return false;
        }
        if (!dEnd.after(dStart)) {
            action.addFieldError("form.sessionEnd", MSG.errorSessionEndDateNotAfterSessionStartDate());
            return false;
        }
        Date dClassEnd = null;
        try {
            dClassEnd = df.parse(this.classesEnd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dClassEnd == null) {
            action.addFieldError("form.classesEnd", MSG.errorNotValidDate(MSG.columnClassesEndDate()));
            return false;
        }
        if (!dClassEnd.after(dStart)) {
            action.addFieldError("form.classesEnd", MSG.errorClassesEndDateNotAfterSessionStartDate());
            return false;
        }
        if (!dClassEnd.before(dEnd) && !dClassEnd.equals(dEnd)) {
            action.addFieldError("form.classesEnd", MSG.errorClassesEndDateNotOnOrBeforeSessionEndDate());
            return false;
        }
        Date dExamStart = null;
        try {
            dExamStart = df.parse(this.examStart);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dExamStart == null) {
            action.addFieldError("form.examStart", MSG.errorNotValidDate(MSG.columnExamStartDate()));
            return false;
        }
        Date dEventStart = null;
        try {
            dEventStart = df.parse(this.eventStart);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date dEventEnd = null;
        try {
            dEventEnd = df.parse(this.eventEnd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dEventStart == null) {
            action.addFieldError("form.eventStart", MSG.errorNotValidDate(MSG.columnEventStartDate()));
            return false;
        }
        if (dEventEnd == null) {
            action.addFieldError("form.eventEnd", MSG.errorNotValidDate(MSG.columnEventEndDate()));
            return false;
        }
        if (!dEventStart.before(dEventEnd)) {
            action.addFieldError("form.eventEnd", MSG.errorEventEndDateNotAfterEventStartDate());
            return false;
        }
        Calendar start = Calendar.getInstance(Locale.US);
        if (dEventStart.before(dStart)) {
            start.setTime(dEventStart);
        } else {
            start.setTime(dStart);
        }
        Calendar end = Calendar.getInstance(Locale.US);
        if (dEventEnd.after(dEnd)) {
            end.setTime(dEventEnd);
        } else {
            end.setTime(dEnd);
        }
        int startYear = start.get(1);
        int endYear = end.get(1);
        int startMonth = start.get(2);
        int endMonth = end.get(2);
        int startDay = start.get(5);
        int endDay = end.get(5);
        if (startYear < endYear && (startYear + 1 < endYear || startMonth < endMonth || startMonth == endMonth && startDay <= endDay)) {
            action.addFieldError("form.sessionDays", MSG.errorSessionDatesOverAYear());
            return false;
        }
        Date dNotificationsBegin = null;
        Date dNotificationsEnd = null;
        if (this.notificationsBegin != null && !this.notificationsBegin.isEmpty()) {
            try {
                dNotificationsBegin = df.parse(this.notificationsBegin);
            }
            catch (Exception e) {
                action.addFieldError("form.notificationsBegin", MSG.errorNotValidDate(MSG.columnNotificationsBeginDate()));
                return false;
            }
        }
        if (this.notificationsEnd != null && !this.notificationsEnd.isEmpty()) {
            try {
                dNotificationsEnd = df.parse(this.notificationsEnd);
            }
            catch (Exception e) {
                action.addFieldError("form.notificationsEnd", MSG.errorNotValidDate(MSG.columnNotificationsEndDate()));
                return false;
            }
        }
        if (dNotificationsBegin != null && dNotificationsEnd != null && !dNotificationsBegin.before(dNotificationsEnd)) {
            action.addFieldError("form.notificationsEnd", MSG.errorNotificationsEndDateNotAfterNotificationsStartDate());
            return false;
        }
        return true;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean equals(Object arg0) {
        return this.session.equals(arg0);
    }

    public String getAcademicInitiative() {
        return this.academicInitiative;
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public void setAcademicInitiative(String academicInitiative) {
        this.academicInitiative = academicInitiative;
    }

    public Long getSessionId() {
        return this.session.getSessionId();
    }

    public void setSessionId(Long sessionId) {
        if (sessionId != null && sessionId <= 0L) {
            this.session.setSessionId(null);
        } else {
            this.session.setSessionId(sessionId);
        }
    }

    public String getStatus() {
        return this.session.getStatusType() == null ? null : this.session.getStatusType().getReference();
    }

    public DepartmentStatusType getStatusType() {
        return this.session.getStatusType();
    }

    public void setStatus(String status) throws Exception {
        this.session.setStatusType(status == null || status.length() == 0 ? null : DepartmentStatusType.findByRef(status));
    }

    public ReferenceList getStatusOptions() {
        if (this.statusOptions == null) {
            this.statusOptions = Session.getSessionStatusList(this.includeTestSession);
        }
        return this.statusOptions;
    }

    public void setStatusOptions(ReferenceList statusOptions) {
        this.statusOptions = statusOptions;
    }

    public String getAcademicInitiativeDisplayString() {
        return this.session.academicInitiativeDisplayString();
    }

    public String getLabel() {
        return this.session.getLabel();
    }

    public String getAcademicTerm() {
        return this.academicTerm;
    }

    public void setAcademicTerm(String academicTerm) {
        this.academicTerm = academicTerm;
    }

    public String getAcademicYear() {
        return this.academicYear;
    }

    public void setAcademicYear(String academicYear) {
        this.academicYear = academicYear;
    }

    public Long getDefaultDatePatternId() {
        return this.defaultDatePatternId;
    }

    public void setDefaultDatePatternId(Long defaultDatePatternId) {
        this.defaultDatePatternId = defaultDatePatternId;
    }

    public String getDefaultDatePatternLabel() {
        return this.defaultDatePatternLabel;
    }

    public void setDefaultDatePatternLabel(String defaultDatePatternLabel) {
        this.defaultDatePatternLabel = defaultDatePatternLabel;
    }

    public String getClassesEnd() {
        return this.classesEnd;
    }

    public void setClassesEnd(String classesEnd) {
        this.classesEnd = classesEnd;
    }

    public String getSessionEnd() {
        return this.sessionEnd;
    }

    public void setSessionEnd(String sessionEnd) {
        this.sessionEnd = sessionEnd;
    }

    public String getSessionStart() {
        return this.sessionStart;
    }

    public void setSessionStart(String sessionStart) {
        this.sessionStart = sessionStart;
    }

    public String getExamStart() {
        return this.examStart;
    }

    public void setExamStart(String examStart) {
        this.examStart = examStart;
    }

    public String getEventStart() {
        return this.eventStart;
    }

    public void setEventStart(String eventStart) {
        this.eventStart = eventStart;
    }

    public String getEventEnd() {
        return this.eventEnd;
    }

    public void setEventEnd(String eventEnd) {
        this.eventEnd = eventEnd;
    }

    public void setNotificationsBegin(String nofificationsBegin) {
        this.notificationsBegin = nofificationsBegin;
    }

    public String getNotificationsBegin() {
        return this.notificationsBegin;
    }

    public void setNotificationsEnd(String nofificationsEnd) {
        this.notificationsEnd = nofificationsEnd;
    }

    public String getNotificationsEnd() {
        return this.notificationsEnd;
    }

    public Set<RoomType> getRoomTypes() {
        return RoomType.findAll();
    }

    public Integer getWkEnroll() {
        return this.wkEnroll;
    }

    public void setWkEnroll(Integer wkEnroll) {
        this.wkEnroll = wkEnroll;
    }

    public Integer getWkChange() {
        return this.wkChange;
    }

    public void setWkChange(Integer wkChange) {
        this.wkChange = wkChange;
    }

    public Integer getWkDrop() {
        return this.wkDrop;
    }

    public void setWkDrop(Integer wkDrop) {
        this.wkDrop = wkDrop;
    }

    public Long getSectStatus() {
        return this.sectStatus;
    }

    public void setSectStatus(Long sectStatus) {
        this.sectStatus = sectStatus;
    }

    public List<IdValue> getSectStates() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (StudentSectioningStatus status : StudentSectioningStatus.findAll(this.getSessionId())) {
            ret.add(new IdValue(status.getUniqueId(), status.getLabel()));
        }
        return ret;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public List<IdValue> getDurationTypes() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (ClassDurationType type : ClassDurationType.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.durationType)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }

    public Long getInstructionalMethod() {
        return this.instructionalMethod;
    }

    public void setInstructionalMethod(Long instructionalMethod) {
        this.instructionalMethod = instructionalMethod;
    }

    public List<IdValue> getInstructionalMethods() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (InstructionalMethod im : InstructionalMethod.findAll()) {
            ret.add(new IdValue(im.getUniqueId(), im.getLabel()));
        }
        return ret;
    }

    public void setIncludeTestSession(boolean includeTestSession) {
        this.includeTestSession = includeTestSession;
    }
}

