/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.hql;

import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.export.BufferedPrinter;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SavedHQLException;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:hql-test.csv")
public class TestHqlExportToCSV
implements Exporter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(TestHqlExportToCSV.class);

    @Override
    public String reference() {
        return "hql-test.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getAcademicSessionId());
        context.checkPermission(helper.getAcademicSessionId(), Right.TestHQL);
        String hql = helper.getParameter("hql");
        if (hql == null) {
            throw new IllegalArgumentException("No query provided, please set the hql parameter.");
        }
        for (SavedHQL.Option o : SavedHQL.Option.values()) {
            if (hql.indexOf("%" + o.name() + "%") < 0) continue;
            Object value = null;
            if (value == null || ((String)value).isEmpty()) {
                Map<Long, String> vals = o.values(helper.getSessionContext().getUser());
                if (vals == null || vals.isEmpty()) {
                    throw new IllegalArgumentException("Unable to set parameter " + o.name() + ": no available values.");
                }
                value = "";
                for (Long id : vals.keySet()) {
                    if (!((String)value).isEmpty()) {
                        value = (String)value + ",";
                    }
                    value = (String)value + id.toString();
                    if (o.allowMultiSelection()) continue;
                    break;
                }
            }
            hql = hql.replace("%" + o.name() + "%", "(" + (String)value + ")");
        }
        if (hql.indexOf("%USER%") >= 0) {
            hql = hql.replace("%USER%", "'" + HibernateUtil.escapeSql(helper.getSessionContext().getUser().getExternalUserId()) + "'");
        }
        BufferedPrinter out = new BufferedPrinter(new CSVPrinter(helper, false));
        helper.setup(out.getContentType(), this.reference(), false);
        TestHqlExportToCSV.execute(context.getUser(), out, hql, 0, ApplicationProperty.TestHQLMaxLines.intValue());
        out.close();
    }

    public static void execute(UserContext user, Exporter.Printer out, String hql, int fromRow, int maxRows) throws SavedHQLException, PageAccessException {
        try {
            org.hibernate.Session hibSession = SavedHQLDAO.getInstance().getSession();
            Query q = hibSession.createQuery(hql, Tuple.class);
            if (maxRows > 0) {
                q.setMaxResults(maxRows);
            }
            if (fromRow > 0) {
                q.setFirstResult(fromRow);
            }
            q.setCacheable(true);
            int len = -1;
            for (Tuple o : q.list()) {
                String[] line;
                if (len < 0) {
                    len = TestHqlExportToCSV.length(o);
                    line = new String[len];
                    TestHqlExportToCSV.header(line, o);
                    if (line.length > 0 && line[0].startsWith("__")) {
                        out.hideColumn(0);
                    }
                    out.printHeader(line);
                }
                line = new String[len];
                TestHqlExportToCSV.line(line, o);
                out.printLine(line);
                out.flush();
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SavedHQLException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SavedHQLException(MESSAGES.failedExecution(e.getMessage() + (String)(e.getCause() == null ? "" : " (" + e.getCause().getMessage() + ")")));
        }
    }

    private static boolean skip(Attribute t) {
        try {
            Class<?> ts = t.getJavaType().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static int length(Tuple o) {
        if (o == null) {
            return 1;
        }
        int len = 0;
        for (TupleElement te : o.getElements()) {
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (et == null) {
                ++len;
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (TestHqlExportToCSV.skip(sa)) continue;
                ++len;
            }
        }
        return len;
    }

    private static String format(String column) {
        if (column == null || column.isEmpty()) {
            return "?";
        }
        return column.substring(0, 1).toUpperCase() + column.substring(1);
    }

    private static void header(String[] ret, Tuple o) {
        int idx = 0;
        for (TupleElement te : o.getElements()) {
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (et == null) {
                if (te.getAlias() == null || te.getAlias().isEmpty()) {
                    if (o.getElements().size() == 1) {
                        ret[idx++] = "Result";
                        continue;
                    }
                    ret[idx++] = "Column" + (idx + 1);
                    continue;
                }
                ret[idx++] = te.getAlias();
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (TestHqlExportToCSV.skip(sa)) continue;
                ret[idx++] = TestHqlExportToCSV.format(sa.getName());
            }
        }
    }

    private static String toString(Object o) {
        if (o != null && o instanceof Document) {
            return ((Document)o).asXML();
        }
        return o == null ? "" : o.toString();
    }

    private static void line(String[] ret, Tuple o) {
        int idx = 0;
        for (TupleElement te : o.getElements()) {
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Object x = o.get(te);
            if (et == null) {
                ret[idx++] = TestHqlExportToCSV.toString(x);
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (TestHqlExportToCSV.skip(sa)) continue;
                try {
                    ret[idx++] = TestHqlExportToCSV.toString(((Method)sa.getJavaMember()).invoke(x, new Object[0]));
                }
                catch (Exception e) {
                    ret[idx++] = "";
                }
            }
        }
    }

    static class AttributeComparator
    implements Comparator<Attribute> {
        AttributeComparator() {
        }

        @Override
        public int compare(Attribute a1, Attribute a2) {
            boolean id2;
            boolean id1 = a1 instanceof SingularAttribute && ((SingularAttribute)a1).isId();
            boolean bl = id2 = a2 instanceof SingularAttribute && ((SingularAttribute)a2).isId();
            if (id1 != id2) {
                return id1 ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

