/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.backup;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import jakarta.persistence.Column;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.backup.BackupProgress;
import org.unitime.timetable.backup.SessionBackup;
import org.unitime.timetable.backup.SessionRestoreInterface;
import org.unitime.timetable.backup.TableData;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.base.BaseExamOwner;
import org.unitime.timetable.model.base.BaseRelatedCourseInfo;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMajor;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMinor;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

public class SessionRestore
implements SessionRestoreInterface {
    private static Log sLog = LogFactory.getLog(SessionBackup.class);
    private org.hibernate.Session iHibSession = null;
    private BackupProgress iProgress = null;
    private boolean iIsClone = false;
    private SimpleDateFormat iDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private SimpleDateFormat iAltDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Map<String, Map<String, Entity>> iEntities = new Hashtable<String, Map<String, Entity>>();
    private List<Entity> iAllEntitites = new ArrayList<Entity>();
    private Map<String, Student> iStudents = new Hashtable<String, Student>();
    private PrintWriter iDebug = null;
    private Map<String, TableData.Table> iSkippedTables = new Hashtable<String, TableData.Table>();
    private Metamodel iMetamodel = null;
    private InputStream iIn;
    Map<String, Set<String>> iMessages = new HashMap<String, Set<String>>();

    public BackupProgress getProgress() {
        return this.iProgress;
    }

    public void debug(PrintWriter pw) {
        this.iDebug = pw;
    }

    private boolean lookup(Entity entity, String property, Object value, String session) {
        boolean hasSession = false;
        for (SingularAttribute attribute : entity.getMeta().getSingularAttributes()) {
            if (!session.equals(attribute.getName())) continue;
            hasSession = true;
            break;
        }
        if (!hasSession) {
            return this.lookup(entity, property, value);
        }
        if (entity.getElement(session) != null) {
            return false;
        }
        try {
            HibernateCriteriaBuilder cb = this.iHibSession.getCriteriaBuilder();
            CriteriaQuery cr = cb.createQuery(entity.getMeta().getJavaType());
            Root root = cr.from(entity.getMeta().getJavaType());
            cr.select((Selection)root).where((Expression)cb.and((Expression)cb.isNull((Expression)root.get(session)), (Expression)cb.equal((Expression)root.get(property), value)));
            Object object = this.iHibSession.createQuery(cr).uniqueResult();
            if (object != null) {
                entity.setObject(object);
            } else {
                this.message("Lookup " + entity.getAbbv() + "." + property + " failed", value == null ? "null" : value.toString());
            }
            return object != null;
        }
        catch (NonUniqueResultException e) {
            this.message("Lookup " + entity.getAbbv() + "." + property + "=" + String.valueOf(value) + " is not unique", entity.getId());
            HibernateCriteriaBuilder cb = this.iHibSession.getCriteriaBuilder();
            CriteriaQuery cr = cb.createQuery(entity.getMeta().getJavaType());
            Root root = cr.from(entity.getMeta().getJavaType());
            cr.select((Selection)root).where((Expression)cb.and((Expression)cb.isNull((Expression)root.get(session)), (Expression)cb.equal((Expression)root.get(property), value)));
            List list = this.iHibSession.createQuery(cr).list();
            if (!list.isEmpty()) {
                Object object = list.get(0);
                entity.setObject(object);
                return true;
            }
            return false;
        }
    }

    private boolean lookup(Entity entity, String property, Object value) {
        try {
            HibernateCriteriaBuilder cb = this.iHibSession.getCriteriaBuilder();
            CriteriaQuery cr = cb.createQuery(entity.getMeta().getJavaType());
            Root root = cr.from(entity.getMeta().getJavaType());
            cr.select((Selection)root).where((Expression)cb.equal((Expression)root.get(property), value));
            Object object = this.iHibSession.createQuery(cr).uniqueResult();
            if (object != null) {
                entity.setObject(object);
            } else {
                this.message("Lookup " + entity.getAbbv() + "." + property + " failed", value == null ? "null" : value.toString());
            }
            return object != null;
        }
        catch (NonUniqueResultException e) {
            this.message("Lookup " + entity.getAbbv() + "." + property + "=" + String.valueOf(value) + " is not unique", entity.getId());
            HibernateCriteriaBuilder cb = this.iHibSession.getCriteriaBuilder();
            CriteriaQuery cr = cb.createQuery(entity.getMeta().getJavaType());
            Root root = cr.from(entity.getMeta().getJavaType());
            cr.select((Selection)root).where((Expression)cb.equal((Expression)root.get(property), value));
            List list = this.iHibSession.createQuery(cr).list();
            if (!list.isEmpty()) {
                Object object = list.get(0);
                entity.setObject(object);
                return true;
            }
            return false;
        }
    }

    protected void add(Entity entity) {
        Script x;
        boolean save = true;
        boolean lookup = true;
        if (entity.getObject() instanceof Session) {
            Session oldSession = (Session)this.iHibSession.get(Session.class, (Object)Long.valueOf(entity.getId()));
            if (oldSession != null) {
                this.iIsClone = true;
            }
            Session session = (Session)entity.getObject();
            int attempt = 0;
            while (!this.iHibSession.createQuery("from Session where academicInitiative = :academicInitiative and academicYear = :academicYear and academicTerm = :academicTerm", Session.class).setParameter("academicInitiative", (Object)(session.getAcademicInitiative() + (String)(attempt == 0 ? "" : " [" + attempt + "]"))).setParameter("academicYear", (Object)session.getAcademicYear()).setParameter("academicTerm", (Object)session.getAcademicTerm()).list().isEmpty()) {
                ++attempt;
            }
            if (attempt > 0) {
                session.setAcademicInitiative(session.getAcademicInitiative() + " [" + attempt + "]");
            }
        }
        if (entity.getObject() instanceof PreferenceLevel && this.lookup(entity, "prefProlog", ((PreferenceLevel)entity.getObject()).getPrefProlog())) {
            save = false;
        }
        if (entity.getObject() instanceof RefTableEntry && this.lookup(entity, "reference", ((RefTableEntry)entity.getObject()).getReference(), "session")) {
            save = false;
        }
        if (entity.getObject() instanceof TimetableManager && this.lookup(entity, "externalUniqueId", ((TimetableManager)entity.getObject()).getExternalUniqueId())) {
            save = false;
        }
        if (entity.getObject() instanceof ItypeDesc && this.lookup(entity, "itype", Integer.valueOf(entity.getId()))) {
            save = false;
        }
        if (entity.getObject() instanceof SolverInfoDef && this.lookup(entity, "name", ((SolverInfoDef)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof SolverParameterGroup && this.lookup(entity, "name", ((SolverParameterGroup)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof SolverPredefinedSetting && this.lookup(entity, "name", ((SolverPredefinedSetting)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof Roles && this.lookup(entity, "reference", ((Roles)entity.getObject()).getReference())) {
            save = false;
        }
        if (entity.getObject() instanceof OfferingConsentType && this.lookup(entity, "label", ((OfferingConsentType)entity.getObject()).getLabel())) {
            save = false;
        }
        if (entity.getObject() instanceof ChangeLog) {
            save = false;
            lookup = false;
        }
        if (entity.getObject() instanceof OnlineSectioningLog) {
            save = false;
            lookup = false;
        }
        if (entity.getObject() instanceof Settings && this.lookup(entity, "key", ((Settings)entity.getObject()).getKey())) {
            save = false;
        }
        if (entity.getObject() instanceof EventContact && this.lookup(entity, "externalUniqueId", ((EventContact)entity.getObject()).getExternalUniqueId())) {
            save = false;
        }
        if (entity.getObject() instanceof EventServiceProvider && this.lookup(entity, "reference", ((EventServiceProvider)entity.getObject()).getReference(), "session")) {
            save = false;
        }
        if (entity.getObject() instanceof Script && this.lookup(entity, "name", ((Script)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof ScriptParameter && (x = (Script)this.get(Script.class, entity.getElement("script").getValue(0))) != null && x.getUniqueId() != null) {
            save = false;
            lookup = false;
        }
        if (save) {
            this.iAllEntitites.add(entity);
        }
        if (lookup) {
            Map<String, Entity> entityOfThisType = this.iEntities.get(entity.getName());
            if (entityOfThisType == null) {
                entityOfThisType = new Hashtable<String, Entity>();
                this.iEntities.put(entity.getName(), entityOfThisType);
            }
            entityOfThisType.put(entity.getId(), entity);
        }
        if (entity.getObject() instanceof Student) {
            Student student = (Student)entity.getObject();
            this.iStudents.put(student.getExternalUniqueId(), student);
        }
    }

    protected Entity lookupSkippedRecord(String tableName, String id) {
        TableData.Table table = this.iSkippedTables.get(tableName);
        if (table == null) {
            return null;
        }
        for (TableData.Record record : table.getRecordList()) {
            if (!id.equals(record.getId()) || record.getElementCount() <= 0) continue;
            return new Entity(null, record, null, id);
        }
        return null;
    }

    private boolean isNullable(Attribute attribute) {
        return attribute instanceof SingularAttribute && ((SingularAttribute)attribute).isOptional();
    }

    private boolean isEntity(Attribute attribute) {
        if (attribute.isCollection()) {
            return false;
        }
        try {
            return this.iMetamodel.entity(attribute.getJavaType()) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getSetterMethod(Attribute attribute) {
        return "set" + attribute.getName().substring(0, 1).toUpperCase() + attribute.getName().substring(1);
    }

    private void setAttribute(Object object, Attribute attribute, Object value) {
        try {
            try {
                object.getClass().getMethod(this.getSetterMethod(attribute), attribute.getJavaType()).invoke(object, value);
            }
            catch (NoSuchMethodException f) {
                object.getClass().getMethod(this.getSetterMethod(attribute), value.getClass()).invoke(object, value);
            }
        }
        catch (Exception e) {
            this.iProgress.warn("Failed to set " + object.getClass().getSimpleName() + "." + attribute.getName() + ": " + e.getMessage());
        }
    }

    public void create(TableData.Table table) throws InstantiationException, IllegalAccessException, DocumentException, InvocationTargetException, NoSuchMethodException {
        EntityType meta = null;
        try {
            meta = this.iMetamodel.entity(Class.forName(table.getName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (meta == null) {
            this.iSkippedTables.put(table.getName(), table);
            return;
        }
        for (Attribute attribute : meta.getAttributes()) {
            if (!"org.unitime.timetable.model.CurriculumClassification.students".equals(meta.getJavaType().getName() + "." + attribute.getName()) && !"org.unitime.timetable.model.Script.script".equals(meta.getJavaType().getName() + "." + attribute.getName()) && !"org.unitime.timetable.model.TaskExecution.logFile".equals(meta.getJavaType().getName() + "." + attribute.getName())) continue;
        }
        this.iProgress.setPhase(meta.getName() + " [" + table.getRecordCount() + "]", table.getRecordCount());
        for (TableData.Record record : table.getRecordList()) {
            this.iProgress.incProgress();
            Object object = meta.getJavaType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (SingularAttribute attribute : meta.getSingularAttributes()) {
                TableData.Element element = null;
                for (TableData.Element e : record.getElementList()) {
                    if (!e.getName().equals(attribute.getName())) continue;
                    element = e;
                    break;
                }
                if (element == null) continue;
                Object value = null;
                Class type = attribute.getJavaType();
                if (Boolean.class.isAssignableFrom(type)) {
                    value = Boolean.valueOf(element.getValue(0));
                } else if (Byte.class.isAssignableFrom(type)) {
                    value = Byte.valueOf(element.getValue(0));
                } else if (Short.class.isAssignableFrom(type)) {
                    value = Short.valueOf(element.getValue(0));
                } else if (Integer.class.isAssignableFrom(type)) {
                    value = Integer.valueOf(element.getValue(0));
                } else if (Long.class.isAssignableFrom(type)) {
                    value = Long.valueOf(element.getValue(0));
                } else if (Float.class.isAssignableFrom(type)) {
                    value = Float.valueOf(element.getValue(0));
                } else if (Double.class.isAssignableFrom(type)) {
                    value = Double.valueOf(element.getValue(0));
                } else if (String.class.isAssignableFrom(type)) {
                    value = element.getValue(0);
                    Column col = ((AnnotatedElement)((Object)attribute.getJavaMember())).getAnnotation(Column.class);
                    if (col != null && col.length() > 0 && col.length() != 255 && value.toString().length() > col.length()) {
                        this.message("Value is too long, truncated (property " + meta.getName() + "." + attribute.getName() + ", length " + col.length() + ")", record.getId());
                        value = value.toString().substring(0, col.length());
                    }
                } else if (Date.class.isAssignableFrom(type)) {
                    try {
                        value = this.iDateFormat.parse(element.getValue(0));
                    }
                    catch (ParseException p) {
                        try {
                            value = this.iAltDateFormat.parse(element.getValue(0));
                        }
                        catch (ParseException q) {
                            try {
                                value = new SimpleDateFormat("dd MMMM yyyy", Localization.getJavaLocale()).parse(element.getValue(0));
                            }
                            catch (ParseException r) {
                                this.message("Falied to parse a date " + element.getValue(0) + " (property " + meta.getName() + "." + attribute.getName() + ", class " + type.getSimpleName() + ")", record.getId());
                            }
                        }
                    }
                } else if (byte[].class.isAssignableFrom(type)) {
                    value = element.getValueBytes(0).toByteArray();
                } else if (!this.isEntity((Attribute)attribute)) {
                    this.message("Unknown type " + type.getClass().getName() + " (property " + meta.getName() + "." + attribute.getName() + ", class " + type.getSimpleName() + ")", record.getId());
                }
                if (value == null) continue;
                this.setAttribute(object, (Attribute)attribute, value);
            }
            this.add(new Entity(meta, record, object, record.getId()));
        }
    }

    protected void message(String message, String id) {
        Set<String> ids = this.iMessages.get(message);
        if (ids == null) {
            ids = new HashSet<String>();
            this.iMessages.put(message, ids);
        }
        if (ids.add(id) && ids.size() <= 5) {
            this.iProgress.warn(message + (String)(id.isEmpty() ? "" : ": " + id));
        }
    }

    private Object checkUnknown(Class clazz, String id, Object object) {
        if (object == null && !"0".equals(id)) {
            this.message("Unknown " + clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1), id);
        }
        return object;
    }

    private void printMessages() {
        for (String message : new TreeSet<String>(this.iMessages.keySet())) {
            TreeSet ids = new TreeSet(this.iMessages.get(message));
            if (ids.isEmpty() || ids.size() == 1 && ids.contains("")) {
                this.iProgress.info(message);
                continue;
            }
            Object list = "";
            int size = 0;
            for (String id : ids) {
                if (!((String)list).isEmpty()) {
                    list = (String)list + ", ";
                }
                if (size > 20) {
                    list = (String)list + "... " + (ids.size() - size) + " more";
                    break;
                }
                list = (String)list + id;
                ++size;
            }
            this.iProgress.info(message + ": " + (String)list);
        }
    }

    protected Entity getEntity(Class clazz, String id) {
        Map<String, Entity> entities = this.iEntities.get(clazz.getName());
        if (entities != null) {
            return entities.get(id);
        }
        return null;
    }

    protected Object get(Class clazz, String id) {
        Entity entity;
        if (clazz.equals(String.class)) {
            return id;
        }
        if (clazz.equals(Character.class)) {
            return id == null || id.isEmpty() ? null : Character.valueOf(id.charAt(0));
        }
        if (clazz.equals(Byte.class)) {
            return Byte.valueOf(id);
        }
        if (clazz.equals(Short.class)) {
            return Short.valueOf(id);
        }
        if (clazz.equals(Integer.class)) {
            return Integer.valueOf(id);
        }
        if (clazz.equals(Long.class)) {
            return Long.valueOf(id);
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(id);
        }
        if (clazz.equals(Double.class)) {
            return Double.valueOf(id);
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.valueOf(id);
        }
        Map<String, Entity> entities = this.iEntities.get(clazz.getName());
        if (entities != null && (entity = entities.get(id)) != null) {
            return entity.getObject();
        }
        for (Map.Entry<String, Map<String, Entity>> entry : this.iEntities.entrySet()) {
            Entity o = entry.getValue().get(id);
            if (o == null || !clazz.isInstance(o.getObject())) continue;
            return o.getObject();
        }
        if (clazz.equals(Session.class)) {
            return this.iEntities.get(Session.class.getName()).values().iterator().next().getObject();
        }
        if (clazz.equals(Student.class)) {
            return this.checkUnknown(clazz, id, this.iStudents.get(id));
        }
        if (this.iIsClone) {
            return this.checkUnknown(clazz, id, this.iHibSession.get(clazz, (Object)(clazz.equals(ItypeDesc.class) ? (Number)Integer.valueOf(id) : (Number)Long.valueOf(id))));
        }
        return this.checkUnknown(clazz, id, null);
    }

    private boolean fix(Entity entity) {
        Department department;
        if (entity.getObject() instanceof SolverParameterDef) {
            List list;
            SolverParameterDef def = (SolverParameterDef)entity.getObject();
            TableData.Element element = entity.getElement("group");
            SolverParameterGroup group = (SolverParameterGroup)this.get(SolverParameterGroup.class, element.getValue(0));
            if (group != null && group.getUniqueId() != null && !(list = this.iHibSession.createQuery("from SolverParameterDef where name = :name and group.uniqueId = :groupId", SolverParameterDef.class).setParameter("name", (Object)def.getName()).setParameter("groupId", (Object)group.getUniqueId()).list()).isEmpty()) {
                if (list.size() > 1) {
                    this.message("Multiple results for SolverParameterDef (name=" + def.getName() + ", group=" + group.getName() + ")", "");
                }
                entity.setObject(list.get(0));
                return false;
            }
        }
        if (entity.getObject() instanceof ManagerRole) {
            ManagerRole object;
            Roles role = (Roles)this.get(Roles.class, entity.getElement("role").getValue(0));
            TimetableManager manager = (TimetableManager)this.get(TimetableManager.class, entity.getElement("timetableManager").getValue(0));
            if (role.getRoleId() != null && manager.getUniqueId() != null && (object = (ManagerRole)this.iHibSession.createQuery("from ManagerRole where role.roleId = :roleId and timetableManager.uniqueId = :managerId", ManagerRole.class).setParameter("roleId", (Object)role.getUniqueId()).setParameter("managerId", (Object)manager.getUniqueId()).uniqueResult()) != null) {
                entity.setObject(object);
                return false;
            }
        }
        if (entity.getObject() instanceof Department && (department = (Department)entity.getObject()).isInheritInstructorPreferences() == null) {
            department.setInheritInstructorPreferences(department.isExternalManager() == false);
        }
        if (entity.getObject() instanceof ItypeDesc) {
            ItypeDesc itype = (ItypeDesc)entity.getObject();
            itype.setItype(Integer.valueOf(entity.getId()));
        }
        if (entity.getObject() instanceof DistributionType) {
            int maxReqId = ((Number)this.iHibSession.createQuery("select max(requirementId) from DistributionType", Number.class).uniqueResult()).intValue();
            int distReqId = 0;
            for (Entity e : this.iEntities.get(DistributionType.class.getName()).values()) {
                if (e.getId().compareTo(entity.getId()) > 0 || ((DistributionType)e.getObject()).getUniqueId() != null) continue;
                ++distReqId;
            }
            ((DistributionType)entity.getObject()).setRequirementId(maxReqId + distReqId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(InputStream input, BackupProgress progress) throws IOException, InstantiationException, IllegalAccessException, DocumentException, InvocationTargetException, NoSuchMethodException {
        this.iIn = input;
        this.iProgress = progress;
        this.iHibSession = new _RootDAO().createNewSession();
        this.iHibSession.setCacheMode(CacheMode.IGNORE);
        this.iMetamodel = this.iHibSession.getMetamodel();
        try {
            CodedInputStream cin = CodedInputStream.newInstance((InputStream)this.iIn);
            cin.setSizeLimit(0x40000000);
            this.iProgress.setPhase("Loading data", 1.0);
            TableData.Table t = null;
            while ((t = SessionRestore.readTable(cin)) != null) {
                if (this.iDebug != null) {
                    this.iDebug.println("## " + t.getName() + " ##");
                    this.iDebug.print(t.toString());
                    this.iDebug.flush();
                }
                this.create(t);
            }
            this.iProgress.incProgress();
            this.iHibSession.setHibernateFlushMode(FlushMode.MANUAL);
            this.iProgress.setPhase("Fixing", this.iAllEntitites.size());
            Iterator<Entity> i = this.iAllEntitites.iterator();
            while (i.hasNext()) {
                this.iProgress.incProgress();
                if (this.fix(i.next())) continue;
                i.remove();
            }
            this.iProgress.setPhase("Saving (not-null)", this.iAllEntitites.size());
            ArrayList<Entity> save = new ArrayList<Entity>(this.iAllEntitites);
            ArrayList<Object> otherObjectsToSave = new ArrayList<Object>();
            boolean saved = true;
            while (!save.isEmpty() && saved) {
                saved = false;
                Iterator i2 = save.iterator();
                while (i2.hasNext()) {
                    Entity entity = (Entity)i2.next();
                    if (entity.canSave() != null) continue;
                    this.iProgress.incProgress();
                    entity.fixRelationsNullOnly(otherObjectsToSave);
                    this.iHibSession.persist(entity.getObject());
                    i2.remove();
                    saved = true;
                }
                this.iHibSession.flush();
            }
            for (Object e : otherObjectsToSave) {
                this.iHibSession.persist(e);
            }
            otherObjectsToSave.clear();
            this.iHibSession.flush();
            this.iProgress.setPhase("Saving (all)", this.iAllEntitites.size());
            for (Entity entity : this.iAllEntitites) {
                this.iProgress.incProgress();
                String property = entity.canSave();
                if (property == null) {
                    entity.fixRelations(otherObjectsToSave);
                    this.iHibSession.merge(entity.getObject());
                    continue;
                }
                this.message("Skipping " + entity.getAbbv() + " (missing not-null relation " + property + ")", entity.getId());
            }
            for (Object object : otherObjectsToSave) {
                this.iHibSession.persist(object);
            }
            otherObjectsToSave.clear();
            this.iProgress.setPhase("Flush", 1.0);
            this.iHibSession.flush();
            this.iProgress.incProgress();
            this.printMessages();
            this.iProgress.setStatus("All done.");
        }
        finally {
            this.iHibSession.close();
        }
    }

    public static TableData.Table readTable(CodedInputStream cin) throws IOException {
        if (cin.isAtEnd()) {
            return null;
        }
        int size = cin.readInt32();
        int limit = cin.pushLimit(size);
        TableData.Table ret = TableData.Table.parseFrom(cin);
        cin.popLimit(limit);
        cin.resetSizeCounter();
        return ret;
    }

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            InputStream in = null;
            in = args[0].endsWith(".dat.gz") ? new GZIPInputStream(new FileInputStream(args[0])) : new FileInputStream(args[0]);
            sLog.info((Object)("Using " + ApplicationProperty.SessionRestoreInterface.value()));
            SessionRestore restore = (SessionRestore)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            PrintWriter debug = null;
            if (args.length >= 2) {
                debug = new PrintWriter(args[1]);
                restore.debug(debug);
            }
            final Progress progress = Progress.getInstance();
            progress.addProgressListener((ProgressListener)new ProgressWriter(System.out));
            restore.restore(in, new BackupProgress(){

                @Override
                public void setStatus(String status) {
                    progress.setStatus(status);
                }

                @Override
                public void setPhase(String phase, double max) {
                    progress.setPhase(phase, Math.round(max));
                }

                @Override
                public void incProgress() {
                    progress.incProgress();
                }

                @Override
                public void info(String message) {
                    progress.info(message);
                }

                @Override
                public void warn(String message) {
                    progress.warn(message);
                }

                @Override
                public void error(String message) {
                    progress.error(message);
                }
            });
            in.close();
            if (debug != null) {
                debug.close();
            }
            HibernateUtil.closeHibernate();
        }
        catch (Exception e) {
            sLog.fatal((Object)("Backup failed: " + e.getMessage()), (Throwable)e);
        }
    }

    protected class Entity {
        private EntityType iMeta;
        private TableData.Record iRecord;
        private Object iObject;
        private String iId;

        protected Entity(EntityType meta, TableData.Record record, Object object, String id) {
            this.iMeta = meta;
            this.iRecord = record;
            this.iObject = object;
            this.iId = id;
        }

        public EntityType getMeta() {
            return this.iMeta;
        }

        public String getName() {
            return this.getMeta().getJavaType().getName();
        }

        public String getAbbv() {
            return this.getMeta().getName();
        }

        public Object getObject() {
            return this.iObject;
        }

        public void setObject(Object object) {
            this.iObject = object;
        }

        public String getId() {
            return this.iId;
        }

        public TableData.Record getRecord() {
            return this.iRecord;
        }

        public TableData.Element getElement(String property) {
            for (TableData.Element e : this.getRecord().getElementList()) {
                if (!e.getName().equals(property)) continue;
                return e;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Entity)) {
                return false;
            }
            Entity e = (Entity)o;
            return this.getName().equals(e.getName()) && this.getId().equals(e.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return this.getAbbv() + "@" + this.getId();
        }

        public String canSave() {
            for (SingularAttribute attribute : this.getMeta().getSingularAttributes()) {
                Object value;
                TableData.Element element;
                if (SessionRestore.this.isNullable((Attribute)attribute) && !attribute.isId() || !SessionRestore.this.isEntity((Attribute)attribute) || (element = this.getElement(attribute.getName())) == null || element.getValueCount() == 0 || (value = SessionRestore.this.get(attribute.getJavaType(), element.getValue(0))) != null && SessionRestore.this.iHibSession.contains(value)) continue;
                return attribute.getName();
            }
            return null;
        }

        public void fixRelationsNullOnly(List<Object> otherObjectsToSave) {
            TableData.Element element;
            this.fixRelationsNullOnly();
            if (this.getObject() instanceof InstructionalOffering && (element = this.getElement("coordinators")) != null) {
                InstructionalOffering io = (InstructionalOffering)this.getObject();
                for (int i = 0; i < element.getValueCount(); ++i) {
                    DepartmentalInstructor instructor = (DepartmentalInstructor)SessionRestore.this.get(DepartmentalInstructor.class, element.getValue(i));
                    if (instructor == null) continue;
                    OfferingCoordinator oc = new OfferingCoordinator();
                    oc.setInstructor(instructor);
                    oc.setOffering(io);
                    oc.setPercentShare(0);
                    io.addToOfferingCoordinators(oc);
                    otherObjectsToSave.add(oc);
                }
            }
        }

        public void fixRelationsNullOnly() {
            RoomFeatureType rft;
            TableData.Element element;
            Department dept;
            ExamType type;
            Curriculum curriculum;
            Class_ clazz;
            for (SingularAttribute attribute : this.getMeta().getSingularAttributes()) {
                TableData.Element element2;
                if (SessionRestore.this.isNullable((Attribute)attribute) && !attribute.isId() || !SessionRestore.this.isEntity((Attribute)attribute) || (element2 = this.getElement(attribute.getName())) == null) continue;
                if (element2.getValueCount() == 0) {
                    SessionRestore.this.message("Required " + this.getAbbv() + "." + attribute.getName() + " has no value", this.getRecord().getId());
                    continue;
                }
                Object value = SessionRestore.this.get(attribute.getJavaType(), element2.getValue(0));
                if (value == null) continue;
                if (!SessionRestore.this.iHibSession.contains(value)) {
                    SessionRestore.this.message("Required " + this.getAbbv() + "." + attribute.getName() + " has transient value", this.getId() + "-" + element2.getValue(0));
                    continue;
                }
                SessionRestore.this.setAttribute(this.getObject(), (Attribute)attribute, value);
            }
            if (this.getObject() instanceof Class_ && (clazz = (Class_)this.getObject()).getCancelled() == null) {
                clazz.setCancelled(false);
            }
            if (this.getObject() instanceof Curriculum && (curriculum = (Curriculum)this.getObject()).isMultipleMajors() == null) {
                curriculum.setMultipleMajors(false);
            }
            if (this.getObject() instanceof ExamType && (type = (ExamType)this.getObject()).getHighlightInEvents() == null) {
                type.setHighlightInEvents(type.getType() == 0);
            }
            if (this.getObject() instanceof SolverInfo) {
                SolverInfo info = (SolverInfo)this.getObject();
                TableData.Element element3 = this.getElement("data");
                if (element3 != null) {
                    info.setData(element3.getValueBytes(0).toByteArray());
                } else {
                    element3 = this.getElement("value");
                    try {
                        Document value = new SAXReader().read((Reader)new StringReader(element3.getValue(0)));
                        info.setValue(value);
                    }
                    catch (DocumentException e) {
                        sLog.warn((Object)("Failed to parse solver info for " + this.getId() + ": " + e.getMessage()));
                    }
                }
            }
            if (this.getObject() instanceof Department && (dept = (Department)this.getObject()).isAllowStudentScheduling() == null) {
                dept.setAllowStudentScheduling(true);
            }
            if (this.getObject() instanceof StudentAreaClassificationMajor && (element = this.getElement("concentration")) != null) {
                StudentAreaClassificationMajor acm = (StudentAreaClassificationMajor)this.getObject();
                PosMajorConcentration conc = (PosMajorConcentration)SessionRestore.this.get(PosMajorConcentration.class, element.getValue(0));
                if (conc != null) {
                    if (!SessionRestore.this.iHibSession.contains((Object)conc)) {
                        SessionRestore.this.message("Required " + this.getAbbv() + ".concentration has transient value", this.getId() + "-" + element.getValue(0));
                    } else {
                        acm.setConcentration(conc);
                    }
                }
            }
            if (this.getObject() instanceof RoomFeatureType && (rft = (RoomFeatureType)this.getObject()).isShowInInstructorSurvey() == null) {
                rft.setShowInInstructorSurvey(true);
            }
        }

        public void fixRelations(List<Object> otherObjectsToSave) {
            this.fixRelations();
            if (this.getObject() instanceof Student) {
                Comparable<StudentAreaClassificationMajor> acm;
                AcademicClassification clasf;
                AcademicArea area;
                String clasfId;
                String areaId;
                Entity aac;
                ProtocolStringList areaIds;
                Student student;
                TableData.Element ac = this.getElement("academicAreaClassifications");
                TableData.Element mj = this.getElement("posMajors");
                TableData.Element mn = this.getElement("posMinors");
                if (ac != null && mj != null) {
                    student = (Student)this.getObject();
                    for (String majorId : mj.getValueList()) {
                        Entity majorEntity = SessionRestore.this.getEntity(PosMajor.class, majorId);
                        if (majorEntity == null) continue;
                        areaIds = majorEntity.getElement("academicAreas").getValueList();
                        PosMajor major = (PosMajor)majorEntity.getObject();
                        for (String aacId : ac.getValueList()) {
                            aac = SessionRestore.this.lookupSkippedRecord("org.unitime.timetable.model.AcademicAreaClassification", aacId);
                            if (aac == null) continue;
                            areaId = aac.getElement("academicArea").getValue(0);
                            clasfId = aac.getElement("academicClassification").getValue(0);
                            if (!areaIds.contains(areaId)) continue;
                            area = (AcademicArea)SessionRestore.this.get(AcademicArea.class, areaId);
                            clasf = (AcademicClassification)SessionRestore.this.get(AcademicClassification.class, clasfId);
                            if (area == null || clasf == null) continue;
                            acm = new StudentAreaClassificationMajor();
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicArea(area);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setStudent(student);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicClassification(clasf);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setMajor(major);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setWeight(1.0);
                            student.addToAreaClasfMajors((StudentAreaClassificationMajor)acm);
                            otherObjectsToSave.add(acm);
                        }
                    }
                }
                if (ac != null && mn != null) {
                    student = (Student)this.getObject();
                    for (String minorId : mn.getValueList()) {
                        Entity minorEntity = SessionRestore.this.getEntity(PosMinor.class, minorId);
                        if (minorEntity == null) continue;
                        areaIds = minorEntity.getElement("academicAreas").getValueList();
                        PosMinor minor = (PosMinor)minorEntity.getObject();
                        for (String aacId : ac.getValueList()) {
                            aac = SessionRestore.this.lookupSkippedRecord("org.unitime.timetable.model.AcademicAreaClassification", aacId);
                            if (aac == null) continue;
                            areaId = aac.getElement("academicArea").getValue(0);
                            clasfId = aac.getElement("academicClassification").getValue(0);
                            if (!areaIds.contains(areaId)) continue;
                            area = (AcademicArea)SessionRestore.this.get(AcademicArea.class, areaId);
                            clasf = (AcademicClassification)SessionRestore.this.get(AcademicClassification.class, clasfId);
                            if (area == null || clasf == null) continue;
                            acm = new StudentAreaClassificationMinor();
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicArea(area);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setStudent(student);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicClassification(clasf);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setMinor(minor);
                            student.addToAreaClasfMinors((StudentAreaClassificationMinor)acm);
                            otherObjectsToSave.add(acm);
                        }
                    }
                }
            }
        }

        public void fixRelations() {
            TableData.Element a;
            StudentAreaClassificationMajor m;
            Location loc;
            Comparable<ExamOwner> owner;
            for (Attribute attribute : this.getMeta().getAttributes()) {
                Object v;
                AbstractCollection set;
                TableData.Element element;
                if (!SessionRestore.this.isNullable(attribute) && !attribute.isCollection()) continue;
                if (SessionRestore.this.isEntity(attribute)) {
                    Object object;
                    element = this.getElement(attribute.getName());
                    if (element == null || element.getValueCount() == 0 || (object = SessionRestore.this.get(attribute.getJavaType(), element.getValue(0))) == null) continue;
                    if (!SessionRestore.this.iHibSession.contains(object)) {
                        SessionRestore.this.message("Optional " + this.getAbbv() + "." + attribute.getName() + " has transient value", this.getId() + "-" + element.getValue(0));
                        continue;
                    }
                    SessionRestore.this.setAttribute(this.getObject(), attribute, object);
                    continue;
                }
                if (!attribute.isCollection() || (element = this.getElement(attribute.getName())) == null) continue;
                Class clazz = ((PluralAttribute)attribute).getElementType().getJavaType();
                boolean isEnity = false;
                try {
                    isEnity = SessionRestore.this.iMetamodel.entity(clazz) != null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (Set.class.isAssignableFrom(attribute.getJavaType())) {
                    set = new HashSet();
                    for (String id : element.getValueList()) {
                        v = SessionRestore.this.get(clazz, id);
                        if (v == null) continue;
                        if (isEnity && !SessionRestore.this.iHibSession.contains(v)) {
                            SessionRestore.this.message("Collection " + this.getAbbv() + "." + attribute.getName() + " has transient value", this.getId() + "-" + id);
                            continue;
                        }
                        set.add(v);
                    }
                    SessionRestore.this.setAttribute(this.getObject(), attribute, set);
                    continue;
                }
                if (List.class.isAssignableFrom(attribute.getJavaType())) {
                    set = new ArrayList();
                    for (String id : element.getValueList()) {
                        v = SessionRestore.this.get(clazz, id);
                        if (v == null) continue;
                        if (isEnity && !SessionRestore.this.iHibSession.contains(v)) {
                            SessionRestore.this.message("Collection " + this.getAbbv() + "." + attribute.getName() + " has transient value", this.getId() + "-" + id);
                            continue;
                        }
                        set.add(v);
                    }
                    SessionRestore.this.setAttribute(this.getObject(), attribute, set);
                    continue;
                }
                SessionRestore.this.message("Unimplemented collection type: " + attribute.getJavaType().getSimpleName() + " (" + this.getAbbv() + "." + attribute.getName() + ")", "");
            }
            if (this.getObject() instanceof ExamOwner) {
                owner = (ExamOwner)this.getObject();
                switch (((BaseExamOwner)((Object)owner)).getOwnerType()) {
                    case 3: {
                        ((BaseExamOwner)((Object)owner)).setOwnerId(((Class_)SessionRestore.this.get(Class_.class, ((BaseExamOwner)((Object)owner)).getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 2: {
                        ((BaseExamOwner)((Object)owner)).setOwnerId(((InstrOfferingConfig)SessionRestore.this.get(InstrOfferingConfig.class, ((BaseExamOwner)((Object)owner)).getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 1: {
                        ((BaseExamOwner)((Object)owner)).setOwnerId(((CourseOffering)SessionRestore.this.get(CourseOffering.class, ((BaseExamOwner)((Object)owner)).getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 0: {
                        ((BaseExamOwner)((Object)owner)).setOwnerId(((InstructionalOffering)SessionRestore.this.get(InstructionalOffering.class, ((BaseExamOwner)((Object)owner)).getOwnerId().toString())).getUniqueId());
                    }
                }
            }
            if (this.getObject() instanceof RelatedCourseInfo) {
                owner = (RelatedCourseInfo)this.getObject();
                switch (((BaseRelatedCourseInfo)((Object)owner)).getOwnerType()) {
                    case 3: {
                        ((BaseRelatedCourseInfo)((Object)owner)).setOwnerId(((Class_)SessionRestore.this.get(Class_.class, ((BaseRelatedCourseInfo)((Object)owner)).getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 2: {
                        ((BaseRelatedCourseInfo)((Object)owner)).setOwnerId(((InstrOfferingConfig)SessionRestore.this.get(InstrOfferingConfig.class, ((BaseRelatedCourseInfo)((Object)owner)).getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 1: {
                        ((BaseRelatedCourseInfo)((Object)owner)).setOwnerId(((CourseOffering)SessionRestore.this.get(CourseOffering.class, ((BaseRelatedCourseInfo)((Object)owner)).getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 0: {
                        ((BaseRelatedCourseInfo)((Object)owner)).setOwnerId(((InstructionalOffering)SessionRestore.this.get(InstructionalOffering.class, ((BaseRelatedCourseInfo)((Object)owner)).getOwnerId().toString())).getUniqueId());
                    }
                }
            }
            if (this.getObject() instanceof TravelTime) {
                Location l2;
                TravelTime tt = (TravelTime)this.getObject();
                Location l1 = (Location)SessionRestore.this.get(Location.class, tt.getLocation1Id().toString());
                if (l1 != null) {
                    tt.setLocation1Id(l1.getUniqueId());
                }
                if ((l2 = (Location)SessionRestore.this.get(Location.class, tt.getLocation2Id().toString())) != null) {
                    tt.setLocation2Id(l2.getUniqueId());
                }
            }
            if (this.getObject() instanceof Location && (loc = (Location)this.getObject()).getManagerIds() != null) {
                Object managerIds = null;
                Iterator<OnlineSectioningLog.Section.Builder> stk = new StringTokenizer(loc.getManagerIds(), ",");
                while (((StringTokenizer)((Object)stk)).hasMoreTokens()) {
                    Department department = (Department)SessionRestore.this.get(Department.class, ((StringTokenizer)((Object)stk)).nextToken());
                    if (department == null) continue;
                    if (managerIds == null) {
                        managerIds = department.getUniqueId().toString();
                        continue;
                    }
                    managerIds = (String)managerIds + "," + department.getUniqueId();
                }
                loc.setManagerIds((String)managerIds);
            }
            if (this.getObject() instanceof CourseRequestOption) {
                CourseRequestOption o = (CourseRequestOption)this.getObject();
                try {
                    OnlineSectioningLog.CourseRequestOption.Builder option = OnlineSectioningLog.CourseRequestOption.parseFrom(o.getValue()).toBuilder();
                    if (option.getInstructionalMethodCount() > 0) {
                        for (OnlineSectioningLog.Entity.Builder builder : option.getInstructionalMethodBuilderList()) {
                            InstructionalMethod im = InstructionalMethod.findByReference(builder.getExternalId(), SessionRestore.this.iHibSession);
                            if (im == null) continue;
                            builder.setUniqueId(im.getUniqueId());
                        }
                    }
                    if (option.getSectionCount() > 0) {
                        for (OnlineSectioningLog.Section.Builder builder : option.getSectionBuilderList()) {
                            CourseOffering course;
                            Class_ clazz = (Class_)SessionRestore.this.get(Class_.class, String.valueOf(builder.getClazzBuilder().getUniqueId()));
                            if (clazz != null) {
                                builder.getClazzBuilder().setUniqueId(clazz.getUniqueId());
                                builder.getSubpartBuilder().setUniqueId(clazz.getSchedulingSubpart().getUniqueId());
                            }
                            if (builder.hasCourse() && (course = (CourseOffering)SessionRestore.this.get(CourseOffering.class, String.valueOf(builder.getCourseBuilder().getUniqueId()))) != null) {
                                builder.getCourseBuilder().setUniqueId(course.getUniqueId());
                            }
                            if (builder.getInstructorCount() > 0) {
                                for (OnlineSectioningLog.Entity.Builder f : builder.getInstructorBuilderList()) {
                                    DepartmentalInstructor instructor = (DepartmentalInstructor)SessionRestore.this.get(DepartmentalInstructor.class, String.valueOf(f.getUniqueId()));
                                    if (instructor == null) continue;
                                    f.setUniqueId(instructor.getUniqueId());
                                }
                            }
                            if (builder.getLocationCount() <= 0) continue;
                            for (OnlineSectioningLog.Entity.Builder f : builder.getLocationBuilderList()) {
                                Location location = (Location)SessionRestore.this.get(Location.class, String.valueOf(f.getUniqueId()));
                                if (location == null) continue;
                                f.setUniqueId(location.getUniqueId());
                            }
                        }
                    }
                    o.setValue(option.build().toByteArray());
                }
                catch (InvalidProtocolBufferException option) {
                    // empty catch block
                }
            }
            if (this.getObject() instanceof StudentAreaClassificationMajor && (m = (StudentAreaClassificationMajor)this.getObject()).getWeight() == null) {
                m.setWeight(1.0);
            }
            if (this.getObject() instanceof CurriculumReservation && (a = this.getElement("area")) != null) {
                AcademicArea area = (AcademicArea)SessionRestore.this.get(AcademicArea.class, a.getValue(0));
                CurriculumReservation cr = (CurriculumReservation)this.getObject();
                cr.addToAreas(area);
            }
        }
    }
}

