/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionSupport;
import org.apache.struts2.action.ServletRequestAware;
import org.apache.struts2.action.ServletResponseAware;
import org.springframework.context.ApplicationContext;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.ExaminationSolverService;
import org.unitime.timetable.solver.service.InstructorSchedulingSolverService;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.service.StudentSectioningSolverService;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public abstract class UniTimeAction<T extends UniTimeForm>
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private static final long serialVersionUID = 3596810266703379946L;
    protected SessionContext sessionContext;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected T form;
    protected String op;
    private static RegExp sAcessKeyRegExp = RegExp.compile((String)"<u>(\\w)</u>", (String)"i");
    private static RegExp sStripAcessKeyRegExp = RegExp.compile((String)"(.*)<u>(\\w)</u>(.*)", (String)"i");

    public T getForm() {
        return this.form;
    }

    public void setForm(T form) {
        this.form = form;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void withServletRequest(HttpServletRequest request) {
        this.request = request;
        this.sessionContext = new HttpSessionContext(request.getSession());
    }

    public void withServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected SolverServerService getSolverServerService() {
        return (SolverServerService)SpringApplicationContextHolder.getBean("solverServerService");
    }

    protected ExaminationSolverService getExaminationSolverService() {
        return (ExaminationSolverService)SpringApplicationContextHolder.getBean("examinationSolverService");
    }

    protected StudentSectioningSolverService getStudentSectioningSolverService() {
        return (StudentSectioningSolverService)SpringApplicationContextHolder.getBean("studentSectioningSolverService");
    }

    protected InstructorSchedulingSolverService getInstructorSchedulingSolverService() {
        return (InstructorSchedulingSolverService)SpringApplicationContextHolder.getBean("instructorSchedulingSolverService");
    }

    protected AssignmentService<ClassAssignmentProxy> getClassAssignmentService() {
        return (AssignmentService)SpringApplicationContextHolder.getBean("classAssignmentService");
    }

    protected SolverService<SolverProxy> getCourseTimetablingSolverService() {
        return (SolverService)SpringApplicationContextHolder.getBean("courseTimetablingSolverService");
    }

    protected ApplicationContext getApplicationContext() {
        return SpringApplicationContextHolder.getContext();
    }

    protected PageContext getPageContext() {
        return (PageContext)ActionContext.getContext().get("org.apache.struts2.dispatcher.PageContext");
    }

    protected <X> Permission<X> getPermission(String name) {
        return (Permission)SpringApplicationContextHolder.getBean(name);
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public static String guessAccessKey(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        MatchResult result = sAcessKeyRegExp.exec(name);
        return result == null ? "" : result.getGroup(1).toLowerCase();
    }

    public static String stripAccessKey(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        MatchResult result = sStripAcessKeyRegExp.exec(name);
        return ((String)(result == null ? name : result.getGroup(1) + result.getGroup(2) + result.getGroup(3))).replace("&nbsp;", " ");
    }
}

