/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.util;

import jakarta.persistence.Entity;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.apache.commons.lang3.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.community.dialect.OracleLegacyDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.unitime.commons.LocalContext;
import org.unitime.commons.hibernate.connection.LoggingConnectionProvider;
import org.unitime.commons.hibernate.id.UniqueIdGenerator;
import org.unitime.commons.hibernate.util.DatabaseUpdate;
import org.unitime.commons.hibernate.util.HibernateContext;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.dao._RootDAO;

public class HibernateUtil {
    private static Log sLog = LogFactory.getLog(HibernateUtil.class);
    protected static HibernateContext sContext;
    protected static ThreadLocal<Session> sSessions;
    private static String sConnectionUrl;

    public static void configureHibernate(String connectionUrl) throws Exception {
        Properties properties = ApplicationProperties.getProperties();
        properties.setProperty("connection.url", connectionUrl);
        HibernateUtil.configureHibernate(properties);
    }

    public static String getProperty(Properties properties, String name) {
        String value = properties.getProperty(name);
        if (value != null) {
            sLog.debug((Object)("  -- " + name + "=" + value));
            return value;
        }
        sLog.debug((Object)("    -- using application properties for " + name));
        value = ApplicationProperties.getProperty(name);
        sLog.debug((Object)("  -- " + name + "=" + value));
        return value;
    }

    public static void fixSchemaInFormulas(Metadata meta, String schema, Class dialect) throws ClassNotFoundException {
        for (PersistentClass pc : meta.getEntityBindings()) {
            for (Property p : pc.getProperties()) {
                for (Selectable c : p.getSelectables()) {
                    if (!(c instanceof Formula)) continue;
                    Formula f = (Formula)c;
                    boolean updated = false;
                    if (schema != null && f.getFormula() != null && f.getFormula().indexOf("%SCHEMA%") >= 0) {
                        f.setFormula(f.getFormula().replaceAll("%SCHEMA%", schema));
                        sLog.debug((Object)("Schema updated in " + pc.getClassName() + "." + p.getName() + " to " + f.getFormula()));
                    }
                    if (f.getFormula() != null && (f.getFormula().indexOf("%TRUE%") >= 0 || f.getFormula().indexOf("%FALSE%") >= 0)) {
                        if (HibernateUtil.isPostgress(dialect)) {
                            f.setFormula(f.getFormula().replaceAll("%TRUE%", "'t'").replaceAll("%FALSE%", "'f'"));
                        } else {
                            f.setFormula(f.getFormula().replaceAll("%TRUE%", "1").replaceAll("%FALSE%", "0"));
                        }
                    }
                    if (!updated) continue;
                    sLog.debug((Object)("Schema updated in " + pc.getClassName() + "." + p.getName() + " to " + f.getFormula()));
                }
            }
        }
    }

    public static HibernateContext configureHibernateFromProperties(Properties properties) throws ClassNotFoundException {
        ServiceBinding scp;
        ConnectionProvider cp;
        String idgen;
        if (properties == null) {
            properties = ApplicationProperties.getProperties();
        }
        sLog.info((Object)("Connecting to " + HibernateUtil.getProperty(properties, "connection.url")));
        ClassLoader classLoader = HibernateUtil.class.getClassLoader();
        sLog.debug((Object)"  -- class loader retrieved");
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        LoadedConfig config = registryBuilder.getConfigLoader().loadConfigXmlUrl(classLoader.getResource("hibernate.cfg.xml"));
        String dialect = ApplicationProperty.DatabaseDialect.value();
        if ("org.hibernate.dialect.MySQLInnoDBDialect".equals(dialect)) {
            dialect = MySQLDialect.class.getName();
        } else if ("org.hibernate.dialect.Oracle10gDialect".equals(dialect)) {
            dialect = OracleDialect.class.getName();
        }
        if (dialect != null) {
            sLog.debug((Object)("  -- dialect: " + dialect));
            config.getConfigurationValues().put("hibernate.dialect", dialect);
        }
        if ((idgen = HibernateUtil.getProperty(properties, "tmtbl.uniqueid.generator")) != null) {
            config.getConfigurationValues().put("tmtbl.uniqueid.generator", idgen);
        }
        config.getConfigurationValues().put("hibernate.cache.use_second_level_cache", "false");
        config.getConfigurationValues().put("hibernate.cache.use_query_cache", "false");
        config.getConfigurationValues().remove("hibernate.cache.region.factory_class");
        config.getConfigurationValues().remove("hibernate.cache.infinispan.cfg");
        config.getConfigurationValues().put("cache.use_second_level_cache", "false");
        config.getConfigurationValues().put("cache.use_query_cache", "false");
        config.getConfigurationValues().remove("cache.region.factory_class");
        config.getConfigurationValues().remove("cache.infinispan.cfg");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (name.startsWith("hibernate.") || name.startsWith("tmtbl.hibernate.")) {
                value = ApplicationProperties.getProperty(name);
                if ("NULL".equals(value)) {
                    config.getConfigurationValues().remove(name);
                } else {
                    config.getConfigurationValues().put(name, value);
                }
                if (!name.equals("connection.password")) {
                    sLog.debug((Object)("  -- set " + name + ": " + (String)value));
                } else {
                    sLog.debug((Object)("  -- set " + name + ": *****"));
                }
            }
            if (!name.startsWith("connection.")) continue;
            value = ApplicationProperties.getProperty(name);
            if ("NULL".equals(value)) {
                config.getConfigurationValues().remove(name);
                config.getConfigurationValues().remove("hibernate." + name);
            } else {
                config.getConfigurationValues().put(name, value);
                config.getConfigurationValues().put("hibernate." + name, value);
            }
            if (!name.equals("connection.password")) {
                sLog.debug((Object)("  -- set " + name + ": " + (String)value));
                continue;
            }
            sLog.debug((Object)("  -- set " + name + ": *****"));
        }
        String default_schema = HibernateUtil.getProperty(properties, "hibernate.default_schema");
        if (default_schema == null) {
            default_schema = HibernateUtil.getProperty(properties, "default_schema");
        }
        if (default_schema != null) {
            sLog.debug((Object)("  -- default_schema: " + default_schema));
            config.getConfigurationValues().put("hibernate.default_schema", default_schema);
        } else {
            default_schema = "timetable";
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        for (MappingReference mr : new ArrayList(config.getMappingReferences())) {
            if (mr.getType() != MappingReference.Type.PACKAGE) continue;
            for (BeanDefinition bd : scanner.findCandidateComponents(mr.getReference())) {
                config.getMappingReferences().add(new MappingReference(MappingReference.Type.CLASS, bd.getBeanClassName()));
            }
        }
        UniqueIdGenerator.configure(config);
        registryBuilder.configure(config);
        StandardServiceRegistry registry = registryBuilder.build();
        if (ApplicationProperty.ConnectionLogging.isTrue() && (cp = (ConnectionProvider)registry.getService(ConnectionProvider.class)) != null && (scp = ((StandardServiceRegistryImpl)registry).locateServiceBinding(ConnectionProvider.class)) != null) {
            scp.setService((Service)new LoggingConnectionProvider((ConnectionProvider)registry.getService(ConnectionProvider.class)));
        }
        MetadataBuilder metaBuild = new MetadataSources((ServiceRegistry)registry).getMetadataBuilder();
        Class<?> d = Class.forName((String)config.getConfigurationValues().get("hibernate.dialect"));
        HibernateUtil.addOperations(metaBuild, d);
        Metadata meta = metaBuild.build();
        HibernateUtil.fixSchemaInFormulas(meta, default_schema, d);
        return new HibernateContext(config, (ServiceRegistry)registry, meta, meta.buildSessionFactory());
    }

    public static void configureHibernate(Properties properties) throws NamingException, ClassNotFoundException {
        if (sContext != null) {
            sContext.close();
            sContext = null;
        }
        if (!NamingManager.hasInitialContextFactoryBuilder()) {
            NamingManager.setInitialContextFactoryBuilder(new LocalContext(null));
        }
        sContext = HibernateUtil.configureHibernateFromProperties(properties);
        DatabaseUpdate.update();
    }

    public static void closeHibernate() {
        if (sContext != null) {
            sContext.close();
            sContext = null;
        }
    }

    public static HibernateContext configureHibernateFromRootDAO() throws ClassNotFoundException {
        ServiceBinding scp;
        ConnectionProvider cp;
        String idgen;
        sLog.info((Object)("Connecting to " + ApplicationProperty.ConnectionUrl.value()));
        ClassLoader classLoader = HibernateUtil.class.getClassLoader();
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        LoadedConfig config = registryBuilder.getConfigLoader().loadConfigXmlUrl(classLoader.getResource("hibernate.cfg.xml"));
        String dialect = ApplicationProperty.DatabaseDialect.value();
        if ("org.hibernate.dialect.MySQLInnoDBDialect".equals(dialect)) {
            dialect = MySQLDialect.class.getName();
        } else if ("org.hibernate.dialect.Oracle10gDialect".equals(dialect)) {
            dialect = OracleDialect.class.getName();
        }
        if (dialect != null) {
            sLog.debug((Object)("  -- dialect: " + dialect));
            config.getConfigurationValues().put("hibernate.dialect", dialect);
        }
        if ((idgen = ApplicationProperty.DatabaseUniqueIdGenerator.value()) != null) {
            config.getConfigurationValues().put("tmtbl.uniqueid.generator", idgen);
        }
        if (ApplicationProperty.HibernateCacheConfiguration.value() != null) {
            config.getConfigurationValues().put("hibernate.cache.infinispan.cfg", ApplicationProperty.HibernateCacheConfiguration.value());
        } else if (ApplicationProperty.HibernateClusterEnabled.isTrue()) {
            config.getConfigurationValues().put("hibernate.cache.infinispan.cfg", "infinispan-cluster.xml");
        } else if (ApplicationProperty.HibernateClusterEnabled.isFalse()) {
            config.getConfigurationValues().put("hibernate.cache.infinispan.cfg", "infinispan-local.xml");
        }
        config.getConfigurationValues().put("hibernate.cache.infinispan.jgroups_cfg", ApplicationProperty.HibernateClusterConfiguration.value());
        Enumeration<?> e = ApplicationProperties.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (name.startsWith("hibernate.") || name.startsWith("tmtbl.hibernate.")) {
                value = ApplicationProperties.getProperty(name);
                if ("NULL".equals(value)) {
                    config.getConfigurationValues().remove(name);
                } else {
                    config.getConfigurationValues().put(name, value);
                }
                if (!name.equals("connection.password")) {
                    sLog.debug((Object)("  -- set " + name + ": " + (String)value));
                } else {
                    sLog.debug((Object)("  -- set " + name + ": *****"));
                }
            }
            if (!name.startsWith("connection.")) continue;
            value = ApplicationProperties.getProperty(name);
            if ("NULL".equals(value)) {
                config.getConfigurationValues().remove(name);
                config.getConfigurationValues().remove("hibernate." + name);
            } else {
                config.getConfigurationValues().put(name, value);
                config.getConfigurationValues().put("hibernate." + name, value);
            }
            if (!name.equals("connection.password")) {
                sLog.debug((Object)("  -- set " + name + ": " + (String)value));
                continue;
            }
            sLog.debug((Object)("  -- set " + name + ": *****"));
        }
        String default_schema = ApplicationProperty.DatabaseSchema.value();
        if (default_schema != null) {
            sLog.debug((Object)("  -- default_schema: " + default_schema));
            config.getConfigurationValues().put("hibernate.default_schema", default_schema);
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        for (MappingReference mr : new ArrayList(config.getMappingReferences())) {
            if (mr.getType() != MappingReference.Type.PACKAGE) continue;
            for (BeanDefinition bd : scanner.findCandidateComponents(mr.getReference())) {
                config.getMappingReferences().add(new MappingReference(MappingReference.Type.CLASS, bd.getBeanClassName()));
            }
        }
        UniqueIdGenerator.configure(config);
        registryBuilder.configure(config);
        StandardServiceRegistry registry = registryBuilder.build();
        if (ApplicationProperty.ConnectionLogging.isTrue() && (cp = (ConnectionProvider)registry.getService(ConnectionProvider.class)) != null && (scp = ((StandardServiceRegistryImpl)registry).locateServiceBinding(ConnectionProvider.class)) != null) {
            scp.setService((Service)new LoggingConnectionProvider((ConnectionProvider)registry.getService(ConnectionProvider.class)));
        }
        MetadataBuilder metaBuild = new MetadataSources((ServiceRegistry)registry).getMetadataBuilder();
        Class<?> d = Class.forName((String)config.getConfigurationValues().get("hibernate.dialect"));
        HibernateUtil.addOperations(metaBuild, d);
        Metadata meta = metaBuild.build();
        HibernateUtil.fixSchemaInFormulas(meta, default_schema, d);
        return new HibernateContext(config, (ServiceRegistry)registry, meta, meta.buildSessionFactory());
    }

    public static String getConnectionUrl() {
        if (sConnectionUrl == null) {
            try {
                SessionImplementor session = (SessionImplementor)new _RootDAO().getSession();
                Connection connection = session.getJdbcConnectionAccess().obtainConnection();
                sConnectionUrl = connection.getMetaData().getURL();
                session.getJdbcConnectionAccess().releaseConnection(connection);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to get connection string, reason: " + e.getMessage()), (Throwable)e);
            }
        }
        return sConnectionUrl;
    }

    public static String getDatabaseName() {
        String schema = (String)HibernateUtil.getHibernateContext().getConfig().getConfigurationValues().get("hibernate.default_schema");
        String url = HibernateUtil.getConnectionUrl();
        if (url == null) {
            return "N/A";
        }
        if (url.startsWith("jdbc:oracle:")) {
            return schema + "@" + url.substring(1 + url.lastIndexOf(58));
        }
        return schema;
    }

    public static void clearCache() {
        HibernateUtil.clearCache(null, true);
    }

    public static void clearCache(Class persistentClass) {
        HibernateUtil.clearCache(persistentClass, false);
    }

    public static void clearCache(Class persistentClass, boolean evictQueries) {
        _RootDAO dao = new _RootDAO();
        Session hibSession = dao.getSession();
        SessionFactory hibSessionFactory = hibSession.getSessionFactory();
        if (persistentClass == null) {
            hibSessionFactory.getCache().evictEntityData();
            hibSessionFactory.getCache().evictCollectionData();
        } else {
            hibSessionFactory.getCache().evictEntityData(persistentClass);
            EntityType et = null;
            try {
                et = hibSession.getMetamodel().entity(persistentClass);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (et != null) {
                for (Attribute a : et.getAttributes()) {
                    if (!a.isCollection()) continue;
                    try {
                        hibSessionFactory.getCache().evictCollectionData(persistentClass.getClass().getName() + "." + a.getName());
                    }
                    catch (MappingException mappingException) {}
                }
            }
        }
        if (evictQueries) {
            hibSessionFactory.getCache().evictQueryRegions();
            hibSessionFactory.getCache().evictDefaultQueryRegion();
        }
    }

    public static Class<?> getDialect() {
        try {
            return Class.forName((String)HibernateUtil.getHibernateContext().getConfig().getConfigurationValues().get("hibernate.dialect"));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isMySQL() {
        return MySQLDialect.class.isAssignableFrom(HibernateUtil.getDialect());
    }

    public static boolean isOracle() {
        return OracleDialect.class.isAssignableFrom(HibernateUtil.getDialect()) || OracleLegacyDialect.class.isAssignableFrom(HibernateUtil.getDialect());
    }

    public static boolean isPostgress() {
        return PostgreSQLDialect.class.isAssignableFrom(HibernateUtil.getDialect());
    }

    public static boolean isPostgress(Class dialect) {
        return PostgreSQLDialect.class.isAssignableFrom(dialect);
    }

    public static String addDate(String dateSQL, String incrementSQL) {
        return "adddate(" + dateSQL + "," + incrementSQL + ")";
    }

    public static String dayOfWeek(String field) {
        return "weekday(" + field + ")";
    }

    public static String date(Date date) {
        if (HibernateUtil.isOracle() || HibernateUtil.isPostgress()) {
            return "to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "', 'YYYY-MM-DD')";
        }
        return "str_to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "', '%Y-%m-%d')";
    }

    public static void addOperations(MetadataBuilder builder, Class dialect) {
        if (PostgreSQLDialect.class.isAssignableFrom(dialect)) {
            builder.applySqlFunction("adddate", (SqmFunctionDescriptor)PostgreSQLAddDateFunction.INSTANCE);
            builder.applySqlFunction("days", (SqmFunctionDescriptor)PostgreSQLDaysFunction.INSTANCE);
            builder.applySqlFunction("weekday", (SqmFunctionDescriptor)PostgreSQLWeekdayFunction.INSTANCE);
        } else if (OracleDialect.class.isAssignableFrom(dialect) || OracleLegacyDialect.class.isAssignableFrom(dialect)) {
            builder.applySqlFunction("weekday", (SqmFunctionDescriptor)OracleWeekdayFunction.INSTANCE);
            builder.applySqlFunction("days", (SqmFunctionDescriptor)OracleDaysFunction.INSTANCE);
            builder.applySqlFunction("adddate", (SqmFunctionDescriptor)OracleAddDateFunction.INSTANCE);
        } else if (MySQLDialect.class.isAssignableFrom(dialect)) {
            builder.applySqlFunction("days", (SqmFunctionDescriptor)MySQLDaysFunction.INSTANCE);
            builder.applySqlFunction("weekday", (SqmFunctionDescriptor)MySQLWeekdayFunction.INSTANCE);
        }
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return Strings.CS.replace(str, "'", "''");
    }

    public static void initialize() throws ClassNotFoundException {
        if (sContext != null) {
            return;
        }
        sContext = HibernateUtil.configureHibernateFromRootDAO();
        DatabaseUpdate.update();
    }

    public static void reconnect(Properties properties) throws ClassNotFoundException {
        HibernateContext newContext;
        sLog.info((Object)"Reconnecting database ...");
        HibernateContext oldContect = sContext;
        sLog.info((Object)"Configuring new Hibernate context ...");
        sContext = newContext = properties != null ? HibernateUtil.configureHibernateFromProperties(properties) : HibernateUtil.configureHibernateFromRootDAO();
        sLog.info((Object)"Closing old Hibernate context ...");
        oldContect.close();
    }

    public static Session getSession() {
        return HibernateUtil.getSession(false);
    }

    public static Session createNewSession() {
        return HibernateUtil.getSession(true);
    }

    private static Session getSession(boolean createNew) {
        Session session;
        if (createNew) {
            return sContext.getSessionFactory().openSession();
        }
        if (sSessions == null) {
            sSessions = new ThreadLocal();
        }
        if ((session = sSessions.get()) == null || !session.isOpen()) {
            session = sContext.getSessionFactory().openSession();
            sSessions.set(session);
        }
        return session;
    }

    public static Session getCurrentThreadSession() {
        Session session;
        if (sSessions != null && (session = sSessions.get()) != null) {
            return session;
        }
        return null;
    }

    public static boolean closeCurrentThreadSessions() {
        return HibernateUtil.closeCurrentThreadSessions(true);
    }

    public static boolean rollbackCurrentThreadSessions() {
        return HibernateUtil.closeCurrentThreadSessions(false);
    }

    private static boolean closeCurrentThreadSessions(boolean commit) {
        boolean ret = false;
        if (sSessions != null) {
            Session session = sSessions.get();
            if (session != null && session.isOpen()) {
                if (session.getTransaction() != null && session.getTransaction().isActive()) {
                    if (commit) {
                        session.getTransaction().commit();
                    } else {
                        session.getTransaction().rollback();
                    }
                }
                session.close();
                ret = true;
            }
            sSessions.remove();
        }
        return ret;
    }

    public static boolean isConfigured() {
        return sContext != null && sContext.getSessionFactory() != null;
    }

    public static HibernateContext getHibernateContext() {
        return sContext;
    }

    public static HibernateContext getConfiguration() {
        return sContext;
    }

    static {
        sConnectionUrl = null;
    }

    public static class PostgreSQLAddDateFunction
    extends NamedSqmFunctionDescriptor {
        public static final PostgreSQLAddDateFunction INSTANCE = new PostgreSQLAddDateFunction();

        public PostgreSQLAddDateFunction() {
            super("adddate", false, StandardArgumentsValidators.exactly((int)2), null);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(" + (");
            translator.render(sqlAstArguments.get(1), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(") * interval '1 day'");
        }
    }

    public static class PostgreSQLDaysFunction
    extends NamedSqmFunctionDescriptor {
        public static final PostgreSQLDaysFunction INSTANCE = new PostgreSQLDaysFunction();

        public PostgreSQLDaysFunction() {
            super("days", false, StandardArgumentsValidators.exactly((int)2), new FunctionReturnTypeResolver(){

                public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                    return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                }

                public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                    return impliedTypeAccess.get();
                }
            });
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(date(");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(") - date(");
            translator.render(sqlAstArguments.get(1), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql("))");
        }
    }

    public static class PostgreSQLWeekdayFunction
    extends NamedSqmFunctionDescriptor {
        public static final PostgreSQLWeekdayFunction INSTANCE = new PostgreSQLWeekdayFunction();

        public PostgreSQLWeekdayFunction() {
            super("weekday", false, StandardArgumentsValidators.exactly((int)1), new FunctionReturnTypeResolver(){

                public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                    return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                }

                public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                    return impliedTypeAccess.get();
                }
            });
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(extract(isodow from ");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(") - 1)");
        }
    }

    public static class OracleWeekdayFunction
    extends NamedSqmFunctionDescriptor {
        public static final OracleWeekdayFunction INSTANCE = new OracleWeekdayFunction();

        public OracleWeekdayFunction() {
            super("weekday", false, StandardArgumentsValidators.exactly((int)1), new FunctionReturnTypeResolver(){

                public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                    return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                }

                public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                    return impliedTypeAccess.get();
                }
            });
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(trunc(");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(") - trunc(");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(", 'IW'))");
        }
    }

    public static class OracleDaysFunction
    extends NamedSqmFunctionDescriptor {
        public static final OracleDaysFunction INSTANCE = new OracleDaysFunction();

        public OracleDaysFunction() {
            super("days", false, StandardArgumentsValidators.exactly((int)2), new FunctionReturnTypeResolver(){

                public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                    return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                }

                public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                    return impliedTypeAccess.get();
                }
            });
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(trunc(");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(") - trunc(");
            translator.render(sqlAstArguments.get(1), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql("))");
        }
    }

    public static class OracleAddDateFunction
    extends NamedSqmFunctionDescriptor {
        public static final OracleAddDateFunction INSTANCE = new OracleAddDateFunction();

        public OracleAddDateFunction() {
            super("adddate", false, StandardArgumentsValidators.exactly((int)2), null);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(" + (");
            translator.render(sqlAstArguments.get(1), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(")");
        }
    }

    public static class MySQLDaysFunction
    extends NamedSqmFunctionDescriptor {
        public static final MySQLDaysFunction INSTANCE = new MySQLDaysFunction();

        public MySQLDaysFunction() {
            super("days", false, StandardArgumentsValidators.exactly((int)2), new FunctionReturnTypeResolver(){

                public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                    return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                }

                public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                    return impliedTypeAccess.get();
                }
            });
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("datediff(");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(", ");
            translator.render(sqlAstArguments.get(1), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(")");
        }
    }

    public static class MySQLWeekdayFunction
    extends NamedSqmFunctionDescriptor {
        public static final MySQLWeekdayFunction INSTANCE = new MySQLWeekdayFunction();

        public MySQLWeekdayFunction() {
            super("weekday", false, StandardArgumentsValidators.exactly((int)1), new FunctionReturnTypeResolver(){

                public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                    return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                }

                public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                    return impliedTypeAccess.get();
                }
            });
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("weekday(");
            translator.render(sqlAstArguments.get(0), SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(")");
        }
    }
}

