/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons;

import biweekly.ICalendar;
import biweekly.component.VTimezone;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.text.ICalReader;
import biweekly.property.TimezoneId;
import biweekly.property.ValuedProperty;
import biweekly.util.IOUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.unitime.timetable.defaults.ApplicationProperty;

public class CalendarVTimeZoneGenerator {
    private static final Map<URI, VTimezone> cache = Collections.synchronizedMap(new HashMap());

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VTimezone generate(TimeZone timezone) throws IllegalArgumentException {
        ICalendar ical;
        URI uri;
        try {
            String tz = ApplicationProperty.CalendarVTimeZoneID.value(timezone.getID());
            uri = tz != null ? new URI(tz) : new URI(ApplicationProperty.CalendarVTimeZone.value().replace("{id}", timezone.getID()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        VTimezone component = cache.get(uri);
        if (component != null) {
            return component.copy();
        }
        ICalReader reader = null;
        try {
            reader = new ICalReader(this.getInputStream(uri));
            ical = reader.readNext();
        }
        catch (FileNotFoundException e) {
            try {
                throw CalendarVTimeZoneGenerator.notFound(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        if (ical == null) {
            throw CalendarVTimeZoneGenerator.notFound(null);
        }
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        Collection components = tzinfo.getComponents();
        if (components.isEmpty() && (components = ical.getComponents(VTimezone.class)).isEmpty()) {
            throw CalendarVTimeZoneGenerator.notFound(null);
        }
        component = (VTimezone)components.iterator().next();
        TimezoneId id = component.getTimezoneId();
        if (id == null) {
            component.setTimezoneId(timezone.getID());
        } else {
            String value = (String)ValuedProperty.getValue((ValuedProperty)id);
            if (value == null || value.trim().isEmpty()) {
                id.setValue((Object)timezone.getID());
            }
        }
        cache.put(uri, component);
        return component.copy();
    }

    InputStream getInputStream(URI uri) throws IOException {
        return uri.toURL().openStream();
    }

    public static void clearCache() {
        cache.clear();
    }

    private static IllegalArgumentException notFound(Exception e) {
        return new IllegalArgumentException("Timezone ID not recognized.", e);
    }

    public static TimezoneAssignment download(TimeZone timezone) {
        CalendarVTimeZoneGenerator generator = new CalendarVTimeZoneGenerator();
        VTimezone component = generator.generate(timezone);
        return new TimezoneAssignment(timezone, component);
    }
}

