/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.NullAddress;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Experimental
public class BatchBundler
extends BaseBundler {
    @Property(description="Max interval (millis) at which the queued messages are sent")
    protected long flush_interval = 100L;
    @Property(description="The maximum number of messages per batch")
    public int max_batch_size = 1000;
    @ManagedAttribute(description="Local address")
    protected volatile Address local_addr;
    @ManagedAttribute(description="Number of messages sent in BatchMessages", type=AttributeType.SCALAR)
    protected long num_msgs_sent;
    @ManagedAttribute(description="Number of BatchMessages sent", type=AttributeType.SCALAR)
    protected long num_ebs_sent;
    @ManagedAttribute(description="Number of BatchMessages sent because the queue was full", type=AttributeType.SCALAR)
    protected long num_ebs_sent_due_to_full_queue;
    @ManagedAttribute(description="Number of BatchMessages sent because the max number of messages has been reached (max_batch_size)", type=AttributeType.SCALAR)
    protected long num_ebs_sent_due_to_max_number_of_msgs;
    @ManagedAttribute(description="Number of BatchMessages sent because the timeout kicked in", type=AttributeType.SCALAR)
    protected long num_ebs_sent_due_to_timeout;
    protected ConcurrentMap<Address, Buffer> msgMap = Util.createConcurrentMap();
    protected final NullAddress nullAddress = new NullAddress();
    protected TimeScheduler timer;
    protected volatile boolean running;
    protected Future<?> flush_task;

    @Override
    @ManagedAttribute(description="Average number of messages in an BatchMessage")
    public double avgBatchSize() {
        if (this.num_ebs_sent == 0L || this.num_msgs_sent == 0L) {
            return 0.0;
        }
        return (double)this.num_msgs_sent / (double)this.num_ebs_sent;
    }

    @Override
    public void resetStats() {
        this.num_msgs_sent = 0L;
        this.num_ebs_sent = 0L;
        this.num_ebs_sent_due_to_full_queue = 0L;
        this.num_ebs_sent_due_to_timeout = 0L;
        this.num_ebs_sent_due_to_max_number_of_msgs = 0L;
    }

    @Override
    public void viewChange(View view) {
        List<Address> mbrs = view.getMembers();
        if (mbrs == null) {
            return;
        }
        mbrs.stream().filter(dest -> !this.msgMap.containsKey(dest)).forEach(dest -> this.msgMap.putIfAbsent((Address)dest, new Buffer((Address)dest)));
        this.msgMap.keySet().stream().filter(dest -> !mbrs.contains(dest) && !(dest instanceof NullAddress)).forEach(dest -> {
            Buffer removed = (Buffer)this.msgMap.remove(dest);
            removed.close();
        });
    }

    @Override
    public void start() {
        this.timer = this.transport.getTimer();
        if (this.timer == null) {
            throw new RuntimeException("timer is null");
        }
        this.local_addr = Objects.requireNonNull(this.transport.getAddress());
        this.running = true;
        this.startFlushTask();
    }

    @Override
    public void stop() {
        this.running = false;
        this.stopFlushTask();
    }

    @Override
    public void send(Message msg) throws Exception {
        boolean add_successful;
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (!Objects.equals(msg.getSrc(), this.local_addr)) {
            this._send(msg);
            return;
        }
        Address dest = msg.dest() == null ? this.nullAddress : msg.dest();
        Buffer ebbuffer = (Buffer)this.msgMap.get(dest);
        if (ebbuffer == null) {
            ebbuffer = this.msgMap.computeIfAbsent(dest, k -> new Buffer(dest));
        }
        if (!(add_successful = ebbuffer.addMessage(msg))) {
            this._send(msg);
        }
    }

    @Override
    public int getQueueSize() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return this.max_batch_size;
    }

    protected void _send(Message msg) {
        ByteArrayDataOutputStream buffer = new ByteArrayDataOutputStream(msg.size());
        this.sendSingle(msg.dest(), msg, buffer);
    }

    protected void startFlushTask() {
        if (this.flush_task == null || this.flush_task.isDone()) {
            this.flush_task = this.timer.scheduleWithFixedDelay(new FlushTask(), 0L, this.flush_interval, TimeUnit.MILLISECONDS, true);
        }
    }

    protected void stopFlushTask() {
        if (this.flush_task != null) {
            this.flush_task.cancel(true);
            this.flush_task = null;
        }
    }

    public void flush() {
        this.msgMap.forEach((k, v) -> v.sendBatch(true));
    }

    protected class Buffer {
        private final Address dest;
        private final Message[] msgs;
        private int index;
        private boolean closed;
        private long total_bytes;
        private final ByteArrayDataOutputStream output;

        protected Buffer(Address address) {
            this.dest = address;
            this.msgs = new Message[BatchBundler.this.max_batch_size];
            this.index = 0;
            this.output = new ByteArrayDataOutputStream(BatchBundler.this.max_size + 5);
        }

        protected synchronized boolean addMessage(Message msg) {
            if (this.closed) {
                return false;
            }
            int msg_bytes = msg.size();
            if (this.total_bytes + (long)msg_bytes > (long)BatchBundler.this.max_size) {
                ++BatchBundler.this.num_ebs_sent_due_to_full_queue;
                this.sendBatch(false);
            }
            this.msgs[this.index++] = msg;
            this.total_bytes += (long)msg_bytes;
            if (this.index == this.msgs.length) {
                ++BatchBundler.this.num_ebs_sent_due_to_max_number_of_msgs;
                this.sendBatch(false);
            }
            return true;
        }

        protected synchronized void sendBatch(boolean due_to_timeout) {
            if (this.index == 0) {
                return;
            }
            if (this.index == 1) {
                this.output.position(0);
                BatchBundler.this.sendSingle(this.msgs[0].dest(), this.msgs[0], this.output);
                this.msgs[0] = null;
                this.index = 0;
                this.total_bytes = 0L;
                ++BatchBundler.this.num_msgs_sent;
                return;
            }
            Address ebdest = this.dest instanceof NullAddress ? null : this.dest;
            this.output.position(0);
            BatchBundler.this.sendMultiple(ebdest, BatchBundler.this.local_addr, this.msgs, this.index, this.output);
            BatchBundler.this.num_msgs_sent += (long)this.index;
            ++BatchBundler.this.num_ebs_sent;
            if (due_to_timeout) {
                ++BatchBundler.this.num_ebs_sent_due_to_timeout;
            }
            this.index = 0;
            this.total_bytes = 0L;
        }

        protected synchronized void close() {
            this.closed = true;
            this.sendBatch(false);
        }
    }

    protected class FlushTask
    implements Runnable {
        protected FlushTask() {
        }

        @Override
        public void run() {
            BatchBundler.this.flush();
        }

        public String toString() {
            return BatchBundler.class.getSimpleName() + ": FlushTask (interval=" + BatchBundler.this.flush_interval + " ms)";
        }
    }
}

