/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;

public class ScriptInterface
implements GwtRpcResponse,
Comparable<ScriptInterface> {
    private Long iId;
    private String iName;
    private String iDescription;
    private String iEngine;
    private String iPermission;
    private String iScript;
    private List<ScriptParameterInterface> iParameters;
    private boolean iCanEdit = false;
    private boolean iCanDelete = false;
    private boolean iCanExecute;

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public String getEngine() {
        return this.iEngine;
    }

    public void setEngine(String engine) {
        this.iEngine = engine;
    }

    public String getPermission() {
        return this.iPermission;
    }

    public void setPermission(String permission) {
        this.iPermission = permission;
    }

    public String getScript() {
        return this.iScript;
    }

    public void setScript(String script) {
        this.iScript = script;
    }

    public boolean hasParameters() {
        return this.iParameters != null && !this.iParameters.isEmpty();
    }

    public List<ScriptParameterInterface> getParameters() {
        return this.iParameters;
    }

    public void addParameter(ScriptParameterInterface parameter) {
        if (this.iParameters == null) {
            this.iParameters = new ArrayList<ScriptParameterInterface>();
        }
        this.iParameters.add(parameter);
    }

    public ScriptParameterInterface getParameter(String name) {
        if (this.iParameters == null) {
            return null;
        }
        for (ScriptParameterInterface p : this.iParameters) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public boolean isFileParameter(String name) {
        if (this.iParameters == null) {
            return false;
        }
        for (ScriptParameterInterface p : this.iParameters) {
            if (!name.equals(p.getName())) continue;
            return "file".equalsIgnoreCase(p.getType());
        }
        return false;
    }

    public boolean canEdit() {
        return this.iCanEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.iCanEdit = canEdit;
    }

    public boolean canDelete() {
        return this.iCanDelete;
    }

    public void setCanDelete(boolean canDelete) {
        this.iCanDelete = canDelete;
    }

    public boolean canExecute() {
        return this.iCanExecute;
    }

    public void setCanExecute(boolean canExecute) {
        this.iCanExecute = canExecute;
    }

    @Override
    public int compareTo(ScriptInterface o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.getName();
    }

    public static class ScriptParameterInterface
    implements IsSerializable,
    Comparable<ScriptParameterInterface> {
        private String iName;
        private String iLabel;
        private String iType;
        private String iValue;
        private String iDefault;
        private Set<ListItem> iOptions = null;
        private boolean iMultiSelect = false;

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getDefaultValue() {
            return this.iDefault;
        }

        public void setDefaultValue(String defaultValue) {
            this.iDefault = defaultValue;
        }

        public boolean hasOptions() {
            return this.iOptions != null && !this.iOptions.isEmpty();
        }

        public void addOption(String value, String text) {
            if (this.iOptions == null) {
                this.iOptions = new TreeSet<ListItem>();
            }
            this.iOptions.add(new ListItem(value, text));
        }

        public Set<ListItem> getOptions() {
            return this.iOptions;
        }

        public String getOption(String key) {
            if (this.iOptions == null || key == null) {
                return key;
            }
            for (ListItem o : this.iOptions) {
                if (!key.equals(o.getValue())) continue;
                return o.getText();
            }
            return key;
        }

        public boolean isMultiSelect() {
            return this.iMultiSelect;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.iMultiSelect = multiSelect;
        }

        public String toString() {
            return this.getName() + "=" + (this.getValue() == null ? this.getDefaultValue() : this.getValue());
        }

        @Override
        public int compareTo(ScriptParameterInterface o) {
            int cmp = this.getLabel().compareTo(o.getLabel());
            if (cmp != 0) {
                return cmp;
            }
            return this.getName().compareTo(o.getName());
        }
    }

    public static class GetQueueTableRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<QueueItemInterface>> {
        private String iDeleteId = null;

        public GetQueueTableRpcRequest() {
        }

        public GetQueueTableRpcRequest(String deleteId) {
            this.iDeleteId = deleteId;
        }

        public String getDeleteId() {
            return this.iDeleteId;
        }

        @Override
        public String toString() {
            return this.iDeleteId == null ? "" : this.iDeleteId;
        }
    }

    public static class QueueItemInterface
    implements GwtRpcResponse {
        private String iId;
        private String iName;
        private String iStatus;
        private String iProgress;
        private String iOwner;
        private String iSession;
        private String iOutput;
        private String iLog;
        private String iHost;
        private String iOutputLink;
        private Date iCreated;
        private Date iStarted;
        private Date iFinished;
        private boolean iCanDelete = false;
        private ExecuteScriptRpcRequest iExecutionRequest;

        public String getId() {
            return this.iId;
        }

        public void setId(String id) {
            this.iId = id;
        }

        public String getHost() {
            return this.iHost;
        }

        public void setHost(String host) {
            this.iHost = host;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getStatus() {
            return this.iStatus;
        }

        public void setStatus(String status) {
            this.iStatus = status;
        }

        public String getProgress() {
            return this.iProgress;
        }

        public void setProgress(String progress) {
            this.iProgress = progress;
        }

        public String getOwner() {
            return this.iOwner;
        }

        public void setOwner(String owner) {
            this.iOwner = owner;
        }

        public String getSession() {
            return this.iSession;
        }

        public void setSession(String session) {
            this.iSession = session;
        }

        public String getOtuput() {
            return this.iOutput;
        }

        public void setOutput(String output) {
            this.iOutput = output;
        }

        public String getOtuputLink() {
            return this.iOutputLink;
        }

        public void setOutputLink(String outputLink) {
            this.iOutputLink = outputLink;
        }

        public Date getCreated() {
            return this.iCreated;
        }

        public void setCreated(Date created) {
            this.iCreated = created;
        }

        public Date getStarted() {
            return this.iStarted;
        }

        public void setStarted(Date started) {
            this.iStarted = started;
        }

        public Date getFinished() {
            return this.iFinished;
        }

        public void setFinished(Date finished) {
            this.iFinished = finished;
        }

        public String getLog() {
            return this.iLog;
        }

        public void setLog(String log) {
            this.iLog = log;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setExecutionRequest(ExecuteScriptRpcRequest request) {
            this.iExecutionRequest = request;
        }

        public ExecuteScriptRpcRequest getExecutionRequest() {
            return this.iExecutionRequest;
        }
    }

    public static class ListItem
    implements IsSerializable,
    Comparable<ListItem> {
        private String iValue;
        private String iText;

        public ListItem() {
        }

        public ListItem(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getText() {
            return this.iText;
        }

        @Override
        public int compareTo(ListItem item) {
            int cmp = this.getText().compareTo(item.getText());
            if (cmp != 0) {
                return cmp;
            }
            return this.getValue().compareTo(item.getValue());
        }
    }

    public static class ExecuteScriptRpcRequest
    implements GwtRpcRequest<QueueItemInterface>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iName;
        private Map<String, String> iParameters = new HashMap<String, String>();
        private String iEmail;

        public Long getScriptId() {
            return this.iId;
        }

        public void setScriptId(Long id) {
            this.iId = id;
        }

        public String getScriptName() {
            return this.iName;
        }

        public void setScriptName(String name) {
            this.iName = name;
        }

        public Map<String, String> getParameters() {
            return this.iParameters;
        }

        public void setParameter(String name, String value) {
            this.iParameters.put(name, value);
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public static ExecuteScriptRpcRequest executeScript(Long scriptId, String scriptName, Map<String, String> parameters, String email) {
            ExecuteScriptRpcRequest request = new ExecuteScriptRpcRequest();
            request.setScriptId(scriptId);
            request.setScriptName(scriptName);
            if (parameters != null) {
                for (Map.Entry<String, String> e : parameters.entrySet()) {
                    request.setParameter(e.getKey(), e.getValue());
                }
            }
            request.setEmail(email);
            return request;
        }

        public static ExecuteScriptRpcRequest executeScript(ScriptInterface script) {
            ExecuteScriptRpcRequest request = new ExecuteScriptRpcRequest();
            request.setScriptId(script.getId());
            request.setScriptName(script.getName());
            if (script.hasParameters()) {
                for (ScriptParameterInterface parameter : script.getParameters()) {
                    if (parameter.getValue() == null && parameter.getDefaultValue() == null) continue;
                    request.setParameter(parameter.getName(), parameter.getValue() == null ? parameter.getDefaultValue() : parameter.getValue());
                }
            }
            return request;
        }

        @Override
        public String toString() {
            return this.getScriptName() + String.valueOf(this.getParameters());
        }
    }

    public static class DeleteScriptRpcRequest
    implements GwtRpcRequest<ScriptInterface> {
        private Long iId;
        private String iName;

        public DeleteScriptRpcRequest() {
        }

        public DeleteScriptRpcRequest(Long id, String name) {
            this.iId = id;
            this.iName = name;
        }

        public Long getScriptId() {
            return this.iId;
        }

        public void setScriptId(Long id) {
            this.iId = id;
        }

        public String getScriptName() {
            return this.iName;
        }

        public void setScriptName(String name) {
            this.iName = name;
        }

        @Override
        public String toString() {
            return this.getScriptName();
        }
    }

    public static class SaveOrUpdateScriptRpcRequest
    implements GwtRpcRequest<ScriptInterface> {
        private ScriptInterface iScript;

        public SaveOrUpdateScriptRpcRequest() {
        }

        public SaveOrUpdateScriptRpcRequest(ScriptInterface script) {
            this.iScript = script;
        }

        public ScriptInterface getScript() {
            return this.iScript;
        }

        public void setScript(ScriptInterface script) {
            this.iScript = script;
        }

        @Override
        public String toString() {
            return this.getScript().toString();
        }
    }

    public static class LoadAllScriptsRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<ScriptInterface>> {
        @Override
        public String toString() {
            return "";
        }
    }

    public static class GetScriptOptionsRpcRequest
    implements GwtRpcRequest<ScriptOptionsInterface> {
        @Override
        public String toString() {
            return "";
        }
    }

    public static class ScriptOptionsInterface
    implements GwtRpcResponse {
        private List<String> iEngines = new ArrayList<String>();
        private List<String> iPermissions = new ArrayList<String>();
        private boolean iCanAdd;
        private String iEmail;

        public void addEngine(String engine) {
            this.iEngines.add(engine);
        }

        public List<String> getEngines() {
            return this.iEngines;
        }

        public void addPermission(String permission) {
            this.iPermissions.add(permission);
        }

        public List<String> getPermissions() {
            return this.iPermissions;
        }

        public boolean canAdd() {
            return this.iCanAdd;
        }

        public void setCanAdd(boolean canAdd) {
            this.iCanAdd = canAdd;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }
    }
}

