/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.offerings.PreferenceEditWidget;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class InstructorPreferencesPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private PrefGroupEditInterface.InstructorPreferencesEditResponse iData;
    private PreferenceEditWidget iPreferences;

    public InstructorPreferencesPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ClassEditPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"instructorId");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoInstructorId());
        } else {
            this.load(Long.valueOf(id), PrefGroupEditInterface.Operation.GET, true, null);
        }
        this.iHeader.addButton("update", COURSE.actionUpdatePreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorPreferencesPage.this.iPreferences.update();
                if (InstructorPreferencesPage.this.validate()) {
                    InstructorPreferencesPage.this.load(InstructorPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.UPDATE, true, null);
                }
            }
        });
        this.iHeader.getButton("update").setTitle(COURSE.titleUpdatePreferences(COURSE.accessUpdatePreferences()));
        this.iHeader.getButton("update").setAccessKey(COURSE.accessUpdatePreferences().charAt(0));
        this.iHeader.setEnabled("update", false);
        this.iHeader.addButton("clear", COURSE.actionClearInstructorPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorPreferencesPage.this.iPreferences.update();
                InstructorPreferencesPage.this.load(InstructorPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.CLEAR_CLASS_PREFS, true, null);
            }
        });
        this.iHeader.getButton("clear").setTitle(COURSE.titleClearInstructorPreferences(COURSE.accessClearInstructorPreferences()));
        this.iHeader.getButton("clear").setAccessKey(COURSE.accessClearInstructorPreferences().charAt(0));
        this.iHeader.setEnabled("clear", false);
        this.iHeader.addButton("previous", COURSE.actionPreviousInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorPreferencesPage.this.iPreferences.update();
                if (InstructorPreferencesPage.this.validate()) {
                    InstructorPreferencesPage.this.load(InstructorPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.PREVIOUS, true, null);
                }
            }
        });
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousInstructorWithUpdate(COURSE.accessPreviousInstructor()));
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousInstructor().charAt(0));
        this.iHeader.setEnabled("previous", false);
        this.iHeader.addButton("next", COURSE.actionNextInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorPreferencesPage.this.iPreferences.update();
                if (InstructorPreferencesPage.this.validate()) {
                    InstructorPreferencesPage.this.load(InstructorPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.NEXT, true, null);
                }
            }
        });
        this.iHeader.getButton("next").setTitle(COURSE.titleNextInstructorWithUpdate(COURSE.accessNextInstructor()));
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextInstructor().charAt(0));
        this.iHeader.setEnabled("next", false);
        this.iHeader.addButton("back", COURSE.actionBackToDetail(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + InstructorPreferencesPage.this.iData.getId());
            }
        });
        this.iHeader.getButton("back").setTitle(COURSE.titleBackToDetail(COURSE.accessBackToDetail()));
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackToDetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(Long instructorId, final PrefGroupEditInterface.Operation op, final boolean showLoading, final Command command) {
        if (showLoading) {
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        }
        PrefGroupEditInterface.InstructorPreferencesEditRequest req = new PrefGroupEditInterface.InstructorPreferencesEditRequest();
        req.setOperation(op);
        if (op != null && this.iData != null) {
            this.iPreferences.update();
            req.setPayLoad(this.iData);
        }
        req.setId(instructorId);
        RPC.execute(req, new AsyncCallback<PrefGroupEditInterface.InstructorPreferencesEditResponse>(){

            public void onFailure(Throwable caught) {
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                InstructorPreferencesPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(PrefGroupEditInterface.InstructorPreferencesEditResponse response) {
                InstructorPreferencesPage.this.iData = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                if (op == PrefGroupEditInterface.Operation.DATE_PATTERN) {
                    InstructorPreferencesPage.this.iPreferences.setValue(response);
                    return;
                }
                InstructorPreferencesPage.this.iPanel.clear();
                InstructorPreferencesPage.this.iHeader.setHeaderTitle(response.getName());
                InstructorPreferencesPage.this.iPanel.addHeaderRow((Widget)InstructorPreferencesPage.this.iHeader);
                InstructorPreferencesPage.this.iPreferences = new PreferenceEditWidget(false);
                InstructorPreferencesPage.this.iPreferences.setValue(response);
                InstructorPreferencesPage.this.iPanel.addRow((Widget)InstructorPreferencesPage.this.iPreferences);
                InstructorPreferencesPage.this.iPanel.addBottomRow((Widget)InstructorPreferencesPage.this.iFooter);
                UniTimeNavigation.getInstance().refresh();
                InstructorPreferencesPage.this.iHeader.setEnabled("update", true);
                InstructorPreferencesPage.this.iHeader.setEnabled("previous", response.getPreviousId() != null);
                InstructorPreferencesPage.this.iHeader.setEnabled("next", response.getNextId() != null);
                InstructorPreferencesPage.this.iHeader.setEnabled("clear", response.canClearPrefs());
                if (command != null) {
                    command.execute();
                }
            }
        });
    }

    public boolean validate() {
        this.iHeader.clearMessage();
        String error = this.iPreferences.validate();
        if (error != null) {
            this.iHeader.setErrorMessage(error);
            return false;
        }
        return true;
    }
}

