/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.exams;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.ExaminationEnrollmentTable;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class ExamDetailPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    private static final ExaminationMessages EXAM = (ExaminationMessages)GWT.create(ExaminationMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private ExamsInterface.ExamDetailReponse iResponse;

    public ExamDetailPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ExamDetailPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"examId");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(EXAM.errorNoExamId());
        } else {
            this.load(Long.valueOf(id), null);
        }
        this.iHeader.addButton("edit", EXAM.actionExamEdit(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "examEdit.action?examId=" + ExamDetailPage.this.iResponse.getExamId());
            }
        });
        this.iHeader.setEnabled("edit", false);
        this.iHeader.getButton("edit").setAccessKey(EXAM.accessExamEdit().charAt(0));
        this.iHeader.getButton("edit").setTitle(EXAM.titleExamEdit());
        this.iHeader.addButton("clone", EXAM.actionExamClone(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "examEdit.action?examId=" + ExamDetailPage.this.iResponse.getExamId() + "&clone=true");
            }
        });
        this.iHeader.setEnabled("clone", false);
        this.iHeader.getButton("clone").setAccessKey(EXAM.accessExamClone().charAt(0));
        this.iHeader.getButton("clone").setTitle(EXAM.titleExamClone());
        this.iHeader.addButton("assign", EXAM.actionExamAssign(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                UniTimeFrameDialog.openDialog(EXAM.dialogExamAssign(), "examInfo.action?examId=" + ExamDetailPage.this.iResponse.getExamId(), "900", "90%");
            }
        });
        this.iHeader.setEnabled("assign", false);
        this.iHeader.getButton("assign").setAccessKey(EXAM.accessExamAssign().charAt(0));
        this.iHeader.getButton("assign").setTitle(EXAM.titleExamAssign());
        this.iHeader.addButton("delete", EXAM.actionExamDelete(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                if (ExamDetailPage.this.iResponse.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(EXAM.confirmExamDelete(), new Command(){

                        public void execute() {
                            ExamDetailPage.this.load(ExamDetailPage.this.iResponse.getExamId(), ExamsInterface.ExamDetailRequest.Action.DELETE);
                        }
                    });
                } else {
                    ExamDetailPage.this.load(ExamDetailPage.this.iResponse.getExamId(), ExamsInterface.ExamDetailRequest.Action.DELETE);
                }
            }
        });
        this.iHeader.setEnabled("delete", false);
        this.iHeader.getButton("delete").setAccessKey(EXAM.accessExamDelete().charAt(0));
        this.iHeader.getButton("delete").setTitle(EXAM.titleExamDelete());
        this.iHeader.addButton("previous", EXAM.actionExamPrevious(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "examination?id=" + ExamDetailPage.this.iResponse.getPreviousId());
            }
        });
        this.iHeader.setEnabled("previous", false);
        this.iHeader.getButton("previous").setAccessKey(EXAM.accessExamPrevious().charAt(0));
        this.iHeader.getButton("previous").setTitle(EXAM.titleExamPrevious());
        this.iHeader.addButton("next", EXAM.actionExamNext(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "examination?id=" + ExamDetailPage.this.iResponse.getNextId());
            }
        });
        this.iHeader.setEnabled("next", false);
        this.iHeader.getButton("next").setAccessKey(EXAM.accessExamNext().charAt(0));
        this.iHeader.getButton("next").setTitle(EXAM.titleExamNext());
        this.iHeader.addButton("back", EXAM.actionExamBack(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "back.action?uri=" + URL.encodeQueryString((String)ExamDetailPage.this.iResponse.getBackUrl()) + "&backId=" + ExamDetailPage.this.iResponse.getExamId() + "&backType=PreferenceGroup");
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(EXAM.accessExamBack().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(Long examId, ExamsInterface.ExamDetailRequest.Action action) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        ExamsInterface.ExamDetailRequest req = new ExamsInterface.ExamDetailRequest();
        req.setExamId(examId);
        req.setAction(action);
        RPC.execute(req, new AsyncCallback<ExamsInterface.ExamDetailReponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                ExamDetailPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(ExamsInterface.ExamDetailReponse response) {
                UniTimeHeaderPanel hp;
                ExamDetailPage.this.iResponse = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                LoadingWidget.getInstance().hide();
                ExamDetailPage.this.iPanel.clear();
                ExamDetailPage.this.iPanel.addHeaderRow((Widget)ExamDetailPage.this.iHeader);
                ExamDetailPage.this.iHeader.setHeaderTitle(response.getExamName());
                for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                    ExamDetailPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                }
                if (response.hasOwners()) {
                    hp = new UniTimeHeaderPanel(response.getOwners().getName());
                    ExamDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    ExamDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getOwners()));
                }
                if (response.hasAssignment()) {
                    hp = new UniTimeHeaderPanel(response.getAssignment().getName());
                    ExamDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    ExamDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getAssignment()));
                }
                if (response.hasPreferences()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitlePreferences());
                    ExamDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    ExamDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getPreferences()));
                }
                if (response.hasDistributions()) {
                    hp = new UniTimeHeaderPanel(response.getDistributions().getName());
                    ExamDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    ExamDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getDistributions()));
                    if (response.hasOperation("add-distribution")) {
                        hp.addButton("add-distribution", EXAM.actionAddDistributionPreference(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "examDistributionAdd?examId=" + ExamDetailPage.this.iResponse.getExamId());
                            }
                        });
                        hp.getButton("add-distribution").setAccessKey(EXAM.accessAddDistributionPreference().charAt(0));
                        hp.getButton("add-distribution").setTitle(EXAM.titleAddDistributionPreference(EXAM.accessAddDistributionPreference()));
                    } else if (response.hasOperation("add-distribution-legacy")) {
                        hp.addButton("add-distribution", EXAM.actionAddDistributionPreference(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "examDistributionPrefs.action?examId=" + ExamDetailPage.this.iResponse.getExamId() + "&op=" + URL.encodeQueryString((String)EXAM.actionAddDistributionPreference()));
                            }
                        });
                        hp.getButton("add-distribution").setAccessKey(EXAM.accessAddDistributionPreference().charAt(0));
                        hp.getButton("add-distribution").setTitle(EXAM.titleAddDistributionPreference(EXAM.accessAddDistributionPreference()));
                    }
                }
                ExamDetailPage.this.iPanel.addRow((Widget)new ExaminationEnrollmentTable(true, true).forExamId(response.getExamId()));
                ExamDetailPage.this.iPanel.addBottomRow((Widget)ExamDetailPage.this.iFooter);
                for (String op : ExamDetailPage.this.iHeader.getOperations()) {
                    ExamDetailPage.this.iHeader.setEnabled(op, response.hasOperation(op));
                }
                if (response.hasBackTitle()) {
                    ExamDetailPage.this.iHeader.getButton("back").setTitle(EXAM.titleExamBack().replace("%%", response.getBackTitle()));
                    ExamDetailPage.this.iFooter.getButton("back").setTitle(EXAM.titleExamBack().replace("%%", response.getBackTitle()));
                }
                UniTimeNavigation.getInstance().refresh();
            }
        });
    }
}

