/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumOverrideReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.UniversalOverrideReservation;
import org.unitime.timetable.model.base.BaseUniversalOverrideReservation;

public class ReservationExport
extends BaseExport {
    public static String sDateFormat = "MM/dd/yyyy";

    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("reservations");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("dateFormat", sDateFormat);
            root.addAttribute("created", new Date().toString());
            List reservations = this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId = :sessionId", Reservation.class).setParameter("sessionId", (Object)session.getUniqueId()).list();
            Collections.sort(reservations, new Comparator<Reservation>(){

                @Override
                public int compare(Reservation r1, Reservation r2) {
                    int cmp = r1.getInstructionalOffering().getControllingCourseOffering().compareTo(r2.getInstructionalOffering().getControllingCourseOffering());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = r1.getClass().getName().compareTo(r2.getClass().getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return r1.getUniqueId().compareTo(r2.getUniqueId());
                }
            });
            SimpleDateFormat df = new SimpleDateFormat(sDateFormat, Locale.US);
            for (Reservation reservation : this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId = :sessionId", Reservation.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                Object groupEl;
                StudentGroup group;
                Reservation override;
                Element reservationEl = root.addElement("reservation");
                CourseOffering course = reservation.getInstructionalOffering().getControllingCourseOffering();
                if (reservation instanceof CourseReservation) {
                    course = ((CourseReservation)reservation).getCourse();
                }
                if (reservation instanceof LearningCommunityReservation) {
                    course = ((LearningCommunityReservation)reservation).getCourse();
                }
                reservationEl.addAttribute("subject", course.getSubjectAreaAbbv());
                reservationEl.addAttribute("courseNbr", course.getCourseNbr());
                if (reservation.getLimit() != null && !(reservation instanceof IndividualReservation)) {
                    reservationEl.addAttribute("limit", reservation.getLimit().toString());
                }
                if (reservation.getExpirationDate() != null) {
                    reservationEl.addAttribute("expire", df.format(reservation.getExpirationDate()));
                }
                if (reservation.getStartDate() != null) {
                    reservationEl.addAttribute("startDate", df.format(reservation.getStartDate()));
                }
                if (reservation.isInclusive() != null) {
                    reservationEl.addAttribute("inclusive", reservation.isInclusive() != false ? "true" : "false");
                }
                for (InstrOfferingConfig config : reservation.getConfigurations()) {
                    reservationEl.addElement("configuration").addAttribute("name", config.getName());
                }
                for (Class_ clazz : reservation.getClasses()) {
                    Element classEl = reservationEl.addElement("class");
                    if (clazz.getExternalUniqueId() != null) {
                        classEl.addAttribute("externalId", clazz.getExternalUniqueId());
                    }
                    classEl.addAttribute("type", clazz.getItypeDesc().trim());
                    classEl.addAttribute("suffix", this.getClassSuffix(clazz));
                }
                if (reservation instanceof OverrideReservation) {
                    reservationEl.addAttribute("type", ((OverrideReservation)reservation).getOverrideType().getReference());
                    for (Student student : ((OverrideReservation)reservation).getStudents()) {
                        reservationEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                    }
                    continue;
                }
                if (reservation instanceof IndividualReservation) {
                    reservationEl.addAttribute("type", "individual");
                    for (Student student : ((IndividualReservation)reservation).getStudents()) {
                        reservationEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                    }
                    if (!(reservation instanceof IndividualOverrideReservation)) continue;
                    override = (IndividualOverrideReservation)reservation;
                    reservationEl.addAttribute("override", "true");
                    reservationEl.addAttribute("expired", ((IndividualOverrideReservation)override).isAlwaysExpired() ? "true" : "false");
                    reservationEl.addAttribute("allowOverlap", ((IndividualOverrideReservation)override).isAllowOverlap() ? "true" : "false");
                    reservationEl.addAttribute("overLimit", ((IndividualOverrideReservation)override).isCanAssignOverLimit() ? "true" : "false");
                    reservationEl.addAttribute("mustBeUsed", ((IndividualOverrideReservation)override).isMustBeUsed() ? "true" : "false");
                    continue;
                }
                if (reservation instanceof LearningCommunityReservation) {
                    reservationEl.addAttribute("type", "lc");
                    group = ((LearningCommunityReservation)reservation).getGroup();
                    groupEl = reservationEl.addElement("studentGroup");
                    if (group.getExternalUniqueId() != null) {
                        groupEl.addAttribute("externalId", group.getExternalUniqueId());
                    }
                    groupEl.addAttribute("code", group.getGroupAbbreviation());
                    continue;
                }
                if (reservation instanceof StudentGroupReservation) {
                    reservationEl.addAttribute("type", "group");
                    group = ((StudentGroupReservation)reservation).getGroup();
                    groupEl = reservationEl.addElement("studentGroup");
                    if (group.getExternalUniqueId() != null) {
                        groupEl.addAttribute("externalId", group.getExternalUniqueId());
                    }
                    groupEl.addAttribute("code", group.getGroupAbbreviation());
                    if (!(reservation instanceof GroupOverrideReservation)) continue;
                    GroupOverrideReservation override2 = (GroupOverrideReservation)reservation;
                    reservationEl.addAttribute("override", "true");
                    reservationEl.addAttribute("expired", override2.isAlwaysExpired() ? "true" : "false");
                    reservationEl.addAttribute("allowOverlap", override2.isAllowOverlap() ? "true" : "false");
                    reservationEl.addAttribute("overLimit", override2.isCanAssignOverLimit() ? "true" : "false");
                    reservationEl.addAttribute("mustBeUsed", override2.isMustBeUsed() ? "true" : "false");
                    continue;
                }
                if (reservation instanceof CurriculumReservation) {
                    reservationEl.addAttribute("type", "curriculum");
                    CurriculumReservation curRes = (CurriculumReservation)reservation;
                    for (AcademicArea area : curRes.getAreas()) {
                        Element acadAreaEl = reservationEl.addElement("academicArea");
                        if (area.getExternalUniqueId() != null) {
                            acadAreaEl.addAttribute("externalId", area.getExternalUniqueId());
                        }
                        acadAreaEl.addAttribute("abbreviation", area.getAcademicAreaAbbreviation());
                    }
                    for (AcademicClassification clasf : curRes.getClassifications()) {
                        Element clasfEl = reservationEl.addElement("academicClassification");
                        if (clasf.getExternalUniqueId() != null) {
                            clasfEl.addAttribute("externalId", clasf.getExternalUniqueId());
                        }
                        clasfEl.addAttribute("code", clasf.getCode());
                    }
                    for (PosMajor major : curRes.getMajors()) {
                        Element majorEl = reservationEl.addElement("major");
                        if (major.getExternalUniqueId() != null) {
                            majorEl.addAttribute("externalId", major.getExternalUniqueId());
                        }
                        majorEl.addAttribute("code", major.getCode());
                    }
                    for (PosMinor minor : curRes.getMinors()) {
                        Element minorEl = reservationEl.addElement("minor");
                        if (minor.getExternalUniqueId() != null) {
                            minorEl.addAttribute("externalId", minor.getExternalUniqueId());
                        }
                        minorEl.addAttribute("code", minor.getCode());
                    }
                    if (!(reservation instanceof CurriculumOverrideReservation)) continue;
                    CurriculumOverrideReservation override3 = (CurriculumOverrideReservation)reservation;
                    reservationEl.addAttribute("override", "true");
                    reservationEl.addAttribute("expired", override3.isAlwaysExpired() ? "true" : "false");
                    reservationEl.addAttribute("allowOverlap", override3.isAllowOverlap() ? "true" : "false");
                    reservationEl.addAttribute("overLimit", override3.isCanAssignOverLimit() ? "true" : "false");
                    reservationEl.addAttribute("mustBeUsed", override3.isMustBeUsed() ? "true" : "false");
                    continue;
                }
                if (reservation instanceof CourseReservation) {
                    if (course.getReservation() != null) {
                        reservationEl.addAttribute("limit", course.getReservation().toString());
                    }
                    reservationEl.addAttribute("type", "course");
                    continue;
                }
                if (reservation instanceof OverrideReservation) {
                    OverrideReservation ovRes = (OverrideReservation)reservation;
                    reservationEl.addAttribute("type", ovRes.getOverrideType().getReference());
                    for (Student student : ovRes.getStudents()) {
                        reservationEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                    }
                    continue;
                }
                if (reservation instanceof UniversalOverrideReservation) {
                    override = (UniversalOverrideReservation)reservation;
                    reservationEl.addAttribute("type", "universal");
                    if (((BaseUniversalOverrideReservation)override).getFilter() != null) {
                        reservationEl.addAttribute("filter", ((BaseUniversalOverrideReservation)override).getFilter());
                    }
                    reservationEl.addAttribute("expired", ((UniversalOverrideReservation)override).isAlwaysExpired() ? "true" : "false");
                    reservationEl.addAttribute("allowOverlap", ((UniversalOverrideReservation)override).isAllowOverlap() ? "true" : "false");
                    reservationEl.addAttribute("overLimit", ((UniversalOverrideReservation)override).isCanAssignOverLimit() ? "true" : "false");
                    reservationEl.addAttribute("mustBeUsed", ((UniversalOverrideReservation)override).isMustBeUsed() ? "true" : "false");
                    continue;
                }
                reservationEl.addAttribute("type", "unknown");
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }
}

