/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseSession;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomPicturesBackend;

@GwtRpcImplements(value=RoomInterface.RoomPropertiesRequest.class)
public class RoomPropertiesBackend
implements GwtRpcImplementation<RoomInterface.RoomPropertiesRequest, RoomInterface.RoomPropertiesInterface> {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public RoomInterface.RoomPropertiesInterface execute(RoomInterface.RoomPropertiesRequest request, SessionContext context) {
        RoomInterface.FeatureInterface feature;
        void var6_16;
        String mode;
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        context.checkPermission(Right.Rooms);
        RoomInterface.RoomPropertiesInterface response = new RoomInterface.RoomPropertiesInterface();
        UserAuthority authority = null;
        if (context.getUser() != null) {
            Iterator<Comparable> session = (Session)SessionDAO.getInstance().get(request.hasSessionId() ? request.getSessionId() : context.getUser().getCurrentAcademicSessionId());
            response.setAcademicSession(new RoomInterface.AcademicSessionInterface(((BasePreferenceGroup)((Object)session)).getUniqueId(), ((BaseSession)((Object)session)).getAcademicTerm() + " " + ((BaseSession)((Object)session)).getAcademicYear()));
            authority = context.getUser().getCurrentAuthority();
            if (!request.hasSessionId()) {
                request.setSessionId(((BasePreferenceGroup)((Object)session)).getUniqueId());
            }
        }
        response.setCanEditDepartments(context.hasPermission(Right.EditRoomDepartments));
        response.setCanExportCsv(context.hasPermission(Right.RoomsExportCsv));
        response.setCanExportPdf(context.hasPermission(Right.RoomsExportPdf));
        response.setCanEditRoomExams(context.hasPermission(Right.EditRoomDepartmentsExams));
        response.setCanAddRoom(context.hasPermission(Right.AddRoom));
        response.setCanAddNonUniversity(context.hasPermission(Right.AddNonUnivLocation));
        response.setCanSeeCourses(context.hasPermission(Right.InstructionalOfferings) || context.hasPermission(Right.Classes) || authority != null && (authority.hasRight(Right.RoomEditChangeRoomProperties) || authority.hasRight(Right.RoomEditChangeControll) || authority.hasRight(Right.RoomDetailAvailability) || authority.hasRight(Right.RoomEditAvailability)));
        response.setCanSeeExams(context.hasPermission(Right.Examinations) || authority != null && (authority.hasRight(Right.RoomEditChangeExaminationStatus) || authority.hasRight(Right.RoomDetailPeriodPreferences)));
        response.setCanSeeEvents(context.hasPermission(Right.Events) || authority != null && (authority.hasRight(Right.RoomEditChangeEventProperties) || authority.hasRight(Right.RoomDetailEventAvailability) || authority.hasRight(Right.RoomEditEventAvailability)));
        response.setCanExportRoomGroups(context.hasPermission(Right.RoomGroupsExportPdf));
        response.setCanExportRoomFeatures(context.hasPermission(Right.RoomFeaturesExportPdf));
        response.setCanAddGlobalRoomGroup(context.hasPermission(Right.GlobalRoomGroupAdd));
        response.setCanAddDepartmentalRoomGroup(context.hasPermission(Right.DepartmentRoomGroupAdd));
        response.setCanAddGlobalRoomFeature(context.hasPermission(Right.GlobalRoomFeatureAdd));
        response.setCanAddDepartmentalRoomFeature(context.hasPermission(Right.DepartmentRoomFeatureAdd));
        if (context.getUser() != null) {
            response.setCanChangeAvailability(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditAvailability));
            response.setCanChangeControll(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditChangeControll));
            response.setCanChangeEventAvailability(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditEventAvailability));
            response.setCanChangeEventProperties(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditChangeEventProperties));
            response.setCanChangeExamStatus(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditChangeExaminationStatus));
            response.setCanChangeExternalId(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditChangeExternalId));
            response.setCanChangeFeatures(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditFeatures) || context.getUser().getCurrentAuthority().hasRight(Right.RoomEditGlobalFeatures));
            response.setCanChangeGroups(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditGroups) || context.getUser().getCurrentAuthority().hasRight(Right.RoomEditGlobalGroups));
            response.setCanChangePicture(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditChangePicture));
            response.setCanChangePreferences(context.getUser().getCurrentAuthority().hasRight(Right.RoomEditPreference));
            response.setCanChangeDefaultGroup(context.getUser().getCurrentAuthority().hasRight(Right.GlobalRoomGroupEditSetDefault));
            if (!response.isCanSeeEvents() && response.isCanChangeEventProperties()) {
                response.setCanSeeEvents(true);
            }
        }
        for (RoomType roomType : RoomType.findAll()) {
            response.addRoomType(new RoomInterface.RoomTypeInterface(roomType.getUniqueId(), roomType.getReference(), roomType.getLabel(), roomType.isRoom(), roomType.getOrd()));
        }
        for (Building building : Building.findAll(response.getAcademicSessionId())) {
            RoomInterface.BuildingInterface building2 = new RoomInterface.BuildingInterface(building.getUniqueId(), building.getAbbreviation(), building.getName());
            building2.setX(building.getCoordinateX());
            building2.setY(building.getCoordinateY());
            building2.setExternalId(building.getExternalUniqueId());
            response.addBuilding(building2);
        }
        for (RoomFeatureType roomFeatureType : new TreeSet(RoomFeatureTypeDAO.getInstance().findAll())) {
            response.addFeatureType(new RoomInterface.FeatureTypeInterface(roomFeatureType.getUniqueId(), roomFeatureType.getReference(), roomFeatureType.getLabel(), roomFeatureType.isShowInEventManagement()));
        }
        if (context.getUser() != null) {
            for (ExamType examType : ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable)) {
                response.addExamType(new RoomInterface.ExamTypeInterface(examType.getUniqueId(), examType.getReference(), examType.getLabel(), examType.getType() == 0));
            }
        }
        boolean usedOnly = ApplicationProperty.RoomDeptUsedDeptsOnly.isTrue();
        for (Department d : Department.getUserDepartments(context.getUser(), usedOnly)) {
            RoomInterface.DepartmentInterface department = new RoomInterface.DepartmentInterface();
            department.setId(d.getUniqueId());
            department.setDeptCode(d.getDeptCode());
            department.setAbbreviation(d.getAbbreviation());
            department.setLabel(d.getName());
            department.setExternal(d.isExternalManager());
            department.setEvent(d.isAllowEvents());
            department.setExtAbbreviation(d.getExternalMgrAbbv());
            department.setExtLabel(d.getExternalMgrLabel());
            department.setTitle(d.getLabel());
            department.setCanEditRoomSharing(context.hasPermission(d, Right.EditRoomDepartments));
            response.addDepartment(department);
        }
        response.setNrDepartments(usedOnly ? Department.findAllBeingUsed(response.getAcademicSessionId()).size() : Department.findAll(response.getAcademicSessionId()).size());
        response.setHorizontal(context.getUser() == null ? false : CommonValues.HorizontalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        response.setGridAsText(context.getUser() == null ? false : CommonValues.TextGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        boolean bl = false;
        while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + var6_16), var6_16 < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[var6_16] : null)) != null && !mode.isEmpty()) {
            response.addMode(new RoomInterface.RoomSharingDisplayMode(mode));
            ++var6_16;
        }
        boolean bl2 = context.getUser() != null && !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        boolean includeGlobalGroups = context.getUser() != null && context.getUser().getCurrentAuthority().hasRight(Right.RoomEditGlobalGroups);
        boolean includeDeptGroups = context.getUser() != null && context.getUser().getCurrentAuthority().hasRight(Right.RoomEditGroups);
        for (RoomGroup roomGroup : RoomGroup.getAllRoomGroupsForSession(context.getUser().getCurrentAcademicSessionId())) {
            RoomInterface.GroupInterface group = new RoomInterface.GroupInterface(roomGroup.getUniqueId(), roomGroup.getAbbv(), roomGroup.getName());
            if (roomGroup.getDepartment() != null) {
                if (!includeDeptGroups || bl2 && !context.getUser().getCurrentAuthority().hasQualifier(roomGroup.getDepartment())) continue;
                group.setDepartment(response.getDepartment(roomGroup.getDepartment().getUniqueId()));
                group.setTitle((roomGroup.getDescription() == null || roomGroup.getDescription().isEmpty() ? roomGroup.getName() : roomGroup.getDescription()) + " (" + roomGroup.getDepartment().getName() + ")");
            } else {
                if (!includeGlobalGroups) continue;
                group.setTitle(roomGroup.getDescription() == null || roomGroup.getDescription().isEmpty() ? roomGroup.getName() : roomGroup.getDescription());
            }
            response.addGroup(group);
        }
        if (context.getUser() != null && context.getUser().getCurrentAuthority().hasRight(Right.RoomEditGlobalFeatures)) {
            for (GlobalRoomFeature globalRoomFeature : RoomFeature.getAllGlobalRoomFeatures(context.getUser().getCurrentAcademicSessionId())) {
                feature = new RoomInterface.FeatureInterface(globalRoomFeature.getUniqueId(), globalRoomFeature.getAbbv(), globalRoomFeature.getLabel());
                if (globalRoomFeature.getFeatureType() != null) {
                    feature.setType(response.getFeatureType(globalRoomFeature.getFeatureType().getUniqueId()));
                }
                feature.setTitle(globalRoomFeature.getDescription() == null || globalRoomFeature.getDescription().isEmpty() ? globalRoomFeature.getLabel() : globalRoomFeature.getDescription());
                response.addFeature(feature);
            }
        }
        if (context.getUser() != null && context.getUser().getCurrentAuthority().hasRight(Right.RoomEditFeatures)) {
            for (DepartmentRoomFeature departmentRoomFeature : RoomFeature.getAllDepartmentRoomFeaturesInSession(context.getUser().getCurrentAcademicSessionId())) {
                if (bl2 && !context.getUser().getCurrentAuthority().hasQualifier(departmentRoomFeature.getDepartment())) continue;
                feature = new RoomInterface.FeatureInterface(departmentRoomFeature.getUniqueId(), departmentRoomFeature.getAbbv(), departmentRoomFeature.getLabel());
                if (departmentRoomFeature.getFeatureType() != null) {
                    feature.setType(new RoomInterface.FeatureTypeInterface(departmentRoomFeature.getFeatureType().getUniqueId(), departmentRoomFeature.getFeatureType().getReference(), departmentRoomFeature.getFeatureType().getLabel(), departmentRoomFeature.getFeatureType().isShowInEventManagement()));
                }
                feature.setDepartment(response.getDepartment(departmentRoomFeature.getDepartment().getUniqueId()));
                feature.setTitle((departmentRoomFeature.getDescription() == null || departmentRoomFeature.getDescription().isEmpty() ? departmentRoomFeature.getLabel() : departmentRoomFeature.getDescription()) + " (" + departmentRoomFeature.getDepartment().getName() + ")");
                feature.setDescription(departmentRoomFeature.getDescription());
                response.addFeature(feature);
            }
        }
        for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList(false)) {
            response.addPreference(new RoomInterface.PreferenceInterface(preferenceLevel.getUniqueId(), PreferenceLevel.prolog2bgColor(preferenceLevel.getPrefProlog()), preferenceLevel.getPrefProlog(), preferenceLevel.getPrefName(), preferenceLevel.getAbbreviation(), true));
        }
        for (AttachmentType attachmentType : AttachmentType.listTypes(AttachmentType.VisibilityFlag.ROOM_PICTURE_TYPE)) {
            response.addPictureType(RoomPicturesBackend.getPictureType(attachmentType));
        }
        if (request.hasSessionId()) {
            for (EventServiceProvider eventServiceProvider : EventServiceProvider.findAll(request.getSessionId())) {
                if (eventServiceProvider.isAllRooms().booleanValue()) continue;
                EventInterface.EventServiceProviderInterface provider = new EventInterface.EventServiceProviderInterface();
                provider.setId(eventServiceProvider.getUniqueId());
                provider.setReference(eventServiceProvider.getReference());
                provider.setLabel(eventServiceProvider.getLabel());
                provider.setMessage(eventServiceProvider.getNote());
                provider.setEmail(eventServiceProvider.getEmail());
                if (eventServiceProvider.getDepartment() != null) {
                    provider.setDepartmentId(eventServiceProvider.getDepartment().getUniqueId());
                }
                response.addEventServiceProvider(provider);
            }
        }
        DistanceMetric.Ellipsoid ellipsoid = DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value());
        response.setEllipsoid(ellipsoid.getEclipsoindName());
        response.setGoogleMap(ApplicationProperty.RoomUseGoogleMap.isTrue());
        response.setGoogleMapApiKey(ApplicationProperty.GoogleMapsApiKey.value());
        response.setLeafletMap(!response.isGoogleMap() && ApplicationProperty.RoomUseLeafletMap.isTrue());
        response.setLeafletMapTiles(ApplicationProperty.RoomCacheLeafletMapTiles.isTrue() ? "maps?tile={z},{x},{y}" : ApplicationProperty.RoomUseLeafletMapTiles.value());
        response.setLeafletMapAttribution(ApplicationProperty.RoomUseLeafletMapAttribution.value());
        if (response.getAcademicSession() != null) {
            for (Session session : SessionDAO.getInstance().getSession().createQuery("select f from Session f, Session s where s.uniqueId = :sessionId and s.sessionBeginDateTime < f.sessionBeginDateTime and s.academicInitiative = f.academicInitiative order by f.sessionBeginDateTime", Session.class).setParameter("sessionId", (Object)response.getAcademicSessionId()).list()) {
                RoomInterface.AcademicSessionInterface s = new RoomInterface.AcademicSessionInterface(session.getUniqueId(), session.getAcademicTerm() + " " + session.getAcademicYear());
                EventAction.EventContext cx = new EventAction.EventContext(context, context.getUser(), session.getUniqueId());
                s.setCanAddRoom(cx.hasPermission(Right.AddRoom));
                s.setCanAddNonUniversity(cx.hasPermission(Right.AddNonUnivLocation));
                s.setCanAddGlobalRoomGroup(cx.hasPermission(Right.GlobalRoomGroupAdd));
                s.setCanAddDepartmentalRoomGroup(cx.hasPermission(Right.DepartmentRoomGroupAdd));
                s.setCanAddGlobalRoomFeature(cx.hasPermission(Right.GlobalRoomFeatureAdd));
                s.setCanAddDepartmentalRoomFeature(cx.hasPermission(Right.DepartmentRoomFeatureAdd));
                if (!s.isCanAddRoom() && !s.isCanAddNonUniversity()) continue;
                response.addFutureSession(s);
            }
        }
        response.setRoomAreaInMetricUnits(ApplicationProperty.RoomAreaUnitsMetric.isTrue());
        response.setCanSaveFilterDefaults(context.hasPermission(Right.HasRole));
        if (context.isAuthenticated() && response.isCanSaveFilterDefaults() && request.hasMode()) {
            response.setFilterDefault("filter", context.getUser().getProperty("Default[" + request.getMode() + ".filter]"));
        } else if (request.hasMode()) {
            response.setFilterDefault("filter", "EVENTS".equalsIgnoreCase(request.getMode()) ? "flag:Event" : "");
        }
        return response;
    }
}

