/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassEditBackend;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@GwtRpcImplements(value=ExamsInterface.ExamEditRequest.class)
public class ExamEditBackend
implements GwtRpcImplementation<ExamsInterface.ExamEditRequest, ExamsInterface.ExamEditResponse> {
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public ExamsInterface.ExamEditResponse execute(ExamsInterface.ExamEditRequest request, SessionContext context) {
        Iterator<Comparable<ExamType>> et;
        Exam exam;
        org.hibernate.Session hibSession = Class_DAO.getInstance().getSession();
        Exam exam2 = exam = request.getId() == null ? null : (Exam)ExamDAO.getInstance().get(request.getId());
        if (exam == null) {
            context.checkPermission(Right.ExaminationAdd);
        } else {
            context.checkPermission(exam, Right.ExaminationEdit);
        }
        if (request.getOperation() != null) {
            switch (request.getOperation()) {
                case CLEAR_EXAM_PREFS: {
                    context.checkPermission(exam, Right.ExaminationEditClearPreferences);
                    ClassEditBackend.doClear(exam.getPreferences(), Preference.Type.PERIOD, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                    hibSession.merge((Object)exam);
                    hibSession.flush();
                    ChangeLog.addChange(null, context, exam, ChangeLog.Source.EXAM_EDIT, ChangeLog.Operation.CLEAR_PREF, exam.firstSubjectArea(), exam.firstDepartment());
                    ExamsInterface.ExamEditResponse ret = new ExamsInterface.ExamEditResponse();
                    ret.setUrl("examination?id=" + exam.getUniqueId());
                    return ret;
                }
                case UPDATE: 
                case NEXT: 
                case PREVIOUS: {
                    Transaction tx = hibSession.beginTransaction();
                    try {
                        ExamsInterface.ExamEditResponse data = (ExamsInterface.ExamEditResponse)request.getPayLoad();
                        if (exam == null) {
                            exam = new Exam();
                            exam.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
                            exam.setExamType((ExamType)ExamTypeDAO.getInstance().get(data.getExamTypeId(), hibSession));
                            exam.setInstructors(new HashSet<DepartmentalInstructor>());
                            exam.setPreferences(new HashSet<Preference>());
                            exam.setOwners(new HashSet<ExamOwner>());
                        }
                        exam.setName(data.getName());
                        exam.setSeatingType(data.isExamSeating() ? 1 : 0);
                        exam.setLength(data.getLength());
                        exam.setMaxNbrRooms(data.getMaxRooms() == null ? 0 : data.getMaxRooms());
                        exam.setPrintOffset(data.getPrintOffset());
                        exam.setNote(data.getNotes());
                        exam.setExamSize(data.getSize());
                        if (request.getId() == null) {
                            hibSession.persist((Object)exam);
                        }
                        ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(exam.getInstructors());
                        if (data.hasExamInstructors()) {
                            block15: for (PrefGroupEditInterface.IdLabel instr : data.getExamInstructors()) {
                                if (instr == null || instr.getId() == null) continue;
                                Iterator i = instructors.iterator();
                                while (i.hasNext()) {
                                    DepartmentalInstructor deptInstr = (DepartmentalInstructor)i.next();
                                    if (!deptInstr.getUniqueId().equals(instr.getId())) continue;
                                    i.remove();
                                    continue block15;
                                }
                                DepartmentalInstructor deptInstr = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instr.getId());
                                if (deptInstr == null) continue;
                                exam.getInstructors().add(deptInstr);
                                deptInstr.getExams().add(exam);
                            }
                        }
                        for (DepartmentalInstructor deptInstr : instructors) {
                            deptInstr.getExams().remove(exam);
                            exam.getInstructors().remove(deptInstr);
                        }
                        exam.getOwners().clear();
                        if (data.hasExamObjects()) {
                            for (ExamsInterface.ExamObjectInterface eo : data.getExamObjects()) {
                                CourseOffering course;
                                if (eo.getCourseId() == null || !eo.isValid() || (course = (CourseOffering)CourseOfferingDAO.getInstance().get(eo.getCourseId(), hibSession)) == null) continue;
                                ExamOwner owner = new ExamOwner();
                                if (eo.getSubpartId() == Long.MIN_VALUE) {
                                    owner.setOwner(course);
                                } else if (eo.getSubpartId() == -9223372036854775807L) {
                                    owner.setOwner(course.getInstructionalOffering());
                                } else if (eo.getSubpartId() < 0L) {
                                    InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(-eo.getSubpartId().longValue());
                                    if (config == null) continue;
                                    owner.setOwner(config);
                                } else {
                                    Class_ clazz;
                                    if (eo.getClassId() == null || (clazz = (Class_)Class_DAO.getInstance().get(eo.getClassId())) == null) continue;
                                    owner.setOwner(clazz);
                                }
                                owner.setExam(exam);
                                exam.getOwners().add(owner);
                            }
                        }
                        ClassEditBackend.doUpdate(exam, exam.getPreferences(), data, Preference.Type.PERIOD, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING);
                        hibSession.merge((Object)exam);
                        ChangeLog.addChange(null, context, exam, ChangeLog.Source.EXAM_EDIT, request.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, exam.firstSubjectArea(), exam.firstDepartment());
                        tx.commit();
                        tx = null;
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw new GwtRpcException(e.getMessage(), e);
                    }
                    ExamsInterface.ExamEditResponse ret = new ExamsInterface.ExamEditResponse();
                    if (request.getOperation() == PrefGroupEditInterface.Operation.PREVIOUS && ((ExamsInterface.ExamEditResponse)request.getPayLoad()).getPreviousId() != null) {
                        ret.setUrl("examEdit?id=" + ((ExamsInterface.ExamEditResponse)request.getPayLoad()).getPreviousId());
                    } else if (request.getOperation() == PrefGroupEditInterface.Operation.NEXT && ((ExamsInterface.ExamEditResponse)request.getPayLoad()).getNextId() != null) {
                        ret.setUrl("examEdit?id=" + ((ExamsInterface.ExamEditResponse)request.getPayLoad()).getNextId());
                    } else {
                        ret.setUrl("examination?id=" + exam.getUniqueId());
                    }
                    return ret;
                }
                case EXAM_TYPE: {
                    ExamsInterface.ExamEditResponse ret = (ExamsInterface.ExamEditResponse)request.getPayLoad();
                    ExamType examType = (ExamType)ExamTypeDAO.getInstance().get(ret.getExamTypeId());
                    this.fillInPreferences(ret, null, examType, ret.isExamSeating(), context);
                    return ret;
                }
                case EXAM_SEATING: {
                    TreeSet<Location> rooms;
                    ExamsInterface.ExamEditResponse ret = (ExamsInterface.ExamEditResponse)request.getPayLoad();
                    PrefGroupEditInterface.Preferences roomPrefs = ret.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM);
                    if (roomPrefs != null && !(rooms = Location.findAllExamLocations(context.getUser().getCurrentAcademicSessionId(), (ExamType)ExamTypeDAO.getInstance().get(ret.getExamTypeId()))).isEmpty()) {
                        roomPrefs.getItems().clear();
                        for (Location location : rooms) {
                            roomPrefs.addItem(location.getUniqueId(), ret.isExamSeating() ? location.getLabelWithExamCapacity() : location.getLabelWithCapacity(), location.getDisplayName());
                        }
                    }
                    return ret;
                }
                case EXAM_OWNERS: {
                    ExamsInterface.ExamEditResponse ret = (ExamsInterface.ExamEditResponse)request.getPayLoad();
                    TreeSet<DepartmentalInstructor> instructors = null;
                    NameFormat nameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
                    instructors = ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue() ? new TreeSet<DepartmentalInstructor>(new DepartmentalInstructorComparator(nameFormat)) : new TreeSet<DepartmentalInstructor>(new DepartmentalInstructorComparator());
                    if (ret.hasExamObjects()) {
                        HashSet<Long> deptIds = new HashSet<Long>();
                        for (ExamsInterface.ExamObjectInterface eo : ret.getExamObjects()) {
                            CourseOffering course;
                            if (eo.getCourseId() == null || !deptIds.add((course = (CourseOffering)CourseOfferingDAO.getInstance().get(eo.getCourseId(), hibSession)).getSubjectArea().getDepartment().getUniqueId())) continue;
                            instructors.addAll(hibSession.createQuery("from DepartmentalInstructor where department.uniqueId = :deptId", DepartmentalInstructor.class).setParameter("deptId", (Object)course.getSubjectArea().getDepartment().getUniqueId()).list());
                        }
                        if (ret.hasInstructors()) {
                            ret.getInstructors().clear();
                        }
                        for (DepartmentalInstructor instr : instructors) {
                            ret.addInstructor(instr.getUniqueId(), nameFormat.format(instr), instr.getDepartment().getDeptCode());
                        }
                        if (ret.hasExamInstructors()) {
                            Iterator<PrefGroupEditInterface.IdLabel> it = ret.getExamInstructors().iterator();
                            while (it.hasNext()) {
                                if (ret.getInstructor(it.next().getId()) != null) continue;
                                it.remove();
                            }
                        }
                    }
                    return ret;
                }
            }
        }
        ExamsInterface.ExamEditResponse ret = new ExamsInterface.ExamEditResponse();
        ExamType examType = exam == null ? null : exam.getExamType();
        NameFormat nameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
        if (examType == null && (et = context.getAttribute(SessionAttribute.ExamType)) != null) {
            examType = (ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(et.toString()));
        }
        if (examType == null && (et = ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamEdit).iterator()).hasNext()) {
            ExamType type;
            examType = type = et.next();
        }
        if (exam != null) {
            ret.setId(request.getId());
            ret.setLabel(exam.getLabel());
            ret.setName(exam.getName() == null || exam.getName().isEmpty() ? null : exam.getName());
            ret.setExamSeating(exam.getSeatingType() == 1);
            ret.setSize(exam.getExamSize());
            ret.setSizeUseLimitInsteadOfEnrollment(ApplicationProperty.ExaminationSizeUseLimitInsteadOfEnrollment.isTrue(examType.getReference(), examType.getType() != 0));
            ret.setMaxRooms(exam.getMaxNbrRooms());
            ret.setPrintOffset(exam.getPrintOffset());
            ret.setNotes(exam.getNote());
            ret.setLength(exam.getLength());
            for (DepartmentalInstructor instr : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                ret.addExamInstructor(new PrefGroupEditInterface.IdLabel(instr.getUniqueId(), nameFormat.format(instr), instr.getDepartment().getDeptCode()));
            }
            TreeSet<DepartmentalInstructor> instructors = null;
            instructors = ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue() ? new TreeSet<DepartmentalInstructor>(new DepartmentalInstructorComparator(nameFormat)) : new TreeSet<DepartmentalInstructor>(new DepartmentalInstructorComparator());
            HashSet<Long> deptIds = new HashSet<Long>();
            block24: for (ExamOwner owner : new TreeSet<ExamOwner>(exam.getOwners())) {
                obj = new ExamsInterface.ExamObjectInterface();
                obj.setSubject(owner.getCourse().getSubjectAreaAbbv());
                obj.setSubjectId(owner.getCourse().getSubjectArea().getUniqueId());
                obj.setCourse(owner.getCourse().getCourseNumberWithTitle());
                obj.setCourseId(owner.getCourse().getUniqueId());
                switch (owner.getOwnerType()) {
                    case 0: {
                        obj.setSubpartId(-9223372036854775807L);
                        obj.setSubpart(MSG.examTypeOffering());
                        break;
                    }
                    case 1: {
                        obj.setSubpartId(Long.MIN_VALUE);
                        obj.setSubpart(MSG.examTypeCourse());
                        break;
                    }
                    case 2: {
                        config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(owner.getOwnerId());
                        if (config == null) continue block24;
                        obj.setSubpartId(-config.getUniqueId().longValue());
                        obj.setSubpart(ExamEditBackend.getConfigLabel(config));
                        break;
                    }
                    case 3: {
                        Class_ clazz = (Class_)Class_DAO.getInstance().get(owner.getOwnerId());
                        if (clazz == null) continue block24;
                        obj.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                        obj.setSubpart(ExamEditBackend.getSubpartLabel(clazz.getSchedulingSubpart()));
                        obj.setClassId(clazz.getUniqueId());
                        obj.setClazz(ExamEditBackend.getClassLabel(clazz, owner.getCourse()));
                    }
                }
                ret.addExamObject(obj);
                if (!deptIds.add(owner.getCourse().getSubjectArea().getDepartment().getUniqueId())) continue;
                instructors.addAll(hibSession.createQuery("from DepartmentalInstructor where department.uniqueId = :deptId", DepartmentalInstructor.class).setParameter("deptId", (Object)owner.getCourse().getSubjectArea().getDepartment().getUniqueId()).list());
            }
            for (DepartmentalInstructor instr : instructors) {
                ret.addInstructor(instr.getUniqueId(), nameFormat.format(instr), instr.getDepartment().getDeptCode());
            }
        } else {
            Object maxRoomsParam;
            TreeSet<ExamPeriod> periods;
            ret.setExamSeating(true);
            if (examType != null && !(periods = ExamPeriod.findAll(context.getUser().getCurrentAcademicSessionId(), examType)).isEmpty()) {
                ret.setLength(Constants.SLOT_LENGTH_MIN * periods.first().getLength());
            }
            if ((maxRoomsParam = SolverParameterDef.findByNameType("Exams.MaxRooms", SolverParameterGroup.SolverType.EXAM)) != null && ((SolverParameterDef)maxRoomsParam).getDefault() != null) {
                ret.setMaxRooms(Integer.valueOf(((SolverParameterDef)maxRoomsParam).getDefault()));
            }
            if (request.getFirstType() != null && request.getFirstId() != null) {
                String firstType = request.getFirstType();
                Long firstId = Long.valueOf(request.getFirstId());
                CourseOffering course = null;
                obj = new ExamsInterface.ExamObjectInterface();
                if ("Class_".equals(firstType)) {
                    Class_ clazz = (Class_)new Class_DAO().get(firstId);
                    course = clazz.getSchedulingSubpart().getControllingCourseOffering();
                    obj.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                    obj.setSubpart(ExamEditBackend.getSubpartLabel(clazz.getSchedulingSubpart()));
                    obj.setClassId(clazz.getUniqueId());
                    obj.setClazz(ExamEditBackend.getClassLabel(clazz, course));
                } else if ("SchedulingSubpart".equals(firstType)) {
                    SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(firstId);
                    InstrOfferingConfig config = subpart.getInstrOfferingConfig();
                    course = config.getControllingCourseOffering();
                    obj.setSubpartId(subpart.getUniqueId());
                    obj.setSubpart(ExamEditBackend.getSubpartLabel(subpart));
                } else if ("InstrOfferingConfig".equals(firstType)) {
                    config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(firstId);
                    course = config.getControllingCourseOffering();
                    obj.setSubpartId(-config.getUniqueId().longValue());
                    obj.setSubpart(ExamEditBackend.getConfigLabel(config));
                } else if ("InstructionalOffering".equals(firstType)) {
                    InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(firstId);
                    course = offering.getControllingCourseOffering();
                    obj.setSubpartId(-9223372036854775807L);
                    obj.setSubpart(MSG.examTypeOffering());
                } else if ("CourseOffering".equals(firstType)) {
                    course = (CourseOffering)CourseOfferingDAO.getInstance().get(firstId);
                    obj.setSubpartId(Long.MIN_VALUE);
                    obj.setSubpart(MSG.examTypeCourse());
                }
                if (course != null) {
                    obj.setSubject(course.getSubjectAreaAbbv());
                    obj.setSubjectId(course.getSubjectArea().getUniqueId());
                    obj.setCourse(course.getCourseNumberWithTitle());
                    obj.setCourseId(course.getUniqueId());
                    ret.addExamObject(obj);
                    TreeSet<DepartmentalInstructor> instructors = null;
                    instructors = ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue() ? new TreeSet<DepartmentalInstructor>(new DepartmentalInstructorComparator(nameFormat)) : new TreeSet<DepartmentalInstructor>(new DepartmentalInstructorComparator());
                    instructors.addAll(hibSession.createQuery("from DepartmentalInstructor where department.uniqueId = :deptId", DepartmentalInstructor.class).setParameter("deptId", (Object)course.getSubjectArea().getDepartment().getUniqueId()).list());
                    for (DepartmentalInstructor instr : instructors) {
                        ret.addInstructor(instr.getUniqueId(), nameFormat.format(instr), instr.getDepartment().getDeptCode());
                    }
                }
            }
        }
        if (examType != null) {
            ret.setExamType(new PrefGroupEditInterface.IdLabel(examType.getUniqueId(), examType.getLabel(), examType.getReference()));
            if (exam == null) {
                ret.setPeriodPreferences(new PeriodPreferencesBackend().loadExamPeriodPreferences(this.examinationSolverService.getSolver(), exam, examType, context));
                for (ExamType type : ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamEdit)) {
                    ret.addExamType(type.getUniqueId(), type.getLabel(), type.getReference());
                }
            }
        }
        this.fillInPreferences(ret, exam, examType, ret.isExamSeating(), context);
        if (request.getOperation() == PrefGroupEditInterface.Operation.CLONE_EXAM) {
            ret.setId(null);
            if (ret.hasPeriodPreferences()) {
                ret.getPeriodPreferences().setPattern("");
            }
        }
        if (exam != null && ret.getId() != null) {
            Long prevId;
            BackTracker.markForBack(context, "examination?id=" + exam.getUniqueId(), MSG.backExam(exam.getLabel()), true, false);
            Long nextId = Navigation.getNext(context, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
            if (nextId != null && context.hasPermission(nextId, Right.ExaminationEdit)) {
                ret.setNextId(nextId);
            }
            if ((prevId = Navigation.getPrevious(context, Navigation.sInstructionalOfferingLevel, exam.getUniqueId())) != null && context.hasPermission(prevId, Right.ExaminationEdit)) {
                ret.setPreviousId(prevId);
            }
        }
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser(), true)) {
            ret.addSubject(subject.getUniqueId(), subject.getSubjectAreaAbbreviation(), subject.getLabel());
        }
        BackTracker.BackItem back = BackTracker.getBackItem(context, 2);
        if (back != null) {
            ret.setBackTitle(back.getTitle());
            if (exam != null) {
                ret.setBackUrl(back.getUrl() + (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + exam.getUniqueId() + "&backType=PreferenceGroup");
            } else {
                ret.setBackUrl(back.getUrl());
            }
        }
        return ret;
    }

    public void fillInPreferences(PrefGroupEditInterface.PrefGroupEditResponse response, Exam pg, ExamType et, boolean examSeating, SessionContext context) {
        if (pg != null) {
            response.setNbrRooms(1);
            ClassEditBackend.fillInPreferences(response, pg, context, examSeating);
            RoomInterface.PeriodPreferenceModel model = new PeriodPreferencesBackend().loadExamPeriodPreferences(this.examinationSolverService.getSolver(), pg, pg.getExamType(), context);
            response.setPeriodPreferences(model);
        } else if (et != null) {
            List<RoomGroup> list;
            List<GlobalRoomFeature> roomFeatures;
            ClassEditBackend.fillInPreferenceLevels(response, pg, context);
            PrefGroupEditInterface.Preferences roomPrefs = response.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM);
            if (roomPrefs == null) {
                roomPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.ROOM);
                response.addRoomPreference(roomPrefs);
                roomPrefs.setAllowHard(true);
            } else if (roomPrefs.hasItems()) {
                roomPrefs.getItems().clear();
            }
            PrefGroupEditInterface.Preferences bldgPrefs = response.getRoomPreference(PrefGroupEditInterface.PreferenceType.BUILDING);
            if (bldgPrefs == null) {
                bldgPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.BUILDING);
                bldgPrefs.setAllowHard(true);
                response.addRoomPreference(bldgPrefs);
            } else if (bldgPrefs.hasItems()) {
                bldgPrefs.getItems().clear();
            }
            PrefGroupEditInterface.Preferences rfPrefs = response.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM_FEATURE);
            if (rfPrefs == null) {
                rfPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.ROOM_FEATURE);
                rfPrefs.setAllowHard(true);
                response.addRoomPreference(rfPrefs);
            } else if (rfPrefs.hasItems()) {
                rfPrefs.getItems().clear();
            }
            PrefGroupEditInterface.Preferences groupPrefs = response.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM_GROUP);
            if (groupPrefs == null) {
                groupPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.ROOM_GROUP);
                groupPrefs.setAllowHard(true);
                response.addRoomPreference(groupPrefs);
            } else if (groupPrefs.hasItems()) {
                groupPrefs.getItems().clear();
            }
            TreeSet<Location> rooms = Location.findAllExamLocations(context.getUser().getCurrentAcademicSessionId(), et);
            TreeSet<Building> buildings = new TreeSet<Building>();
            if (!rooms.isEmpty()) {
                for (Location location : rooms) {
                    roomPrefs.addItem(location.getUniqueId(), examSeating ? location.getLabelWithExamCapacity() : location.getLabelWithCapacity(), location.getDisplayName());
                    if (!(location instanceof Room)) continue;
                    buildings.add(((Room)location).getBuilding());
                }
            }
            if (!buildings.isEmpty()) {
                for (Building building : buildings) {
                    bldgPrefs.addItem(building.getUniqueId(), building.getAbbrName(), null);
                }
            }
            if (!(roomFeatures = RoomFeature.getAllGlobalRoomFeatures(context.getUser().getCurrentAcademicSessionId())).isEmpty()) {
                for (RoomFeature roomFeature : roomFeatures) {
                    rfPrefs.addItem(roomFeature.getUniqueId(), roomFeature.getLabelWithType(), roomFeature.getDescription());
                }
            }
            if (!(list = RoomGroup.getAllGlobalRoomGroups(context.getUser().getCurrentAcademicSessionId())).isEmpty()) {
                for (RoomGroup group : list) {
                    groupPrefs.addItem(group.getUniqueId(), group.getNameWithTitle(), group.getDescription());
                }
            }
            if (roomPrefs.hasSelections()) {
                Iterator<PrefGroupEditInterface.Selection> iterator = roomPrefs.getSelections().iterator();
                while (iterator.hasNext()) {
                    if (roomPrefs.getItem(iterator.next().getItem()) != null) continue;
                    iterator.remove();
                }
            }
            if (bldgPrefs.hasSelections()) {
                Iterator<PrefGroupEditInterface.Selection> iterator = bldgPrefs.getSelections().iterator();
                while (iterator.hasNext()) {
                    if (bldgPrefs.getItem(iterator.next().getItem()) != null) continue;
                    iterator.remove();
                }
            }
            if (rfPrefs.hasSelections()) {
                Iterator<PrefGroupEditInterface.Selection> iterator = rfPrefs.getSelections().iterator();
                while (iterator.hasNext()) {
                    if (rfPrefs.getItem(iterator.next().getItem()) != null) continue;
                    iterator.remove();
                }
            }
            if (groupPrefs.hasSelections()) {
                Iterator<PrefGroupEditInterface.Selection> iterator = groupPrefs.getSelections().iterator();
                while (iterator.hasNext()) {
                    if (groupPrefs.getItem(iterator.next().getItem()) != null) continue;
                    iterator.remove();
                }
            }
            RoomInterface.PeriodPreferenceModel periodPreferenceModel = new PeriodPreferencesBackend().loadExamPeriodPreferences(null, null, et, context);
            response.setPeriodPreferences(periodPreferenceModel);
        }
    }

    protected static String getConfigLabel(InstrOfferingConfig c) {
        return c.getName() + (String)(c.getInstructionalMethod() == null ? "" : " (" + c.getInstructionalMethod().getLabel() + ")");
    }

    protected static String getSubpartLabel(SchedulingSubpart s) {
        Object name = s.getItype().getAbbv();
        while (s.getParentSubpart() != null) {
            name = "\u00a0\u00a0" + (String)name;
            s = s.getParentSubpart();
        }
        if (s.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
            name = (String)name + " [" + s.getInstrOfferingConfig().getName() + "]";
        }
        return name;
    }

    protected static String getClassLabel(Class_ c, CourseOffering co) {
        String extId = c.getClassSuffix(co);
        return c.getSectionNumberString() + (String)(extId == null || extId.isEmpty() || extId.equalsIgnoreCase(c.getSectionNumberString()) ? "" : " - " + extId);
    }

    @GwtRpcImplements(value=ExamsInterface.ExamLookupClasses.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupClassesBackend
    implements GwtRpcImplementation<ExamsInterface.ExamLookupClasses, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(ExamsInterface.ExamLookupClasses request, SessionContext context) {
            CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourseId());
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
            classes.addAll(new Class_DAO().getSession().createQuery("select distinct c from Class_ c where c.schedulingSubpart.uniqueId=:schedulingSubpartId", Class_.class).setFetchSize(200).setCacheable(true).setParameter("schedulingSubpartId", (Object)request.getSubpartId()).list());
            for (Class_ c : classes) {
                ret.add(new PrefGroupEditInterface.IdLabel(c.getUniqueId(), ExamEditBackend.getClassLabel(c, course), null));
            }
            return ret;
        }
    }

    @GwtRpcImplements(value=ExamsInterface.ExamLookupSubparts.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupSubpartsBackend
    implements GwtRpcImplementation<ExamsInterface.ExamLookupSubparts, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(ExamsInterface.ExamLookupSubparts request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourseId());
            if (course.isIsControl().booleanValue()) {
                ret.add(new PrefGroupEditInterface.IdLabel(-9223372036854775807L, MSG.examTypeOffering(), null));
            }
            ret.add(new PrefGroupEditInterface.IdLabel(Long.MIN_VALUE, MSG.examTypeCourse(), null));
            TreeSet configs = new TreeSet(new InstrOfferingConfigComparator(null));
            configs.addAll(SchedulingSubpartDAO.getInstance().getSession().createQuery("select distinct c from InstrOfferingConfig c inner join c.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId", InstrOfferingConfig.class).setFetchSize(200).setCacheable(true).setParameter("courseOfferingId", (Object)request.getCourseId()).list());
            if (!configs.isEmpty()) {
                ret.add(new PrefGroupEditInterface.IdLabel(-9223372036854775806L, MSG.sctOwnerTypeConfigurations(), null));
                for (InstrOfferingConfig c : configs) {
                    ret.add(new PrefGroupEditInterface.IdLabel(-c.getUniqueId().longValue(), ExamEditBackend.getConfigLabel(c), null));
                }
            }
            TreeSet subparts = new TreeSet(new SchedulingSubpartComparator(null));
            subparts.addAll(SchedulingSubpartDAO.getInstance().getSession().createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId", SchedulingSubpart.class).setFetchSize(200).setCacheable(true).setParameter("courseOfferingId", (Object)request.getCourseId()).list());
            if (!subparts.isEmpty()) {
                ret.add(new PrefGroupEditInterface.IdLabel(-9223372036854775805L, MSG.sctOwnerTypeSubparts(), null));
                for (SchedulingSubpart s : subparts) {
                    ret.add(new PrefGroupEditInterface.IdLabel(s.getUniqueId(), ExamEditBackend.getSubpartLabel(s), null));
                }
            }
            return ret;
        }
    }

    @GwtRpcImplements(value=ExamsInterface.ExamLookupCourses.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupCoursesBackend
    implements GwtRpcImplementation<ExamsInterface.ExamLookupCourses, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(ExamsInterface.ExamLookupCourses request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            List courseNumbers = CourseOfferingDAO.getInstance().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ", Object[].class).setFetchSize(200).setCacheable(true).setParameter("subjectAreaId", (Object)request.getSubjectId()).list();
            for (Object[] o : courseNumbers) {
                ret.add(new PrefGroupEditInterface.IdLabel((Long)o[0], o[1].toString() + (String)(o[2] == null || o[2].toString().isEmpty() ? "" : " - " + String.valueOf(o[2])), null));
            }
            return ret;
        }
    }
}

