/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=ExamsInterface.ExamDistributionsRequest.class)
public class ExamDistributionsBackend
implements GwtRpcImplementation<ExamsInterface.ExamDistributionsRequest, OfferingsInterface.DistributionsResponse> {
    protected static ExaminationMessages MESSAGES = Localization.create(ExaminationMessages.class);

    @Override
    public OfferingsInterface.DistributionsResponse execute(ExamsInterface.ExamDistributionsRequest request, SessionContext context) {
        context.checkPermission(Right.ExaminationDistributionPreferences);
        String examType = request.getFilter().getParameterValue("examType");
        ExamType type = null;
        try {
            type = (ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(examType));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = ExamType.findByReference(examType);
        }
        if (type == null) {
            throw new GwtRpcException(MESSAGES.messageNoExamType());
        }
        String subjectArea = request.getFilter().getParameterValue("subjectArea");
        if (subjectArea == null || subjectArea.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorNoSubjectAreaSelected());
        }
        DistributionsTableBuilder builder = new DistributionsTableBuilder(context, request.getBackType(), request.getBackId());
        for (FilterInterface.FilterParameterInterface p : request.getFilter().getParameters()) {
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if (p.getValue() == null) continue;
            context.getUser().setProperty("Distributions." + p.getName(), p.getValue());
        }
        OfferingsInterface.DistributionsResponse response = new OfferingsInterface.DistributionsResponse();
        TableInterface table = builder.getExamDistPrefsTableForFilter(request.getFilter(), type);
        table.setName(MESSAGES.sectionDistributionPreferences(type.getLabel()));
        response.addTable(table);
        BackTracker.markForBack(context, "examDistributions", MESSAGES.backgroundDistributionPreferences(), true, true);
        return response;
    }
}

