/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;
import org.unitime.timetable.util.Formats;

public class ListEnrollments
extends WaitlistedOnlineSectioningAction<List<ClassAssignmentInterface.Enrollment>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iOfferingId;
    private Long iSectionId;
    private boolean iCanShowExtIds = false;
    private boolean iCanRegister = false;
    private boolean iCanUseAssistant = false;
    protected boolean iIsAdmin = false;
    protected boolean iIsAdvisor = false;
    protected boolean iCanEditMyStudents = false;
    protected boolean iCanEditOtherStudents = false;

    public ListEnrollments forOffering(Long offeringId) {
        this.iOfferingId = offeringId;
        return this;
    }

    public ListEnrollments withSection(Long sectionId) {
        this.iSectionId = sectionId;
        return this;
    }

    public ListEnrollments canShowExternalIds(boolean canShowExtIds) {
        this.iCanShowExtIds = canShowExtIds;
        return this;
    }

    public ListEnrollments canRegister(boolean canRegister) {
        this.iCanRegister = canRegister;
        return this;
    }

    public ListEnrollments canUseAssistant(boolean canUseAssistant) {
        this.iCanUseAssistant = canUseAssistant;
        return this;
    }

    public ListEnrollments withPermissions(boolean isAdmin, boolean isAdvisor, boolean canEditMyStudents, boolean canEditOtherStudents) {
        this.iIsAdmin = isAdmin;
        this.iIsAdvisor = isAdvisor;
        this.iCanEditMyStudents = canEditMyStudents;
        this.iCanEditOtherStudents = canEditOtherStudents;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    @Override
    public List<ClassAssignmentInterface.Enrollment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            ArrayList<ClassAssignmentInterface.Enrollment> enrollments = new ArrayList<ClassAssignmentInterface.Enrollment>();
            XOffering offering = server.getOffering(this.iOfferingId);
            DistanceMetric m = server.getDistanceMetric();
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
            XExpectations expectations = server.getExpectations(this.iOfferingId);
            HashSet<String> regStates = new HashSet<String>();
            HashSet<String> assStates = new HashSet<String>();
            HashSet<String> wlStates = new HashSet<String>();
            HashSet<String> noSubStates = new HashSet<String>();
            AcademicSessionInfo session = server.getAcademicSession();
            Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
            for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
                if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.enabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.admin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.advisor)) {
                    assStates.add(status.getReference());
                }
                if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regenabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadmin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadvisor)) {
                    regStates.add(status.getReference());
                }
                if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.waitlist)) {
                    wlStates.add(status.getReference());
                    continue;
                }
                if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.nosubs)) continue;
                noSubStates.add(status.getReference());
            }
            XEnrollments requests = server.getEnrollments(this.iOfferingId);
            for (XCourseRequest request : requests.getRequests()) {
                XEnrollment enrollment = request.getEnrollment();
                if (this.iSectionId != null && (enrollment == null || !enrollment.getSectionIds().contains(this.iSectionId))) continue;
                for (XCourse course : offering.getCourses()) {
                    if (!request.getCourseIds().contains(course) || enrollment != null && !course.getCourseId().equals(enrollment.getCourseId())) continue;
                    XStudent student = server.getStudent(request.getStudentId());
                    String status = student.getStatus();
                    if (status == null) {
                        status = session.getDefaultSectioningStatus();
                    }
                    OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
                    if (status == null || wlStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.WaitList;
                    } else if (noSubStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                    }
                    if (enrollment == null && !student.canAssign(request, wl)) continue;
                    ClassAssignmentInterface.Enrollment e = new ClassAssignmentInterface.Enrollment();
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    st.setId(student.getStudentId());
                    st.setSessionId(server.getAcademicSession().getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setWaitListMode(wl);
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setName(student.getName());
                    for (XAreaClassificationMajor acm : student.getMajors()) {
                        st.addArea(acm.getArea(), acm.getAreaLabel());
                        st.addClassification(acm.getClassification(), acm.getClassificationLabel());
                        st.addMajor(acm.getMajor(), acm.getMajorLabel());
                        st.addConcentration(acm.getConcentration(), acm.getConcentrationLabel());
                        st.addDegree(acm.getDegree(), acm.getDegreeLabel());
                        st.addProgram(acm.getProgram(), acm.getProgramLabel());
                        st.addCampus(acm.getCampus(), acm.getCampusLabel());
                    }
                    st.setDefaultCampus(server.getAcademicSession().getCampus());
                    for (XAreaClassificationMajor acm : student.getMinors()) {
                        st.addMinor(acm.getMajor(), acm.getMajorLabel());
                    }
                    for (XStudent.XGroup gr : student.getGroups()) {
                        st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
                    }
                    for (XStudent.XGroup acc : student.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation(), acc.getTitle());
                    }
                    for (Object a : student.getAdvisors()) {
                        if (((XStudent.XAdvisor)a).getName() == null) continue;
                        st.addAdvisor(((XStudent.XAdvisor)a).getName());
                    }
                    e.setStudent(st);
                    e.setPriority(1 + request.getPriority());
                    ClassAssignmentInterface.CourseAssignment c = new ClassAssignmentInterface.CourseAssignment();
                    c.setCourseId(course.getCourseId());
                    c.setSubject(course.getSubjectArea());
                    c.setCourseNbr(course.getCourseNumber());
                    c.setTitle(course.getTitle());
                    c.setParentCourseId(course.getParentCourseId());
                    c.setHasCrossList(offering.hasCrossList());
                    c.setCanWaitList(offering.isWaitList());
                    e.setCourse(c);
                    e.setWaitList(request.isWaitlist());
                    e.setNoSub(request.isNoSub());
                    if (!request.getCourseIds().get(0).equals(course)) {
                        e.setAlternative(request.getCourseIds().get(0).getCourseName());
                    }
                    if (request.isAlternative()) {
                        Object a;
                        a = student.getRequests().iterator();
                        while (a.hasNext()) {
                            XRequest r = (XRequest)a.next();
                            if (!(r instanceof XCourseRequest) || r.isAlternative() || ((XCourseRequest)r).getEnrollment() != null) continue;
                            e.setAlternative(((XCourseRequest)r).getCourseIds().get(0).getCourseName());
                        }
                    }
                    if (request.getTimeStamp() != null) {
                        e.setRequestedDate(request.getTimeStamp());
                    }
                    e.setCritical(request.getCritical());
                    if (request.getWaitListedTimeStamp() != null && request.getEnrollment() == null) {
                        e.setWaitListedDate(request.getWaitListedTimeStamp());
                    }
                    e.setWaitListedPosition(this.getWaitListPosition(offering, student, request, course, server, helper));
                    if (student.isEnrolled(request.getWaitListSwapWithCourseOffering())) {
                        e.setWaitListedReplacement(request.getWaitListSwapWithCourseOffering().getCourseName());
                    }
                    if (enrollment == null) {
                        XOverride override;
                        e.setEnrollmentMessage(request.getEnrollmentMessage());
                        if (request.hasOverrides() && (override = request.getOverride(course)) != null && override.getStatus() != null) {
                            switch (CourseRequest.CourseRequestOverrideStatus.values()[override.getStatus()]) {
                                case PENDING: {
                                    e.addEnrollmentMessage(MSG.overridePendingShort(course.getCourseName()));
                                    break;
                                }
                                case REJECTED: {
                                    e.addEnrollmentMessage(MSG.overrideRejectedWaitList(course.getCourseName()));
                                    break;
                                }
                                case CANCELLED: {
                                    e.addEnrollmentMessage(MSG.overrideCancelledWaitList(course.getCourseName()));
                                    break;
                                }
                                case NOT_CHECKED: {
                                    e.addEnrollmentMessage(MSG.overrideNotRequested());
                                    break;
                                }
                                case NOT_NEEDED: {
                                    e.addEnrollmentMessage(MSG.overrideNotNeeded(course.getCourseName()));
                                }
                            }
                        }
                        if (student.getMaxCreditOverride() != null && student.getMaxCreditOverride().getStatus() != null && student.getMaxCredit() != null && course.hasCredit()) {
                            float credit = 0.0f;
                            for (XRequest r : student.getRequests()) {
                                if (!(r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() == null) continue;
                                credit += ((XCourseRequest)r).getEnrollment().getCredit(server);
                            }
                            if (credit + course.getMinCredit().floatValue() > student.getMaxCredit().floatValue()) {
                                switch (CourseRequest.CourseRequestOverrideStatus.values()[student.getMaxCreditOverride().getStatus()]) {
                                    case PENDING: {
                                        e.addEnrollmentMessage(MSG.creditStatusPendingShort());
                                        break;
                                    }
                                    case REJECTED: {
                                        e.addEnrollmentMessage(MSG.creditStatusDenied());
                                        break;
                                    }
                                    case CANCELLED: {
                                        e.addEnrollmentMessage(MSG.creditStatusCancelledWaitList());
                                        break;
                                    }
                                    case NOT_CHECKED: {
                                        e.addEnrollmentMessage(MSG.overrideNotRequested());
                                    }
                                }
                            }
                        }
                        if (request.isWaitlist(wl) && offering.isWaitList()) {
                            AssignmentMap assignment = new AssignmentMap();
                            CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, request, server, wl, helper);
                            List enrls = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                                @Override
                                public int compare(Enrollment o1, Enrollment o2) {
                                    return o1.getRequest().compareTo(o2.getRequest());
                                }
                            });
                            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                            Iterator<Object> noConfEnrl = null;
                            for (Object enrl : enrls) {
                                if (!course.getCourseId().equals(enrl.getCourse().getId())) continue;
                                boolean overlaps = false;
                                for (Object q : enrl.getStudent().getRequests()) {
                                    if (q.equals((Object)request)) continue;
                                    Enrollment x = (Enrollment)assignment.getValue((Variable)q);
                                    if (q instanceof FreeTimeRequest) {
                                        if (!GetAssignment.isFreeTimeOverlapping((FreeTimeRequest)q, (Enrollment)enrl)) continue;
                                        overlaps = true;
                                        overlap.add(((FreeTimeRequest)q).createEnrollment());
                                        continue;
                                    }
                                    if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                    for (SctAssignment a : x.getAssignments()) {
                                        if (!a.isOverlapping(enrl.getAssignments())) continue;
                                        overlaps = true;
                                        overlap.add(x);
                                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                                        CourseRequest cr = (CourseRequest)x.getRequest();
                                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                        if (ss == null) {
                                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                                            overlapingSections.put(cr, ss);
                                        }
                                        ss.add((Section)a);
                                    }
                                }
                                if (overlaps || noConfEnrl != null) continue;
                                noConfEnrl = enrl;
                            }
                            if (noConfEnrl == null) {
                                Object enrl;
                                TreeSet<String> overlaps = new TreeSet<String>();
                                enrl = overlap.iterator();
                                while (enrl.hasNext()) {
                                    Enrollment q = (Enrollment)enrl.next();
                                    if (q.getRequest() instanceof FreeTimeRequest) {
                                        overlaps.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                        continue;
                                    }
                                    CourseRequest cr = (CourseRequest)q.getRequest();
                                    Course o = q.getCourse();
                                    Object ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                    if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                        Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                        while (i.hasNext()) {
                                            Section s = (Section)i.next();
                                            ov = (String)ov + " " + s.getSubpart().getName();
                                            if (!i.hasNext()) continue;
                                            ov = (String)ov + ",";
                                        }
                                    }
                                    overlaps.add((String)ov);
                                }
                                if (overlaps != null && !overlaps.isEmpty()) {
                                    Object message = null;
                                    Iterator i = overlaps.iterator();
                                    while (i.hasNext()) {
                                        String ov = (String)i.next();
                                        if (message == null) {
                                            message = MSG.conflictWithFirst(ov);
                                            continue;
                                        }
                                        if (i.hasNext()) {
                                            message = (String)message + MSG.conflictWithMiddle(ov);
                                            continue;
                                        }
                                        message = (String)message + MSG.conflictWithLast(ov);
                                    }
                                    e.addEnrollmentMessage(message + ".");
                                }
                            }
                        }
                    }
                    if (enrollment != null) {
                        if (enrollment.getReservation() != null) {
                            switch (enrollment.getReservation().getType()) {
                                case Course: {
                                    e.setReservation(MSG.reservationCourse());
                                    break;
                                }
                                case Curriculum: 
                                case CurriculumOverride: {
                                    e.setReservation(MSG.reservationCurriculum());
                                    break;
                                }
                                case Group: 
                                case GroupOverride: {
                                    e.setReservation(MSG.reservationGroup());
                                    break;
                                }
                                case Individual: 
                                case IndividualOverride: {
                                    e.setReservation(MSG.reservationIndividual());
                                    break;
                                }
                                case LearningCommunity: {
                                    e.setReservation(MSG.reservationLearningCommunity());
                                    break;
                                }
                                case Universal: {
                                    e.setReservation(MSG.reservationUniversal());
                                }
                            }
                        }
                        e.setEnrolledDate(request.getEnrollment().getTimeStamp());
                        if (request.getEnrollment().getApproval() != null) {
                            e.setApprovedDate(request.getEnrollment().getApproval().getTimeStamp());
                            e.setApprovedBy(request.getEnrollment().getApproval().getName());
                        }
                        for (Long sectionId : request.getEnrollment().getSectionIds()) {
                            String consent;
                            XSection section = offering.getSection(sectionId);
                            ClassAssignmentInterface.ClassAssignment a = e.getCourse().addClassAssignment();
                            a.setAlternative(request.isAlternative());
                            a.setClassId(section.getSectionId());
                            XSubpart subpart = offering.getSubpart(section.getSubpartId());
                            a.setSubpart(subpart.getName());
                            a.setSection(section.getName(course.getCourseId()));
                            a.setExternalId(section.getExternalId(c.getCourseId()));
                            a.setClassNumber(section.getName(-1L));
                            a.setCancelled(section.isCancelled());
                            a.setLimit(new int[]{requests.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                            if (section.getTime() != null) {
                                for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                    a.addDay(d.getIndex());
                                }
                                a.setStart(section.getTime().getSlot());
                                a.setLength(section.getTime().getLength());
                                a.setBreakTime(section.getTime().getBreakTime());
                                a.setDatePattern(section.getTime().getDatePatternName());
                            }
                            for (XRoom rm : section.getRooms()) {
                                a.addRoom(rm.getUniqueId(), rm.getName());
                            }
                            for (XInstructor instructor : section.getInstructors()) {
                                a.addInstructor(instructor.getName());
                                a.addInstructor(instructor.getEmail() == null ? "" : instructor.getEmail());
                            }
                            if (section.getParentId() != null) {
                                a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                            }
                            a.setSubpartId(section.getSubpartId());
                            a.addNote(course.getNote());
                            a.addNote(section.getNote());
                            a.setCredit(subpart.getCredit(course.getCourseId()));
                            a.setCreditRange(Float.valueOf(subpart.getCreditMin(course.getCourseId())), Float.valueOf(subpart.getCreditMax(course.getCourseId())));
                            Float creditOverride = section.getCreditOverride(c.getCourseId());
                            if (creditOverride != null) {
                                a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                            }
                            int dist = 0;
                            Object from = null;
                            TreeSet<String> overlap = new TreeSet<String>();
                            for (Object q : student.getRequests()) {
                                XEnrollment otherEnrollment;
                                if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                                XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                    XSubpart otherSubpart;
                                    XCourse otherCourse;
                                    if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                    int d = otherSection.getDistanceInMinutes(section, m);
                                    if (d > dist) {
                                        dist = d;
                                        from = "";
                                        Iterator<XRoom> k = otherSection.getRooms().iterator();
                                        while (k.hasNext()) {
                                            from = (String)from + k.next().getName() + (k.hasNext() ? ", " : "");
                                        }
                                        from = (String)from + " (" + otherEnrollment.getCourseName() + " " + otherSection.getSubpartName() + " " + otherSection.getName(otherEnrollment.getCourseId()) + ")";
                                    }
                                    if (otherSection.isDistanceConflict(student, section, m)) {
                                        a.setDistanceConflict(true);
                                        a.setLongDistanceConflict(otherSection.isLongDistanceConflict(student, section, m));
                                    }
                                    if (section.getTime() != null && section.getTime().hasIntersection(otherSection.getTime()) && !section.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) {
                                        otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                        otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                                        overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                                    }
                                    if (!otherSection.isHardDistanceConflict(student, section, m)) continue;
                                    otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                    otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                                    overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                                }
                            }
                            if (!overlap.isEmpty()) {
                                Object note = null;
                                Iterator j = overlap.iterator();
                                while (j.hasNext()) {
                                    String n = (String)j.next();
                                    if (note == null) {
                                        note = MSG.noteAllowedOverlapFirst(n);
                                        continue;
                                    }
                                    if (j.hasNext()) {
                                        note = (String)note + MSG.noteAllowedOverlapMiddle(n);
                                        continue;
                                    }
                                    note = (String)note + MSG.noteAllowedOverlapLast(n);
                                }
                                a.setOverlapNote((String)note);
                            }
                            a.setBackToBackDistance(dist);
                            a.setBackToBackRooms((String)from);
                            a.setSaved(true);
                            if (a.getParentSection() == null && (consent = server.getCourse(course.getCourseId()).getConsentLabel()) != null) {
                                if (request.getEnrollment().getApproval() != null) {
                                    a.setParentSection(MSG.consentApproved(df.format(request.getEnrollment().getApproval().getTimeStamp())));
                                } else {
                                    a.setParentSection(MSG.consentWaiting(consent.toLowerCase()));
                                }
                            }
                            a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                        }
                    }
                    enrollments.add(e);
                }
            }
            ArrayList<ClassAssignmentInterface.Enrollment> arrayList = enrollments;
            return arrayList;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "list-enrollments";
    }
}

