/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.Reservation;

@MappedSuperclass
public abstract class BaseCourseReservation
extends Reservation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CourseOffering iCourse;

    public BaseCourseReservation() {
    }

    public BaseCourseReservation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_id", nullable=false)
    public CourseOffering getCourse() {
        return this.iCourse;
    }

    public void setCourse(CourseOffering course) {
        this.iCourse = course;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseReservation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseReservation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseReservation)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "CourseReservation[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "CourseReservation[\n\tCourse: " + String.valueOf(this.getCourse()) + "\n\tExpirationDate: " + String.valueOf(this.getExpirationDate()) + "\n\tInclusive: " + this.getInclusive() + "\n\tInstructionalOffering: " + String.valueOf(this.getInstructionalOffering()) + "\n\tLimit: " + this.getLimit() + "\n\tStartDate: " + String.valueOf(this.getStartDate()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

