/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

public class RoomFilterBox
extends UniTimeFilterBox<EventInterface.RoomFilterRpcRequest> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private ListBox iBuildings;
    private ListBox iDepartments = new ListBox();
    private TextBox iMin;
    private TextBox iMax;
    private FilterBox.Chip iLastSize = null;
    private FilterBox.CustomFilter iDepartmentFilter;

    public RoomFilterBox(AcademicSessionProvider session) {
        this(session, true);
    }

    public RoomFilterBox(AcademicSessionProvider session, boolean init) {
        super(session, init);
        this.iDepartments.setMultipleSelect(false);
        this.iDepartments.setWidth("100%");
        this.iDepartmentFilter = new FilterBox.CustomFilter("department", MESSAGES.tagDepartment(), new Widget[]{this.iDepartments}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    String name;
                    FilterBox.Chip chip;
                    int i;
                    FilterBox.Chip oldChip = RoomFilterBox.this.getChip("department");
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (i = 0; i < RoomFilterBox.this.iDepartments.getItemCount(); ++i) {
                        chip = new FilterBox.Chip("department", RoomFilterBox.this.iDepartments.getValue(i)).withTranslatedCommand(MESSAGES.tagDepartment());
                        name = RoomFilterBox.this.iDepartments.getItemText(i);
                        if (RoomFilterBox.this.iDepartments.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase()) && !name.toLowerCase().contains(" (" + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                    }
                    if ("department".startsWith(text.toLowerCase()) && text.toLowerCase().length() >= 5) {
                        for (i = 0; i < RoomFilterBox.this.iDepartments.getItemCount(); ++i) {
                            chip = new FilterBox.Chip("department", RoomFilterBox.this.iDepartments.getValue(i)).withTranslatedCommand(MESSAGES.tagDepartment());
                            name = RoomFilterBox.this.iDepartments.getItemText(i);
                            if (chip.equals(oldChip)) continue;
                            suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                        }
                    }
                    callback.onSuccess(suggestions);
                }
            }

            @Override
            public void validate(String value, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("managed".equalsIgnoreCase(value)) {
                    translatedValue = MESSAGES.attrDepartmentManagedRooms();
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), value).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        };
        this.iDepartmentFilter.setVisible(false);
        this.addFilter(this.iDepartmentFilter);
        this.iDepartments.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FilterBox.Chip newChip;
                FilterBox.Chip oldChip = RoomFilterBox.this.getChip("department");
                FilterBox.Chip chip = newChip = RoomFilterBox.this.iDepartments.getSelectedIndex() <= 0 ? null : new FilterBox.Chip("department", RoomFilterBox.this.iDepartments.getValue(RoomFilterBox.this.iDepartments.getSelectedIndex())).withTranslatedCommand(MESSAGES.tagDepartment());
                if (oldChip != null) {
                    if (newChip == null) {
                        RoomFilterBox.this.removeChip(oldChip, true);
                    } else if (!oldChip.getValue().equals(newChip.getValue())) {
                        RoomFilterBox.this.removeChip(oldChip, false);
                        RoomFilterBox.this.addChip(newChip, true);
                    }
                } else if (newChip != null) {
                    RoomFilterBox.this.addChip(newChip, true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("type", MESSAGES.tagRoomType(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("feature", MESSAGES.tagRoomFeature(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("group", MESSAGES.tagRoomGroup(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("size", MESSAGES.tagRoomSize(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("flag", MESSAGES.tagRoomFlag(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("all".equalsIgnoreCase(text)) {
                    translatedValue = MESSAGES.attrFlagAllRooms();
                } else if ("event".equalsIgnoreCase(text)) {
                    translatedValue = MESSAGES.attrFlagEventRooms();
                } else if ("nearby".equalsIgnoreCase(text)) {
                    translatedValue = MESSAGES.attrFlagNearbyRooms();
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.iBuildings = new ListBox();
        this.iBuildings.setMultipleSelect(true);
        this.iBuildings.setWidth("100%");
        this.iBuildings.setVisibleItemCount(3);
        this.addFilter(new FilterBox.CustomFilter("building", MESSAGES.tagBuilding(), new Widget[]{this.iBuildings}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    String name;
                    FilterBox.Chip chip;
                    int i;
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (i = 0; i < RoomFilterBox.this.iBuildings.getItemCount(); ++i) {
                        chip = new FilterBox.Chip("building", RoomFilterBox.this.iBuildings.getValue(i)).withTranslatedCommand(MESSAGES.tagBuilding());
                        name = RoomFilterBox.this.iBuildings.getItemText(i);
                        if (RoomFilterBox.this.iBuildings.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip));
                    }
                    if ("building".startsWith(text.toLowerCase()) && text.toLowerCase().length() >= 5) {
                        for (i = 0; i < RoomFilterBox.this.iBuildings.getItemCount(); ++i) {
                            chip = new FilterBox.Chip("building", RoomFilterBox.this.iBuildings.getValue(i)).withTranslatedCommand(MESSAGES.tagBuilding());
                            name = RoomFilterBox.this.iBuildings.getItemText(i);
                            suggestions.add(new FilterBox.Suggestion(name, chip));
                        }
                    }
                    callback.onSuccess(suggestions);
                }
            }

            @Override
            public boolean isVisible() {
                return RoomFilterBox.this.iBuildings.getItemCount() > 0;
            }
        });
        this.iBuildings.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean changed = false;
                for (int i = 0; i < RoomFilterBox.this.iBuildings.getItemCount(); ++i) {
                    FilterBox.Chip chip = new FilterBox.Chip("building", RoomFilterBox.this.iBuildings.getValue(i)).withTranslatedCommand(MESSAGES.tagBuilding());
                    if (RoomFilterBox.this.iBuildings.isItemSelected(i)) {
                        if (RoomFilterBox.this.hasChip(chip)) continue;
                        RoomFilterBox.this.addChip(chip, false);
                        changed = true;
                        continue;
                    }
                    if (!RoomFilterBox.this.hasChip(chip)) continue;
                    RoomFilterBox.this.removeChip(chip, false);
                    changed = true;
                }
                if (changed) {
                    RoomFilterBox.this.fireValueChangeEvent();
                }
            }
        });
        Label l1 = new Label(MESSAGES.propMin());
        this.iMin = new TextBox();
        this.iMin.setStyleName("unitime-TextArea");
        this.iMin.setMaxLength(10);
        this.iMin.getElement().getStyle().setWidth(50.0, Style.Unit.PX);
        Label l2 = new Label(MESSAGES.propMax());
        l2.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.iMax = new TextBox();
        this.iMax.setMaxLength(10);
        this.iMax.getElement().getStyle().setWidth(50.0, Style.Unit.PX);
        this.iMax.setStyleName("unitime-TextArea");
        final CheckBox events = new CheckBox(MESSAGES.checkOnlyEventLocations());
        events.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        final CheckBox nearby = new CheckBox(MESSAGES.checkIncludeNearby());
        nearby.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.addFilter(new FilterBox.CustomFilter("other", MESSAGES.tagOther(), new Widget[]{l1, this.iMin, l2, this.iMax, events, nearby}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    if (MESSAGES.attrFlagNearbyRooms().toLowerCase().startsWith(text.toLowerCase()) || "nearby".startsWith(text.toLowerCase()) || MESSAGES.checkIncludeNearby().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkIncludeNearby(), new FilterBox.Chip("flag", "Nearby").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagNearbyRooms())));
                    } else if (MESSAGES.attrFlagAllRooms().toLowerCase().startsWith(text.toLowerCase()) || "all".startsWith(text.toLowerCase()) || MESSAGES.checkAllLocations().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkAllLocations(), new FilterBox.Chip("flag", "All").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagAllRooms()), new FilterBox.Chip("flag", "Event").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagEventRooms())));
                    } else if (MESSAGES.attrFlagEventRooms().toLowerCase().startsWith(text.toLowerCase()) || "event".startsWith(text.toLowerCase()) || MESSAGES.checkOnlyEventLocations().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkOnlyEventLocations(), new FilterBox.Chip("flag", "Event").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagEventRooms()), new FilterBox.Chip("flag", "All").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagAllRooms())));
                    } else {
                        FilterBox.Chip old = null;
                        for (FilterBox.Chip c : chips) {
                            if (!c.getCommand().equals("size")) continue;
                            old = c;
                            break;
                        }
                        try {
                            String number = text;
                            String prefix = "";
                            if (text.startsWith("<=") || text.startsWith(">=")) {
                                number = number.substring(2);
                                prefix = text.substring(0, 2);
                            } else if (text.startsWith("<") || text.startsWith(">")) {
                                number = number.substring(1);
                                prefix = text.substring(0, 1);
                            }
                            Integer.parseInt(number);
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                            if (prefix.isEmpty()) {
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", "<=" + text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", ">=" + text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                            }
                        }
                        catch (Exception number) {
                            // empty catch block
                        }
                        if (text.contains("..")) {
                            try {
                                String first = text.substring(0, text.indexOf(46));
                                String second = text.substring(text.indexOf("..") + 2);
                                Integer.parseInt(first);
                                Integer.parseInt(second);
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.iMin.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomFilterBox.this.sizeChanged(true);
            }
        });
        this.iMax.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomFilterBox.this.sizeChanged(true);
            }
        });
        this.iMin.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        RoomFilterBox.this.sizeChanged(false);
                    }
                });
            }
        });
        this.iMax.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        RoomFilterBox.this.sizeChanged(false);
                    }
                });
            }
        });
        this.iMin.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            RoomFilterBox.this.sizeChanged(false);
                        }
                    });
                }
            }
        });
        this.iMax.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            RoomFilterBox.this.sizeChanged(false);
                        }
                    });
                }
            }
        });
        this.iMin.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                RoomFilterBox.this.sizeChanged(true);
            }
        });
        this.iMax.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                RoomFilterBox.this.sizeChanged(true);
            }
        });
        nearby.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                FilterBox.Chip chip = new FilterBox.Chip("flag", "Nearby").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagNearbyRooms());
                if (((Boolean)event.getValue()).booleanValue()) {
                    if (!RoomFilterBox.this.hasChip(chip)) {
                        RoomFilterBox.this.addChip(chip, true);
                    }
                } else if (RoomFilterBox.this.hasChip(chip)) {
                    RoomFilterBox.this.removeChip(chip, true);
                }
            }
        });
        nearby.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
            }
        });
        events.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                FilterBox.Chip eventChip = new FilterBox.Chip("flag", "Event").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagEventRooms());
                FilterBox.Chip allChip = new FilterBox.Chip("flag", "All").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagAllRooms());
                if (((Boolean)event.getValue()).booleanValue()) {
                    if (!RoomFilterBox.this.hasChip(eventChip)) {
                        RoomFilterBox.this.addChip(eventChip, true);
                    }
                    if (RoomFilterBox.this.hasChip(allChip)) {
                        RoomFilterBox.this.removeChip(allChip, true);
                    }
                } else {
                    if (RoomFilterBox.this.hasChip(eventChip)) {
                        RoomFilterBox.this.removeChip(eventChip, true);
                    }
                    if (!RoomFilterBox.this.hasChip(allChip)) {
                        RoomFilterBox.this.addChip(allChip, true);
                    }
                }
            }
        });
        events.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                RoomFilterBox.this.iLastSize = RoomFilterBox.this.getChip("size");
                if (!RoomFilterBox.this.isFilterPopupShowing()) {
                    String value;
                    int i;
                    nearby.setValue(Boolean.valueOf(RoomFilterBox.this.hasChip(new FilterBox.Chip("flag", "Nearby").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagNearbyRooms()))));
                    events.setValue(Boolean.valueOf(RoomFilterBox.this.hasChip(new FilterBox.Chip("flag", "Event").withTranslatedCommand(MESSAGES.tagRoomFlag()).withTranslatedValue(MESSAGES.attrFlagEventRooms()))));
                    FilterBox.Chip size = RoomFilterBox.this.getChip("size");
                    if (size != null) {
                        if (size.getValue().startsWith("<=")) {
                            RoomFilterBox.this.iMin.setText("");
                            RoomFilterBox.this.iMax.setText(size.getValue().substring(2));
                        } else if (size.getValue().startsWith("<")) {
                            try {
                                RoomFilterBox.this.iMax.setText(String.valueOf(Integer.parseInt(size.getValue().substring(1)) - 1));
                                RoomFilterBox.this.iMin.setText("");
                            }
                            catch (Exception exception) {}
                        } else if (size.getValue().startsWith(">=")) {
                            RoomFilterBox.this.iMin.setText(size.getValue().substring(2));
                            RoomFilterBox.this.iMax.setText("");
                        } else if (size.getValue().startsWith(">")) {
                            try {
                                RoomFilterBox.this.iMin.setText(String.valueOf(Integer.parseInt(size.getValue().substring(1)) + 1));
                                RoomFilterBox.this.iMax.setText("");
                            }
                            catch (Exception exception) {}
                        } else if (size.getValue().contains("..")) {
                            RoomFilterBox.this.iMin.setText(size.getValue().substring(0, size.getValue().indexOf("..")));
                            RoomFilterBox.this.iMax.setText(size.getValue().substring(size.getValue().indexOf("..") + 2));
                        } else {
                            RoomFilterBox.this.iMin.setText(size.getValue());
                            RoomFilterBox.this.iMax.setText(size.getValue());
                        }
                    } else {
                        RoomFilterBox.this.iMin.setText("");
                        RoomFilterBox.this.iMax.setText("");
                    }
                    for (i = 0; i < RoomFilterBox.this.iBuildings.getItemCount(); ++i) {
                        value = RoomFilterBox.this.iBuildings.getValue(i);
                        RoomFilterBox.this.iBuildings.setItemSelected(i, RoomFilterBox.this.hasChip(new FilterBox.Chip("building", value).withTranslatedCommand(MESSAGES.tagBuilding())));
                    }
                    RoomFilterBox.this.iDepartments.setSelectedIndex(0);
                    for (i = 1; i < RoomFilterBox.this.iDepartments.getItemCount(); ++i) {
                        value = RoomFilterBox.this.iDepartments.getValue(i);
                        if (!RoomFilterBox.this.hasChip(new FilterBox.Chip("department", value).withTranslatedCommand(MESSAGES.tagDepartment()))) continue;
                        RoomFilterBox.this.iDepartments.setSelectedIndex(i);
                        break;
                    }
                }
                if (RoomFilterBox.this.getAcademicSessionId() != null) {
                    RoomFilterBox.this.init(false, RoomFilterBox.this.getAcademicSessionId(), new Command(){

                        public void execute() {
                            if (RoomFilterBox.this.isFilterPopupShowing()) {
                                RoomFilterBox.this.showFilterPopup();
                            }
                        }
                    });
                }
                RoomFilterBox.this.setAriaLabel(ARIA.roomFilter(RoomFilterBox.this.toAriaString()));
            }
        });
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                RoomFilterBox.this.setAriaLabel(ARIA.roomFilter(RoomFilterBox.this.toAriaString()));
            }
        });
    }

    @Override
    public void setValue(String value, boolean fireEvents) {
        ((FilterBox)this.iFilter.getWidget()).setValue(value, fireEvents);
    }

    @Override
    protected void onLoad(EventInterface.FilterRpcResponse result) {
        if (!result.hasEntities()) {
            return;
        }
        boolean added = false;
        block0: for (String type : result.getTypes()) {
            for (FilterBox.Filter filter : ((FilterBox)this.iFilter.getWidget()).getFilters()) {
                if (!filter.getCommand().equals(type)) continue;
                continue block0;
            }
            FilterBox.StaticSimpleFilter filter = new FilterBox.StaticSimpleFilter(type, null, new String[0]);
            ((FilterBox)this.iFilter.getWidget()).getFilters().add(((FilterBox)this.iFilter.getWidget()).getFilters().size() - 5, filter);
            this.populateFilter(filter, result.getEntities(type));
            added = true;
        }
        if (added) {
            this.setValue(this.getValue(), false);
        }
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if ("building".equals(filter.getCommand())) {
            this.iBuildings.clear();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iBuildings.addItem(entity.getName() + " (" + entity.getCount() + ")", entity.getAbbreviation());
                }
            }
            for (int i = 0; i < this.iBuildings.getItemCount(); ++i) {
                String value = this.iBuildings.getValue(i);
                this.iBuildings.setItemSelected(i, this.hasChip(new FilterBox.Chip("building", value)));
            }
            return true;
        }
        if ("department".equals(filter.getCommand())) {
            this.iDepartments.clear();
            this.iDepartments.addItem(MESSAGES.itemAllDepartments(), "");
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iDepartments.addItem(entity.getName() + (String)(entity.getCount() > 0 ? " (" + entity.getCount() + ")" : ""), entity.getAbbreviation());
                }
            }
            this.iDepartments.setSelectedIndex(0);
            FilterBox.Chip dept = this.getChip("department");
            if (dept != null) {
                for (int i = 1; i < this.iDepartments.getItemCount(); ++i) {
                    if (!dept.getValue().equals(this.iDepartments.getValue(i))) continue;
                    this.iDepartments.setSelectedIndex(i);
                    break;
                }
            }
            this.iDepartmentFilter.setVisible(this.iDepartments.getItemCount() > 1);
            return true;
        }
        return super.populateFilter(filter, entities);
    }

    private void sizeChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("size");
        if (this.iMin.getText().isEmpty() && this.iMax.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("size", this.iMin.getText().isEmpty() ? "<=" + this.iMax.getText() : (this.iMax.getText().isEmpty() ? ">=" + this.iMin.getText() : this.iMin.getText() + ".." + this.iMax.getText())).withTranslatedCommand(MESSAGES.tagRoomSize());
            if (newChip.equals(oldChip)) {
                if (fireChange && !newChip.equals(this.iLastSize)) {
                    this.fireValueChangeEvent();
                }
                return;
            }
            if (oldChip != null) {
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    @Override
    public EventInterface.RoomFilterRpcRequest createRpcRequest() {
        return new EventInterface.RoomFilterRpcRequest();
    }
}

