/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.courses.OfferingsXLS;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:offerings.pdf")
public class OfferingsPDF
extends OfferingsXLS {
    @Override
    public String reference() {
        return "offerings.pdf";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.checkPermission(helper, Right.InstructionalOfferingsExportPDF);
        this.exportDataPdf(this.getOfferings(helper), helper);
    }

    protected void exportDataPdf(List<TableInterface> response, ExportHelper helper) throws IOException {
        PDFPrinter printer = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), this.reference(), false);
        for (TableInterface table : response) {
            for (int i = 0; i < table.getHeader().size(); ++i) {
                printer.printHeader(i, table.getHeader().size(), printer.toA(table.getHeader().get(0), true));
            }
            if (table.hasErrorMessage()) {
                PDFPrinter.A a = new PDFPrinter.A();
                a.italic();
                a.center();
                a.setColor("red");
                a.setText(table.getErrorMessage());
                a.setColSpan(table.getMaxColumns());
                printer.printLine(a);
            }
            if (table.getLines() != null) {
                for (TableInterface.LineInterface line : table.getLines()) {
                    printer.printLine(printer.toA(line, false));
                }
            }
            printer.flushTable(table.getName());
        }
        printer.flush();
        printer.close();
    }
}

