/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.component.VAlarm;
import biweekly.io.CannotParseException;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.Action;
import biweekly.property.ICalProperty;
import biweekly.property.Trigger;
import biweekly.property.VCalAlarmProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class VCalAlarmPropertyScribe<T extends VCalAlarmProperty>
extends ICalPropertyScribe<T> {
    protected VCalAlarmPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    protected VCalAlarmPropertyScribe(Class<T> clazz, String propertyName, ICalDataType defaultDataType) {
        super(clazz, propertyName, defaultDataType);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        ArrayList<String> values = new ArrayList<String>();
        Date start = ((VCalAlarmProperty)property).getStart();
        String value = VCalAlarmPropertyScribe.date(start, property, context).extended(false).write();
        values.add(value);
        Duration snooze = ((VCalAlarmProperty)property).getSnooze();
        value = snooze == null ? "" : snooze.toString();
        values.add(value);
        Integer repeat = ((VCalAlarmProperty)property).getRepeat();
        value = repeat == null ? "" : repeat.toString();
        values.add(value);
        List<String> dataValues = this.writeData(property);
        values.addAll(dataValues);
        boolean escapeCommas = context.getVersion() != ICalVersion.V1_0;
        return VObjectPropertyValues.writeSemiStructured(values, (boolean)escapeCommas, (boolean)true);
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Integer repeat;
        Duration snooze;
        ICalDate start;
        VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value);
        String next = this.next(it);
        try {
            start = next == null ? null : VCalAlarmPropertyScribe.date(next).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(27, next);
        }
        next = this.next(it);
        try {
            snooze = next == null ? null : Duration.parse(next);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(26, next);
        }
        next = this.next(it);
        try {
            repeat = next == null ? null : Integer.valueOf(next);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(24, next);
        }
        T property = this.create(dataType, it);
        ((VCalAlarmProperty)property).setStart(start);
        ((VCalAlarmProperty)property).setSnooze(snooze);
        ((VCalAlarmProperty)property).setRepeat(repeat);
        ((ICalProperty)property).setParameters(parameters);
        DataModelConversionException conversionException = new DataModelConversionException((ICalProperty)property);
        VAlarm valarm = this.toVAlarm(property);
        conversionException.getComponents().add(valarm);
        throw conversionException;
    }

    private String next(VObjectPropertyValues.SemiStructuredValueIterator it) {
        String next = it.next();
        if (next == null) {
            return null;
        }
        return (next = next.trim()).isEmpty() ? null : next;
    }

    protected VAlarm toVAlarm(T property) {
        Trigger trigger = new Trigger(((VCalAlarmProperty)property).getStart());
        VAlarm valarm = new VAlarm(this.action(), trigger);
        valarm.setDuration(((VCalAlarmProperty)property).getSnooze());
        valarm.setRepeat(((VCalAlarmProperty)property).getRepeat());
        this.toVAlarm(valarm, property);
        return valarm;
    }

    protected abstract List<String> writeData(T var1);

    protected abstract T create(ICalDataType var1, VObjectPropertyValues.SemiStructuredValueIterator var2);

    protected abstract Action action();

    protected abstract void toVAlarm(VAlarm var1, T var2);

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V1_0);
    }
}

