/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgroups.util.Util;

public class LazyRemovalCache<K, V> {
    private final ConcurrentMap<K, Entry<V>> map = Util.createConcurrentMap();
    private final int max_elements;
    private final long max_age;

    public LazyRemovalCache() {
        this(200, 5000L);
    }

    public LazyRemovalCache(int max_elements, long max_age) {
        this.max_elements = max_elements;
        this.max_age = TimeUnit.NANOSECONDS.convert(max_age, TimeUnit.MILLISECONDS);
    }

    public boolean add(K key, V val) {
        return this.add(key, val, false);
    }

    public boolean addIfAbsent(K key, V val) {
        return this.add(key, val, true);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mappingFunction);
        V v = this.get(key);
        if (v != null) {
            return v;
        }
        v = mappingFunction.apply(key);
        if (v != null) {
            this.add(key, v);
            return v;
        }
        return v;
    }

    public void addAll(Map<K, V> m) {
        this.addAll(m, false);
    }

    public void addAllIfAbsent(Map<K, V> m) {
        this.addAll(m, true);
    }

    public Set<Map.Entry<K, Entry<V>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsKeys(Collection<K> keys) {
        for (K key : keys) {
            if (this.map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        Entry entry = (Entry)this.map.get(key);
        return entry != null ? (V)entry.val : null;
    }

    public K getByValue(V val) {
        if (val == null) {
            return null;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            Entry v = (Entry)entry.getValue();
            if (v.isRemovable() || !Objects.equals(v.val, val)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void remove(K key) {
        this.remove(key, false);
    }

    public void remove(K key, boolean force) {
        if (key == null) {
            return;
        }
        if (force) {
            this.map.remove(key);
        } else {
            Entry entry = (Entry)this.map.get(key);
            if (entry != null) {
                entry.setRemovable(true);
            }
        }
        this.checkMaxSizeExceeded();
    }

    public void removeAll(Collection<K> keys) {
        this.removeAll(keys, false);
    }

    public void removeAll(Collection<K> keys, boolean force) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (force) {
            this.map.keySet().removeAll(keys);
        } else {
            for (K key : keys) {
                Entry entry = (Entry)this.map.get(key);
                if (entry == null) continue;
                entry.setRemovable(true);
            }
        }
        this.checkMaxSizeExceeded();
    }

    public void clear(boolean force) {
        if (force) {
            this.map.clear();
        } else {
            for (Map.Entry entry : this.map.entrySet()) {
                Entry tmp;
                Entry val = (Entry)entry.getValue();
                if (val == null || (tmp = (Entry)entry.getValue()) == null) continue;
                tmp.setRemovable(true);
            }
        }
    }

    public void retainAll(Collection<K> keys) {
        this.retainAll(keys, false);
    }

    public void retainAll(Collection<K> keys, boolean force) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (force) {
            this.map.keySet().retainAll(keys);
        } else {
            this.map.entrySet().stream().filter(entry -> !keys.contains(entry.getKey())).forEach(entry -> {
                Entry val = (Entry)entry.getValue();
                if (val != null) {
                    val.setRemovable(true);
                }
            });
        }
        for (K key : keys) {
            Entry val = (Entry)this.map.get(key);
            if (val == null || !val.removable) continue;
            val.setRemovable(false);
        }
        this.checkMaxSizeExceeded();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<V> values() {
        return this.map.values().stream().map(entry -> entry.val).collect(Collectors.toSet());
    }

    public Iterable<Entry<V>> valuesIterator() {
        return () -> this.map.values().iterator();
    }

    public Set<V> nonRemovedValues() {
        return this.map.values().stream().filter(entry -> !entry.removable).map(entry -> entry.val).collect(Collectors.toSet());
    }

    public Map<K, V> contents() {
        return this.contents(false);
    }

    public Map<K, V> contents(boolean skip_removed_values) {
        HashMap retval = new HashMap();
        for (Map.Entry entry : this.map.entrySet()) {
            Entry val = (Entry)entry.getValue();
            if (val.isRemovable() && skip_removed_values) continue;
            retval.put(entry.getKey(), ((Entry)entry.getValue()).val);
        }
        return retval;
    }

    public int size() {
        return this.map.size();
    }

    public String printCache() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public String printCache(Printable print_function) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            Object key = entry.getKey();
            sb.append(print_function.print(key, entry.getValue()));
        }
        return sb.toString();
    }

    public String toString() {
        return this.printCache();
    }

    private void checkMaxSizeExceeded() {
        if (this.map.size() > this.max_elements) {
            this.removeMarkedElements(false);
        }
    }

    public void removeMarkedElements(boolean force) {
        long curr_time = System.nanoTime();
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Entry tmp = (Entry)entry.getValue();
            if (tmp == null || !tmp.removable || !force && curr_time - tmp.timestamp < this.max_age) continue;
            it.remove();
        }
    }

    public void removeMarkedElements() {
        this.removeMarkedElements(false);
    }

    protected boolean add(K key, V val, boolean if_absent) {
        boolean added = false;
        if (key != null && val != null) {
            Entry<V> entry = new Entry<V>(val);
            boolean bl = if_absent ? this.map.putIfAbsent(key, entry) == null : (added = this.map.put(key, entry) == null);
            if (added) {
                this.checkMaxSizeExceeded();
            }
        }
        return added;
    }

    protected void addAll(Map<K, V> m, boolean if_absent) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            Entry<V> e = new Entry<V>(val);
            if (if_absent) {
                this.map.putIfAbsent(key, e);
                continue;
            }
            this.map.put(key, e);
        }
        this.checkMaxSizeExceeded();
    }

    public static class Entry<V> {
        protected final V val;
        protected long timestamp = System.nanoTime();
        protected boolean removable = false;

        public Entry(V val) {
            this.val = val;
        }

        public boolean isRemovable() {
            return this.removable;
        }

        public void setRemovable(boolean flag) {
            if (this.removable != flag) {
                this.removable = flag;
                this.timestamp = System.nanoTime();
            }
        }

        public V getVal() {
            return this.val;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Function<V, String> print_val) {
            StringBuilder sb = new StringBuilder(print_val != null ? print_val.apply(this.val) : this.val.toString()).append(" (");
            long age = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.timestamp, TimeUnit.NANOSECONDS);
            if (age < 1000L) {
                sb.append(age).append(" ms");
            } else {
                sb.append(TimeUnit.SECONDS.convert(age, TimeUnit.MILLISECONDS)).append(" secs");
            }
            sb.append(" old").append(this.removable ? ", removable" : "").append(")");
            return sb.toString();
        }
    }

    public static interface Printable<K, V> {
        public String print(K var1, V var2);
    }
}

