/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.util.AsciiString;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

@MBean(description="Component measuring round-trip times to all other nodes")
public class RTT {
    protected TP transport;
    protected short tp_id;
    @Property(description="Enables or disables RTT functionality")
    protected boolean enabled;
    @Property(description="The number of RPCs to send")
    protected int num_reqs = 10;
    @Property(description="Timeout (ms) for an RPC")
    protected long timeout = 1000L;
    @Property(description="Size (in bytes) of an RPC")
    protected int size;
    @Property(description="Send requests and responses as OOB messages")
    protected boolean oob;
    protected final Map<Address, AverageMinMax> rtts = Util.createConcurrentMap();
    protected final Map<Address, long[]> times = Util.createConcurrentMap();

    public boolean enabled() {
        return this.enabled;
    }

    public RTT enabled(boolean f) {
        this.enabled = f;
        return this;
    }

    public int numReqs() {
        return this.num_reqs;
    }

    public RTT numReqs(int n) {
        this.num_reqs = n;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    public RTT timeout(long t) {
        this.timeout = t;
        return this;
    }

    public int size() {
        return this.size;
    }

    public RTT size(int size) {
        this.size = size;
        return this;
    }

    public boolean oob() {
        return this.oob;
    }

    public RTT oob(boolean b) {
        this.oob = b;
        return this;
    }

    public void init(TP tp) {
        this.transport = Objects.requireNonNull(tp);
        this.tp_id = this.transport.getId();
    }

    @ManagedOperation(description="Sends N RPCs to all other nodes and computes min/avg/max RTT")
    public String rtt() {
        return this.rtt(this.num_reqs, this.size, true, false);
    }

    @ManagedOperation(description="Sends N RPCs to all other nodes and computes min/avg/max RTT")
    public String rtt(int num_reqs, boolean details) {
        return this.rtt(num_reqs, this.size, details, false);
    }

    @ManagedOperation(description="Sends N RPCs to all other nodes and computes min/avg/max RTT")
    public String rtt(int num_reqs, int size, boolean details, boolean exclude_self) {
        if (!this.enabled) {
            return "RTT functionality is disabled";
        }
        Map<Address, AverageMinMax> m = this._rtt(num_reqs, size, exclude_self);
        return m.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), RTT.print((AverageMinMax)e.getValue(), details, TimeUnit.MICROSECONDS, num_reqs))).collect(Collectors.joining("\n"));
    }

    public Map<Address, AverageMinMax> _rtt(int num_reqs, int size, boolean exclude_self) {
        this.rtts.clear();
        this.times.clear();
        View view = this.transport.view();
        byte[] payload = new byte[size];
        ArrayList<Address> targets = new ArrayList<Address>(view.getMembers());
        if (exclude_self) {
            targets.remove(this.transport.addr());
        }
        for (Address addr : targets) {
            this.rtts.put(addr, (AverageMinMax)new AverageMinMax(1024).usePercentiles(128).unit(TimeUnit.MICROSECONDS));
            this.times.put(addr, new long[num_reqs]);
        }
        AsciiString cluster = this.transport.getClusterNameAscii();
        for (int i = 0; i < num_reqs; ++i) {
            TpHeader hdr = new TpHeader(cluster, 1, i);
            for (Address addr : targets) {
                Message msg = new BytesMessage(addr, payload).putHeader(this.tp_id, hdr);
                if (this.oob) {
                    msg.setFlag(Message.Flag.OOB);
                }
                long[] t = this.times.get(addr);
                t[i] = Util.micros();
                this.transport.down(msg);
            }
        }
        Util.waitUntilTrue(this.timeout, this.timeout / 10L, () -> this.rtts.values().stream().allMatch(a -> a.count() >= num_reqs));
        return new HashMap<Address, AverageMinMax>(this.rtts);
    }

    public void handleMessage(Message msg, TpHeader hdr) {
        if (hdr != null) {
            switch (hdr.flag()) {
                case 1: {
                    this.handleRequest(msg.src(), hdr);
                    break;
                }
                case 2: {
                    this.handleResponse(msg.src(), hdr.index());
                }
            }
        }
    }

    protected void handleRequest(Address sender, TpHeader hdr) {
        Message rsp = new EmptyMessage(sender).putHeader(this.tp_id, new TpHeader(this.transport.getClusterNameAscii(), 2, hdr.index()));
        if (this.oob) {
            rsp.setFlag(Message.Flag.OOB);
        }
        this.transport.down(rsp);
    }

    protected void handleResponse(Address sender, int index) {
        long[] start_times = this.times.get(sender);
        if (start_times != null) {
            long time = Util.micros() - start_times[index];
            AverageMinMax avg = this.rtts.get(sender);
            if (avg != null) {
                avg.add(time);
            }
        }
    }

    protected static String print(AverageMinMax avg, boolean details, TimeUnit unit, int num_reqs) {
        return details ? avg.toString(unit) + String.format(" (%s)", RTT.percentiles(avg, num_reqs)) : Util.printTime(avg.average(), unit);
    }

    protected static String percentiles(AverageMinMax avg, int num_reqs) {
        List<Long> values = avg.values();
        int received = values.size();
        int non_received = num_reqs - received;
        double failure_rate = non_received == 0 ? 0.0 : (double)non_received / (double)received;
        String failures = non_received == 0 ? "" : String.format(" (failure rate: %.2f)", failure_rate);
        return String.format("p90=%s p99=%s p99.9=%s%s", Util.printTime(avg.p(90.0), avg.unit()), Util.printTime(avg.p(99.0), avg.unit()), Util.printTime(avg.p(99.9), avg.unit()), failures);
    }
}

