/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.Messages;
import biweekly.ValidationWarning;
import biweekly.ValidationWarnings;
import biweekly.component.RawComponent;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.Status;
import biweekly.util.ListMultimap;
import biweekly.util.StringUtils;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ICalComponent {
    protected final ListMultimap<Class<? extends ICalComponent>, ICalComponent> components = new ListMultimap();
    protected final ListMultimap<Class<? extends ICalProperty>, ICalProperty> properties = new ListMultimap();

    protected ICalComponent() {
    }

    protected ICalComponent(ICalComponent original) {
        this();
        for (ICalProperty property : original.properties.values()) {
            this.addProperty(property.copy());
        }
        for (ICalComponent component : original.components.values()) {
            this.addComponent(component.copy());
        }
    }

    public <T extends ICalProperty> T getProperty(Class<T> clazz) {
        return (T)((ICalProperty)clazz.cast(this.properties.first(clazz)));
    }

    public <T extends ICalProperty> List<T> getProperties(Class<T> clazz) {
        return new ICalPropertyList<T>(clazz);
    }

    public ListMultimap<Class<? extends ICalProperty>, ICalProperty> getProperties() {
        return this.properties;
    }

    public void addProperty(ICalProperty property) {
        this.properties.put(property.getClass(), property);
    }

    public List<ICalProperty> setProperty(ICalProperty property) {
        return this.properties.replace(property.getClass(), property);
    }

    public <T extends ICalProperty> List<T> setProperty(Class<T> clazz, T property) {
        List<ICalProperty> replaced = this.properties.replace(clazz, property);
        return ICalComponent.castList(replaced, clazz);
    }

    public <T extends ICalProperty> boolean removeProperty(T property) {
        return this.properties.remove(property.getClass(), property);
    }

    public <T extends ICalProperty> List<T> removeProperties(Class<T> clazz) {
        List<ICalProperty> removed = this.properties.removeAll(clazz);
        return ICalComponent.castList(removed, clazz);
    }

    public <T extends ICalComponent> boolean removeComponent(T component) {
        return this.components.remove(component.getClass(), component);
    }

    public <T extends ICalComponent> List<T> removeComponents(Class<T> clazz) {
        List<ICalComponent> removed = this.components.removeAll(clazz);
        return ICalComponent.castList(removed, clazz);
    }

    public RawProperty getExperimentalProperty(String name) {
        for (RawProperty raw : this.getExperimentalProperties()) {
            if (!raw.getName().equalsIgnoreCase(name)) continue;
            return raw;
        }
        return null;
    }

    public List<RawProperty> getExperimentalProperties(String name) {
        ArrayList<RawProperty> toReturn = new ArrayList<RawProperty>();
        for (RawProperty property : this.getExperimentalProperties()) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            toReturn.add(property);
        }
        return Collections.unmodifiableList(toReturn);
    }

    public List<RawProperty> getExperimentalProperties() {
        return this.getProperties(RawProperty.class);
    }

    public RawProperty addExperimentalProperty(String name, String value) {
        return this.addExperimentalProperty(name, null, value);
    }

    public RawProperty addExperimentalProperty(String name, ICalDataType dataType, String value) {
        RawProperty raw = new RawProperty(name, dataType, value);
        this.addProperty(raw);
        return raw;
    }

    public RawProperty setExperimentalProperty(String name, String value) {
        return this.setExperimentalProperty(name, null, value);
    }

    public RawProperty setExperimentalProperty(String name, ICalDataType dataType, String value) {
        this.removeExperimentalProperties(name);
        return this.addExperimentalProperty(name, dataType, value);
    }

    public List<RawProperty> removeExperimentalProperties(String name) {
        List<RawProperty> all = this.getExperimentalProperties();
        ArrayList<RawProperty> toRemove = new ArrayList<RawProperty>();
        for (RawProperty property : all) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            toRemove.add(property);
        }
        all.removeAll(toRemove);
        return Collections.unmodifiableList(toRemove);
    }

    public <T extends ICalComponent> T getComponent(Class<T> clazz) {
        return (T)((ICalComponent)clazz.cast(this.components.first(clazz)));
    }

    public <T extends ICalComponent> List<T> getComponents(Class<T> clazz) {
        return new ICalComponentList<T>(clazz);
    }

    public ListMultimap<Class<? extends ICalComponent>, ICalComponent> getComponents() {
        return this.components;
    }

    public void addComponent(ICalComponent component) {
        this.components.put(component.getClass(), component);
    }

    public List<ICalComponent> setComponent(ICalComponent component) {
        return this.components.replace(component.getClass(), component);
    }

    public <T extends ICalComponent> List<T> setComponent(Class<T> clazz, T component) {
        List<ICalComponent> replaced = this.components.replace(clazz, component);
        return ICalComponent.castList(replaced, clazz);
    }

    public RawComponent getExperimentalComponent(String name) {
        for (RawComponent component : this.getExperimentalComponents()) {
            if (!component.getName().equalsIgnoreCase(name)) continue;
            return component;
        }
        return null;
    }

    public List<RawComponent> getExperimentalComponents(String name) {
        ArrayList<RawComponent> toReturn = new ArrayList<RawComponent>();
        for (RawComponent component : this.getExperimentalComponents()) {
            if (!component.getName().equalsIgnoreCase(name)) continue;
            toReturn.add(component);
        }
        return Collections.unmodifiableList(toReturn);
    }

    public List<RawComponent> getExperimentalComponents() {
        return this.getComponents(RawComponent.class);
    }

    public RawComponent addExperimentalComponent(String name) {
        RawComponent raw = new RawComponent(name);
        this.addComponent(raw);
        return raw;
    }

    public RawComponent setExperimentalComponent(String name) {
        this.removeExperimentalComponents(name);
        return this.addExperimentalComponent(name);
    }

    public List<RawComponent> removeExperimentalComponents(String name) {
        List<RawComponent> all = this.getExperimentalComponents();
        ArrayList<RawComponent> toRemove = new ArrayList<RawComponent>();
        for (RawComponent property : all) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            toRemove.add(property);
        }
        all.removeAll(toRemove);
        return Collections.unmodifiableList(toRemove);
    }

    public final List<ValidationWarnings.WarningsGroup> validate(List<ICalComponent> hierarchy, ICalVersion version) {
        ArrayList<ValidationWarnings.WarningsGroup> warnings = new ArrayList<ValidationWarnings.WarningsGroup>();
        ArrayList<ValidationWarning> warningsBuf = new ArrayList<ValidationWarning>(0);
        this.validate(hierarchy, version, warningsBuf);
        if (!warningsBuf.isEmpty()) {
            warnings.add(new ValidationWarnings.WarningsGroup(this, hierarchy, warningsBuf));
        }
        hierarchy = new ArrayList<ICalComponent>(hierarchy);
        hierarchy.add(this);
        for (ICalProperty property : this.properties.values()) {
            List<ValidationWarning> propWarnings = property.validate(hierarchy, version);
            if (propWarnings.isEmpty()) continue;
            warnings.add(new ValidationWarnings.WarningsGroup(property, hierarchy, propWarnings));
        }
        for (ICalComponent component : this.components.values()) {
            warnings.addAll(component.validate(hierarchy, version));
        }
        return warnings;
    }

    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
    }

    protected void checkRequiredCardinality(List<ValidationWarning> warnings, Class<? extends ICalProperty> ... classes) {
        for (Class<? extends ICalProperty> clazz : classes) {
            List<? extends ICalProperty> props = this.getProperties(clazz);
            if (props.isEmpty()) {
                warnings.add(new ValidationWarning(2, clazz.getSimpleName()));
                continue;
            }
            if (props.size() <= 1) continue;
            warnings.add(new ValidationWarning(3, clazz.getSimpleName()));
        }
    }

    protected void checkOptionalCardinality(List<ValidationWarning> warnings, Class<? extends ICalProperty> ... classes) {
        for (Class<? extends ICalProperty> clazz : classes) {
            List<? extends ICalProperty> props = this.getProperties(clazz);
            if (props.size() <= 1) continue;
            warnings.add(new ValidationWarning(3, clazz.getSimpleName()));
        }
    }

    protected void checkStatus(List<ValidationWarning> warnings, Status ... allowed) {
        Status actual = this.getProperty(Status.class);
        if (actual == null) {
            return;
        }
        ArrayList<String> allowedValues = new ArrayList<String>(allowed.length);
        for (Status status : allowed) {
            String value = ((String)status.getValue()).toLowerCase();
            allowedValues.add(value);
        }
        String actualValue = ((String)actual.getValue()).toLowerCase();
        if (!allowedValues.contains(actualValue)) {
            warnings.add(new ValidationWarning(13, actual.getValue(), allowedValues));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(0, sb);
        return sb.toString();
    }

    protected Map<String, Object> toStringValues() {
        return Collections.emptyMap();
    }

    private void toString(int depth, StringBuilder sb) {
        StringUtils.repeat(' ', depth * 2, sb);
        sb.append(this.getClass().getName());
        Map<String, Object> fields = this.toStringValues();
        if (!fields.isEmpty()) {
            sb.append(' ').append(fields.toString());
        }
        sb.append(StringUtils.NEWLINE);
        ++depth;
        for (ICalProperty property : this.properties.values()) {
            StringUtils.repeat(' ', depth * 2, sb);
            sb.append(property).append(StringUtils.NEWLINE);
        }
        for (ICalComponent component : this.components.values()) {
            component.toString(depth, sb);
        }
    }

    public ICalComponent copy() {
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> copyConstructor = clazz.getConstructor(clazz);
            return (ICalComponent)copyConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(Messages.INSTANCE.getExceptionMessage(1, clazz.getName()), e);
        }
    }

    private static <T> List<T> castList(List<?> list, Class<T> castTo) {
        ArrayList<T> casted = new ArrayList<T>(list.size());
        for (Object object : list) {
            casted.add(castTo.cast(object));
        }
        return Collections.unmodifiableList(casted);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int propertiesHash = 1;
        for (ICalProperty property : this.properties.values()) {
            propertiesHash += property.hashCode();
        }
        result = 31 * result + propertiesHash;
        int componentsHash = 1;
        for (ICalComponent component : this.components.values()) {
            componentsHash += component.hashCode();
        }
        result = 31 * result + componentsHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICalComponent other = (ICalComponent)obj;
        if (this.properties.size() != other.properties.size()) {
            return false;
        }
        if (this.components.size() != other.components.size()) {
            return false;
        }
        if (!ICalComponent.compareMultimaps(this.properties, other.properties)) {
            return false;
        }
        return ICalComponent.compareMultimaps(this.components, other.components);
    }

    private static <K, V> boolean compareMultimaps(ListMultimap<K, V> map1, ListMultimap<K, V> map2) {
        for (Map.Entry<K, List<V>> entry : map1) {
            K key = entry.getKey();
            List<V> value = entry.getValue();
            List<V> otherValue = map2.get(key);
            if (value.size() != otherValue.size()) {
                return false;
            }
            ArrayList<V> otherValueCopy = new ArrayList<V>(otherValue);
            for (V property : value) {
                if (otherValueCopy.remove(property)) continue;
                return false;
            }
        }
        return true;
    }

    private class ICalPropertyList<T extends ICalProperty>
    extends AbstractList<T> {
        protected final Class<T> propertyClass;
        protected final List<ICalProperty> properties;

        public ICalPropertyList(Class<T> propertyClass) {
            this.propertyClass = propertyClass;
            this.properties = ICalComponent.this.properties.get(propertyClass);
        }

        @Override
        public void add(int index, T value) {
            this.properties.add(index, (ICalProperty)value);
        }

        @Override
        public T remove(int index) {
            ICalProperty removed = this.properties.remove(index);
            return this.cast(removed);
        }

        @Override
        public T get(int index) {
            ICalProperty property = this.properties.get(index);
            return this.cast(property);
        }

        @Override
        public T set(int index, T value) {
            ICalProperty replaced = this.properties.set(index, (ICalProperty)value);
            return this.cast(replaced);
        }

        @Override
        public int size() {
            return this.properties.size();
        }

        protected T cast(ICalProperty value) {
            return (T)((ICalProperty)this.propertyClass.cast(value));
        }
    }

    private class ICalComponentList<T extends ICalComponent>
    extends AbstractList<T> {
        protected final Class<T> componentClass;
        protected final List<ICalComponent> components;

        public ICalComponentList(Class<T> componentClass) {
            this.componentClass = componentClass;
            this.components = ICalComponent.this.components.get(componentClass);
        }

        @Override
        public void add(int index, T value) {
            this.components.add(index, (ICalComponent)value);
        }

        @Override
        public T remove(int index) {
            ICalComponent removed = this.components.remove(index);
            return this.cast(removed);
        }

        @Override
        public T get(int index) {
            ICalComponent property = this.components.get(index);
            return this.cast(property);
        }

        @Override
        public T set(int index, T value) {
            ICalComponent replaced = this.components.set(index, (ICalComponent)value);
            return this.cast(replaced);
        }

        @Override
        public int size() {
            return this.components.size();
        }

        protected T cast(ICalComponent value) {
            return (T)((ICalComponent)this.componentClass.cast(value));
        }
    }
}

