/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import biweekly.Biweekly;
import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.ValidationWarnings;
import biweekly.component.ICalComponent;
import biweekly.component.VEvent;
import biweekly.component.VFreeBusy;
import biweekly.component.VJournal;
import biweekly.component.VTodo;
import biweekly.io.TimezoneInfo;
import biweekly.property.CalendarScale;
import biweekly.property.Categories;
import biweekly.property.Color;
import biweekly.property.Description;
import biweekly.property.Geo;
import biweekly.property.ICalProperty;
import biweekly.property.Image;
import biweekly.property.LastModified;
import biweekly.property.Method;
import biweekly.property.Name;
import biweekly.property.ProductId;
import biweekly.property.RefreshInterval;
import biweekly.property.Source;
import biweekly.property.Uid;
import biweekly.property.Url;
import biweekly.util.Duration;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class ICalendar
extends ICalComponent {
    private ICalVersion version;
    private TimezoneInfo tzinfo = new TimezoneInfo();

    public ICalendar() {
        this.setProductId(ProductId.biweekly());
    }

    public ICalendar(ICalendar original) {
        super(original);
        this.version = original.version;
    }

    public ICalVersion getVersion() {
        return this.version;
    }

    public void setVersion(ICalVersion version) {
        this.version = version;
    }

    public TimezoneInfo getTimezoneInfo() {
        return this.tzinfo;
    }

    public void setTimezoneInfo(TimezoneInfo tzinfo) {
        if (tzinfo == null) {
            throw new NullPointerException();
        }
        this.tzinfo = tzinfo;
    }

    public ProductId getProductId() {
        return this.getProperty(ProductId.class);
    }

    public void setProductId(ProductId prodId) {
        this.setProperty(ProductId.class, prodId);
    }

    public ProductId setProductId(String prodId) {
        ProductId property = prodId == null ? null : new ProductId(prodId);
        this.setProductId(property);
        return property;
    }

    public CalendarScale getCalendarScale() {
        return this.getProperty(CalendarScale.class);
    }

    public void setCalendarScale(CalendarScale calendarScale) {
        this.setProperty(CalendarScale.class, calendarScale);
    }

    public Method getMethod() {
        return this.getProperty(Method.class);
    }

    public void setMethod(Method method) {
        this.setProperty(Method.class, method);
    }

    public Method setMethod(String method) {
        Method property = method == null ? null : new Method(method);
        this.setMethod(property);
        return property;
    }

    public List<Name> getNames() {
        return this.getProperties(Name.class);
    }

    public void setName(Name name) {
        this.setProperty(Name.class, name);
    }

    public Name setName(String name) {
        Name property = name == null ? null : new Name(name);
        this.setName(property);
        return property;
    }

    public void addName(Name name) {
        this.addProperty(name);
    }

    public Name addName(String name) {
        Name property = new Name(name);
        this.addProperty(property);
        return property;
    }

    public List<Description> getDescriptions() {
        return this.getProperties(Description.class);
    }

    public void setDescription(Description description) {
        this.setProperty(Description.class, description);
    }

    public Description setDescription(String description) {
        Description property = description == null ? null : new Description(description);
        this.setDescription(property);
        return property;
    }

    public void addDescription(Description description) {
        this.addProperty(description);
    }

    public Description addDescription(String description) {
        Description property = new Description(description);
        this.addProperty(property);
        return property;
    }

    public Uid getUid() {
        return this.getProperty(Uid.class);
    }

    public void setUid(Uid uid) {
        this.setProperty(Uid.class, uid);
    }

    public Uid setUid(String uid) {
        Uid property = uid == null ? null : new Uid(uid);
        this.setUid(property);
        return property;
    }

    public LastModified getLastModified() {
        return this.getProperty(LastModified.class);
    }

    public void setLastModified(LastModified lastModified) {
        this.setProperty(LastModified.class, lastModified);
    }

    public LastModified setLastModified(Date lastModified) {
        LastModified property = lastModified == null ? null : new LastModified(lastModified);
        this.setLastModified(property);
        return property;
    }

    public Url getUrl() {
        return this.getProperty(Url.class);
    }

    public void setUrl(Url url) {
        this.setProperty(Url.class, url);
    }

    public Url setUrl(String url) {
        Url property = url == null ? null : new Url(url);
        this.setUrl(property);
        return property;
    }

    public List<Categories> getCategories() {
        return this.getProperties(Categories.class);
    }

    public void addCategories(Categories categories) {
        this.addProperty(categories);
    }

    public Categories addCategories(String ... categories) {
        Categories prop = new Categories(categories);
        this.addProperty(prop);
        return prop;
    }

    public RefreshInterval getRefreshInterval() {
        return this.getProperty(RefreshInterval.class);
    }

    public void setRefreshInterval(RefreshInterval refreshInterval) {
        this.setProperty(RefreshInterval.class, refreshInterval);
    }

    public RefreshInterval setRefreshInterval(Duration refreshInterval) {
        RefreshInterval property = refreshInterval == null ? null : new RefreshInterval(refreshInterval);
        this.setRefreshInterval(property);
        return property;
    }

    public Source getSource() {
        return this.getProperty(Source.class);
    }

    public void setSource(Source source) {
        this.setProperty(Source.class, source);
    }

    public Source setSource(String url) {
        Source property = url == null ? null : new Source(url);
        this.setSource(property);
        return property;
    }

    public Color getColor() {
        return this.getProperty(Color.class);
    }

    public void setColor(Color color) {
        this.setProperty(Color.class, color);
    }

    public Color setColor(String color) {
        Color property = color == null ? null : new Color(color);
        this.setColor(property);
        return property;
    }

    public List<Image> getImages() {
        return this.getProperties(Image.class);
    }

    public void addImage(Image image) {
        this.addProperty(image);
    }

    public List<VEvent> getEvents() {
        return this.getComponents(VEvent.class);
    }

    public void addEvent(VEvent event) {
        this.addComponent(event);
    }

    public List<VTodo> getTodos() {
        return this.getComponents(VTodo.class);
    }

    public void addTodo(VTodo todo) {
        this.addComponent(todo);
    }

    public List<VJournal> getJournals() {
        return this.getComponents(VJournal.class);
    }

    public void addJournal(VJournal journal) {
        this.addComponent(journal);
    }

    public List<VFreeBusy> getFreeBusies() {
        return this.getComponents(VFreeBusy.class);
    }

    public void addFreeBusy(VFreeBusy freeBusy) {
        this.addComponent(freeBusy);
    }

    public ValidationWarnings validate(ICalVersion version) {
        List<ValidationWarnings.WarningsGroup> warnings = this.validate(new ArrayList<ICalComponent>(0), version);
        return new ValidationWarnings(warnings);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (version != ICalVersion.V1_0) {
            this.checkRequiredCardinality(warnings, ProductId.class);
            if (this.components.isEmpty()) {
                warnings.add(new ValidationWarning(4, new Object[0]));
            }
            if (this.getProperty(Geo.class) != null) {
                warnings.add(new ValidationWarning(44, new Object[0]));
            }
        }
        this.checkOptionalCardinality(warnings, Uid.class, LastModified.class, Url.class, RefreshInterval.class, Color.class, Source.class);
        this.checkUniqueLanguages(warnings, Name.class);
        this.checkUniqueLanguages(warnings, Description.class);
    }

    private void checkUniqueLanguages(List<ValidationWarning> warnings, Class<? extends ICalProperty> clazz) {
        List<? extends ICalProperty> properties = this.getProperties(clazz);
        if (properties.size() <= 1) {
            return;
        }
        HashSet<String> languages = new HashSet<String>(properties.size());
        for (ICalProperty iCalProperty : properties) {
            boolean added;
            String language = iCalProperty.getParameters().getLanguage();
            if (language != null) {
                language = language.toLowerCase();
            }
            if (added = languages.add(language)) continue;
            warnings.add(new ValidationWarning(55, clazz.getSimpleName()));
            break;
        }
    }

    public String write() {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        return Biweekly.write(this).version(version).go();
    }

    public void write(File file) throws IOException {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        Biweekly.write(this).version(version).go(file);
    }

    public void write(OutputStream out) throws IOException {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        Biweekly.write(this).version(version).go(out);
    }

    public void write(Writer writer) throws IOException {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        Biweekly.write(this).version(version).go(writer);
    }

    public String writeXml() {
        return Biweekly.writeXml(this).indent(2).go();
    }

    public void writeXml(File file) throws TransformerException, IOException {
        Biweekly.writeXml(this).indent(2).go(file);
    }

    public void writeXml(OutputStream out) throws TransformerException {
        Biweekly.writeXml(this).indent(2).go(out);
    }

    public void writeXml(Writer writer) throws TransformerException {
        Biweekly.writeXml(this).indent(2).go(writer);
    }

    public String writeJson() {
        return Biweekly.writeJson(this).go();
    }

    public void writeJson(File file) throws IOException {
        Biweekly.writeJson(this).go(file);
    }

    public void writeJson(OutputStream out) throws IOException {
        Biweekly.writeJson(this).go(out);
    }

    public void writeJson(Writer writer) throws IOException {
        Biweekly.writeJson(this).go(writer);
    }

    @Override
    protected Map<String, Object> toStringValues() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("version", (Object)this.version);
        return fields;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ICalendar other = (ICalendar)obj;
        return this.version == other.version;
    }
}

