/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Hashtable;
import org.unitime.timetable.defaults.ApplicationProperty;

public class PdfFont {
    private static Hashtable<String, Font> sFontCache = new Hashtable();

    private static Font getFont(float size, boolean fixed, boolean bold, boolean italic) {
        if (ApplicationProperty.PdfFontCache.isTrue()) {
            Font font = sFontCache.get(size + (fixed ? "F" : "") + (bold ? "B" : "") + (italic ? "I" : ""));
            if (font == null) {
                font = PdfFont.createFont(size, fixed, bold, italic);
                sFontCache.put(size + (fixed ? "F" : "") + (bold ? "B" : "") + (italic ? "I" : ""), font);
            }
            return font;
        }
        return PdfFont.createFont(size, fixed, bold, italic);
    }

    public static Font createFont(float size, boolean fixed, boolean bold, boolean italic) {
        BaseFont base2;
        String font = null;
        font = fixed ? ApplicationProperty.PdfFontFixed.value() : (bold ? (italic ? ApplicationProperty.PdfFontBoldItalic.value() : ApplicationProperty.PdfFontBold.value()) : (italic ? ApplicationProperty.PdfFontItalic.value() : ApplicationProperty.PdfFontNormal.value()));
        if (font != null && !font.isEmpty()) {
            try {
                base2 = BaseFont.createFont((String)font, (String)"Identity-H", (boolean)true);
                if (base2 != null) {
                    return new Font(base2, size);
                }
            }
            catch (Throwable base2) {
                // empty catch block
            }
        }
        String string = font = fixed ? ApplicationProperty.PdfFontFixed.value() : ApplicationProperty.PdfFontNormal.value();
        if (font != null && !font.isEmpty()) {
            try {
                base2 = BaseFont.createFont((String)font, (String)"Identity-H", (boolean)true);
                if (base2 != null) {
                    return new Font(base2, size, italic && bold ? 3 : (italic ? 2 : (bold ? 1 : 0)));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fixed) {
            return FontFactory.getFont((String)(bold ? (italic ? "Courier-BoldOblique" : "Courier-Bold") : (italic ? "Courier-Oblique" : "Courier")), (float)size);
        }
        return FontFactory.getFont((String)(bold ? (italic ? "Helvetica-BoldOblique" : "Helvetica-Bold") : (italic ? "Helvetica-Oblique" : "Helvetica")), (float)size);
    }

    public static Font getBigFont(boolean bold, boolean italic) {
        return PdfFont.getFont(ApplicationProperty.PdfFontSizeBig.floatValue().floatValue(), false, bold, italic);
    }

    public static Font getBigFont(boolean bold) {
        return PdfFont.getBigFont(bold, false);
    }

    public static Font getBigFont() {
        return PdfFont.getBigFont(false, false);
    }

    public static Font getFont(boolean bold, boolean italic) {
        return PdfFont.getFont(ApplicationProperty.PdfFontSizeNormal.floatValue().floatValue(), false, bold, italic);
    }

    public static Font getFont(boolean bold) {
        return PdfFont.getFont(bold, false);
    }

    public static Font getFont() {
        return PdfFont.getFont(false, false);
    }

    public static Font getFont(boolean bold, boolean italic, boolean underline, Color color) {
        Font font = PdfFont.getFont(bold, italic);
        if (underline) {
            font.setStyle(font.getStyle() + 4);
        }
        if (color != null) {
            font.setColor(color);
        }
        return font;
    }

    public static Font getFont(boolean bold, boolean italic, Color color) {
        return PdfFont.getFont(bold, italic, false, color);
    }

    public static Font getSmallFont(boolean bold, boolean italic) {
        return PdfFont.getFont(ApplicationProperty.PdfFontSizeSmall.floatValue().floatValue(), false, bold, italic);
    }

    public static Font getSmallFont(boolean bold) {
        return PdfFont.getSmallFont(bold, false);
    }

    public static Font getSmallFont() {
        return PdfFont.getSmallFont(false, false);
    }

    public static Font getSmallFont(boolean bold, boolean italic, boolean underline, Color color) {
        Font font = PdfFont.getSmallFont(bold, italic);
        if (underline) {
            font.setStyle(font.getStyle() + 4);
        }
        if (color != null) {
            font.setColor(color);
        }
        return font;
    }

    public static Font getSmallFont(boolean bold, boolean italic, Color color) {
        return PdfFont.getSmallFont(bold, italic, false, color);
    }

    public static Font getFixedFont() {
        return PdfFont.getFont(ApplicationProperty.PdfFontSizeFixed.floatValue().floatValue(), true, false, false);
    }
}

