/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

@GwtRpcImplements(value=SolverInterface.SolverPageMessagesRequest.class)
public class SolverPageMessagesBackend
implements GwtRpcImplementation<SolverInterface.SolverPageMessagesRequest, SolverInterface.SolverPageMessages> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public SolverInterface.SolverPageMessages execute(SolverInterface.SolverPageMessagesRequest request, SessionContext context) {
        SolverInterface.SolverPageMessages ret = new SolverInterface.SolverPageMessages();
        SolverPageBackend.fillSolverWarnings(context, this.getSolver(request.getType()), request.getType(), ret);
        return ret;
    }

    protected CommonSolverInterface getSolver(SolverInterface.SolverType type) {
        switch (type) {
            case COURSE: {
                return this.courseTimetablingSolverService.getSolver();
            }
            case EXAM: {
                return this.examinationSolverService.getSolver();
            }
            case STUDENT: {
                return this.studentSectioningSolverService.getSolver();
            }
            case INSTRUCTOR: {
                return this.instructorSchedulingSolverService.getSolver();
            }
        }
        throw new IllegalArgumentException(MESSAGES.errorSolverInvalidType(type.name()));
    }
}

